/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters.power;

import net.minecraft.item.ItemBlock;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.Configuration;
import powercrystals.powerconverters.common.BridgeSideData;
import powercrystals.powerconverters.power.base.BlockPowerConverter;
import powercrystals.powerconverters.power.base.TileEntityBridgeComponent;

public abstract class PowerSystem {
    protected String name;
    protected float _internalEnergyPerInput;
    protected float _internalEnergyPerOutput;
    protected float serverInternalEnergyPerInput;
    protected float serverInternalEnergyPerOutput;
    protected String _unit;
    protected String[] voltageNames;
    protected int[] voltageValues;
    public BlockPowerConverter block;
    public Class<? extends ItemBlock> itemBlock;
    public Class<? extends TileEntityBridgeComponent> consumer;
    public Class<? extends TileEntityBridgeComponent> producer;
    public static final String POWERSYSTEM_CATEGORY = "powersystems";

    public abstract String getId();

    public abstract void registerBlocks();

    public abstract void registerCommonRecipes();

    public abstract void loadConfig(Configuration var1);

    public abstract void saveConfig(Configuration var1);

    public void readEnergyValues(NBTTagCompound nbt) {
        this.serverInternalEnergyPerInput = nbt.func_74760_g("Input");
        this.serverInternalEnergyPerOutput = nbt.func_74760_g("Output");
    }

    public NBTTagCompound writeEnergyValues() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74776_a("Input", this._internalEnergyPerInput);
        nbt.func_74776_a("Output", this._internalEnergyPerOutput);
        return nbt;
    }

    public float getInternalEnergyPerInput(int meta) {
        return this._internalEnergyPerInput;
    }

    public float getInternalEnergyPerOutput(int meta) {
        return this._internalEnergyPerOutput;
    }

    public String getUnit() {
        return this.getUnit(-1);
    }

    public String getUnit(int subtype) {
        return this._unit;
    }

    public String[] getVoltageNames() {
        return this.voltageNames;
    }

    public String getRateString(BridgeSideData data) {
        double rate = data.outputRate;
        if (rate > 1000000.0) {
            double rateMillion = rate / 1000000.0;
            return String.format("%.1f %s%s/t", rateMillion, "m", this.getUnit());
        }
        if (rate > 1000.0) {
            double rateThousand = rate / 1000.0;
            return String.format("%.1f %s%s/t", rateThousand, "k", this.getUnit());
        }
        return rate + " " + this.getUnit() + "/t";
    }
}

