/*
 * Decompiled with CFR 0.152.
 */
package journeymap.server.oldservercode.events;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import journeymap.common.Journeymap;
import journeymap.server.oldservercode.config.ConfigHandler;
import journeymap.server.oldservercode.mapcontrol.MappingOptionsHandler;
import journeymap.server.oldservercode.network.PacketManager;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;

public class ForgeEvents {
    @SideOnly(value=Side.SERVER)
    @SubscribeEvent
    public void on(EntityJoinWorldEvent event) {
        if (event.entity instanceof EntityPlayerMP) {
            String worldName = event.world.func_72912_H().func_76065_j();
            new UserJoinWorldThread((EntityPlayerMP)event.entity, ConfigHandler.getConfigByWorldName(worldName).getWorldID()).start();
        }
    }

    private class UserJoinWorldThread
    extends Thread {
        private String worldID;
        private EntityPlayerMP player;
        private MappingOptionsHandler options;

        public UserJoinWorldThread(EntityPlayerMP player, String worldID) {
            this.player = player;
            this.worldID = worldID;
            this.options = new MappingOptionsHandler(player.func_130014_f_().func_72912_H().func_76065_j());
        }

        @Override
        public void run() {
            try {
                UserJoinWorldThread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            String playerName = this.player.func_70005_c_();
            if (this.options.disableRadar(playerName)) {
                Journeymap.getLogger().info("Disabling Radar for player: " + playerName);
                this.player.func_145747_a((IChatComponent)new ChatComponentTranslation("\u00a73 \u00a76 \u00a73 \u00a76 \u00a73 \u00a76 \u00a7e", new Object[0]));
            }
            if (this.options.disableCaveMapping(playerName)) {
                Journeymap.getLogger().info("Disabling CaveMapping for player: " + playerName);
                this.player.func_145747_a((IChatComponent)new ChatComponentTranslation("\u00a73 \u00a76 \u00a73 \u00a76 \u00a73 \u00a76 \u00a7d", new Object[0]));
            }
            if (ConfigHandler.getConfigByWorldName(this.player.func_130014_f_().func_72912_H().func_76065_j()).isUsingWorldID()) {
                Journeymap.getLogger().info(String.format("Login: Sending WorldID Packet to %s", playerName));
                PacketManager.instance.sendPlayerWorldID(this.worldID, playerName);
            }
        }
    }
}

