/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.cartography.render;

import journeymap.client.cartography.IChunkRenderer;
import journeymap.client.cartography.RGB;
import journeymap.client.cartography.Strata;
import journeymap.client.cartography.render.BaseRenderer;
import journeymap.client.cartography.render.CaveRenderer;
import journeymap.client.model.BlockMD;
import journeymap.client.model.ChunkMD;
import journeymap.common.Journeymap;

public class NetherRenderer
extends CaveRenderer
implements IChunkRenderer {
    public NetherRenderer() {
        super(null);
        this.cachePrefix = "Nether";
    }

    @Override
    protected void updateOptions() {
        super.updateOptions();
        this.ambientColor = RGB.floats(this.tweakNetherAmbientColor);
        this.mapSurfaceAboveCaves = false;
    }

    @Override
    protected Integer getSliceBlockHeight(ChunkMD chunkMd, int x, Integer vSlice, int z, int sliceMinY, int sliceMaxY, BaseRenderer.HeightsCache chunkHeights) {
        Integer[][] blockSliceHeights = (Integer[][])chunkHeights.getUnchecked(chunkMd.getCoord());
        if (blockSliceHeights == null) {
            return null;
        }
        Integer y = blockSliceHeights[x][z];
        if (y != null) {
            return y;
        }
        try {
            y = sliceMaxY;
            BlockMD blockMD = BlockMD.getBlockMD(chunkMd, x, y, z);
            BlockMD blockMDAbove = BlockMD.getBlockMD(chunkMd, x, Math.min(y + 1, sliceMaxY), z);
            while (y > 0 && !blockMD.isLava()) {
                if (blockMDAbove.isAir() || blockMDAbove.hasTranparency() || blockMDAbove.hasFlag(BlockMD.Flag.OpenToSky)) {
                    if (!(blockMD.isAir() || blockMD.hasTranparency() || blockMD.hasFlag(BlockMD.Flag.OpenToSky))) {
                        break;
                    }
                } else if (y == sliceMinY) {
                    y = sliceMaxY;
                    break;
                }
                Integer n = y;
                Integer n2 = y = Integer.valueOf(y - 1);
                blockMD = BlockMD.getBlockMD(chunkMd, x, y, z);
                blockMDAbove = BlockMD.getBlockMD(chunkMd, x, y + 1, z);
            }
        }
        catch (Exception e) {
            Journeymap.getLogger().warn("Couldn't get safe slice block height at " + x + "," + z + ": " + e);
            y = sliceMaxY;
        }
        blockSliceHeights[x][z] = y = Integer.valueOf(Math.max(0, y));
        return y;
    }

    @Override
    protected void buildStrata(Strata strata, int minY, ChunkMD chunkMd, int x, int topY, int z, BaseRenderer.HeightsCache chunkHeights, BaseRenderer.SlopesCache chunkSlopes) {
        super.buildStrata(strata, minY, chunkMd, x, topY, z, chunkHeights, chunkSlopes);
    }

    @Override
    protected int getSliceLightLevel(ChunkMD chunkMd, int x, int y, int z, boolean adjusted) {
        if (y + 1 >= chunkMd.getWorldActualHeight()) {
            return 0;
        }
        int actualLight = chunkMd.getSavedLightValue(x, y + 1, z);
        if (actualLight > 0) {
            return actualLight;
        }
        return Math.max(adjusted ? 2 : 0, actualLight);
    }

    @Override
    public float[] getAmbientColor() {
        return this.ambientColor;
    }
}

