/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.world.profiling;

import com.xcompwiz.mystcraft.world.AgeController;
import com.xcompwiz.mystcraft.world.WorldProviderMyst;
import com.xcompwiz.mystcraft.world.profiling.ChunkProfiler;
import com.xcompwiz.mystcraft.world.profiling.ChunkProfilerManager;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;

public class MystWorldGenerator
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World worldObj, IChunkProvider chunkGenerator, IChunkProvider ichunkprovider) {
        if (!(worldObj.field_73011_w instanceof WorldProviderMyst)) {
            return;
        }
        AgeController controller = ((WorldProviderMyst)worldObj.field_73011_w).getAgeController();
        ChunkCoordinates spawn = worldObj.func_72861_E();
        if (spawn != null && spawn.field_71574_a >> 4 == chunkX && spawn.field_71573_c >> 4 == chunkZ) {
            MystWorldGenerator.generatePlatform(worldObj, spawn.field_71574_a, spawn.field_71572_b - 1, spawn.field_71573_c, Blocks.field_150347_e);
        }
        ChunkProfiler profiler = controller.getChunkProfiler();
        this.profileCompletedChunks(profiler, chunkX, chunkZ, ichunkprovider);
    }

    private void profileCompletedChunks(ChunkProfiler profiler, int chunkX, int chunkZ, IChunkProvider ichunkprovider) {
        for (int i = chunkX - 1; i <= chunkX + 1; ++i) {
            for (int k = chunkZ - 1; k <= chunkZ + 1; ++k) {
                Chunk chunk;
                if (!ichunkprovider.func_73149_a(i, k) || !this.checkForCompletion(ichunkprovider, chunk = ichunkprovider.func_73158_c(i, k), i, k)) continue;
                ChunkProfilerManager.addChunk(profiler, chunk);
            }
        }
    }

    private boolean checkForCompletion(IChunkProvider ichunkprovider, Chunk chunk, int chunkX, int chunkZ) {
        if (!chunk.field_76646_k) {
            return false;
        }
        if (!ichunkprovider.func_73149_a(chunkX - 1, chunkZ - 1)) {
            return false;
        }
        if (!ichunkprovider.func_73149_a(chunkX, chunkZ - 1)) {
            return false;
        }
        if (!ichunkprovider.func_73149_a(chunkX + 1, chunkZ - 1)) {
            return false;
        }
        if (!ichunkprovider.func_73149_a(chunkX - 1, chunkZ)) {
            return false;
        }
        if (!ichunkprovider.func_73149_a(chunkX + 1, chunkZ)) {
            return false;
        }
        if (!ichunkprovider.func_73149_a(chunkX - 1, chunkZ + 1)) {
            return false;
        }
        if (!ichunkprovider.func_73149_a(chunkX, chunkZ + 1)) {
            return false;
        }
        if (!ichunkprovider.func_73149_a(chunkX + 1, chunkZ + 1)) {
            return false;
        }
        if (!ichunkprovider.func_73154_d((int)(chunkX - 1), (int)(chunkZ - 1)).field_76646_k) {
            return false;
        }
        if (!ichunkprovider.func_73154_d((int)chunkX, (int)(chunkZ - 1)).field_76646_k) {
            return false;
        }
        if (!ichunkprovider.func_73154_d((int)(chunkX + 1), (int)(chunkZ - 1)).field_76646_k) {
            return false;
        }
        if (!ichunkprovider.func_73154_d((int)(chunkX - 1), (int)chunkZ).field_76646_k) {
            return false;
        }
        if (!ichunkprovider.func_73154_d((int)(chunkX + 1), (int)chunkZ).field_76646_k) {
            return false;
        }
        if (!ichunkprovider.func_73154_d((int)(chunkX - 1), (int)(chunkZ + 1)).field_76646_k) {
            return false;
        }
        if (!ichunkprovider.func_73154_d((int)chunkX, (int)(chunkZ + 1)).field_76646_k) {
            return false;
        }
        return ichunkprovider.func_73154_d((int)(chunkX + 1), (int)(chunkZ + 1)).field_76646_k;
    }

    private static void generatePlatform(World worldObj, int i, int j, int k, Block block) {
        int size = 2;
        for (int x = -size; x <= size; ++x) {
            for (int z = -size; z <= size; ++z) {
                worldObj.func_147465_d(i + x, j, k + z, block, 0, 2);
                for (int y = j + 1; y < j + 5; ++y) {
                    worldObj.func_147465_d(i + x, y, k + z, Blocks.field_150350_a, 0, 2);
                }
            }
        }
    }
}

