/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.world.gen;

import com.xcompwiz.mystcraft.world.gen.MapGenAdvanced;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class MapGenRavineMyst
extends MapGenAdvanced {
    private float[] field_75046_d = new float[1024];

    public MapGenRavineMyst(long seed, Block block) {
        this(seed, block, 0);
    }

    public MapGenRavineMyst(long seed, Block block, byte blockMeta) {
        super(seed, block, blockMeta);
    }

    protected void generateRavine(long seed, int chunkX, int chunkZ, Block[] blocks, byte[] metadata, double baseX, double baseY, double baseZ, float par12, float par13, float par14, int par15, int par16, double par17) {
        Random rand = new Random(seed);
        double chunkXmid = chunkX * 16 + 8;
        double chunkZmid = chunkZ * 16 + 8;
        int layers = blocks.length / 256;
        float var24 = 0.0f;
        float var25 = 0.0f;
        if (par16 <= 0) {
            int var26 = this.range * 16 - 16;
            par16 = var26 - rand.nextInt(var26 / 4);
        }
        boolean flag1 = false;
        if (par15 == -1) {
            par15 = par16 / 2;
            flag1 = true;
        }
        float var27 = 1.0f;
        for (int var28 = 0; var28 < 128; ++var28) {
            if (var28 == 0 || rand.nextInt(3) == 0) {
                var27 = 1.0f + rand.nextFloat() * rand.nextFloat() * 1.0f;
            }
            this.field_75046_d[var28] = var27 * var27;
        }
        while (par15 < par16) {
            double var53 = 1.5 + (double)(MathHelper.func_76126_a((float)((float)par15 * (float)Math.PI / (float)par16)) * par12 * 1.0f);
            double var30 = var53 * par17;
            var53 *= (double)rand.nextFloat() * 0.25 + 0.75;
            var30 *= (double)rand.nextFloat() * 0.25 + 0.75;
            float var32 = MathHelper.func_76134_b((float)par14);
            float var33 = MathHelper.func_76126_a((float)par14);
            baseX += (double)(MathHelper.func_76134_b((float)par13) * var32);
            baseY += (double)var33;
            baseZ += (double)(MathHelper.func_76126_a((float)par13) * var32);
            par14 *= 0.7f;
            par14 += var25 * 0.05f;
            par13 += var24 * 0.05f;
            var25 *= 0.8f;
            var24 *= 0.5f;
            var25 += (rand.nextFloat() - rand.nextFloat()) * rand.nextFloat() * 2.0f;
            var24 += (rand.nextFloat() - rand.nextFloat()) * rand.nextFloat() * 4.0f;
            if (flag1 || rand.nextInt(4) != 0) {
                double var34 = baseX - chunkXmid;
                double var36 = baseZ - chunkZmid;
                double var38 = par16 - par15;
                double var40 = par12 + 2.0f + 16.0f;
                if (var34 * var34 + var36 * var36 - var38 * var38 > var40 * var40) {
                    return;
                }
                if (baseX >= chunkXmid - 16.0 - var53 * 2.0 && baseZ >= chunkZmid - 16.0 - var53 * 2.0 && baseX <= chunkXmid + 16.0 + var53 * 2.0 && baseZ <= chunkZmid + 16.0 + var53 * 2.0) {
                    int localY;
                    int minX = MathHelper.func_76128_c((double)(baseX - var53)) - chunkX * 16 - 1;
                    int maxX = MathHelper.func_76128_c((double)(baseX + var53)) - chunkX * 16 + 1;
                    int minY = MathHelper.func_76128_c((double)(baseY - var30)) - 1;
                    int maxY = MathHelper.func_76128_c((double)(baseY + var30)) + 1;
                    int minZ = MathHelper.func_76128_c((double)(baseZ - var53)) - chunkZ * 16 - 1;
                    int maxZ = MathHelper.func_76128_c((double)(baseZ + var53)) - chunkZ * 16 + 1;
                    if (minX < 0) {
                        minX = 0;
                    }
                    if (maxX > 16) {
                        maxX = 16;
                    }
                    if (minY < 1) {
                        minY = 1;
                    }
                    if (maxY > layers) {
                        maxY = layers;
                    }
                    if (minZ < 0) {
                        minZ = 0;
                    }
                    if (maxZ > 16) {
                        maxZ = 16;
                    }
                    boolean foundwater = false;
                    for (localY = maxY + 1; !foundwater && localY >= minY - 1; --localY) {
                        for (int localZ = minZ; !foundwater && localZ < maxZ; ++localZ) {
                            for (int localX = minX; !foundwater && localX < maxX; ++localX) {
                                int coords = localY << 8 | localZ << 4 | localX;
                                if (localY < 0 || localY >= layers) continue;
                                if (blocks[coords] == Blocks.field_150355_j || blocks[coords] == Blocks.field_150355_j) {
                                    foundwater = true;
                                }
                                if (localY == minY - 1 || localX == minX || localX == maxX - 1 || localZ == minZ || localZ == maxZ - 1) continue;
                                localY = minY;
                            }
                        }
                    }
                    if (!foundwater) {
                        for (localY = 0; localY < minY; ++localY) {
                            double yfactor = ((double)localY + 0.5 - baseY) / var30;
                            double yfactorSq = yfactor * yfactor;
                            for (int localZ = minZ; localZ < maxZ; ++localZ) {
                                double zfactor = ((double)(localZ + chunkZ * 16) + 0.5 - baseZ) / var53;
                                double zfactorSq = zfactor * zfactor;
                                for (int localX = minX; localX < maxX; ++localX) {
                                    double xfactor = ((double)(localX + chunkX * 16) + 0.5 - baseX) / var53;
                                    double xfactorSq = xfactor * xfactor;
                                    int coords = localY << 8 | localZ << 4 | localX;
                                    if (!(xfactorSq + zfactorSq < 1.0) || !((xfactorSq + zfactorSq) * (double)this.field_75046_d[localY] + yfactorSq / 6.0 < 1.0)) continue;
                                    this.placeBlock(blocks, metadata, coords);
                                }
                            }
                        }
                        if (flag1) break;
                    }
                }
            }
            ++par15;
        }
    }

    @Override
    protected void recursiveGenerate(World par1World, int par2, int par3, int par4, int par5, Block[] blocks, byte[] metadata) {
        if (this.rand.nextInt(50) == 0) {
            double x = par2 * 16 + this.rand.nextInt(16);
            double y = this.rand.nextInt(this.rand.nextInt(40) + 8) + 20;
            double z = par3 * 16 + this.rand.nextInt(16);
            int var13 = 1;
            for (int var14 = 0; var14 < var13; ++var14) {
                float var15 = this.rand.nextFloat() * (float)Math.PI * 2.0f;
                float var16 = (this.rand.nextFloat() - 0.5f) * 2.0f / 8.0f;
                float var17 = (this.rand.nextFloat() * 2.0f + this.rand.nextFloat()) * 2.0f;
                this.generateRavine(this.rand.nextLong(), par4, par5, blocks, metadata, x, y, z, var17, var15, var16, 0, 0, 3.0);
            }
        }
    }
}

