/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.world.gen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class MapGenAdvanced {
    protected int range = 8;
    protected Random rand = new Random();
    private long seed;
    private Block block;
    private byte blockMeta;
    private boolean profiling = false;
    private int blockcount;
    private int blockcounttotal = 0;
    private int callcount = 0;
    private int fillcount = 0;

    public MapGenAdvanced(long seed, Block block, byte blockMeta) {
        this.seed = seed;
        this.block = block;
        this.blockMeta = blockMeta;
    }

    public void generate(IChunkProvider chunkprovider, World worldObj, int chunkX, int chunkZ, Block[] blocks, byte[] metadata) {
        int range = this.range;
        this.rand.setSeed(this.seed);
        long xseed = this.rand.nextLong();
        long zseed = this.rand.nextLong();
        this.blockcount = 0;
        ++this.callcount;
        for (int x = chunkX - range; x <= chunkX + range; ++x) {
            for (int z = chunkZ - range; z <= chunkZ + range; ++z) {
                long xseed2 = (long)x * xseed;
                long zseed2 = (long)z * zseed;
                this.rand.setSeed(xseed2 ^ zseed2 ^ this.seed);
                this.recursiveGenerate(worldObj, x, z, chunkX, chunkZ, blocks, metadata);
            }
        }
        if (this.profiling) {
            if (this.blockcount > 0) {
                ++this.fillcount;
            }
            System.out.println(String.format("Using %s. AVG: [%f] / %d / %d TOT: [%d] GENFRQ: [%f:%f]", this.toString(), Float.valueOf((float)this.blockcounttotal / (float)this.fillcount), this.fillcount, this.callcount, this.blockcounttotal, Float.valueOf((float)this.fillcount / (float)this.callcount), Float.valueOf((float)this.blockcounttotal / (float)this.callcount)));
        }
    }

    protected void recursiveGenerate(World worldObj, int x, int z, int chunkX, int chunkZ, Block[] blocks, byte[] metadata) {
    }

    protected boolean placeBlock(Block[] blocks, byte[] metadata, int coords) {
        Block block = blocks[coords];
        if (this.block == null || block != null && block.func_149688_o().func_76224_d()) {
            return false;
        }
        if (block == Blocks.field_150357_h) {
            return false;
        }
        ++this.blockcounttotal;
        ++this.blockcount;
        blocks[coords] = this.block;
        metadata[coords] = this.blockMeta;
        return true;
    }

    public void setProfiling(boolean profiling) {
        this.profiling = profiling;
    }
}

