/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.symbol.symbols;

import com.xcompwiz.mystcraft.api.symbol.ModifierUtils;
import com.xcompwiz.mystcraft.api.util.Color;
import com.xcompwiz.mystcraft.api.util.ColorGradient;
import com.xcompwiz.mystcraft.api.world.AgeDirector;
import com.xcompwiz.mystcraft.symbol.SymbolBase;
import com.xcompwiz.mystcraft.symbol.symbols.CelestialBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class SymbolStarsTwinkle
extends SymbolBase {
    public SymbolStarsTwinkle(String identifier) {
        super(identifier);
    }

    @Override
    public void registerLogic(AgeDirector controller, long seed) {
        Number period = controller.popModifier("wavelength").asNumber();
        Number angle = controller.popModifier("angle").asNumber();
        ColorGradient gradient = ModifierUtils.popGradient(controller, 1.0f, 1.0f, 1.0f);
        controller.registerInterface(new SkyBackground(controller, seed, period, angle, gradient));
    }

    private class SkyBackground
    extends CelestialBase {
        private static final int layerscount = 10;
        private Random rand;
        private int[] starGLCallList;
        private long[] offsets;
        private boolean initialized;
        private long period;
        private float angle;
        private float offset = 0.0f;
        private ColorGradient gradient;
        private AgeDirector controller;

        SkyBackground(AgeDirector controller, long seed, Number period, Number angle, ColorGradient gradient) {
            this.controller = controller;
            this.rand = new Random(seed);
            if (period == null) {
                period = 1.8 * this.rand.nextDouble() + 0.2;
            }
            this.period = (long)(period.doubleValue() * 240000.0);
            if (angle == null) {
                angle = this.rand.nextDouble() * 360.0;
            }
            this.angle = -angle.floatValue();
            this.gradient = gradient;
        }

        @Override
        public void render(TextureManager texturemanager, World worldObj, float partial) {
            if (!this.initialized) {
                this.initialize();
            }
            float invertRain = 1.0f - worldObj.func_72867_j(partial);
            GL11.glDisable((int)3553);
            GL11.glBlendFunc((int)770, (int)1);
            GL11.glPushMatrix();
            GL11.glRotatef((float)this.angle, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(this.getCelestialPeriod(worldObj.func_72820_D(), partial) * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            float starbrightness = worldObj.func_72880_h(partial) * invertRain;
            if (starbrightness > 0.0f) {
                Color color = this.gradient.getColor((float)this.controller.getTime() / 12000.0f);
                for (int i = 0; i < this.starGLCallList.length; ++i) {
                    GL11.glColor4f((float)color.r, (float)color.g, (float)color.b, (float)(starbrightness * this.getLayerBrightness(i, worldObj, partial)));
                    GL11.glCallList((int)this.starGLCallList[i]);
                }
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        }

        private float getLayerBrightness(int i, World worldObj, float partial) {
            long time = worldObj.func_72820_D() + this.offsets[i];
            float f1 = ((float)(time %= 100L) + partial) / 100.0f;
            float f2 = 1.0f - (MathHelper.func_76134_b((float)(f1 * (float)Math.PI * 2.0f)) * 2.0f + 0.25f);
            if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            return f2;
        }

        public float getCelestialPeriod(long time, float partialTime) {
            if (this.period == 0L) {
                return this.offset;
            }
            int i = (int)(time % this.period);
            float f = ((float)i + partialTime) / (float)this.period + this.offset;
            if (f < 0.0f) {
                f += 1.0f;
            }
            if (f > 1.0f) {
                f -= 1.0f;
            }
            float f1 = f;
            f = 1.0f - (float)((Math.cos((double)f * Math.PI) + 1.0) / 2.0);
            f = f1 + (f - f1) / 3.0f;
            return f;
        }

        @SideOnly(value=Side.CLIENT)
        private void initialize() {
            int i;
            this.initialized = true;
            this.starGLCallList = new int[10];
            this.offsets = new long[this.starGLCallList.length];
            for (i = 0; i < this.offsets.length; ++i) {
                this.offsets[i] = this.rand.nextLong();
            }
            this.starGLCallList[0] = GLAllocation.func_74526_a((int)this.starGLCallList.length);
            for (i = 0; i < this.starGLCallList.length; ++i) {
                this.starGLCallList[i] = this.starGLCallList[0] + i;
                GL11.glPushMatrix();
                GL11.glNewList((int)this.starGLCallList[i], (int)4864);
                this.renderStars();
                GL11.glEndList();
                GL11.glPopMatrix();
            }
        }

        private void renderStars() {
            Tessellator tess = Tessellator.field_78398_a;
            tess.func_78382_b();
            for (int i = 0; i < 100; ++i) {
                double var4 = this.rand.nextFloat() * 2.0f - 1.0f;
                double var6 = this.rand.nextFloat() * 2.0f - 1.0f;
                double var8 = this.rand.nextFloat() * 2.0f - 1.0f;
                double var10 = 0.15f + this.rand.nextFloat() * 0.1f;
                double var12 = var4 * var4 + var6 * var6 + var8 * var8;
                if (!(var12 < 1.0) || !(var12 > 0.01)) continue;
                var12 = 1.0 / Math.sqrt(var12);
                double var14 = (var4 *= var12) * 100.0;
                double var16 = (var6 *= var12) * 100.0;
                double var18 = (var8 *= var12) * 100.0;
                double var20 = Math.atan2(var4, var8);
                double var22 = Math.sin(var20);
                double var24 = Math.cos(var20);
                double var26 = Math.atan2(Math.sqrt(var4 * var4 + var8 * var8), var6);
                double var28 = Math.sin(var26);
                double var30 = Math.cos(var26);
                double var32 = this.rand.nextDouble() * Math.PI * 2.0;
                double var34 = Math.sin(var32);
                double var36 = Math.cos(var32);
                this.setStarColor(i, tess);
                for (int var38 = 0; var38 < 4; ++var38) {
                    double var39 = 0.0;
                    double var41 = (double)((var38 & 2) - 1) * var10;
                    double var43 = (double)((var38 + 1 & 2) - 1) * var10;
                    double var47 = var41 * var36 - var43 * var34;
                    double var49 = var43 * var36 + var41 * var34;
                    double var53 = var47 * var28 + var39 * var30;
                    double var55 = var39 * var28 - var47 * var30;
                    double var57 = var55 * var22 - var49 * var24;
                    double var61 = var49 * var22 + var55 * var24;
                    tess.func_78377_a(var14 + var57, var16 + var53, var18 + var61);
                }
            }
            tess.func_78381_a();
        }

        private void setStarColor(int var3, Tessellator var2) {
        }
    }
}

