/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.linking;

import com.xcompwiz.mystcraft.Mystcraft;
import com.xcompwiz.mystcraft.api.linking.ILinkInfo;
import com.xcompwiz.mystcraft.linking.LinkController;
import com.xcompwiz.mystcraft.linking.LinkOptions;
import com.xcompwiz.mystcraft.network.packet.MPacketDimensions;
import com.xcompwiz.mystcraft.world.agedata.AgeData;
import com.xcompwiz.mystcraft.world.storage.FileUtils;
import cpw.mods.fml.common.FMLCommonHandler;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.common.DimensionManager;

public class DimensionUtils {
    private static final String PLAYER_DIM_UUID_TAG = "myst.dimUUID";

    public static int getNewDimensionUID() {
        int dimUId = DimensionManager.getNextFreeDimId();
        return dimUId;
    }

    public static Integer createAge() {
        Integer dimid = DimensionUtils.recycleDimension();
        if (dimid != null) {
            return dimid;
        }
        dimid = DimensionUtils.getNewDimensionUID();
        DimensionUtils.createAge(dimid);
        return dimid;
    }

    private static Integer recycleDimension() {
        if (Mystcraft.deadDims == null || Mystcraft.deadDims.isEmpty()) {
            return null;
        }
        Integer dimid = null;
        for (int i = 0; i < Mystcraft.deadDims.size(); ++i) {
            if (DimensionManager.getWorld((int)Mystcraft.deadDims.get(i)) != null) continue;
            dimid = Mystcraft.deadDims.remove(i);
            break;
        }
        if (dimid == null) {
            return null;
        }
        if (!FileUtils.deleteAgeChunkData(dimid)) {
            Mystcraft.deadDims.add(dimid);
            return null;
        }
        AgeData data = AgeData.getAge((int)dimid, false);
        data.recreate(dimid);
        return dimid;
    }

    public static AgeData createAge(int dimId) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server == null) {
            throw new RuntimeException("Cannot create dimension client-side. Misuse of Mystcraft API.");
        }
        DimensionManager.registerDimension((int)dimId, (int)Mystcraft.providerId);
        Mystcraft.registeredDims.add(dimId);
        server.func_71203_ab().func_148540_a((Packet)MPacketDimensions.createPacket(dimId));
        AgeData data = AgeData.getAge(dimId, false);
        return data;
    }

    public static boolean markDimensionDead(int dimId) {
        if (Mystcraft.homeDimension == dimId) {
            return false;
        }
        if (!DimensionManager.isDimensionRegistered((int)dimId)) {
            return false;
        }
        if (!Mystcraft.registeredDims.contains(dimId)) {
            return false;
        }
        AgeData.getAge(dimId, false).markDead();
        Mystcraft.deadDims.add(dimId);
        return true;
    }

    public static String getDimensionName(WorldProvider worldProvider) {
        return worldProvider.func_80007_l();
    }

    public static boolean isDimensionVisited(Integer dimId) {
        if (dimId == null) {
            return false;
        }
        return DimensionManager.isDimensionRegistered((int)dimId);
    }

    public static boolean isDimensionDead(int dimId) {
        if (!DimensionManager.isDimensionRegistered((int)dimId)) {
            return true;
        }
        if (!Mystcraft.registeredDims.contains(dimId)) {
            return false;
        }
        return AgeData.getAge(dimId, false).isDead();
    }

    public static int getLinkColor(ILinkInfo info) {
        if (info == null) {
            return 0;
        }
        Random rand = new Random(info.getDisplayName().hashCode());
        int color = 0;
        color += rand.nextInt(256);
        color += rand.nextInt(256) << 8;
        return color += rand.nextInt(256) << 16;
    }

    public static UUID getDimensionUUID(int dimId) {
        if (!DimensionManager.isDimensionRegistered((int)dimId)) {
            return null;
        }
        if (!Mystcraft.registeredDims.contains(dimId)) {
            return new UUID(dimId, 0L);
        }
        return AgeData.getAge(dimId, false).getUUID();
    }

    public static boolean checkDimensionUUID(int dimid, UUID uuid) {
        if (uuid == null) {
            return true;
        }
        UUID targetuuid = DimensionUtils.getDimensionUUID(dimid);
        if (targetuuid == null) {
            return true;
        }
        return targetuuid.equals(uuid);
    }

    public static UUID getPlayerDimensionUUID(EntityPlayer player) {
        NBTTagCompound nbt = player.getEntityData();
        if (nbt == null) {
            return null;
        }
        if ((nbt = nbt.func_74775_l("PlayerPersisted")) == null) {
            return null;
        }
        if (nbt.func_74764_b(PLAYER_DIM_UUID_TAG)) {
            return UUID.fromString(nbt.func_74779_i(PLAYER_DIM_UUID_TAG));
        }
        return null;
    }

    public static void setPlayerDimensionUUID(EntityPlayer player, UUID uuid) {
        NBTTagCompound nbt = player.getEntityData();
        if (!nbt.func_74764_b("PlayerPersisted")) {
            nbt.func_74782_a("PlayerPersisted", (NBTBase)new NBTTagCompound());
        }
        nbt = nbt.func_74775_l("PlayerPersisted");
        if (uuid != null) {
            nbt.func_74778_a(PLAYER_DIM_UUID_TAG, uuid.toString());
        } else {
            nbt.func_82580_o(PLAYER_DIM_UUID_TAG);
        }
    }

    public static void ejectPlayerFromDimension(EntityPlayer player) {
        if (DimensionUtils.isDimensionDead(Mystcraft.homeDimension)) {
            throw new RuntimeException("The Mystcraft Home Dimension is flagged as dead. This is a serious problem...");
        }
        LinkOptions link = new LinkOptions(null);
        link.setDimensionUID(Mystcraft.homeDimension);
        link.setFlag("Op-TP", true);
        LinkController.travelEntity(player.field_70170_p, (Entity)player, link);
    }
}

