/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.data;

import com.xcompwiz.mystcraft.api.impl.InternalAPI;
import com.xcompwiz.mystcraft.data.ModSymbolsModifiers;
import com.xcompwiz.mystcraft.grammar.GrammarGenerator;
import com.xcompwiz.mystcraft.instability.InstabilityData;
import com.xcompwiz.mystcraft.logging.LoggerUtils;
import com.xcompwiz.mystcraft.symbol.SymbolBase;
import com.xcompwiz.mystcraft.symbol.modifiers.SymbolAngle;
import com.xcompwiz.mystcraft.symbol.modifiers.SymbolBiome;
import com.xcompwiz.mystcraft.symbol.modifiers.SymbolClear;
import com.xcompwiz.mystcraft.symbol.modifiers.SymbolGradient;
import com.xcompwiz.mystcraft.symbol.modifiers.SymbolHorizonColor;
import com.xcompwiz.mystcraft.symbol.modifiers.SymbolLength;
import com.xcompwiz.mystcraft.symbol.modifiers.SymbolNoSea;
import com.xcompwiz.mystcraft.symbol.modifiers.SymbolPhase;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolAntiPvP;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolBiomeControllerGrid;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolBiomeControllerHuge;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolBiomeControllerLarge;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolBiomeControllerMedium;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolBiomeControllerNative;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolBiomeControllerSingle;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolBiomeControllerSmall;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolBiomeControllerTiled;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolBiomeControllerTiny;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolCaves;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolColorCloud;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolColorCloudNatural;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolColorFog;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolColorFogNatural;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolColorFoliage;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolColorFoliageNatural;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolColorGrass;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolColorGrassNatural;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolColorSky;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolColorSkyNatural;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolColorSkyNight;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolColorWater;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolColorWaterNatural;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolCrystalFormation;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolDenseOres;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolDoodadRainbow;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolDummy;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolDungeons;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolEnvAccelerated;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolEnvExplosions;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolEnvLightning;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolEnvMeteor;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolEnvScorched;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolFloatingIslands;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolHideHorizon;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolHugeTrees;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolLakesDeep;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolLakesSurface;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolLightingBright;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolLightingDark;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolLightingNormal;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolMineshafts;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolMoonNormal;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolNetherFort;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolObelisks;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolRavines;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolSkylands;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolSpheres;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolSpikes;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolStarFissure;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolStarsEndSky;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolStarsNormal;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolStarsTwinkle;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolStrongholds;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolSunNormal;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolTendrils;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolTerrainGenAmplified;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolTerrainGenEnd;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolTerrainGenFlat;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolTerrainGenNether;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolTerrainGenNormal;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolTerrainGenVoid;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolVillages;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolWeatherAlways;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolWeatherCloudy;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolWeatherFast;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolWeatherNormal;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolWeatherOff;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolWeatherRain;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolWeatherSlow;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolWeatherSnow;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolWeatherStorm;
import com.xcompwiz.util.CollectionUtils;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.world.biome.BiomeGenBase;

public class ModSymbols {
    public static void registerSymbol(SymbolBase symbol2, Integer cardrank, String ... poem) {
        if (poem.length != 4) {
            LoggerUtils.warn("Weird poem length (%d) when registering %s", poem.length, symbol2.identifier());
        }
        symbol2.setWords(poem);
        symbol2.setCardRank(cardrank);
        InternalAPI.symbol.registerSymbol(symbol2, "Mystcraft");
    }

    public static void generateBiomeSymbols() {
        for (int i = 0; i < BiomeGenBase.func_150565_n().length; ++i) {
            BiomeGenBase biome = BiomeGenBase.func_150568_d((int)i);
            if (biome == null) continue;
            if (biome.field_76791_y == null) {
                LoggerUtils.warn("Biome (id " + i + ") has null name, could not build symbol", new Object[0]);
                continue;
            }
            if (biome.field_76756_M != i) {
                LoggerUtils.warn("Biome (id " + biome.field_76756_M + ") is in list as element " + i + ".", new Object[0]);
                continue;
            }
            SymbolBiome symbol2 = new SymbolBiome(biome);
            if (!InternalAPI.symbol.registerSymbol(symbol2, "Mystcraft")) continue;
            Integer rank = 1;
            if (biome == BiomeGenBase.field_76779_k) {
                rank = null;
            } else {
                symbol2.setCardRank(2);
            }
            GrammarGenerator.registerRule(new GrammarGenerator.Rule("Biome", CollectionUtils.buildList(symbol2.identifier()), rank));
            InternalAPI.symbolValues.setSymbolTradeItem(symbol2, new ItemStack(Items.field_151166_bC, 1));
            SymbolBiome.selectables.add(biome);
        }
    }

    public static void initialize() {
        ModSymbolsModifiers.initialize();
        ModSymbols.registerSymbol(new SymbolColorCloud("ColorCloud"), 1, "Image", "Entropy", "Believe", "Weave");
        ModSymbols.registerSymbol(new SymbolColorCloudNatural("ColorCloudNat"), 1, "Image", "Entropy", "Believe", "Nature");
        ModSymbols.registerSymbol(new SymbolColorFog("ColorFog"), 1, "Image", "Entropy", "Explore", "Weave");
        ModSymbols.registerSymbol(new SymbolColorFogNatural("ColorFogNat"), 1, "Image", "Entropy", "Explore", "Nature");
        ModSymbols.registerSymbol(new SymbolColorFoliage("ColorFoliage"), 1, "Image", "Growth", "Elevate", "Weave");
        ModSymbols.registerSymbol(new SymbolColorFoliageNatural("ColorFoliageNat"), 1, "Image", "Growth", "Elevate", "Nature");
        ModSymbols.registerSymbol(new SymbolColorGrass("ColorGrass"), 1, "Image", "Growth", "Resilience", "Weave");
        ModSymbols.registerSymbol(new SymbolColorGrassNatural("ColorGrassNat"), 1, "Image", "Growth", "Resilience", "Nature");
        ModSymbols.registerSymbol(new SymbolColorSky("ColorSky"), 1, "Image", "Celestial", "Harmony", "Weave");
        ModSymbols.registerSymbol(new SymbolColorSkyNatural("ColorSkyNat"), 1, "Image", "Celestial", "Harmony", "Nature");
        ModSymbols.registerSymbol(new SymbolColorSkyNight("ColorSkyNight"), 1, "Image", "Celestial", "Contradict", "Weave");
        ModSymbols.registerSymbol(new SymbolColorWater("ColorWater"), 1, "Image", "Flow", "Constraint", "Weave");
        ModSymbols.registerSymbol(new SymbolColorWaterNatural("ColorWaterNat"), 1, "Image", "Flow", "Constraint", "Nature");
        ModSymbols.registerSymbol(new SymbolDoodadRainbow("Rainbow"), 1, "Celestial", "Image", "Harmony", "Balance");
        ModSymbols.registerSymbol(new SymbolHideHorizon("NoHorizon"), 1, "Celestial", "Inhibit", "Image", "Void");
        ModSymbols.registerSymbol(new SymbolDummy("MoonDark"), 1, "Celestial", "Void", "Inhibit", "Wisdom");
        ModSymbols.registerSymbol(new SymbolMoonNormal("MoonNormal"), 1, "Celestial", "Image", "Cycle", "Wisdom");
        ModSymbols.registerSymbol(new SymbolDummy("StarsDark"), 1, "Celestial", "Void", "Inhibit", "Order");
        ModSymbols.registerSymbol(new SymbolStarsEndSky("StarsEndSky"), 1, "Celestial", "Image", "Chaos", "Weave");
        ModSymbols.registerSymbol(new SymbolStarsNormal("StarsNormal"), 1, "Celestial", "Harmony", "Ethereal", "Order");
        ModSymbols.registerSymbol(new SymbolStarsTwinkle("StarsTwinkle"), 1, "Celestial", "Harmony", "Ethereal", "Entropy");
        ModSymbols.registerSymbol(new SymbolDummy("SunDark"), 1, "Celestial", "Void", "Inhibit", "Energy");
        ModSymbols.registerSymbol(new SymbolSunNormal("SunNormal"), 2, "Celestial", "Image", "Stimulate", "Energy");
        ModSymbols.registerSymbol(new SymbolBiomeControllerGrid("BioConGrid"), 3, "Constraint", "Nature", "Chain", "Mutual");
        ModSymbols.registerSymbol(new SymbolBiomeControllerNative("BioConNative"), 3, "Constraint", "Nature", "Tradition", "Sustain");
        ModSymbols.registerSymbol(new SymbolBiomeControllerSingle("BioConSingle"), 3, "Constraint", "Nature", "Infinite", "Static");
        ModSymbols.registerSymbol(new SymbolBiomeControllerTiled("BioConTiled"), 3, "Constraint", "Nature", "Chain", "Contradict");
        ModSymbols.registerSymbol(new SymbolBiomeControllerHuge("BioConHuge"), 3, "Constraint", "Nature", "Weave", "Huge");
        ModSymbols.registerSymbol(new SymbolBiomeControllerLarge("BioConLarge"), 3, "Constraint", "Nature", "Weave", "Large");
        ModSymbols.registerSymbol(new SymbolBiomeControllerMedium("BioConMedium"), 3, "Constraint", "Nature", "Weave", "Medium");
        ModSymbols.registerSymbol(new SymbolBiomeControllerSmall("BioConSmall"), 3, "Constraint", "Nature", "Weave", "Small");
        ModSymbols.registerSymbol(new SymbolBiomeControllerTiny("BioConTiny"), 3, "Constraint", "Nature", "Weave", "Tiny");
        ModSymbols.registerSymbol(new SymbolNoSea("NoSea"), 2, "Transform", "Constraint", "Flow", "Inhibit");
        ModSymbols.registerSymbol(new SymbolAntiPvP("PvPOff"), null, "Chain", "Chaos", "Encourage", "Harmony");
        ModSymbols.registerSymbol(new SymbolEnvAccelerated("EnvAccel"), 3, "Survival", "Dynamic", "Change", "Spur");
        ModSymbols.registerSymbol(new SymbolEnvExplosions("EnvExplosions"), 3, "Survival", "Sacrifice", "Power", "Force");
        ModSymbols.registerSymbol(new SymbolEnvLightning("EnvLightning"), 3, "Survival", "Sacrifice", "Power", "Energy");
        ModSymbols.registerSymbol(new SymbolEnvMeteor("EnvMeteor"), 3, "Survival", "Sacrifice", "Power", "Momentum");
        ModSymbols.registerSymbol(new SymbolEnvScorched("EnvScorch"), 3, "Survival", "Sacrifice", "Power", "Chaos");
        ModSymbols.registerSymbol(new SymbolLightingBright("LightingBright"), 3, "Ethereal", "Power", "Infinite", "Spur");
        ModSymbols.registerSymbol(new SymbolLightingDark("LightingDark"), 3, "Ethereal", "Void", "Constraint", "Inhibit");
        ModSymbols.registerSymbol(new SymbolLightingNormal("LightingNormal"), 2, "Ethereal", "Dynamic", "Cycle", "Balance");
        ModSymbols.registerSymbol(new SymbolAngle("ModNorth", 0.0f, "North"), 0, "Transform", "Flow", "Motion", "Control");
        ModSymbols.registerSymbol(new SymbolAngle("ModEast", 90.0f, "East"), 0, "Transform", "Flow", "Motion", "Tradition");
        ModSymbols.registerSymbol(new SymbolAngle("ModSouth", 180.0f, "South"), 0, "Transform", "Flow", "Motion", "Chaos");
        ModSymbols.registerSymbol(new SymbolAngle("ModWest", 270.0f, "West"), 0, "Transform", "Flow", "Motion", "Change");
        ModSymbols.registerSymbol(new SymbolClear("ModClear"), 0, "Contradict", "Transform", "Change", "Void");
        ModSymbols.registerSymbol(new SymbolGradient("ModGradient"), 0, "Transform", "Image", "Merge", "Weave");
        ModSymbols.registerSymbol(new SymbolHorizonColor("ColorHorizon"), 0, "Transform", "Image", "Celestial", "Change");
        ModSymbols.registerSymbol(new SymbolLength("ModZero", 0.0f, "Zero Length"), 0, "Transform", "Time", "System", "Inhibit");
        ModSymbols.registerSymbol(new SymbolLength("ModHalf", 0.5f, "Half Length"), 0, "Transform", "Time", "System", "Stimulate");
        ModSymbols.registerSymbol(new SymbolLength("ModFull", 1.0f, "Full Length"), 0, "Transform", "Time", "System", "Balance");
        ModSymbols.registerSymbol(new SymbolLength("ModDouble", 2.0f, "Double Length"), 0, "Transform", "Time", "System", "Sacrifice");
        ModSymbols.registerSymbol(new SymbolPhase("ModEnd", 0.0f, "Nadir"), 0, "Transform", "Cycle", "System", "Rebirth");
        ModSymbols.registerSymbol(new SymbolPhase("ModRising", 90.0f, "Rising"), 0, "Transform", "Cycle", "System", "Growth");
        ModSymbols.registerSymbol(new SymbolPhase("ModNoon", 180.0f, "Zenith"), 0, "Transform", "Cycle", "System", "Harmony");
        ModSymbols.registerSymbol(new SymbolPhase("ModSetting", 270.0f, "Setting"), 0, "Transform", "Cycle", "System", "Future");
        ModSymbols.registerSymbol(new SymbolCaves("Caves"), 2, "Terrain", "Transform", "Void", "Flow");
        ModSymbols.registerSymbol(new SymbolDungeons("Dungeons"), 2, "Civilization", "Constraint", "Chain", "Resurrect");
        ModSymbols.registerSymbol(new SymbolFloatingIslands("FloatIslands"), 3, "Terrain", "Transform", "Form", "Celestial");
        ModSymbols.registerSymbol(new SymbolDummy("FeatureLargeDummy", InstabilityData.symbol.dummyFeatureLarge), 4, "Contradict", "Chaos", "Exist", "Terrain");
        ModSymbols.registerSymbol(new SymbolDummy("FeatureMediumDummy", InstabilityData.symbol.dummyFeatureMedium), 4, "Contradict", "Chaos", "Exist", "Balance");
        ModSymbols.registerSymbol(new SymbolDummy("FeatureSmallDummy", InstabilityData.symbol.dummyFeatureSmall), 5, "Contradict", "Chaos", "Exist", "Form");
        ModSymbols.registerSymbol(new SymbolHugeTrees("HugeTrees"), 2, "Nature", "Stimulate", "Spur", "Elevate");
        ModSymbols.registerSymbol(new SymbolLakesDeep("LakesDeep"), 3, "Nature", "Flow", "Static", "Explore");
        ModSymbols.registerSymbol(new SymbolLakesSurface("LakesSurface"), 3, "Nature", "Flow", "Static", "Elevate");
        ModSymbols.registerSymbol(new SymbolMineshafts("Mineshafts"), 3, "Civilization", "Machine", "Motion", "Tradition");
        ModSymbols.registerSymbol(new SymbolNetherFort("NetherFort"), 3, "Civilization", "Machine", "Power", "Entropy");
        ModSymbols.registerSymbol(new SymbolObelisks("Obelisks"), 3, "Civilization", "Resilience", "Static", "Form");
        ModSymbols.registerSymbol(new SymbolRavines("Ravines"), 2, "Terrain", "Transform", "Void", "Weave");
        ModSymbols.registerSymbol(new SymbolSpheres("TerModSpheres"), 2, "Terrain", "Transform", "Form", "Cycle");
        ModSymbols.registerSymbol(new SymbolSpikes("GenSpikes"), 3, "Nature", "Encourage", "Entropy", "Static");
        ModSymbols.registerSymbol(new SymbolStrongholds("Strongholds"), 3, "Civilization", "Wisdom", "Future", "Honor");
        ModSymbols.registerSymbol(new SymbolTendrils("Tendrils"), 3, "Terrain", "Transform", "Growth", "Flow");
        ModSymbols.registerSymbol(new SymbolVillages("Villages"), 3, "Civilization", "Society", "Harmony", "Nurture");
        ModSymbols.registerSymbol(new SymbolCrystalFormation("CryForm"), 3, "Nature", "Encourage", "Growth", "Static");
        ModSymbols.registerSymbol(new SymbolSkylands("Skylands"), 3, "Terrain", "Transform", "Void", "Elevate");
        ModSymbols.registerSymbol(new SymbolStarFissure("StarFissure"), 3, "Nature", "Harmony", "Mutual", "Void");
        ModSymbols.registerSymbol(new SymbolDenseOres("DenseOres"), 5, "Survival", "Stimulate", "Machine", "Chaos");
        ModSymbols.registerSymbol(new SymbolWeatherAlways("WeatherOn"), 3, "Sustain", "Static", "Tradition", "Stimulate");
        ModSymbols.registerSymbol(new SymbolWeatherCloudy("WeatherCloudy"), 3, "Sustain", "Static", "Believe", "Motion");
        ModSymbols.registerSymbol(new SymbolWeatherFast("WeatherFast"), 3, "Sustain", "Dynamic", "Tradition", "Spur");
        ModSymbols.registerSymbol(new SymbolWeatherNormal("WeatherNorm"), 2, "Sustain", "Dynamic", "Tradition", "Balance");
        ModSymbols.registerSymbol(new SymbolWeatherOff("WeatherOff"), 3, "Sustain", "Static", "Stimulate", "Energy");
        ModSymbols.registerSymbol(new SymbolWeatherRain("WeatherRain"), 3, "Sustain", "Static", "Rebirth", "Growth");
        ModSymbols.registerSymbol(new SymbolWeatherSlow("WeatherSlow"), 3, "Sustain", "Dynamic", "Tradition", "Inhibit");
        ModSymbols.registerSymbol(new SymbolWeatherSnow("WeatherSnow"), 3, "Sustain", "Static", "Inhibit", "Energy");
        ModSymbols.registerSymbol(new SymbolWeatherStorm("WeatherStorm"), 3, "Sustain", "Static", "Nature", "Power");
        ModSymbols.registerSymbol(new SymbolTerrainGenAmplified("TerrainAmplified"), 3, "Terrain", "Form", "Tradition", "Spur");
        ModSymbols.registerSymbol(new SymbolTerrainGenEnd("TerrainEnd"), 4, "Terrain", "Form", "Ethereal", "Flow");
        ModSymbols.registerSymbol(new SymbolTerrainGenFlat("TerrainFlat"), 3, "Terrain", "Form", "Inhibit", "Motion");
        ModSymbols.registerSymbol(new SymbolTerrainGenNether("TerrainNether"), 4, "Terrain", "Form", "Constraint", "Entropy");
        ModSymbols.registerSymbol(new SymbolTerrainGenNormal("TerrainNormal"), 2, "Terrain", "Form", "Tradition", "Flow");
        ModSymbols.registerSymbol(new SymbolTerrainGenVoid("TerrainVoid"), 4, "Terrain", "Form", "Infinite", "Void");
    }
}

