/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.client.render;

import com.xcompwiz.util.MathBezier;
import com.xcompwiz.util.Vector;
import com.xcompwiz.util.VectorPool;
import java.awt.Color;
import org.lwjgl.opengl.GL11;

public class DniColorRenderer {
    static Vector[] points = new Vector[4];

    public static void render(Color color, Vector center, double radius) {
        Vector point;
        double pos;
        int i;
        GL11.glDisable((int)3553);
        GL11.glLineWidth((float)3.0f);
        GL11.glColor3f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f));
        float[] HSB = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        int H = (int)(HSB[0] * 360.0f);
        double eyelidRadius = radius;
        float eyeRadius = (1.0f + (1.0f - HSB[1]) * 3.0f) * (float)radius / 20.0f;
        boolean outerEyelid = false;
        boolean innerEyelid = false;
        boolean eye = false;
        if (HSB[1] > 0.3f && HSB[2] > 0.5f) {
            if (H <= 28 || H > 274) {
                int temp = (H + 85) % 360;
                eyelidRadius = MathBezier.abs((double)MathBezier.cos((float)temp / 114.0f) * radius);
                outerEyelid = true;
                innerEyelid = true;
            } else if (H <= 114) {
                int temp = H - 30;
                outerEyelid = true;
                eyelidRadius = MathBezier.abs((double)MathBezier.sin((float)temp / 86.0f) * radius);
                eye = true;
            } else if (H <= 274) {
                int temp = H - 114;
                innerEyelid = true;
                eyelidRadius = MathBezier.abs((double)MathBezier.cos((float)temp / 160.0f) * radius);
                eye = true;
            }
        } else {
            int temp;
            float mod = MathBezier.min(HSB[1], HSB[2]) / 0.3f;
            eyeRadius *= HSB[2] / 0.3f;
            if (H <= 28 || H > 274) {
                temp = (H + 85) % 360;
                if (mod < 0.3f) {
                    eyelidRadius = MathBezier.abs((double)MathBezier.max(MathBezier.cos((float)temp / 114.0f), 1.0f - mod / 0.3f) * radius);
                    eye = true;
                } else {
                    eyelidRadius = MathBezier.abs((double)MathBezier.min(MathBezier.cos((float)temp / 114.0f), (mod - 0.3f) / 0.7f) * radius);
                    innerEyelid = true;
                }
                outerEyelid = true;
            } else if (H <= 114) {
                temp = H - 30;
                outerEyelid = true;
                eyelidRadius = MathBezier.abs((double)MathBezier.max(MathBezier.cos((float)temp / 86.0f), 1.0f - mod) * radius);
                eye = true;
            } else if (H <= 274) {
                temp = H - 114;
                innerEyelid = true;
                eyelidRadius = MathBezier.abs((double)MathBezier.max(MathBezier.cos((float)temp / 160.0f), 1.0f - mod) * radius);
                eye = true;
            }
        }
        if ((double)eyeRadius > eyelidRadius) {
            eyeRadius = (float)eyelidRadius;
        }
        eyelidRadius *= 1.3333333333333333;
        int max = 20;
        Vector top = VectorPool.getFreeVector(center.posX, center.posY - radius, center.posZ);
        Vector bottom = VectorPool.getFreeVector(center.posX, center.posY + radius, center.posZ);
        Vector left = VectorPool.getFreeVector(center.posX - radius, center.posY, center.posZ);
        Vector right = VectorPool.getFreeVector(center.posX + radius, center.posY, center.posZ);
        if (eye) {
            GL11.glBegin((int)2);
            for (int i2 = 0; i2 <= max; ++i2) {
                float pos2 = (float)i2 / (float)max * 4.0f;
                GL11.glVertex3d((double)(center.posX + (double)(eyeRadius * MathBezier.cos(pos2))), (double)(center.posY + (double)(eyeRadius * MathBezier.sin(pos2))), (double)center.posZ);
            }
            GL11.glEnd();
        }
        if (outerEyelid) {
            Vector vec1 = VectorPool.getFreeVector(center.posX - radius * 0.95, center.posY - eyelidRadius, center.posZ);
            Vector vec2 = VectorPool.getFreeVector(center.posX + radius * 0.95, center.posY - eyelidRadius, center.posZ);
            DniColorRenderer.setPoints(points, left, vec1, vec2, right);
            GL11.glBegin((int)3);
            for (i = 0; i <= max; ++i) {
                pos = (double)i / (double)max;
                point = MathBezier.bezier(points, pos);
                GL11.glVertex3d((double)point.posX, (double)point.posY, (double)point.posZ);
            }
            GL11.glEnd();
            top = MathBezier.bezier(points, 0.5);
            vec1 = VectorPool.getFreeVector(center.posX - radius * 0.95, center.posY + eyelidRadius, center.posZ);
            vec2 = VectorPool.getFreeVector(center.posX + radius * 0.95, center.posY + eyelidRadius, center.posZ);
            DniColorRenderer.setPoints(points, left, vec1, vec2, right);
            GL11.glBegin((int)3);
            for (i = 0; i <= max; ++i) {
                pos = (double)i / (double)max;
                point = MathBezier.bezier(points, pos);
                GL11.glVertex3d((double)point.posX, (double)point.posY, (double)point.posZ);
            }
            GL11.glEnd();
            bottom = MathBezier.bezier(points, 0.5);
        }
        if (innerEyelid && !outerEyelid) {
            Vector vec1 = VectorPool.getFreeVector(top.posX - eyelidRadius, center.posY - radius * 0.95, top.posZ);
            Vector vec2 = VectorPool.getFreeVector(bottom.posX - eyelidRadius, center.posY + radius * 0.95, bottom.posZ);
            DniColorRenderer.setPoints(points, top, vec1, vec2, bottom);
            GL11.glBegin((int)3);
            for (i = 0; i <= max; ++i) {
                pos = (double)i / (double)max;
                point = MathBezier.bezier(points, pos);
                GL11.glVertex3d((double)point.posX, (double)point.posY, (double)point.posZ);
            }
            GL11.glEnd();
            vec1 = VectorPool.getFreeVector(top.posX + eyelidRadius, center.posY - radius * 0.95, top.posZ);
            vec2 = VectorPool.getFreeVector(bottom.posX + eyelidRadius, center.posY + radius * 0.95, bottom.posZ);
            DniColorRenderer.setPoints(points, top, vec1, vec2, bottom);
            GL11.glBegin((int)3);
            for (i = 0; i <= max; ++i) {
                pos = (double)i / (double)max;
                point = MathBezier.bezier(points, pos);
                GL11.glVertex3d((double)point.posX, (double)point.posY, (double)point.posZ);
            }
            GL11.glEnd();
        } else if (innerEyelid) {
            GL11.glBegin((int)1);
            GL11.glVertex3d((double)top.posX, (double)top.posY, (double)top.posZ);
            GL11.glVertex3d((double)bottom.posX, (double)bottom.posY, (double)bottom.posZ);
            GL11.glEnd();
        }
        GL11.glBegin((int)2);
        for (int i3 = 0; i3 <= max; ++i3) {
            float pos3 = (float)i3 / (float)max * 4.0f;
            GL11.glVertex3d((double)(center.posX + radius * (double)MathBezier.cos(pos3)), (double)(center.posY + radius * (double)MathBezier.sin(pos3)), (double)center.posZ);
        }
        GL11.glEnd();
        GL11.glEnable((int)3553);
        VectorPool.unuseVectors();
    }

    private static void setPoints(Vector[] pointsarray, Vector ... points) {
        for (int i = 0; i < points.length; ++i) {
            pointsarray[i] = points[i];
        }
    }
}

