/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.api.impl.linking;

import com.xcompwiz.mystcraft.api.linking.ILinkInfo;
import com.xcompwiz.mystcraft.api.util.Color;
import com.xcompwiz.mystcraft.api.util.ColorGradient;
import com.xcompwiz.mystcraft.data.InkEffects;
import com.xcompwiz.mystcraft.linking.DimensionUtils;
import com.xcompwiz.mystcraft.linking.LinkController;
import com.xcompwiz.mystcraft.linking.LinkListenerManager;
import com.xcompwiz.mystcraft.linking.LinkOptions;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class LinkingAPIDelegate {
    private static final Color defaultColor = new Color(1.0f, 1.0f, 1.0f);
    private static final Color emptyColor = new Color(0.0f, 0.0f, 0.0f);

    public boolean isLinkAllowed(Entity entity, ILinkInfo linkinfo) {
        return LinkListenerManager.isLinkPermitted(entity.field_70170_p, entity, linkinfo);
    }

    public void linkEntity(Entity entity, ILinkInfo linkInfo) {
        LinkController.travelEntity(entity.field_70170_p, entity, linkInfo);
    }

    public ILinkInfo createLinkInfoFromPosition(World world, Entity location) {
        LinkOptions link = new LinkOptions(null);
        link.setDimensionUID(world.field_73011_w.field_76574_g);
        link.setTargetUUID(DimensionUtils.getDimensionUUID(world.field_73011_w.field_76574_g));
        link.setSpawn(new ChunkCoordinates((int)Math.floor(location.field_70165_t), (int)Math.floor(location.field_70163_u), (int)Math.floor(location.field_70161_v)));
        link.setSpawnYaw(location.field_70177_z);
        link.setDisplayName(DimensionUtils.getDimensionName(world.field_73011_w));
        return link;
    }

    public ILinkInfo createLinkInfo(NBTTagCompound linkInfo) {
        return new LinkOptions(linkInfo);
    }

    public void registerLinkProperty(String identifier, Color color) {
        InkEffects.registerProperty(identifier, color);
    }

    public Collection<String> getLinkProperties() {
        return Collections.unmodifiableCollection(InkEffects.getProperties());
    }

    public Color getLinkPropertyColor(String identifier) {
        return InkEffects.getPropertyColor(identifier);
    }

    public ColorGradient getPropertiesGradient(Map<String, Float> properties) {
        ColorGradient gradient = new ColorGradient();
        float max = 1.0f;
        float total = 0.0f;
        for (Map.Entry<String, Float> entry : properties.entrySet()) {
            Color color = InkEffects.getPropertyColor(entry.getKey());
            if (entry.getValue().floatValue() < 0.001f) continue;
            if (color == null) {
                color = defaultColor;
            }
            float interval = entry.getValue().floatValue() * max;
            total += interval;
            if (interval > 0.3f) {
                gradient.pushColor(color, Float.valueOf(interval - 0.3f));
                interval = 0.3f;
            }
            gradient.pushColor(color, Float.valueOf(interval));
        }
        if (total < max - 0.01f) {
            float interval = max - total;
            if (interval > 0.3f) {
                gradient.pushColor(emptyColor, Float.valueOf(interval - 0.3f));
                interval = 0.3f;
            }
            gradient.pushColor(emptyColor, Float.valueOf(interval));
        }
        return gradient;
    }

    public void addPropertyToItem(ItemStack itemstack, String property, float probability) {
        InkEffects.addPropertyToItem(itemstack, property, probability);
    }

    public void addPropertyToItem(String name, String property, float probability) {
        InkEffects.addPropertyToItem(name, property, probability);
    }

    public void addPropertyToItem(Item item, String property, float probability) {
        InkEffects.addPropertyToItem(item, property, probability);
    }

    public Map<String, Float> getPropertiesForItem(ItemStack itemstack) {
        return InkEffects.getItemEffects(itemstack);
    }
}

