/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.World;

import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.RotaryCraft.Auxiliary.Interfaces.PressureTE;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPowerReceiver;
import Reika.RotaryCraft.Entities.EntitySonicShot;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidBase;

public class TileEntitySonicBorer
extends TileEntityPowerReceiver
implements PressureTE {
    private int pressure;
    public static final int FIRE_PRESSURE = 400;
    public static final int MAXPRESSURE = 1000;
    public int xstep;
    public int ystep;
    public int zstep;
    public static final int FOV = 3;

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.getIOSides(world, x, y, z, meta);
        this.getPower(false);
        this.updatePressure(world, x, y, z, meta);
        if (this.canFire(world, x, y, z, meta)) {
            this.fire(world, x, y, z, meta);
            this.pressure -= 400;
        }
        if (this.pressure > 1000) {
            this.overpressure(world, x, y, z);
        }
    }

    public final void getIOSides(World world, int x, int y, int z, int metadata) {
        switch (metadata) {
            case 1: {
                this.read = ForgeDirection.WEST;
                this.xstep = 1;
                this.ystep = 0;
                this.zstep = 0;
                break;
            }
            case 0: {
                this.read = ForgeDirection.EAST;
                this.xstep = -1;
                this.ystep = 0;
                this.zstep = 0;
                break;
            }
            case 3: {
                this.read = ForgeDirection.NORTH;
                this.xstep = 0;
                this.ystep = 0;
                this.zstep = 1;
                break;
            }
            case 2: {
                this.read = ForgeDirection.SOUTH;
                this.xstep = 0;
                this.ystep = 0;
                this.zstep = -1;
                break;
            }
            case 5: {
                this.read = ForgeDirection.UP;
                this.xstep = 0;
                this.ystep = -1;
                this.zstep = 0;
                break;
            }
            case 4: {
                this.read = ForgeDirection.DOWN;
                this.xstep = 0;
                this.ystep = 1;
                this.zstep = 0;
            }
        }
    }

    private void fire(World world, int x, int y, int z, int meta) {
        int r = this.getDistanceToSurface(world, x, y, z);
        if (r < 0) {
            return;
        }
        EntitySonicShot e = new EntitySonicShot(world, this, this.placer);
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)e);
        }
        ReikaSoundHelper.playSoundAtBlock((World)world, (int)x, (int)y, (int)z, (String)"random.explode");
    }

    private int getDistanceToSurface(World world, int x, int y, int z) {
        for (int m = 1; m < this.getMaxRange(); ++m) {
            Block b;
            int j;
            int i;
            int dx = x + m * this.xstep;
            int dy = y + m * this.ystep;
            int dz = z + m * this.zstep;
            boolean nonair = false;
            int k = 3;
            if (this.xstep != 0) {
                for (i = z - k; i <= z + k; ++i) {
                    for (j = y - k; j <= y + k; ++j) {
                        if (!TileEntitySonicBorer.canDrop(world, dx, j, i)) {
                            return -1;
                        }
                        b = world.func_147439_a(dx, j, i);
                        if (b == Blocks.field_150350_a) continue;
                        nonair = true;
                    }
                }
            } else if (this.zstep != 0) {
                for (i = x - k; i <= x + k; ++i) {
                    for (j = y - k; j <= y + k; ++j) {
                        if (!TileEntitySonicBorer.canDrop(world, i, j, dz)) {
                            return -1;
                        }
                        b = world.func_147439_a(i, j, dz);
                        if (b == Blocks.field_150350_a) continue;
                        nonair = true;
                    }
                }
            } else if (this.ystep != 0) {
                for (i = x - k; i <= x + k; ++i) {
                    for (j = z - k; j <= z + k; ++j) {
                        if (!TileEntitySonicBorer.canDrop(world, i, dy, j)) {
                            return -1;
                        }
                        b = world.func_147439_a(i, dy, j);
                        if (b == Blocks.field_150350_a) continue;
                        nonair = true;
                    }
                }
            }
            if (!nonair) continue;
            return m;
        }
        return this.getMaxRange();
    }

    private int getMaxRange() {
        return Math.max(ConfigRegistry.SONICBORERRANGE.getValue(), 64);
    }

    public static boolean canDrop(World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        if (b == Blocks.field_150350_a) {
            return true;
        }
        if (b.func_149712_f(world, x, y, z) < 0.0f) {
            return false;
        }
        if (b instanceof BlockLiquid) {
            return false;
        }
        if (b instanceof BlockFluidBase) {
            return false;
        }
        int meta = world.func_72805_g(x, y, z);
        return !ReikaItemHelper.matchStackWithBlock((ItemStack)ItemStacks.shieldblock, (Block)b);
    }

    private boolean canFire(World world, int x, int y, int z, int meta) {
        if (this.pressure < 400) {
            return false;
        }
        if (this.power < this.MINPOWER || this.torque < this.MINTORQUE) {
            return false;
        }
        return y - this.getDistanceToSurface(world, x, y, z) > 0 || this.ystep != -1;
    }

    private int getPressureIncrement() {
        int amt3 = (int)(this.power / 65536L);
        return amt3;
    }

    public int[] getTargetPosn() {
        World world = this.field_145850_b;
        int x = this.field_145851_c;
        int y = this.field_145848_d;
        int z = this.field_145849_e;
        int[] arr = new int[3];
        int r = this.getDistanceToSurface(world, x, y, z);
        if (r < 0) {
            r = 0;
        }
        arr[0] = x + this.xstep * r;
        arr[1] = y + this.ystep * r;
        arr[2] = z + this.zstep * r;
        return arr;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.SONICBORER;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    @Override
    public void updatePressure(World world, int x, int y, int z, int meta) {
        int Pamb = 101;
        if (world.field_73011_w.field_76575_d) {
            Pamb = 2000;
        }
        int dP = this.pressure - Pamb;
        int pd = dP / 384 + 1;
        this.pressure = dP > 0 ? (this.pressure -= pd) : ++this.pressure;
        if (this.power >= this.MINPOWER && this.torque >= this.MINTORQUE) {
            this.pressure += this.getPressureIncrement();
        }
    }

    @Override
    public void addPressure(int press) {
        this.pressure += press;
    }

    @Override
    public int getPressure() {
        return this.pressure;
    }

    @Override
    public void overpressure(World world, int x, int y, int z) {
        float f = 4.0f;
        world.func_72876_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, f, ConfigRegistry.BLOCKDAMAGE.getState());
        world.func_72876_a(null, (double)x + 0.5, (double)y + 1.5, (double)z + 0.5, f, ConfigRegistry.BLOCKDAMAGE.getState());
        world.func_72876_a(null, (double)x + 0.5, (double)y - 0.5, (double)z + 0.5, f, ConfigRegistry.BLOCKDAMAGE.getState());
        world.func_72876_a(null, (double)x + 1.5, (double)y + 0.5, (double)z + 0.5, f, ConfigRegistry.BLOCKDAMAGE.getState());
        world.func_72876_a(null, (double)x - 0.5, (double)y + 0.5, (double)z + 0.5, f, ConfigRegistry.BLOCKDAMAGE.getState());
        world.func_72876_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 1.5, f, ConfigRegistry.BLOCKDAMAGE.getState());
        world.func_72876_a(null, (double)x + 0.5, (double)y + 0.5, (double)z - 0.5, f, ConfigRegistry.BLOCKDAMAGE.getState());
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("press", this.pressure);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.pressure = NBT.func_74762_e("press");
    }

    public int getDistanceToSurface() {
        return this.getDistanceToSurface(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public int getMaxPressure() {
        return 1000;
    }
}

