/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.World;

import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.RotaryCraft.API.Interfaces.ImmovableBlock;
import Reika.RotaryCraft.Auxiliary.Interfaces.ConditionalOperation;
import Reika.RotaryCraft.Auxiliary.Interfaces.DiscreteFunction;
import Reika.RotaryCraft.Auxiliary.Interfaces.RangedEffect;
import Reika.RotaryCraft.Base.TileEntity.InventoriedPowerReceiver;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.DurationRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.SoundRegistry;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityLineBuilder
extends InventoriedPowerReceiver
implements RangedEffect,
ConditionalOperation,
DiscreteFunction {
    private ForgeDirection dir;
    private StepTimer timer = new StepTimer(40);
    private boolean isOut = false;

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
        if (this.power >= this.MINPOWER && this.torque >= this.MINTORQUE) {
            this.phi = 1.0f - this.timer.getFraction() - 0.01f;
        }
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.LINEBUILDER;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.getIOSides(world, x, y, z, meta);
        this.getPower(false);
        if (this.power < this.MINPOWER || this.torque < this.MINTORQUE) {
            return;
        }
        this.timer.setCap(this.getOperationTime());
        this.timer.update();
        if (this.timer.checkCap() && !world.field_72995_K) {
            this.shiftBlocks(world, x, y, z);
            this.phi = 0.5f;
        }
    }

    private void getIOSides(World world, int x, int y, int z, int meta) {
        switch (meta) {
            case 0: {
                this.read = ForgeDirection.EAST;
                this.dir = ForgeDirection.WEST;
                break;
            }
            case 1: {
                this.read = ForgeDirection.WEST;
                this.dir = ForgeDirection.EAST;
                break;
            }
            case 2: {
                this.read = ForgeDirection.SOUTH;
                this.dir = ForgeDirection.NORTH;
                break;
            }
            case 3: {
                this.read = ForgeDirection.NORTH;
                this.dir = ForgeDirection.SOUTH;
                break;
            }
            case 4: {
                this.read = ForgeDirection.DOWN;
                this.dir = ForgeDirection.UP;
                break;
            }
            case 5: {
                this.read = ForgeDirection.UP;
                this.dir = ForgeDirection.DOWN;
            }
        }
    }

    private boolean shiftBlocks(World world, int x, int y, int z) {
        int r;
        SoundRegistry.LINEBUILDER.playSoundAtBlock(world, x, y, z);
        if (!this.canShift(world, x, y, z)) {
            return false;
        }
        ItemStack is = this.getNextBlockToAdd();
        if (is == null) {
            return false;
        }
        for (int i = r = this.getLineLength(); i > 0; --i) {
            int rx = x + this.dir.offsetX * i;
            int ry = y + this.dir.offsetY * i;
            int rz = z + this.dir.offsetZ * i;
            int rx2 = x + this.dir.offsetX * (i + 1);
            int ry2 = y + this.dir.offsetY * (i + 1);
            int rz2 = z + this.dir.offsetZ * (i + 1);
            Block b = world.func_147439_a(rx, ry, rz);
            int meta = world.func_72805_g(rx, ry, rz);
            world.func_147465_d(rx2, ry2, rz2, b, meta, 3);
            world.func_147468_f(rx, ry, rz);
        }
        int rx = x + this.dir.offsetX;
        int ry = y + this.dir.offsetY;
        int rz = z + this.dir.offsetZ;
        ReikaWorldHelper.setBlock((World)world, (int)rx, (int)ry, (int)rz, (ItemStack)is);
        SoundRegistry.LINEBUILDER.playSoundAtBlock(world, rx, ry, rz);
        return true;
    }

    public boolean canShift(World world, int x, int y, int z) {
        int rz;
        int ry;
        int r = this.getLineLength() + 1;
        int rx = this.field_145851_c + this.dir.offsetX * r;
        boolean softend = ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)rx, (int)(ry = this.field_145848_d + this.dir.offsetY * r), (int)(rz = this.field_145849_e + this.dir.offsetZ * r));
        return softend && r <= this.getMaxRange() && r > 0;
    }

    public ItemStack getNextBlockToAdd() {
        ItemStack is = ReikaInventoryHelper.getNextBlockInInventory((ItemStack[])this.inv, (boolean)true);
        if (is == null) {
            return null;
        }
        return ReikaItemHelper.getWorldBlockFromItem((ItemStack)is).asItemStack();
    }

    @Override
    public int getRange() {
        int range = this.getLineLength();
        return range;
    }

    public int getLineLength() {
        boolean len = false;
        int i = 1;
        int rx = this.field_145851_c + this.dir.offsetX * i;
        int ry = this.field_145848_d + this.dir.offsetY * i;
        int rz = this.field_145849_e + this.dir.offsetZ * i;
        Block id = this.field_145850_b.func_147439_a(rx, ry, rz);
        if (id == Blocks.field_150357_h) {
            return Integer.MIN_VALUE;
        }
        if (!this.field_145850_b.field_72995_K && !ReikaPlayerAPI.playerCanBreakAt((WorldServer)((WorldServer)this.field_145850_b), (int)rx, (int)ry, (int)rz, (EntityPlayerMP)this.getServerPlacer())) {
            return Integer.MIN_VALUE;
        }
        int maxr = this.getMaxRange();
        TileEntity te = this.field_145850_b.func_147438_o(rx, ry, rz);
        if (te != null) {
            return Integer.MIN_VALUE;
        }
        while (!ReikaWorldHelper.softBlocks((IBlockAccess)this.field_145850_b, (int)rx, (int)ry, (int)rz) && i <= maxr) {
            ImmovableBlock im;
            if ((id = this.field_145850_b.func_147439_a(rx = this.field_145851_c + this.dir.offsetX * ++i, ry = this.field_145848_d + this.dir.offsetY * i, rz = this.field_145849_e + this.dir.offsetZ * i)) == Blocks.field_150357_h) {
                return Integer.MIN_VALUE;
            }
            if (id instanceof ImmovableBlock && !(im = (ImmovableBlock)id).canBePushed(this.field_145850_b, rx, ry, rz, i, this.torque, this.power)) {
                return Integer.MIN_VALUE;
            }
            if (!this.field_145850_b.field_72995_K && !ReikaPlayerAPI.playerCanBreakAt((WorldServer)((WorldServer)this.field_145850_b), (int)rx, (int)ry, (int)rz, (EntityPlayerMP)this.getServerPlacer())) {
                return Integer.MIN_VALUE;
            }
            TileEntity tile = this.field_145850_b.func_147438_o(rx, ry, rz);
            if (tile == null) continue;
            return Integer.MIN_VALUE;
        }
        return i - 1;
    }

    @Override
    public int getMaxRange() {
        return Math.max(64, ConfigRegistry.LINEBUILDER.getValue());
    }

    public int func_70302_i_() {
        return 9;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        return true;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return false;
    }

    @Override
    public boolean areConditionsMet() {
        return !ReikaInventoryHelper.isEmpty((ItemStack[])this.inv);
    }

    @Override
    public String getOperationalStatus() {
        return this.areConditionsMet() ? "Operational" : "No Blocks";
    }

    @Override
    public int getOperationTime() {
        int time = DurationRegistry.RAM.getOperationTime(this.omega);
        return Math.max(3, time);
    }
}

