/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.World;

import Reika.DragonAPI.Instantiable.Recipe.ItemMatch;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.RotaryCraft.Auxiliary.Interfaces.ConditionalOperation;
import Reika.RotaryCraft.Auxiliary.Interfaces.RangedEffect;
import Reika.RotaryCraft.Auxiliary.Interfaces.TemperatureTE;
import Reika.RotaryCraft.Base.TileEntity.InventoriedPowerReceiver;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;

public class TileEntityIgniter
extends InventoriedPowerReceiver
implements TemperatureTE,
RangedEffect,
ConditionalOperation {
    private int temperature;
    private IgnitionFuel fuel;
    public static final int ANIMALIGNITION = 280;
    public static final int MAXTEMP = 2500;

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return false;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        ++this.tickcount;
        this.getSummativeSidedPower();
        if (this.power < this.MINPOWER) {
            return;
        }
        if (this.omega < this.MINSPEED) {
            return;
        }
        if (this.tickcount >= 40) {
            this.updateTemperature(world, x, y, z, meta);
            this.tickcount = 0;
            this.fuel = IgnitionFuel.getFromItems(this.inv);
            if (this.fuel == null) {
                return;
            }
            if (this.temperature < this.fuel.temperature) {
                this.burnFuel();
            }
        }
        if (this.fuel == null) {
            return;
        }
        int spread = this.getRange();
        int yspread = this.getRange() / 2;
        int n = 1 + this.temperature / 50;
        for (int i = 0; i < n; ++i) {
            int fx = ReikaRandomHelper.getRandomPlusMinus((int)x, (int)spread);
            int fy = ReikaRandomHelper.getRandomPlusMinus((int)y, (int)yspread);
            int fz = ReikaRandomHelper.getRandomPlusMinus((int)z, (int)spread);
            this.fire(world, x, y, z, fx, fy, fz);
        }
        if (this.temperature >= 280) {
            AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((TileEntity)this).func_72314_b((double)spread, (double)yspread, (double)spread);
            List in = world.func_72872_a(EntityLivingBase.class, box);
            for (EntityLivingBase ent : in) {
                ent.func_70015_d(1);
            }
        }
    }

    private void fire(World world, int x, int y, int z, int fx, int fy, int fz) {
        int d = this.getRange();
        if (world.field_72995_K) {
            this.fireFX(world, x, y, z, fx, fy, fz, d);
        } else {
            ReikaWorldHelper.temperatureEnvironment((World)world, (int)fx, (int)fy, (int)fz, (int)this.getAffectiveTemperature());
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void fireFX(World world, int x, int y, int z, int fx, int fy, int fz, int r) {
        int n = r * r / (1 + 2 * Minecraft.func_71410_x().field_71474_y.field_74362_aa);
        for (int i = 0; i < n; ++i) {
            int dx = x - r + rand.nextInt(r * 2 + 1);
            int dz = z - r + rand.nextInt(r * 2 + 1);
            int dy = y - r / 2 + rand.nextInt(r / 2 + 1);
            world.func_72869_a("flame", (double)dx, (double)(dy + 1), (double)dz, 0.0, 0.0, 0.0);
            world.func_72869_a("smoke", (double)dx, (double)(dy + 1), (double)dz, 0.0, 0.0, 0.0);
        }
    }

    private int getAffectiveTemperature() {
        return ConfigRegistry.ATTACKBLOCKS.getState() ? this.temperature : Math.min(400, this.temperature);
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int func_70302_i_() {
        return 18;
    }

    @Override
    public void updateTemperature(World world, int x, int y, int z, int meta) {
        int Tdiff;
        int Tamb = ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z);
        if (this.temperature > Tamb) {
            Tdiff = this.temperature - Tamb;
            this.temperature -= (int)Math.log(Tdiff);
        }
        if (this.temperature < Tamb) {
            Tdiff = Tamb - this.temperature;
            this.temperature += Tdiff / 24;
        }
        if (this.temperature > 2500) {
            this.temperature = 2500;
        }
    }

    private void burnFuel() {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (ItemMatch m : this.fuel.items) {
            int slot = ReikaInventoryHelper.locateInInventory((ItemMatch)m, (ItemStack[])this.inv);
            ItemStack in = this.inv[slot];
            ItemStack ret = in.func_77973_b().getContainerItem(in);
            if (this.fuel == IgnitionFuel.LAVA) {
                ret = FluidContainerRegistry.drainFluidContainer((ItemStack)ret);
            }
            if (ret != null) {
                drops.add(ret);
            }
            if (slot == -1) continue;
            ReikaInventoryHelper.decrStack((int)slot, (ItemStack[])this.inv);
        }
        if (this.temperature < this.fuel.temperature) {
            this.temperature += (this.fuel.temperature - this.temperature) / 4;
        }
        for (ItemStack is : drops) {
            int leftover = ReikaInventoryHelper.addToInventoryWithLeftover((ItemStack)is, (ItemStack[])this.inv);
            if (leftover <= 0) continue;
            EntityItem ei = new EntityItem(this.field_145850_b, (double)((float)this.field_145851_c + rand.nextFloat()), (double)((float)this.field_145848_d + rand.nextFloat()), (double)((float)this.field_145849_e + rand.nextFloat()), is);
            ReikaEntityHelper.addRandomDirVelocity((Entity)ei, (double)0.2);
            if (this.field_145850_b.field_72995_K) continue;
            this.field_145850_b.func_72838_d((Entity)ei);
        }
    }

    @Override
    public int getRange() {
        return 16 + ReikaMathLibrary.roundUpToX((int)8, (int)((int)Math.sqrt(this.temperature * 2)));
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.temperature = NBT.func_74762_e("temperature");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("temperature", this.temperature);
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.IGNITER;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        return TileEntityIgniter.isValidFuel(is);
    }

    private static boolean isValidFuel(ItemStack is) {
        for (int i = 0; i < IgnitionFuel.fuelList.length; ++i) {
            IgnitionFuel f = IgnitionFuel.fuelList[i];
            for (ItemMatch m : f.items) {
                if (!m.match(is)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int getMaxRange() {
        return this.getRange();
    }

    @Override
    public int getThermalDamage() {
        return this.temperature / 50;
    }

    public int getRedstoneOverride() {
        return this.fuel != null ? 0 : 15;
    }

    @Override
    public void addTemperature(int temp) {
        this.temperature += temp;
    }

    @Override
    public int getTemperature() {
        return this.temperature;
    }

    @Override
    public void overheat(World world, int x, int y, int z) {
    }

    @Override
    public boolean areConditionsMet() {
        return !ReikaInventoryHelper.isEmpty((ItemStack[])this.inv);
    }

    @Override
    public String getOperationalStatus() {
        return this.areConditionsMet() ? "Operational" : "No Fuel";
    }

    @Override
    public boolean canBeCooledWithFins() {
        return false;
    }

    public void setTemperature(int temp) {
        this.temperature = temp;
    }

    @Override
    public boolean allowExternalHeating() {
        return false;
    }

    @Override
    public int getMaxTemperature() {
        return 2500;
    }

    public static enum IgnitionFuel {
        WOOD(400, "plankWood/logWood"),
        COAL(600, Items.field_151044_h),
        BLAZE(800, Items.field_151065_br),
        LAVA(1200, FluidRegistry.LAVA),
        THERMITE(2500, "dustAluminum/dustAluminium", "ingotIron/dustIron");

        public final int temperature;
        private final Collection<ItemMatch> items = new ArrayList<ItemMatch>();
        public static final IgnitionFuel[] fuelList;

        private IgnitionFuel(int t, Object ... items) {
            this.temperature = t;
            for (int i = 0; i < items.length; ++i) {
                Object o = items[i];
                this.items.add(ItemMatch.createFromObject((Object)o));
            }
        }

        private IgnitionFuel compare(IgnitionFuel f) {
            return IgnitionFuel.compare(this, f);
        }

        private static IgnitionFuel compare(IgnitionFuel f1, IgnitionFuel f2) {
            return f1.temperature > f2.temperature ? f1 : f2;
        }

        private static IgnitionFuel getFromItems(ItemStack[] items) {
            for (int i = fuelList.length - 1; i >= 0; --i) {
                boolean valid = true;
                IgnitionFuel f = fuelList[i];
                for (ItemMatch m : f.items) {
                    boolean found = false;
                    for (int k = 0; k < items.length; ++k) {
                        ItemStack in = items[k];
                        if (in == null || !m.match(in)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    valid = false;
                    break;
                }
                if (!valid) continue;
                return f;
            }
            return null;
        }

        static {
            fuelList = IgnitionFuel.values();
        }
    }
}

