/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Weaponry;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.RotaryCraft.Base.TileEntity.TileEntitySpringPowered;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.RotaryAchievements;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class TileEntityLandmine
extends TileEntitySpringPowered {
    private boolean flaming = false;
    private boolean poison = false;
    private boolean chain = false;
    private boolean shrapnel = false;
    private int explosionDelay = 0;
    private boolean isChainExploding = false;

    @Override
    public int func_70302_i_() {
        return 9;
    }

    private boolean checkForPlayer(World world, int x, int y, int z) {
        AxisAlignedBB above = AxisAlignedBB.func_72330_a((double)x, (double)(y + 1), (double)z, (double)(x + 1), (double)(y + 3), (double)(z + 1));
        List in = world.func_72872_a(EntityLivingBase.class, above);
        for (int i = 0; i < in.size(); ++i) {
            EntityLivingBase e = (EntityLivingBase)in.get(i);
            if (!e.field_70122_E || e.func_70093_af()) continue;
            return true;
        }
        return false;
    }

    private boolean checkForArrow(World world, int x, int y, int z) {
        AxisAlignedBB above = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)).func_72314_b(1.0, 1.0, 1.0);
        List in = world.func_72872_a(EntityArrow.class, above);
        return in.size() > 0;
    }

    private boolean ageFail() {
        if (rand.nextInt(20) > 0) {
            return false;
        }
        int age = this.getAge();
        if (age == 0) {
            return false;
        }
        return rand.nextInt(65537 - this.getAge()) == 0;
    }

    private void maxPowerExplosion(World world, int x, int y, int z) {
        world.func_72869_a("hugeexplosion", (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 0.0, 0.0, 0.0);
        world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.explode", 1.0f, 1.0f);
        for (int i = 1; i < 6; ++i) {
            ReikaWorldHelper.recursiveBreakWithinSphere((World)world, (int)(x - i), (int)y, (int)z, (Block)world.func_147439_a(x - 1, y, z), (int)-1, (int)x, (int)y, (int)z, (double)4.0);
            ReikaWorldHelper.recursiveBreakWithinSphere((World)world, (int)(x + i), (int)y, (int)z, (Block)world.func_147439_a(x + 1, y, z), (int)-1, (int)x, (int)y, (int)z, (double)4.0);
            ReikaWorldHelper.recursiveBreakWithinSphere((World)world, (int)x, (int)(y - i), (int)z, (Block)world.func_147439_a(x, y - 1, z), (int)-1, (int)x, (int)y, (int)z, (double)4.0);
            ReikaWorldHelper.recursiveBreakWithinSphere((World)world, (int)x, (int)(y + i), (int)z, (Block)world.func_147439_a(x, y + 1, z), (int)-1, (int)x, (int)y, (int)z, (double)4.0);
            ReikaWorldHelper.recursiveBreakWithinSphere((World)world, (int)x, (int)y, (int)(z - i), (Block)world.func_147439_a(x, y, z - 1), (int)-1, (int)x, (int)y, (int)z, (double)4.0);
            ReikaWorldHelper.recursiveBreakWithinSphere((World)world, (int)x, (int)y, (int)(z + i), (Block)world.func_147439_a(x, y, z + 1), (int)-1, (int)x, (int)y, (int)z, (double)4.0);
            this.chainedExplosion(world, x, y, z);
        }
    }

    public void detonate(World world, int x, int y, int z) {
        if (this.chain) {
            this.chainedExplosion(world, x, y, z);
        }
        if (this.inv[1] != null && this.inv[2] != null && this.inv[3] != null && this.inv[4] != null) {
            boolean flag = true;
            for (int i = 1; i <= 4; ++i) {
                if (!ReikaItemHelper.matchStackWithBlock((ItemStack)this.inv[i], (Block)Blocks.field_150335_W)) continue;
                flag = false;
            }
            if (flag) {
                this.maxPowerExplosion(world, x, y, z);
            }
        }
        float power = this.getExplosionPower();
        world.func_147468_f(x, y, z);
        if (this.flaming) {
            if (!world.field_72995_K) {
                world.func_72885_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, power, true, true);
            }
        } else if (!world.field_72995_K) {
            world.func_72876_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, power, true);
        }
        AxisAlignedBB region = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)).func_72314_b(2.0, 2.0, 2.0);
        List in = world.func_72872_a(EntityLivingBase.class, region);
        for (int i = 0; i < in.size(); ++i) {
            EntityLivingBase e = (EntityLivingBase)in.get(i);
            if (e instanceof EntityPlayer && !((EntityPlayer)e).field_71075_bZ.field_75098_d) {
                RotaryAchievements.LANDMINE.triggerAchievement((EntityPlayer)e);
            }
            e.func_70097_a(DamageSource.func_94539_a((Explosion)new Explosion(world, null, e.field_70165_t, e.field_70163_u, e.field_70161_v, power)), (float)((int)power * 4));
            e.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 400, 0));
            e.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 450, 5));
            if (this.poison) {
                e.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 200, 0));
            }
            if (!(e instanceof EntityCreeper)) continue;
            world.func_72876_a((Entity)e, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 3.0f, true);
        }
        if (this.shrapnel) {
            AxisAlignedBB region2 = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)).func_72314_b(8.0, 8.0, 8.0);
            List in2 = world.func_72872_a(EntityLivingBase.class, region2);
            for (int i = 0; i < in2.size(); ++i) {
                EntityLivingBase e = (EntityLivingBase)in2.get(i);
                double dx = e.field_70165_t - (double)x - 0.5;
                double dy = e.field_70163_u - (double)y - 0.5;
                double dz = e.field_70161_v - (double)z - 0.5;
                double dd = ReikaMathLibrary.py3d((double)dx, (double)dy, (double)dz);
                int dmg = dd < 4.0 ? 8 : (dd < 8.0 ? 6 : 4);
                e.func_70097_a(DamageSource.field_76377_j, (float)dmg);
                ReikaEntityHelper.spawnParticlesAround((String)"crit", (Entity)e, (int)8);
            }
        }
    }

    private void getExplosionModifiers() {
        for (int i = 5; i <= 8; ++i) {
            if (this.inv[i] == null) continue;
            if (this.inv[i].func_77973_b() == Items.field_151065_br) {
                this.flaming = true;
            }
            if (this.inv[i].func_77973_b() == Items.field_151070_bp) {
                this.poison = true;
            }
            if (ReikaItemHelper.matchStackWithBlock((ItemStack)this.inv[i], (Block)Blocks.field_150335_W)) {
                this.chain = true;
            }
            if (!ReikaItemHelper.matchStackWithBlock((ItemStack)this.inv[i], (Block)Blocks.field_150359_w)) continue;
            this.shrapnel = true;
        }
    }

    private float getExplosionPower() {
        int num = 0;
        for (int i = 1; i <= 4; ++i) {
            if (this.inv[i] == null || this.inv[i].func_77973_b() != Items.field_151016_H) continue;
            ++num;
        }
        return 2.0f * (float)num;
    }

    private int getAge() {
        return 65536 - this.inv[0].func_77960_j();
    }

    @Override
    public void func_70295_k_() {
        super.func_70295_k_();
        if (this.inv[0] == null) {
            return;
        }
        if (rand.nextInt(65536 - this.getAge()) / 2 == 0) {
            this.detonate(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public boolean func_94041_b(int i, ItemStack is) {
        switch (i) {
            case 0: {
                return super.func_94041_b(i, is);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return is.func_77973_b() == Items.field_151016_H;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return this.isModifier(is);
            }
        }
        return false;
    }

    private boolean isModifier(ItemStack is) {
        if (is.func_77973_b() == Items.field_151065_br) {
            return true;
        }
        if (is.func_77973_b() == Items.field_151070_bp) {
            return true;
        }
        if (ReikaItemHelper.matchStackWithBlock((ItemStack)is, (Block)Blocks.field_150335_W)) {
            return true;
        }
        return ReikaItemHelper.matchStackWithBlock((ItemStack)is, (Block)Blocks.field_150359_w);
    }

    private void chainedExplosion(World world, int x, int y, int z) {
        for (int i = 0; i < 12; ++i) {
            EntityTNTPrimed tnt = new EntityTNTPrimed(world, (double)(x - 5 + rand.nextInt(11)), (double)(y - 5 + rand.nextInt(11)), (double)(z - 5 + rand.nextInt(11)), null);
            tnt.field_70516_a = 5 + rand.nextInt(10);
            if (world.field_72995_K) continue;
            world.func_72838_d((Entity)tnt);
        }
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.LANDMINE;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (!this.hasCoil()) {
            return;
        }
        ++this.tickcount;
        if (this.tickcount > this.getUnwindTime()) {
            ItemStack is;
            this.inv[0] = is = this.getDecrementedCharged();
            this.tickcount = 0;
        }
        this.getExplosionModifiers();
        if (!DragonAPICore.debugtest && this.ageFail()) {
            this.detonate(world, x, y, z);
        }
        if (this.checkForArrow(world, x, y, z)) {
            this.detonate(world, x, y, z);
        }
        if (this.checkForPlayer(world, x, y, z)) {
            this.detonate(world, x, y, z);
        }
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    @Override
    public int getBaseDischargeTime() {
        return 360;
    }
}

