/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Transmission;

import Reika.ChromatiCraft.API.Interfaces.WorldRift;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Libraries.MathSci.ReikaEngLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import Reika.RotaryCraft.API.Event.ShaftFailureEvent;
import Reika.RotaryCraft.API.Power.ShaftMerger;
import Reika.RotaryCraft.Auxiliary.Interfaces.PowerSourceTracker;
import Reika.RotaryCraft.Auxiliary.Interfaces.SimpleProvider;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Auxiliary.PowerSourceList;
import Reika.RotaryCraft.Auxiliary.RotaryAux;
import Reika.RotaryCraft.Auxiliary.ShaftPowerEmitter;
import Reika.RotaryCraft.Base.TileEntity.TileEntity1DTransmitter;
import Reika.RotaryCraft.Base.TileEntity.TileEntityIOMachine;
import Reika.RotaryCraft.Base.TileEntity.TileEntityTransmissionMachine;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.MaterialRegistry;
import Reika.RotaryCraft.Registry.RotaryAchievements;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityPortalShaft;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityPowerBus;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntitySplitter;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.Collection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityShaft
extends TileEntity1DTransmitter {
    public int[] readtorque = new int[2];
    public int[] readomega = new int[2];
    public boolean reading2Dir = false;
    public float crossphi1 = 0.0f;
    public float crossphi2 = 0.0f;
    private MaterialRegistry type;
    private boolean failed = false;

    public TileEntityShaft(MaterialRegistry type) {
        if (type == null) {
            type = MaterialRegistry.WOOD;
        }
        this.type = type;
    }

    public TileEntityShaft() {
        this(MaterialRegistry.WOOD);
    }

    public MaterialRegistry getShaftType() {
        return this.type;
    }

    public void fail(World world, int x, int y, int z, boolean speed) {
        MinecraftForge.EVENT_BUS.post((Event)new ShaftFailureEvent((TileEntity)this, speed, this.type.ordinal()));
        this.failed = true;
        if (speed) {
            world.func_72876_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 1.0f, true);
            ItemStack item = null;
            switch (this.type) {
                case WOOD: {
                    item = ItemStacks.sawdust.func_77946_l();
                    break;
                }
                case STONE: {
                    item = new ItemStack(Blocks.field_150351_n, 1, 0);
                    break;
                }
                case STEEL: {
                    item = ItemStacks.scrap.func_77946_l();
                    break;
                }
                case DIAMOND: {
                    item = new ItemStack(Items.field_151045_i, 1, 0);
                    break;
                }
                case BEDROCK: {
                    item = ItemStacks.bedrockdust.func_77946_l();
                }
            }
            EntityItem ei = new EntityItem(world, (double)x + 0.5, (double)y + 1.25, (double)z + 0.5, item);
            ei.field_70181_x = 0.4f + 0.6f * rand.nextFloat();
            ei.field_70159_w = rand.nextFloat() / 5.0f;
            ei.field_70179_y = rand.nextFloat() / 5.0f;
            if (world.field_72995_K) {
                return;
            }
            ei.field_70133_I = true;
            if (rand.nextInt(24) == 0) {
                world.func_72838_d((Entity)ei);
            }
        } else {
            world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.break", 1.0f, 1.0f);
            ItemStack item = null;
            switch (this.type) {
                case WOOD: {
                    item = new ItemStack(Items.field_151055_y, 1, 0);
                    break;
                }
                case STONE: {
                    item = new ItemStack(Blocks.field_150347_e, 1, 0);
                    break;
                }
                case STEEL: {
                    item = ItemStacks.shaftitem.func_77946_l();
                    break;
                }
                case DIAMOND: {
                    item = new ItemStack(Items.field_151045_i, 1, 0);
                    break;
                }
                case BEDROCK: {
                    item = ItemStacks.bedrockdust.func_77946_l();
                }
            }
            EntityItem ei = new EntityItem(world, (double)x + 0.5, (double)(y + 1), (double)z + 0.5, item);
            ei.field_70181_x = rand.nextFloat() / 5.0f;
            ei.field_70159_w = rand.nextFloat() / 5.0f;
            ei.field_70179_y = rand.nextFloat() / 5.0f;
            if (world.field_72995_K) {
                return;
            }
            ei.field_70133_I = true;
            if (rand.nextInt(24) == 0) {
                world.func_72838_d((Entity)ei);
            }
        }
    }

    public void repair() {
        this.failed = false;
    }

    public boolean failed() {
        return this.failed;
    }

    public void testFailure() {
        if (ReikaEngLibrary.mat_rotfailure((double)this.type.getDensity(), (double)0.0625, (double)ReikaMathLibrary.doubpow((double)this.omega, (double)(1.0 - 0.11 * (double)this.type.ordinal())), (double)this.type.getTensileStrength())) {
            this.fail(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, true);
        } else if (ReikaEngLibrary.mat_twistfailure((int)this.torque, (double)0.0625, (double)(this.type.getShearStrength() / 16.0))) {
            this.fail(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, false);
        }
    }

    private void crossReadFromCross(TileEntityShaft cross, int dir) {
        this.reading2Dir = true;
        if (cross.isWritingTo(this)) {
            this.readomega[dir] = cross.readomega[0];
            this.readtorque[dir] = cross.readtorque[0];
        } else if (cross.isWritingTo2(this)) {
            this.readomega[dir] = cross.readomega[1];
            this.readtorque[dir] = cross.readtorque[1];
        } else {
            return;
        }
    }

    @Override
    protected void readFromCross(TileEntityShaft cross) {
        this.reading2Dir = true;
        super.readFromCross(cross);
    }

    private void crossReadFromSplitter(World world, int x, int y, int z, TileEntitySplitter spl, int dir) {
        this.reading2Dir = true;
        int sratio = spl.getRatioFromMode();
        if (sratio == 0) {
            return;
        }
        boolean favorbent = false;
        if (sratio < 0) {
            favorbent = true;
            sratio = -sratio;
        }
        if (x == spl.getWriteX() && z == spl.getWriteZ()) {
            this.readomega[dir] = spl.omega;
            if (sratio == 1) {
                this.readtorque[dir] = spl.torque / 2;
                return;
            }
            this.readtorque[dir] = favorbent ? spl.torque / sratio : (int)((double)spl.torque * (((double)sratio - 1.0) / (double)sratio));
        } else if (x == spl.getWriteX2() && z == spl.getWriteZ2()) {
            this.readomega[dir] = spl.omega;
            if (sratio == 1) {
                this.readtorque[dir] = spl.torque / 2;
                return;
            }
            this.readtorque[dir] = favorbent ? (int)((double)spl.torque * (((double)sratio - 1.0) / (double)sratio)) : spl.torque / sratio;
        } else {
            this.readtorque[dir] = 0;
            this.readomega[dir] = 0;
            return;
        }
    }

    @Override
    protected void readFromSplitter(World world, int x, int y, int z, TileEntitySplitter spl) {
        this.reading2Dir = true;
        int sratio = spl.getRatioFromMode();
        if (sratio == 0) {
            return;
        }
        boolean favorbent = false;
        if (sratio < 0) {
            favorbent = true;
            sratio = -sratio;
        }
        if (x == spl.getWriteX() && z == spl.getWriteZ()) {
            this.omega = spl.omega;
            this.torque = sratio == 1 ? spl.torque / 2 : (favorbent ? spl.torque / sratio : (int)((double)spl.torque * (((double)sratio - 1.0) / (double)sratio)));
        } else if (x == spl.getWriteX2() && z == spl.getWriteZ2()) {
            this.omega = spl.omega;
            this.torque = sratio == 1 ? spl.torque / 2 : (favorbent ? (int)((double)spl.torque * (((double)sratio - 1.0) / (double)sratio)) : spl.torque / sratio);
        } else {
            this.torque = 0;
            this.omega = 0;
            this.power = 0L;
            return;
        }
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.ratio = 1;
        if (this.failed) {
            this.torque = 0;
            this.omega = 0;
            this.power = 0L;
            this.basicPowerReceiver();
            return;
        }
        this.getIOSides(world, x, y, z, meta);
        this.transferPower(world, x, y, z, meta);
    }

    public boolean isCross() {
        return this.func_145832_p() >= 6;
    }

    public void getIOSides(World world, int x, int y, int z, int meta) {
        switch (meta) {
            case 0: {
                this.read = ForgeDirection.EAST;
                this.write = ForgeDirection.WEST;
                break;
            }
            case 1: {
                this.read = ForgeDirection.WEST;
                this.write = ForgeDirection.EAST;
                break;
            }
            case 2: {
                this.read = ForgeDirection.SOUTH;
                this.write = ForgeDirection.NORTH;
                break;
            }
            case 3: {
                this.read = ForgeDirection.NORTH;
                this.write = ForgeDirection.SOUTH;
                break;
            }
            case 4: {
                this.read = ForgeDirection.DOWN;
                this.write = ForgeDirection.UP;
                break;
            }
            case 5: {
                this.read = ForgeDirection.UP;
                this.write = ForgeDirection.DOWN;
                break;
            }
            case 6: {
                this.read = ForgeDirection.EAST;
                this.read2 = ForgeDirection.SOUTH;
                this.write = ForgeDirection.WEST;
                this.write2 = ForgeDirection.NORTH;
                break;
            }
            case 7: {
                this.read = ForgeDirection.EAST;
                this.read2 = ForgeDirection.NORTH;
                this.write = ForgeDirection.WEST;
                this.write2 = ForgeDirection.SOUTH;
                break;
            }
            case 8: {
                this.read = ForgeDirection.WEST;
                this.read2 = ForgeDirection.NORTH;
                this.write = ForgeDirection.EAST;
                this.write2 = ForgeDirection.SOUTH;
                break;
            }
            case 9: {
                this.read = ForgeDirection.WEST;
                this.read2 = ForgeDirection.SOUTH;
                this.write = ForgeDirection.EAST;
                this.write2 = ForgeDirection.NORTH;
            }
        }
    }

    private void crossTransfer(World world, int x, int y, int z, boolean check1, boolean check2) {
        WorldLocation loc;
        WorldRift sr;
        ShaftPowerEmitter sp;
        TileEntity te2;
        if (check1 && check2) {
            this.readomega[0] = 0;
            this.readomega[1] = 0;
            this.readtorque[0] = 0;
            this.readtorque[1] = 0;
        }
        boolean isCentered = x == this.field_145851_c && y == this.field_145848_d && z == this.field_145849_e;
        int dx = x + this.read.offsetX;
        int dy = y + this.read.offsetY;
        int dz = z + this.read.offsetZ;
        int dx2 = x + this.read2.offsetX;
        int dy2 = y + this.read2.offsetY;
        int dz2 = z + this.read2.offsetZ;
        MachineRegistry m = isCentered ? this.getMachine(this.read) : MachineRegistry.getMachine((IBlockAccess)world, dx, dy, dz);
        TileEntity te1 = isCentered ? this.getAdjacentTileEntity(this.read) : world.func_147438_o(dx, dy, dz);
        MachineRegistry m2 = isCentered ? this.getMachine(this.read2) : MachineRegistry.getMachine((IBlockAccess)world, dx2, dy2, dz2);
        TileEntity tileEntity = te2 = isCentered ? this.getAdjacentTileEntity(this.read2) : world.func_147438_o(dx2, dy2, dz2);
        if (check1) {
            if (this.isProvider(te1)) {
                TileEntityTransmissionMachine devicein;
                if (m == MachineRegistry.SHAFT) {
                    devicein = (TileEntityShaft)te1;
                    if (((TileEntityShaft)devicein).isCross()) {
                        this.crossReadFromCross((TileEntityShaft)devicein, 0);
                        return;
                    }
                    if (devicein.isWritingTo(this)) {
                        this.readomega[0] = ((TileEntityShaft)devicein).omega;
                        this.readtorque[0] = ((TileEntityShaft)devicein).torque;
                    }
                }
                if (te1 instanceof SimpleProvider && ((TileEntityIOMachine)te1).isWritingTo(this)) {
                    this.readtorque[0] = ((TileEntityIOMachine)te1).torque;
                    this.readomega[0] = ((TileEntityIOMachine)te1).omega;
                }
                if (te1 instanceof ShaftPowerEmitter && (sp = (ShaftPowerEmitter)te1).isEmitting() && sp.canWriteTo(this.read.getOpposite())) {
                    this.readtorque[0] = sp.getTorque();
                    this.readomega[0] = sp.getOmega();
                }
                if (m == MachineRegistry.SPLITTER) {
                    devicein = (TileEntitySplitter)te1;
                    if (((TileEntitySplitter)devicein).isSplitting()) {
                        this.crossReadFromSplitter(world, x, y, z, (TileEntitySplitter)devicein, 0);
                        return;
                    }
                    if (devicein.isWritingTo(this)) {
                        this.readtorque[0] = ((TileEntitySplitter)devicein).torque;
                        this.readomega[0] = ((TileEntitySplitter)devicein).omega;
                    }
                }
            } else if (te1 instanceof WorldRift) {
                sr = (WorldRift)te1;
                loc = sr.getLinkTarget();
                if (loc != null) {
                    this.crossTransfer(loc.getWorld(), loc.xCoord, loc.yCoord, loc.zCoord, true, false);
                }
            } else {
                this.readtorque[0] = 0;
                this.readomega[0] = 0;
            }
        }
        if (check2) {
            if (this.isProvider(te2)) {
                TileEntityTransmissionMachine devicein2;
                if (m2 == MachineRegistry.SHAFT) {
                    devicein2 = (TileEntityShaft)te2;
                    if (((TileEntityShaft)devicein2).isCross()) {
                        this.crossReadFromCross((TileEntityShaft)devicein2, 1);
                        return;
                    }
                    if (devicein2.isWritingTo(this) && ((TileEntityIOMachine)te2).isWritingTo(this)) {
                        this.readomega[1] = ((TileEntityShaft)devicein2).omega;
                        this.readtorque[1] = ((TileEntityShaft)devicein2).torque;
                    }
                }
                if (te2 instanceof SimpleProvider) {
                    this.readtorque[1] = ((TileEntityIOMachine)te2).torque;
                    this.readomega[1] = ((TileEntityIOMachine)te2).omega;
                }
                if (te2 instanceof ShaftPowerEmitter && (sp = (ShaftPowerEmitter)te2).isEmitting() && sp.canWriteTo(this.read2.getOpposite())) {
                    this.readtorque[1] = sp.getTorque();
                    this.readomega[1] = sp.getOmega();
                }
                if (m2 == MachineRegistry.SPLITTER) {
                    devicein2 = (TileEntitySplitter)te2;
                    if (((TileEntitySplitter)devicein2).isSplitting()) {
                        this.crossReadFromSplitter(world, x, y, z, (TileEntitySplitter)devicein2, 1);
                        return;
                    }
                    if (devicein2.isWritingTo(this)) {
                        this.readtorque[1] = ((TileEntitySplitter)devicein2).torque;
                        this.readomega[1] = ((TileEntitySplitter)devicein2).omega;
                    }
                }
            } else if (te2 instanceof WorldRift) {
                sr = (WorldRift)te2;
                loc = sr.getLinkTarget();
                if (loc != null) {
                    this.crossTransfer(loc.getWorld(), loc.xCoord, loc.yCoord, loc.zCoord, false, true);
                }
            } else {
                this.readtorque[1] = 0;
                this.readomega[1] = 0;
            }
        }
        if (!check1 || !check2) {
            return;
        }
        this.writeToPowerReceiver(this.write, this.readomega[0], this.readtorque[0]);
        this.writeToPowerReceiver(this.write2, this.readomega[1], this.readtorque[1]);
    }

    @Override
    protected void transferPower(World world, int x, int y, int z, int meta) {
        TileEntity te;
        if (this.field_145850_b.field_72995_K && !RotaryAux.getPowerOnClient) {
            return;
        }
        this.reading2Dir = false;
        if (this.isCross()) {
            this.crossTransfer(world, x, y, z, true, true);
            return;
        }
        this.torquein = 0;
        this.omegain = 0;
        boolean isCentered = x == this.field_145851_c && y == this.field_145848_d && z == this.field_145849_e;
        int dx = x + this.read.offsetX;
        int dy = y + this.read.offsetY;
        int dz = z + this.read.offsetZ;
        if (isCentered && ReikaBlockHelper.isPortalBlock((World)world, (int)(x + this.write.offsetX), (int)(y + this.write.offsetY), (int)(z + this.write.offsetZ))) {
            this.convertToPortal(world, x, y, z, x + this.write.offsetX, y + this.write.offsetY, z + this.write.offsetZ);
        }
        MachineRegistry m = isCentered ? this.getMachine(this.read) : MachineRegistry.getMachine((IBlockAccess)world, dx, dy, dz);
        TileEntity tileEntity = te = isCentered ? this.getAdjacentTileEntity(this.read) : world.func_147438_o(dx, dy, dz);
        if (this.isProvider(te)) {
            ShaftPowerEmitter sp;
            TileEntityTransmissionMachine devicein;
            if (m == MachineRegistry.SHAFT) {
                devicein = (TileEntityShaft)te;
                if (((TileEntityShaft)devicein).isCross()) {
                    this.readFromCross((TileEntityShaft)devicein);
                    return;
                }
                if (devicein.isWritingTo(this)) {
                    this.torquein = ((TileEntityShaft)devicein).torque;
                    this.omegain = ((TileEntityShaft)devicein).omega;
                }
            }
            if (te instanceof SimpleProvider) {
                this.copyStandardPower(te);
            }
            if (m == MachineRegistry.POWERBUS) {
                TileEntityPowerBus pwr = (TileEntityPowerBus)te;
                ForgeDirection dir = this.getInputForgeDirection().getOpposite();
                this.omegain = pwr.getSpeedToSide(dir);
                this.torquein = pwr.getTorqueToSide(dir);
            }
            if (te instanceof ShaftPowerEmitter && (sp = (ShaftPowerEmitter)te).isEmitting() && sp.canWriteTo(this.read.getOpposite())) {
                this.torquein = sp.getTorque();
                this.omegain = sp.getOmega();
            }
            if (m == MachineRegistry.SPLITTER) {
                devicein = (TileEntitySplitter)te;
                if (((TileEntitySplitter)devicein).isSplitting()) {
                    this.readFromSplitter(world, x, y, z, (TileEntitySplitter)devicein);
                    this.omegain = this.omega;
                    this.torquein = this.torque;
                    if (!this.type.isInfiniteStrength()) {
                        this.testFailure();
                    }
                    return;
                }
                if (devicein.isWritingTo(this)) {
                    this.torquein = ((TileEntitySplitter)devicein).torque;
                    this.omegain = ((TileEntitySplitter)devicein).omega;
                }
            }
        } else if (te instanceof WorldRift) {
            WorldRift sr = (WorldRift)te;
            WorldLocation loc = sr.getLinkTarget();
            if (loc != null) {
                this.transferPower(loc.getWorld(), loc.xCoord, loc.yCoord, loc.zCoord, meta);
            }
        } else {
            this.omega = 0;
            this.torque = 0;
            this.power = 0L;
            return;
        }
        this.omega = this.omegain / this.ratio;
        this.torque = this.torquein * this.ratio;
        this.power = this.omega * this.torque;
        this.basicPowerReceiver();
        if (!this.type.isInfiniteStrength()) {
            this.testFailure();
        }
        if (this.omega >= 32000000 && !this.failed) {
            RotaryAchievements.MRADS32.triggerAchievement(this.getPlacer());
        }
        if (this.power >= 1000000000L && !this.failed) {
            RotaryAchievements.GIGAWATT.triggerAchievement(this.getPlacer());
        }
    }

    private void convertToPortal(World world, int x, int y, int z, int dx, int dy, int dz) {
        world.func_147465_d(x, y, z, MachineRegistry.PORTALSHAFT.getBlock(), MachineRegistry.PORTALSHAFT.getBlockMetadata(), 3);
        TileEntityPortalShaft ps = new TileEntityPortalShaft();
        ps.setBlockMetadata(this.func_145832_p());
        ps.setPortalType(world, dx, dy, dz);
        ps.material = this.getShaftType();
        world.func_147455_a(x, y, z, (TileEntity)ps);
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74757_a("failed", this.failed);
        NBT.func_74783_a("readtorque", this.readtorque);
        NBT.func_74783_a("readomega", this.readomega);
        NBT.func_74776_a("cphi1", this.crossphi1);
        NBT.func_74776_a("cphi2", this.crossphi2);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.failed = NBT.func_74767_n("failed");
        this.readtorque = NBT.func_74759_k("readtorque");
        this.readomega = NBT.func_74759_k("readomega");
        if (this.readtorque.length != 2) {
            this.readtorque = new int[2];
        }
        if (this.readomega.length != 2) {
            this.readomega = new int[2];
        }
        this.crossphi1 = NBT.func_74760_g("cphi1");
        this.crossphi2 = NBT.func_74760_g("cphi2");
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        NBT.func_74768_a("type", this.type.ordinal());
        super.func_145841_b(NBT);
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        this.type = MaterialRegistry.setType(NBT.func_74762_e("type"));
        super.func_145839_a(NBT);
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
        if (!this.isInWorld()) {
            this.phi = 0.0f;
            return;
        }
        this.phi = (float)((double)this.phi + ReikaMathLibrary.doubpow((double)ReikaMathLibrary.logbase((long)(this.omega + 1), (int)2), (double)1.25));
        this.crossphi1 = (float)((double)this.crossphi1 + ReikaMathLibrary.doubpow((double)ReikaMathLibrary.logbase((long)(this.readomega[0] + 1), (int)2), (double)1.25));
        this.crossphi2 = (float)((double)this.crossphi2 + ReikaMathLibrary.doubpow((double)ReikaMathLibrary.logbase((long)(this.readomega[1] + 1), (int)2), (double)1.25));
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.SHAFT;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    @Override
    public void onEMP() {
    }

    @Override
    public PowerSourceList getPowerSources(PowerSourceTracker io, ShaftMerger caller) {
        if (this.isCross()) {
            boolean read1 = this.isWritingTo(io);
            if (read1) {
                return PowerSourceList.getAllFrom(this.field_145850_b, this.read, this.field_145851_c + this.read.offsetX, this.field_145848_d + this.read.offsetY, this.field_145849_e + this.read.offsetZ, this, caller);
            }
            return PowerSourceList.getAllFrom(this.field_145850_b, this.read2, this.field_145851_c + this.read2.offsetX, this.field_145848_d + this.read2.offsetY, this.field_145849_e + this.read2.offsetZ, this, caller);
        }
        return super.getPowerSources(io, caller);
    }

    @Override
    public void getAllOutputs(Collection<TileEntity> c, ForgeDirection dir) {
        if (this.isCross()) {
            if (dir == this.read) {
                c.add(this.getAdjacentTileEntity(this.write));
            } else if (dir == this.read2) {
                c.add(this.getAdjacentTileEntity(this.write2));
            }
        } else {
            super.getAllOutputs(c, dir);
        }
    }

    @Override
    public int getItemMetadata() {
        return this.type.ordinal();
    }
}

