/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities;

import Reika.DragonAPI.Interfaces.TileEntity.BreakAction;
import Reika.DragonAPI.Interfaces.TileEntity.XPProducer;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.ReikaXPFluidHelper;
import Reika.RotaryCraft.API.Event.VacuumItemAbsorbEvent;
import Reika.RotaryCraft.API.Event.VacuumXPAbsorbEvent;
import Reika.RotaryCraft.Auxiliary.Interfaces.RangedEffect;
import Reika.RotaryCraft.Base.TileEntity.InventoriedPowerReceiver;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityVacuum
extends InventoriedPowerReceiver
implements RangedEffect,
BreakAction,
IFluidHandler {
    private int experience = 0;
    public boolean equidistant = true;
    public boolean suckIfFull = true;
    private boolean isFull = false;

    public int getExperience() {
        return this.experience;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return true;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.getSummativeSidedPower();
        if (world.field_72995_K) {
            return;
        }
        ++this.tickcount;
        if (this.power < this.MINPOWER) {
            return;
        }
        this.power = (long)this.torque * (long)this.omega;
        if (this.tickcount < 2) {
            return;
        }
        this.tickcount = 0;
        if (this.suckIfFull || !this.isFull) {
            this.suck(world, x, y, z);
            this.absorb(world, x, y, z);
            this.transfer(world, x, y, z);
        }
    }

    @Override
    protected void onInventoryChanged() {
        this.isFull = false;
    }

    private void transfer(World world, int x, int y, int z) {
        for (int i = 2; i < 6; ++i) {
            ForgeDirection dir = this.dirs[i];
            TileEntity te = this.getAdjacentTileEntity(dir);
            if (te instanceof IInventory && !(te instanceof TileEntityVacuum)) {
                IInventory ii = (IInventory)te;
                int size = ii.func_70302_i_();
                for (int k = 0; k < size; ++k) {
                    ItemStack inslot = ii.func_70301_a(k);
                    if (inslot == null) continue;
                    boolean cansuck = true;
                    if (te instanceof ISidedInventory) {
                        cansuck = ((ISidedInventory)te).func_102008_b(k, inslot, dir.getOpposite().ordinal());
                    }
                    if (!cansuck) continue;
                    if (this.canSuckStacks() && ReikaInventoryHelper.addToIInv((ItemStack)inslot.func_77946_l(), (IInventory)this)) {
                        ii.func_70299_a(k, null);
                        continue;
                    }
                    int newsize = inslot.field_77994_a - 1;
                    ItemStack is2 = ReikaItemHelper.getSizedItemStack((ItemStack)inslot, (int)1);
                    ItemStack is3 = ReikaItemHelper.getSizedItemStack((ItemStack)inslot, (int)newsize);
                    if (newsize <= 0) {
                        is3 = null;
                    }
                    if (!ReikaInventoryHelper.addToIInv((ItemStack)is2, (IInventory)this)) continue;
                    ii.func_70299_a(k, is3);
                }
            }
            if (!(te instanceof XPProducer)) continue;
            XPProducer xpm = (XPProducer)te;
            this.experience = (int)((float)this.experience + xpm.getXP());
            xpm.clearXP();
        }
    }

    private boolean canSuckStacks() {
        return this.power / this.MINPOWER >= 4L;
    }

    public void spawnXP() {
        ReikaWorldHelper.splitAndSpawnXP((World)this.field_145850_b, (double)((float)(this.field_145851_c - 1) + 2.0f * rand.nextFloat()), (double)((float)this.field_145848_d + 2.0f * rand.nextFloat()), (double)((float)(this.field_145849_e - 1) + 2.0f * rand.nextFloat()), (int)this.experience);
        this.experience = 0;
    }

    private void suck(World world, int x, int y, int z) {
        AxisAlignedBB box = this.getBox(world, x, y, z);
        List inbox = world.func_82733_a(Entity.class, box, ReikaEntityHelper.itemOrXPSelector);
        double v = Math.max(1.0, (double)this.power / 1048576.0);
        for (Entity ent : inbox) {
            if (ent.field_70173_aa <= 5) continue;
            double dx = (double)x + 0.5 - ent.field_70165_t;
            double dy = (double)y + 0.5 - ent.field_70163_u;
            double dz = (double)z + 0.5 - ent.field_70161_v;
            double ddt = ReikaMathLibrary.py3d((double)dx, (double)dy, (double)dz);
            if (ent.field_70173_aa > 50 && ddt > 1.5 && ent.field_70173_aa % 400 < 80) {
                double t = (double)this.getTicksExisted() / 25.0;
                double r = 2.875;
                dx += r * Math.cos(t);
                dz += r * Math.sin(t);
            }
            double vx = v * dx / ddt / ddt;
            double vy = v * dy / ddt / ddt / 2.0;
            double vz = v * dz / ddt / ddt;
            double vmax = 0.125;
            vx = MathHelper.func_151237_a((double)vx, (double)(-vmax), (double)vmax);
            vy = MathHelper.func_151237_a((double)vy, (double)(-vmax), (double)vmax);
            vz = MathHelper.func_151237_a((double)vz, (double)(-vmax), (double)vmax);
            ent.field_70159_w += vx;
            ent.field_70181_x += vy;
            ent.field_70179_y += vz;
            if (ent.field_70163_u < (double)y) {
                ent.field_70181_x += 0.125;
            }
            if (world.field_72995_K) continue;
            ent.field_70133_I = true;
        }
    }

    private void absorb(World world, int x, int y, int z) {
        if (world.field_72995_K) {
            return;
        }
        boolean suck = false;
        AxisAlignedBB close = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)).func_72314_b(0.25, 0.25, 0.25);
        List closeitems = world.func_72872_a(EntityItem.class, close);
        for (EntityItem ent : closeitems) {
            if (ent.field_145804_b <= 0) {
                ItemStack is = ent.func_92059_d();
                int targetslot = this.checkForStack(is);
                if (targetslot != -1) {
                    if (this.inv[targetslot] == null) {
                        this.inv[targetslot] = is.func_77946_l();
                    } else {
                        this.inv[targetslot].field_77994_a += is.field_77994_a;
                    }
                } else {
                    return;
                }
                suck = true;
                ent.func_70106_y();
                world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.pop", 0.1f + 0.5f * rand.nextFloat(), rand.nextFloat());
                MinecraftForge.EVENT_BUS.post((Event)new VacuumItemAbsorbEvent((TileEntity)this, is != null ? is.func_77946_l() : null));
                continue;
            }
            suck = true;
        }
        this.isFull = !suck;
        List closeorbs = world.func_72872_a(EntityXPOrb.class, close);
        for (EntityXPOrb xp : closeorbs) {
            int val = xp.func_70526_d();
            this.experience += val;
            xp.func_70106_y();
            world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.orb", 0.1f, 0.5f * ((rand.nextFloat() - rand.nextFloat()) * 0.7f + 1.8f));
            MinecraftForge.EVENT_BUS.post((Event)new VacuumXPAbsorbEvent((TileEntity)this, val));
        }
    }

    private int checkForStack(ItemStack is) {
        int target = -1;
        Item id = is.func_77973_b();
        int meta = is.func_77960_j();
        int size = is.field_77994_a;
        int firstempty = -1;
        for (int k = 0; k < this.inv.length; ++k) {
            if (this.inv[k] != null) continue;
            firstempty = k;
            k = this.inv.length;
        }
        for (int j = 0; j < this.inv.length; ++j) {
            if (this.inv[j] == null || !ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)this.inv[j]) || !ItemStack.func_77970_a((ItemStack)is, (ItemStack)this.inv[j])) continue;
            if (this.inv[j].field_77994_a + size <= this.func_70297_j_()) {
                target = j;
                j = this.inv.length;
                continue;
            }
            int diff = is.func_77976_d() - this.inv[j].field_77994_a;
            this.inv[j].field_77994_a += diff;
            is.field_77994_a -= diff;
        }
        if (target == -1) {
            target = firstempty;
        }
        return target;
    }

    private AxisAlignedBB getBox(World world, int x, int y, int z) {
        int expand = this.getRange();
        AxisAlignedBB base = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
        return this.equidistant ? base.func_72314_b((double)expand, (double)expand, (double)expand) : base.func_72314_b((double)expand, 2.0, (double)expand);
    }

    @Override
    public int getRange() {
        return ReikaMathLibrary.extrema((int)(8 + (int)(this.power * 4L / this.MINPOWER)), (int)this.getMaxRange(), (String)"min");
    }

    public int func_70302_i_() {
        return 54;
    }

    public static boolean func_52005_b(ItemStack par0ItemStack) {
        return true;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.experience = NBT.func_74762_e("xp");
        this.equidistant = NBT.func_74767_n("equi");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("xp", this.experience);
        NBT.func_74757_a("equi", this.equidistant);
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.VACUUM;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        return true;
    }

    @Override
    public int getMaxRange() {
        return Math.max(32, ConfigRegistry.VACUUMRANGE.getValue());
    }

    public int getRedstoneOverride() {
        return Container.func_94526_b((IInventory)this);
    }

    @Override
    public void onEMP() {
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return resource.getFluidID() == ReikaXPFluidHelper.getFluid().getFluidID() ? this.drain(from, resource.amount, doDrain) : null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        FluidStack fs;
        FluidStack fluidStack = fs = this.experience > 0 ? ReikaXPFluidHelper.getFluid((int)this.experience) : null;
        if (fs != null) {
            if (fs.amount > maxDrain) {
                fs.amount = maxDrain;
            }
            if (doDrain) {
                this.experience -= ReikaXPFluidHelper.getXPForAmount((int)fs.amount);
            }
        }
        return fs;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return ReikaXPFluidHelper.fluidsExist() && this.experience > 0 && fluid.equals(ReikaXPFluidHelper.getFluidType());
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[0];
    }

    public void breakBlock() {
        ReikaWorldHelper.splitAndSpawnXP((World)this.field_145850_b, (double)((float)this.field_145851_c + rand.nextFloat()), (double)((float)this.field_145848_d + rand.nextFloat()), (double)((float)this.field_145849_e + rand.nextFloat()), (int)this.experience);
    }
}

