/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities;

import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Auxiliary.ModularLogger;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Instantiable.ModInteract.BasicAEInterface;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Libraries.Java.ReikaArrayHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.ModInteract.DeepInteract.MESystemReader;
import Reika.DragonAPI.ModList;
import Reika.RotaryCraft.Base.TileEntity.InventoriedPowerReceiver;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.RotaryCraft;
import appeng.api.AEApi;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.util.AECableType;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@APIStripper.Strippable(value={"appeng.api.networking.IActionHost"})
public class TileEntityItemFilter
extends InventoriedPowerReceiver
implements IActionHost {
    private static final String LOGGER_ID = "ItemFilter";
    private MatchData data;
    @DependentMethodStripper.ModDependent(value=ModList.APPENG)
    private MESystemReader network;
    private Object aeGridBlock;
    private Object aeGridNode;
    private final StepTimer updateTimer = new StepTimer(200);
    private final ArrayList<ItemStack> MEStacks = new ArrayList();

    public TileEntityItemFilter() {
        if (ModList.APPENG.isLoaded()) {
            this.aeGridBlock = new BasicAEInterface((TileEntity)this, this.getMachine().getCraftedProduct());
            this.aeGridNode = FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER ? AEApi.instance().createGridNode((IGridBlock)this.aeGridBlock) : null;
        }
    }

    public boolean func_102008_b(int slot, ItemStack is, int side) {
        return slot == 1;
    }

    public int func_70302_i_() {
        return 2;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        return slot == 1 && this.power >= this.MINPOWER && this.matchItem(is);
    }

    private boolean matchItem(ItemStack is) {
        return this.data != null && this.data.match(is) != this.hasRedstoneSignal();
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    protected void onInventoryChanged() {
        this.reloadData();
    }

    public void reloadData() {
        this.data = this.inv[0] != null ? new MatchData(this.inv[0]).loadFrom(this.data) : null;
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.ITEMFILTER;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.getSummativeSidedPower();
        if (ModList.APPENG.isLoaded() && this.power >= this.MINPOWER) {
            this.updateTimer.update();
            if (this.updateTimer.checkCap() && !world.field_72995_K) {
                this.buildCache();
            }
            if (this.network != null) {
                this.network.tick();
            }
            if (this.aeGridBlock != null && !world.field_72995_K) {
                ((BasicAEInterface)this.aeGridBlock).setPowerCost(this.power >= this.MINPOWER ? 2.0 : 1.0);
            }
            if (this.network != null && !world.field_72995_K && this.inv[1] == null && !this.MEStacks.isEmpty() && this.data != null) {
                int idx = rand.nextInt(this.MEStacks.size());
                ItemStack is = this.MEStacks.get(idx);
                int ret = (int)this.network.removeItem(is = ReikaItemHelper.getSizedItemStack((ItemStack)is, (int)is.func_77976_d()), false, true);
                if (ret > 0) {
                    this.inv[1] = ReikaItemHelper.getSizedItemStack((ItemStack)is, (int)ret);
                }
            }
        }
        if (this.data == null && this.inv[0] != null) {
            this.onInventoryChanged();
        }
    }

    private void buildCache() {
        if (ModList.APPENG.isLoaded()) {
            Object oldNode = this.aeGridNode;
            if (this.aeGridNode == null) {
                this.aeGridNode = FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER ? AEApi.instance().createGridNode((IGridBlock)this.aeGridBlock) : null;
            }
            ((IGridNode)this.aeGridNode).updateState();
            if (oldNode != this.aeGridNode || this.network == null) {
                this.network = this.aeGridNode == null ? null : (this.network == null ? new MESystemReader((IGridNode)this.aeGridNode, (IActionHost)this) : new MESystemReader((IGridNode)this.aeGridNode, this.network));
            }
            if (this.network != null && this.data != null) {
                this.MEStacks.clear();
                if (ModularLogger.instance.isEnabled(LOGGER_ID)) {
                    ModularLogger.instance.log(LOGGER_ID, "Found raw ME: " + this.network.getRawMESystemContents());
                }
                for (ItemStack is : this.network.getRawMESystemContents()) {
                    if (this.matchItem(is)) {
                        if (ModularLogger.instance.isEnabled(LOGGER_ID)) {
                            ModularLogger.instance.log(LOGGER_ID, "@ " + this + " [" + this.hasRedstoneSignal() + "], " + is.func_82833_r() + ":" + is.func_77960_j() + " {" + is.field_77990_d + "}" + " matches " + this.data);
                        }
                        this.MEStacks.add(ReikaItemHelper.getSizedItemStack((ItemStack)is, (int)1));
                        continue;
                    }
                    if (!ModularLogger.instance.isEnabled(LOGGER_ID)) continue;
                    ModularLogger.instance.log(LOGGER_ID, is.func_82833_r() + " does not match.");
                }
            }
        }
    }

    protected void onInvalidateOrUnload(World world, int x, int y, int z, boolean invalid) {
        super.onInvalidateOrUnload(world, x, y, z, invalid);
        if (ModList.APPENG.isLoaded() && this.aeGridNode != null) {
            ((IGridNode)this.aeGridNode).destroy();
        }
    }

    public MatchData getData() {
        return this.data;
    }

    public void setData(MatchData dat) {
        this.data = dat;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        if (this.data != null) {
            NBTTagCompound tag = this.data.writeToNBT();
            NBT.func_74782_a("data", (NBTBase)tag);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        if (NBT.func_74764_b("data")) {
            this.data = MatchData.createFromNBT(NBT.func_74775_l("data"));
        }
    }

    @DependentMethodStripper.ModDependent(value=ModList.APPENG)
    public IGridNode getGridNode(ForgeDirection dir) {
        return (IGridNode)this.aeGridNode;
    }

    @DependentMethodStripper.ModDependent(value=ModList.APPENG)
    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.COVERED;
    }

    @DependentMethodStripper.ModDependent(value=ModList.APPENG)
    public void securityBreak() {
    }

    @DependentMethodStripper.ModDependent(value=ModList.APPENG)
    public IGridNode getActionableNode() {
        return (IGridNode)this.aeGridNode;
    }

    static {
        ModularLogger.instance.addLogger((DragonAPIMod)RotaryCraft.instance, LOGGER_ID);
    }

    public static enum SettingType {
        BASIC,
        ORE,
        NBT;

        private static final SettingType[] list;

        public SettingType previous() {
            return this.ordinal() == 0 ? this : list[this.ordinal() - 1];
        }

        public SettingType next() {
            return this.ordinal() == list.length - 1 ? this : list[this.ordinal() + 1];
        }

        static {
            list = SettingType.values();
        }
    }

    public static enum MatchType {
        MATCH(32768, "Match"),
        MISMATCH(0xA00000, "Mismatch"),
        IGNORE(0xFFD000, "Ignore");

        private static final MatchType[] list;
        public final String name;
        public final int color;

        private MatchType(int c, String n2) {
            this.name = n2;
            this.color = c;
        }

        public MatchType getNext() {
            return this.ordinal() == list.length - 1 ? list[0] : list[this.ordinal() + 1];
        }

        public boolean check(boolean match) {
            switch (this) {
                case IGNORE: {
                    return true;
                }
                case MATCH: {
                    return match;
                }
                case MISMATCH: {
                    return !match;
                }
            }
            return false;
        }

        static {
            list = MatchType.values();
        }
    }

    public static class MatchDisplay {
        private final MatchData source;
        private final SettingType type;
        private LinkedList<String> tags;
        private MatchType setting;
        public final String displayName;
        public final String value;

        private MatchDisplay(MatchData src, SettingType type, String s, String val, MatchType m) {
            this.setting = m;
            this.displayName = s;
            this.value = val;
            this.source = src;
            this.type = type;
            this.tags = null;
        }

        private MatchDisplay(MatchData src, SettingType type, String s, NBTBase b, LinkedList<String> li, MatchType m) {
            this(src, type, s, b.toString(), m);
            this.tags = new LinkedList<String>(li);
        }

        public MatchType getSetting() {
            return this.setting;
        }

        public void increment() {
            this.setting = this.setting.getNext();
            this.source.incrementSetting(this);
        }
    }

    private static class NBTMatch {
        private MatchType match = MatchType.MATCH;
        private final NBTBase tag;

        private NBTMatch(NBTBase b) {
            this.tag = b;
        }

        public static NBTTagCompound asTag(String s, NBTBase b) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("name", s);
            tag.func_74782_a("tag", b);
            tag.func_74768_a("type", MatchType.MATCH.ordinal());
            return tag;
        }

        public boolean match(NBTBase b) {
            if (this.match == MatchType.IGNORE) {
                return true;
            }
            if (this.tag != null && b == null && !this.match.check(false)) {
                return false;
            }
            if (this.tag instanceof NBTTagCompound || this.tag instanceof NBTTagList) {
                return this.match.check(b.getClass() == this.tag.getClass());
            }
            return this.match.check(this.tag.equals((Object)b));
        }
    }

    public static class MatchData {
        private MatchType matchID = MatchType.MATCH;
        private MatchType matchMetadata = MatchType.MATCH;
        private MatchType matchMod = MatchType.MATCH;
        private MatchType doCheckNBT = MatchType.MATCH;
        private MatchType doCheckOre = MatchType.MATCH;
        private final MatchType[] matchOre;
        private final NBTTagCompound matchNBT;
        public final Item itemID;
        public final int metadata;
        public final String modID;
        private final String[] oreDict;
        private final NBTTagCompound nbt;

        private MatchData(ItemStack is) {
            this.itemID = is.func_77973_b();
            this.metadata = is.func_77960_j();
            this.modID = ReikaItemHelper.getRegistrantMod((ItemStack)is);
            this.oreDict = ReikaItemHelper.getOreNamesArray((ItemStack)is);
            this.nbt = is.field_77990_d != null ? (NBTTagCompound)is.field_77990_d.func_74737_b() : null;
            this.matchOre = (MatchType[])ReikaArrayHelper.getArrayOf((Object)((Object)MatchType.MATCH), (int)this.oreDict.length);
            if (this.nbt != null) {
                this.matchNBT = (NBTTagCompound)this.nbt.func_74737_b();
                this.parseNBT(this.matchNBT);
            } else {
                this.matchNBT = null;
            }
        }

        private MatchData(Item itemID, int metadata, String modID, NBTTagCompound nbt, String[] oreDict, MatchType matchID, MatchType matchMetadata, MatchType matchMod, MatchType doCheckNBT, MatchType doCheckOre, MatchType[] matchOre, NBTTagCompound matchNBT) {
            if (matchNBT.func_82582_d()) {
                matchNBT = null;
            }
            if (nbt.func_82582_d()) {
                nbt = null;
            }
            this.itemID = itemID;
            this.metadata = metadata;
            this.modID = modID;
            this.nbt = nbt;
            this.oreDict = oreDict;
            this.matchID = matchID;
            this.matchMetadata = matchMetadata;
            this.matchMod = matchMod;
            this.doCheckNBT = doCheckNBT;
            this.doCheckOre = doCheckOre;
            this.matchOre = matchOre;
            this.matchNBT = matchNBT;
        }

        public MatchData loadFrom(MatchData data) {
            if (data != null) {
                this.matchID = data.matchID;
                this.matchMetadata = data.matchMetadata;
                this.matchMod = data.matchMod;
                this.doCheckNBT = data.doCheckNBT;
            }
            return this;
        }

        public NBTTagCompound writeToNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            NBTTagCompound settings = new NBTTagCompound();
            settings.func_74768_a("item", this.matchID.ordinal());
            settings.func_74768_a("dmg", this.matchMetadata.ordinal());
            settings.func_74768_a("mod", this.matchMod.ordinal());
            settings.func_74768_a("checknbt", this.doCheckNBT.ordinal());
            settings.func_74768_a("checkore", this.doCheckOre.ordinal());
            NBTTagCompound ore2 = new NBTTagCompound();
            for (int i = 0; i < this.oreDict.length; ++i) {
                ore2.func_74768_a(this.oreDict[i], this.matchOre[i].ordinal());
            }
            settings.func_74782_a("ores", (NBTBase)ore2);
            if (this.nbt != null) {
                settings.func_74782_a("nbt", (NBTBase)this.matchNBT);
            }
            tag.func_74782_a("settings", (NBTBase)settings);
            NBTTagCompound val = new NBTTagCompound();
            val.func_74778_a("item", Item.field_150901_e.func_148750_c((Object)this.itemID));
            val.func_74768_a("dmg", this.metadata);
            val.func_74778_a("mod", this.modID);
            if (this.nbt != null) {
                val.func_74782_a("nbt", (NBTBase)this.nbt);
            }
            tag.func_74782_a("value", (NBTBase)val);
            NBTTagList ore = new NBTTagList();
            for (int i = 0; i < this.oreDict.length; ++i) {
                ore.func_74742_a((NBTBase)new NBTTagString(this.oreDict[i]));
            }
            val.func_74782_a("ores", (NBTBase)ore);
            return tag;
        }

        public static MatchData createFromNBT(NBTTagCompound tag) {
            NBTTagCompound val = tag.func_74775_l("value");
            Item itemID = (Item)Item.field_150901_e.func_82594_a(val.func_74779_i("item"));
            int metadata = val.func_74762_e("dmg");
            String modID = val.func_74779_i("mod");
            NBTTagCompound nbt = val.func_74775_l("nbt");
            NBTTagList ore = val.func_150295_c("ores", ReikaNBTHelper.NBTTypes.STRING.ID);
            ArrayList<String> li = new ArrayList<String>();
            for (Object o : ore.field_74747_a) {
                NBTTagString s = (NBTTagString)o;
                li.add(s.func_150285_a_());
            }
            String[] oreDict = li.toArray(new String[li.size()]);
            NBTTagCompound settings = tag.func_74775_l("settings");
            MatchType matchID = MatchType.list[settings.func_74762_e("item")];
            MatchType matchMetadata = MatchType.list[settings.func_74762_e("dmg")];
            MatchType matchMod = MatchType.list[settings.func_74762_e("mod")];
            MatchType doCheckNBT = MatchType.list[settings.func_74762_e("checknbt")];
            MatchType doCheckOre = MatchType.list[settings.func_74762_e("checkore")];
            NBTTagCompound ore2 = settings.func_74775_l("ores");
            MatchType[] matchOre = new MatchType[oreDict.length];
            for (int i = 0; i < oreDict.length; ++i) {
                matchOre[i] = MatchType.list[ore2.func_74762_e(oreDict[i])];
            }
            NBTTagCompound matchNBT = settings.func_74775_l("nbt");
            return new MatchData(itemID, metadata, modID, nbt, oreDict, matchID, matchMetadata, matchMod, doCheckNBT, doCheckOre, matchOre, matchNBT);
        }

        private void incrementSetting(MatchDisplay m) {
            switch (m.type) {
                case BASIC: {
                    switch (m.displayName) {
                        case "Item ID": {
                            this.matchID = this.matchID.getNext();
                            break;
                        }
                        case "Metadata": {
                            this.matchMetadata = this.matchMetadata.getNext();
                            break;
                        }
                        case "Mod ID": {
                            this.matchMod = this.matchMod.getNext();
                            break;
                        }
                        case "NBT Overall": {
                            this.doCheckNBT = this.doCheckNBT.getNext();
                            break;
                        }
                        case "OreDict Overall": {
                            this.doCheckOre = this.doCheckOre.getNext();
                        }
                    }
                    break;
                }
                case NBT: {
                    NBTTagCompound b = this.matchNBT;
                    if (m.tags != null) {
                        for (String s : m.tags) {
                            b = b.func_74781_a(s);
                        }
                    }
                    NBTTagCompound tag = b.func_74775_l(m.displayName);
                    MatchType match = MatchType.list[tag.func_74762_e("type")];
                    tag.func_74768_a("type", match.getNext().ordinal());
                    break;
                }
                case ORE: {
                    int i = Integer.parseInt(m.displayName);
                    this.matchOre[i] = this.matchOre[i].getNext();
                }
            }
        }

        public ArrayList<MatchDisplay> getMainDisplay() {
            ArrayList<MatchDisplay> li = new ArrayList<MatchDisplay>();
            li.add(new MatchDisplay(this, SettingType.BASIC, "Item ID", Item.field_150901_e.func_148750_c((Object)this.itemID), this.matchID));
            li.add(new MatchDisplay(this, SettingType.BASIC, "Metadata", String.valueOf(this.metadata), this.matchMetadata));
            li.add(new MatchDisplay(this, SettingType.BASIC, "Mod ID", this.modID, this.matchMod));
            li.add(new MatchDisplay(this, SettingType.BASIC, "NBT Overall", "", this.doCheckNBT));
            li.add(new MatchDisplay(this, SettingType.BASIC, "OreDict Overall", Arrays.toString(this.oreDict), this.doCheckOre));
            return li;
        }

        public ArrayList<MatchDisplay> getOreDisplay() {
            ArrayList<MatchDisplay> li = new ArrayList<MatchDisplay>();
            for (int i = 0; i < this.oreDict.length; ++i) {
                li.add(new MatchDisplay(this, SettingType.ORE, String.valueOf(i), this.oreDict[i], this.matchOre[i]));
            }
            return li;
        }

        public ArrayList<MatchDisplay> getNBTDisplay() {
            if (this.nbt == null || this.nbt.func_82582_d()) {
                return new ArrayList<MatchDisplay>();
            }
            return this.getNBTDisplay(this.nbt, this.matchNBT, new LinkedList<String>());
        }

        private ArrayList<MatchDisplay> getNBTDisplay(NBTTagCompound tag, NBTTagCompound matchRef, LinkedList<String> tags) {
            ArrayList<MatchDisplay> li = new ArrayList<MatchDisplay>();
            for (Object o : tag.func_150296_c()) {
                MatchDisplay md;
                String s = (String)o;
                NBTBase b = tag.func_74781_a(s);
                NBTTagCompound match = matchRef.func_74775_l(s);
                MatchType m = MatchType.list[match.func_74762_e("type")];
                if (b instanceof NBTTagList) {
                    md = new MatchDisplay(this, SettingType.NBT, s, "", m);
                    md.tags = new LinkedList<String>(tags);
                    li.add(md);
                    tags.add(s);
                    li.addAll(this.getNBTDisplay((NBTTagList)b, match, tags));
                    continue;
                }
                if (b instanceof NBTTagCompound) {
                    md = new MatchDisplay(this, SettingType.NBT, s, "", m);
                    md.tags = new LinkedList<String>(tags);
                    li.add(md);
                    tags.add(s);
                    li.addAll(this.getNBTDisplay((NBTTagCompound)b, match, tags));
                    continue;
                }
                li.add(new MatchDisplay(this, SettingType.NBT, s, b, tags, m));
            }
            if (!tags.isEmpty()) {
                tags.removeLast();
            }
            return li;
        }

        private ArrayList<MatchDisplay> getNBTDisplay(NBTTagList tag, NBTTagCompound matchRef, LinkedList<String> tags) {
            ArrayList<MatchDisplay> li = new ArrayList<MatchDisplay>();
            for (int i = 0; i < tag.field_74747_a.size(); ++i) {
                MatchDisplay md;
                String s = "#" + i;
                NBTBase b = (NBTBase)tag.field_74747_a.get(i);
                NBTTagCompound match = matchRef.func_74775_l(s);
                MatchType m = MatchType.list[match.func_74762_e("type")];
                if (b instanceof NBTTagList) {
                    md = new MatchDisplay(this, SettingType.NBT, s, "", m);
                    md.tags = new LinkedList<String>(tags);
                    li.add(md);
                    tags.add(s);
                    li.addAll(this.getNBTDisplay((NBTTagList)b, match, tags));
                    continue;
                }
                if (b instanceof NBTTagCompound) {
                    md = new MatchDisplay(this, SettingType.NBT, s, "", m);
                    md.tags = new LinkedList<String>(tags);
                    li.add(md);
                    tags.add(s);
                    li.addAll(this.getNBTDisplay((NBTTagCompound)b, match, tags));
                    continue;
                }
                li.add(new MatchDisplay(this, SettingType.NBT, s, b, tags, m));
            }
            if (!tags.isEmpty()) {
                tags.removeLast();
            }
            return li;
        }

        public boolean match(ItemStack is) {
            if (!this.matchID.check(is.func_77973_b() == this.itemID)) {
                return false;
            }
            if (!this.matchMetadata.check(is.func_77960_j() == this.metadata)) {
                return false;
            }
            if (!this.matchMod.check(ReikaItemHelper.getRegistrantMod((ItemStack)is).equals(this.modID))) {
                return false;
            }
            if (this.doCheckOre != MatchType.IGNORE) {
                for (int i = 0; i < this.matchOre.length; ++i) {
                    String s = this.oreDict[i];
                    if (this.matchOre[i].check(ReikaItemHelper.isInOreTag((ItemStack)is, (String)s))) continue;
                    return false;
                }
            }
            if (this.doCheckNBT != MatchType.IGNORE) {
                if (this.nbt == is.field_77990_d && this.doCheckNBT.check(true)) {
                    return true;
                }
                if (this.nbt == null && is.field_77990_d != null && !this.doCheckNBT.check(false)) {
                    return false;
                }
                if (this.nbt != null && is.field_77990_d == null && !this.doCheckNBT.check(false)) {
                    return false;
                }
                if (!this.tryMatchNBT(is.field_77990_d, this.nbt, this.matchNBT)) {
                    return false;
                }
            }
            return true;
        }

        private boolean tryMatchNBT(NBTTagCompound NBT, NBTTagCompound parentRef, NBTTagCompound matchRef) {
            for (Object o : matchRef.func_150296_c()) {
                String s = (String)o;
                NBTBase b2 = NBT.func_74781_a(s);
                NBTTagCompound match = matchRef.func_74775_l(s);
                MatchType m = MatchType.list[match.func_74762_e("type")];
                if (m == MatchType.IGNORE) continue;
                NBTBase val = match.func_74781_a("tag");
                if (val != null && b2 != null && val.getClass() != b2.getClass()) {
                    return m.check(false);
                }
                if (val instanceof NBTTagCompound) {
                    if (this.tryMatchNBT((NBTTagCompound)b2, (NBTTagCompound)val, match) || m.check(false)) continue;
                    return false;
                }
                if (val instanceof NBTTagList) {
                    if (this.tryMatchNBT((NBTTagList)b2, (NBTTagList)val, match) || m.check(false)) continue;
                    return false;
                }
                if (val == b2) {
                    return m.check(true);
                }
                if (val == null || b2 == null) {
                    ReikaJavaLibrary.pConsole((Object)(val + " @ " + s));
                    return m.check(false);
                }
                if (val instanceof NBTTagCompound || val instanceof NBTTagList) {
                    // empty if block
                }
                if (m.check(val.equals((Object)b2))) continue;
                ReikaJavaLibrary.pConsole((Object)(val + " @ " + s));
                return false;
            }
            return true;
        }

        private boolean tryMatchNBT(NBTTagList NBT, NBTTagList parentRef, NBTTagCompound matchRef) {
            for (int i = 0; i < parentRef.field_74747_a.size(); ++i) {
                String s = "#" + i;
                NBTBase b2 = (NBTBase)parentRef.field_74747_a.get(i);
                NBTTagCompound match = matchRef.func_74775_l(s);
                MatchType m = MatchType.list[match.func_74762_e("type")];
                if (m == MatchType.IGNORE) continue;
                NBTBase val = match.func_74781_a("tag");
                if (val == b2) {
                    return m.check(true);
                }
                if (val == null || b2 == null) {
                    return m.check(false);
                }
                if (val.getClass() != b2.getClass()) {
                    return m.check(false);
                }
                if (!(val instanceof NBTTagCompound ? !this.tryMatchNBT((NBTTagCompound)b2, (NBTTagCompound)val, match) : (val instanceof NBTTagList ? !this.tryMatchNBT((NBTTagList)b2, (NBTTagList)val, match) && !m.check(false) : !m.check(val.equals((Object)b2)) && !m.check(false)))) continue;
                return false;
            }
            return true;
        }

        private void parseNBT(NBTTagCompound NBT) {
            for (Object o : NBT.func_150296_c()) {
                String s = (String)o;
                NBTBase b = NBT.func_74781_a(s);
                if (b instanceof NBTTagList) {
                    this.parseNBT(NBT, s, (NBTTagList)b);
                    continue;
                }
                if (b instanceof NBTTagCompound) {
                    this.parseNBT((NBTTagCompound)b);
                    continue;
                }
                ReikaNBTHelper.replaceTag((NBTTagCompound)NBT, (String)s, (NBTBase)NBTMatch.asTag(s, b));
            }
        }

        private void parseNBT(NBTTagCompound parent, String parentName, NBTTagList NBT) {
            NBTBase b;
            for (int i = 0; i < NBT.field_74747_a.size(); ++i) {
                String s = "#" + i;
                b = (NBTBase)NBT.field_74747_a.get(i);
                if (b instanceof NBTTagList) {
                    this.parseNBT(NBT, i, (NBTTagList)b);
                    continue;
                }
                if (b instanceof NBTTagCompound) {
                    this.parseNBT((NBTTagCompound)b);
                    continue;
                }
                ReikaNBTHelper.replaceTag((NBTTagList)NBT, (int)i, (NBTBase)NBTMatch.asTag(s, b));
            }
            NBTTagCompound repl = new NBTTagCompound();
            for (int i = 0; i < NBT.field_74747_a.size(); ++i) {
                b = (NBTBase)NBT.field_74747_a.get(i);
                String s = "#" + i;
                repl.func_74782_a(s, (NBTBase)NBTMatch.asTag(s, b));
            }
            ReikaNBTHelper.combineNBT((NBTTagCompound)repl, (NBTTagCompound)NBTMatch.asTag(parentName, (NBTBase)NBT));
            ReikaNBTHelper.replaceTag((NBTTagCompound)parent, (String)parentName, (NBTBase)repl);
        }

        private void parseNBT(NBTTagList parent, int idx, NBTTagList NBT) {
            NBTBase b;
            for (int i = 0; i < NBT.field_74747_a.size(); ++i) {
                String s = "#" + i;
                b = (NBTBase)NBT.field_74747_a.get(i);
                if (b instanceof NBTTagList) {
                    this.parseNBT(NBT, i, (NBTTagList)b);
                    continue;
                }
                if (b instanceof NBTTagCompound) {
                    this.parseNBT((NBTTagCompound)b);
                    continue;
                }
                ReikaNBTHelper.replaceTag((NBTTagList)NBT, (int)i, (NBTBase)NBTMatch.asTag(s, b));
            }
            NBTTagCompound repl = new NBTTagCompound();
            for (int i = 0; i < NBT.field_74747_a.size(); ++i) {
                b = (NBTBase)NBT.field_74747_a.get(i);
                String s = "#" + i;
                repl.func_74782_a(s, b);
            }
            ReikaNBTHelper.combineNBT((NBTTagCompound)repl, (NBTTagCompound)NBTMatch.asTag("#" + idx, (NBTBase)NBT));
            ReikaNBTHelper.replaceTag((NBTTagList)parent, (int)idx, (NBTBase)repl);
        }

        public String toString() {
            return (Object)((Object)this.matchID) + "/" + (Object)((Object)this.matchMetadata) + "/" + (Object)((Object)this.matchMod) + "/" + (Object)((Object)this.doCheckOre) + "/" + (Object)((Object)this.doCheckNBT) + " = " + this.itemID + " / " + this.metadata + " / " + this.modID + " / " + Arrays.toString(this.oreDict) + " / " + Arrays.toString((Object[])this.matchOre) + " / " + this.matchNBT;
        }
    }
}

