/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities;

import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.RotaryCraft.Auxiliary.Interfaces.ConditionalOperation;
import Reika.RotaryCraft.Auxiliary.Interfaces.DiscreteFunction;
import Reika.RotaryCraft.Auxiliary.Interfaces.LocationTarget;
import Reika.RotaryCraft.Base.TileEntity.InventoriedPowerReceiver;
import Reika.RotaryCraft.Registry.MachineRegistry;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TileEntityItemCannon
extends InventoriedPowerReceiver
implements DiscreteFunction,
ConditionalOperation,
LocationTarget {
    private WorldLocation target;
    public static final int STACKPOWER = 524288;

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return j == 0;
    }

    public int func_70302_i_() {
        return 9;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        return true;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.ITEMCANNON;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        ++this.tickcount;
        this.getPowerBelow();
        if (this.power < this.MINPOWER) {
            return;
        }
        if (this.tickcount < this.getOperationTime()) {
            return;
        }
        ItemStack is = this.getFirstStack();
        if (is == null) {
            return;
        }
        if (world.field_72995_K) {
            return;
        }
        TileEntityItemCannon te = this.getTargetTE();
        if (te == null) {
            return;
        }
        if (!ReikaInventoryHelper.hasSpaceFor((ItemStack)is, (IInventory)te, (boolean)true)) {
            return;
        }
        this.tickcount = 0;
        this.fire(world, x, y, z, te);
    }

    private void fire(World world, int x, int y, int z, TileEntityItemCannon te) {
        double v = 4.0;
        ItemStack is = this.getFirstStack();
        if (is == null) {
            return;
        }
        int num = this.power >= 524288L ? is.field_77994_a : 1;
        int slot = ReikaInventoryHelper.locateInInventory((ItemStack)is, (ItemStack[])this.inv, (boolean)false);
        ReikaInventoryHelper.decrStack((int)slot, (IInventory)this, (int)num);
        EntityItem ei = new EntityItem(world, (double)x + 0.5, (double)y + 1.125, (double)z + 0.5, is);
        double dx = this.target.xCoord - x;
        double dy = this.target.yCoord - y;
        double dz = this.target.zCoord - z;
        double dd = ReikaMathLibrary.py3d((double)dx, (double)dy, (double)dz);
        ei.field_70159_w = dx / dd * v;
        ei.field_70181_x = dy / dd * v;
        ei.field_70179_y = dz / dd * v;
        ei.field_145804_b = 10;
        ei.lifespan = 5;
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)ei);
        }
        world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.explode", 1.0f, 1.0f);
        int left = ReikaInventoryHelper.addToInventoryWithLeftover((ItemStack)ReikaItemHelper.getSizedItemStack((ItemStack)is, (int)num), (ItemStack[])te.inv);
        this.inv[slot] = left > 0 ? ReikaItemHelper.getSizedItemStack((ItemStack)is, (int)left) : null;
    }

    private TileEntityItemCannon getTargetTE() {
        TileEntity te = this.target.getTileEntity();
        return te instanceof TileEntityItemCannon ? (TileEntityItemCannon)te : null;
    }

    private ItemStack getFirstStack() {
        for (int i = 0; i < this.inv.length; ++i) {
            if (this.inv[i] == null) continue;
            ItemStack is = this.inv[i].func_77946_l();
            return ReikaItemHelper.getSizedItemStack((ItemStack)is, (int)1);
        }
        return null;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        if (NBT.func_74764_b("target")) {
            this.target = WorldLocation.readFromNBT((String)"target", (NBTTagCompound)NBT);
        }
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        if (this.target != null) {
            this.target.writeToNBT("target", NBT);
        }
    }

    public int getRedstoneOverride() {
        if (ReikaInventoryHelper.isEmpty((ItemStack[])this.inv)) {
            return 15;
        }
        return 0;
    }

    @Override
    public int getOperationTime() {
        return 8;
    }

    @Override
    public boolean areConditionsMet() {
        return !ReikaInventoryHelper.isEmpty((ItemStack[])this.inv);
    }

    @Override
    public String getOperationalStatus() {
        return this.areConditionsMet() ? "Operational" : "No Items";
    }

    public void selectNewTarget(int dim, int x, int y, int z) {
        this.setTarget(new WorldLocation(dim, x, y, z));
    }

    @Override
    public void setTarget(WorldLocation loc) {
        this.target = loc;
    }

    @Override
    public WorldLocation getTarget() {
        return this.target;
    }
}

