/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities;

import Reika.DragonAPI.Instantiable.HybridTank;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaFluidHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.RotaryCraft.Auxiliary.Interfaces.ConditionalOperation;
import Reika.RotaryCraft.Auxiliary.Interfaces.DiscreteFunction;
import Reika.RotaryCraft.Auxiliary.Interfaces.PipeConnector;
import Reika.RotaryCraft.Base.TileEntity.InventoriedPowerReceiver;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPiping;
import Reika.RotaryCraft.Registry.DurationRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityBucketFiller
extends InventoriedPowerReceiver
implements PipeConnector,
IFluidHandler,
DiscreteFunction,
ConditionalOperation {
    public boolean filling = true;
    public static final int CAPACITY = 24000;
    private final HybridTank tank = new HybridTank("bucketfiller", 24000);
    public static final Fluid WATER = FluidRegistry.WATER;
    public static final Fluid LAVA = FluidRegistry.LAVA;
    public static final Fluid JETFUEL = FluidRegistry.getFluid((String)"rc jet fuel");
    public static final Fluid LUBRICANT = FluidRegistry.getFluid((String)"rc lubricant");

    public int func_70302_i_() {
        return 18;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        return FluidContainerRegistry.isContainer((ItemStack)is);
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.BUCKETFILLER;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        ++this.tickcount;
        this.getSummativeSidedPower();
        if (this.power < this.MINPOWER) {
            return;
        }
        if (this.omega < this.MINSPEED) {
            return;
        }
        if (this.filling) {
            if (this.tickcount <= this.getOperationTime()) {
                return;
            }
            this.tickcount = 0;
            this.fillBuckets();
        } else {
            if (this.tickcount <= this.getOperationTime()) {
                return;
            }
            this.tickcount = 0;
            this.emptyBuckets();
        }
    }

    private void emptyBuckets() {
        for (int i = 0; i < this.inv.length; ++i) {
            FluidStack fluid;
            ItemStack slot = this.inv[i];
            if (slot == null || (fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)slot)) == null || !this.canAccept(fluid.getFluid()) || this.tank.getCapacity() < fluid.amount + this.tank.getLevel()) continue;
            ItemStack is = FluidContainerRegistry.drainFluidContainer((ItemStack)slot);
            ReikaInventoryHelper.decrStack((int)i, (ItemStack[])this.inv);
            if (is != null && !ReikaInventoryHelper.addToIInv((ItemStack)is, (IInventory)this)) {
                ReikaItemHelper.dropItem((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)(this.field_145848_d + 1), (double)((double)this.field_145849_e + 0.5), (ItemStack)is);
            }
            this.tank.addLiquid(fluid.amount, fluid.getFluid());
            return;
        }
    }

    private void fillBuckets() {
        for (int i = 0; i < this.inv.length; ++i) {
            ItemStack is;
            ItemStack slot = this.inv[i];
            if (slot == null || !FluidContainerRegistry.isEmptyContainer((ItemStack)slot) || (is = FluidContainerRegistry.fillFluidContainer((FluidStack)this.tank.getFluid(), (ItemStack)slot)) == null) continue;
            this.tank.removeLiquid(FluidContainerRegistry.getFluidForFilledItem((ItemStack)is).amount);
            ReikaInventoryHelper.decrStack((int)i, (ItemStack[])this.inv);
            if (ReikaInventoryHelper.addToIInv((ItemStack)is, (IInventory)this)) continue;
            ReikaItemHelper.dropItem((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)(this.field_145848_d + 1), (double)((double)this.field_145849_e + 0.5), (ItemStack)is);
        }
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.tank.readFromNBT(NBT);
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        this.tank.writeToNBT(NBT);
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        if (this.filling) {
            return j == 0 && FluidContainerRegistry.isFilledContainer((ItemStack)itemstack);
        }
        return j == 0 && FluidContainerRegistry.isEmptyContainer((ItemStack)itemstack);
    }

    @Override
    public boolean canConnectToPipe(MachineRegistry m) {
        return m == MachineRegistry.HOSE || m.isStandardPipe() || m == MachineRegistry.FUELLINE;
    }

    @Override
    public boolean canConnectToPipeOnSide(MachineRegistry p, ForgeDirection side) {
        return side.offsetY == 0;
    }

    public boolean canAccept(Fluid f) {
        return this.tank.isEmpty() || f.equals(this.tank.getActualFluid());
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.canReceiveFrom(from) && this.filling;
    }

    private boolean canReceiveFrom(ForgeDirection from) {
        return from.offsetY == 0;
    }

    public void setEmpty() {
        this.tank.empty();
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.canDrain(from, resource.getFluid()) ? this.tank.drain(resource.amount, doDrain) : null;
    }

    @Override
    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this.filling || from.offsetY != 0) {
            return null;
        }
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return !this.filling && from.offsetY == 0 && ReikaFluidHelper.isFluidDrainableFromTank((Fluid)fluid, (HybridTank)this.tank);
    }

    @Override
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (this.canFill(from, resource.getFluid())) {
            return this.tank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @Override
    public TileEntityPiping.Flow getFlowForSide(ForgeDirection side) {
        return side.offsetY == 0 ? (this.filling ? TileEntityPiping.Flow.INPUT : TileEntityPiping.Flow.OUTPUT) : TileEntityPiping.Flow.NONE;
    }

    public int getLevel() {
        return this.tank.getLevel();
    }

    public Fluid getContainedFluid() {
        return this.tank.getActualFluid();
    }

    @Override
    public int getOperationTime() {
        return DurationRegistry.BUCKETFILLER.getOperationTime(this.omega);
    }

    @Override
    public boolean areConditionsMet() {
        return !ReikaInventoryHelper.isEmpty((ItemStack[])this.inv);
    }

    @Override
    public String getOperationalStatus() {
        return this.areConditionsMet() ? "Operational" : "No Buckets";
    }
}

