/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities;

import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Auxiliary.Trackers.ReflectiveFailureTracker;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Interfaces.Registry.ModEntry;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.InterfaceCache;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPowerReceiver;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.RotaryCraft;
import appeng.api.implementations.ICraftingPatternItem;
import cpw.mods.fml.relauncher.Side;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;
import powercrystals.minefactoryreloaded.api.IDeepStorageUnit;

public class TileEntityBlower
extends TileEntityPowerReceiver {
    private ForgeDirection facing;
    public ItemStack[] matchingItems = new ItemStack[18];
    public boolean isWhitelist = false;
    public boolean useOreDict = true;
    public boolean checkMeta = false;
    public boolean checkNBT = false;
    private static Method getPatterns;
    private static Field dualityField;

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.BLOWER;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        this.getIOSides(world, x, y, z, meta);
        this.getSummativeSidedPower();
        if (this.MINPOWER > this.power || this.MINSPEED > this.omega) {
            return;
        }
        if (world.field_72995_K) {
            return;
        }
        ForgeDirection dir = this.getFacingDir();
        ForgeDirection from = dir.getOpposite();
        TileEntity source = this.getAdjacentTileEntity(from);
        if (source instanceof IInventory) {
            HashMap map;
            TileEntity target = this.getAdjacentTileEntity(dir);
            WorldLocation tg = new WorldLocation(target);
            ArrayList<TileEntity> li = new ArrayList<TileEntity>();
            while (target instanceof TileEntityBlower) {
                TileEntityBlower te = (TileEntityBlower)target;
                target = te.getAdjacentTileEntity(te.getFacingDir());
                tg = tg.move(te.getFacingDir(), 1);
                if (li.contains(target)) {
                    return;
                }
                li.add(target);
                if (this.equals(target)) {
                    return;
                }
                if (!source.equals(target)) continue;
                return;
            }
            if (target instanceof IInventory) {
                if (InterfaceCache.DSU.instanceOf((Object)target)) {
                    this.transferItems(null, (IInventory)source, (IInventory)target, dir);
                } else if (!this.tryPatternInsertion((IInventory)source, target) && (map = ReikaInventoryHelper.getLocatedTransferrables((ForgeDirection)from, (IInventory)((IInventory)source))) != null && !map.isEmpty()) {
                    this.transferItems(map, (IInventory)source, (IInventory)target, dir);
                }
            } else if (target == null && ConfigRegistry.BLOWERSPILL.getState() && tg.isEmpty()) {
                if (InterfaceCache.DSU.instanceOf((Object)source)) {
                    this.dumpItems(null, (IInventory)source, tg);
                } else {
                    map = ReikaInventoryHelper.getLocatedTransferrables((ForgeDirection)from, (IInventory)((IInventory)source));
                    if (map != null && !map.isEmpty()) {
                        this.dumpItems(map, (IInventory)source, tg);
                    }
                }
            }
        }
    }

    private boolean tryPatternInsertion(IInventory source, TileEntity target) {
        if (InterfaceCache.MEINTERFACE.instanceOf((Object)target)) {
            for (int i = 0; i < source.func_70302_i_(); ++i) {
                ItemStack is = source.func_70301_a(i);
                if (is == null || !(is.func_77973_b() instanceof ICraftingPatternItem)) continue;
                try {
                    IInventory patterns = this.getPatterns(target);
                    if (!ReikaInventoryHelper.addToIInv((ItemStack)is, (IInventory)patterns)) continue;
                    return true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }
        return false;
    }

    @DependentMethodStripper.ModDependent(value=ModList.APPENG)
    private IInventory getPatterns(TileEntity target) throws Exception {
        return (IInventory)getPatterns.invoke(dualityField.get(target), new Object[0]);
    }

    private void printTEs(TileEntity source, TileEntity target) {
        if (source == null && target == null) {
            ReikaJavaLibrary.pConsole((Object)"null >> null", (Side)Side.SERVER);
        } else if (source == null) {
            ReikaJavaLibrary.pConsole((Object)("null >> " + target.getClass().getSimpleName()), (Side)Side.SERVER);
        } else if (target == null) {
            ReikaJavaLibrary.pConsole((Object)(source.getClass().getSimpleName() + " >> null"), (Side)Side.SERVER);
        } else {
            ReikaJavaLibrary.pConsole((Object)(source.getClass().getSimpleName() + " >> " + target.getClass().getSimpleName()), (Side)Side.SERVER);
        }
    }

    private int getNumberTransferrableItems() {
        return (int)(this.power / 1024L);
    }

    private void transferItems(HashMap<Integer, ItemStack> map, IInventory source, IInventory target, ForgeDirection dir) {
        int max = this.getNumberTransferrableItems();
        if (max <= 0) {
            return;
        }
        if (map == null) {
            IDeepStorageUnit dsu = (IDeepStorageUnit)source;
            ItemStack is = dsu.getStoredItemType();
            if (is != null && this.isItemTransferrable(is)) {
                int add = Math.min(max, is.field_77994_a);
                int rem = this.addItemToInventory(is, target, null, -1, add, dir);
                dsu.setStoredItemCount(is.field_77994_a - rem);
            }
        } else {
            for (int slot : map.keySet()) {
                ItemStack is = map.get(slot);
                if (!this.isItemTransferrable(is)) continue;
                int rem = this.addItemToInventory(is, target, source, slot, max, dir);
            }
        }
    }

    private void dumpItems(HashMap<Integer, ItemStack> map, IInventory source, WorldLocation loc) {
        int max = this.getNumberTransferrableItems();
        if (max <= 0) {
            return;
        }
        if (map == null) {
            IDeepStorageUnit dsu = (IDeepStorageUnit)source;
            ItemStack is = dsu.getStoredItemType();
            if (is != null && this.isItemTransferrable(is)) {
                int drop = Math.min(max, is.field_77994_a);
                int rem = this.dropItem(is, null, -1, drop, loc);
                dsu.setStoredItemCount(is.field_77994_a - rem);
            }
        } else {
            for (int slot : map.keySet()) {
                ItemStack is = map.get(slot);
                if (!this.isItemTransferrable(is)) continue;
                this.dropItem(is, source, slot, max, loc);
            }
        }
    }

    private int dropItem(ItemStack is, IInventory source, int slot, int amt, WorldLocation loc) {
        int items = 0;
        int maxadd = Math.min(amt - items, is.func_77976_d());
        for (int i = 0; i < maxadd; ++i) {
            if (source == null || source.func_70301_a(slot) != null && source.func_70301_a((int)slot).field_77994_a > 0) {
                loc.dropItem(ReikaItemHelper.getSizedItemStack((ItemStack)is, (int)1), 2.0 + rand.nextDouble() * 4.0);
                if (source != null) {
                    ReikaInventoryHelper.decrStack((int)slot, (IInventory)source, (int)1);
                }
                ++items;
            }
            if (items < amt) continue;
            return amt;
        }
        return items;
    }

    private int addItemToInventory(ItemStack is, IInventory ii, IInventory source, int slot, int amt, ForgeDirection dir) {
        int items = 0;
        int size = ii.func_70302_i_();
        int maxadd = Math.min(amt - items, Math.min(is.func_77976_d(), ii.func_70297_j_()));
        ItemStack one = ReikaItemHelper.getSizedItemStack((ItemStack)is, (int)1);
        for (int i = 0; i < maxadd; ++i) {
            for (int k = 0; k < size; ++k) {
                if (source != null && (source.func_70301_a(slot) == null || source.func_70301_a((int)slot).field_77994_a <= 0)) continue;
                if (ii instanceof ISidedInventory) {
                    if (((ISidedInventory)ii).func_102007_a(k, is, dir.getOpposite().ordinal()) && ReikaInventoryHelper.addToIInv((ItemStack)one, (IInventory)ii)) {
                        if (source != null) {
                            ReikaInventoryHelper.decrStack((int)slot, (IInventory)source, (int)1);
                        }
                        ++items;
                    }
                } else if (ReikaInventoryHelper.addToIInv((ItemStack)one, (IInventory)ii)) {
                    if (source != null) {
                        ReikaInventoryHelper.decrStack((int)slot, (IInventory)source, (int)1);
                    }
                    ++items;
                }
                if (items < amt) continue;
                return amt;
            }
        }
        return items;
    }

    public boolean isIntake() {
        return this.getAdjacentTileEntity(this.getFacingDir().getOpposite()) instanceof IInventory;
    }

    private void getIOSides(World world, int x, int y, int z, int meta) {
        switch (meta) {
            case 4: {
                this.facing = ForgeDirection.DOWN;
                break;
            }
            case 5: {
                this.facing = ForgeDirection.UP;
                break;
            }
            case 3: {
                this.facing = ForgeDirection.NORTH;
                break;
            }
            case 1: {
                this.facing = ForgeDirection.WEST;
                break;
            }
            case 2: {
                this.facing = ForgeDirection.SOUTH;
                break;
            }
            case 0: {
                this.facing = ForgeDirection.EAST;
            }
        }
    }

    public ForgeDirection getFacingDir() {
        return this.facing != null ? this.facing : ForgeDirection.UP;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74757_a("ore", this.useOreDict);
        NBT.func_74757_a("metac", this.checkMeta);
        NBT.func_74757_a("cnbt", this.checkNBT);
        NBT.func_74757_a("white", this.isWhitelist);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.matchingItems.length; ++i) {
            if (this.matchingItems[i] == null) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            this.matchingItems[i].func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        NBT.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.isWhitelist = NBT.func_74767_n("white");
        this.checkMeta = NBT.func_74767_n("metac");
        this.checkNBT = NBT.func_74767_n("cnbt");
        this.useOreDict = NBT.func_74767_n("ore");
        NBTTagList nbttaglist = NBT.func_150295_c("Items", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
        this.matchingItems = new ItemStack[18];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            byte byte0 = nbttagcompound.func_74771_c("Slot");
            if (byte0 < 0 || byte0 >= this.matchingItems.length) continue;
            this.matchingItems[byte0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound);
        }
    }

    public boolean isItemTransferrable(ItemStack is) {
        boolean match = this.isItemStackMatched(is);
        return this.isWhitelist ? match : !match;
    }

    private boolean isItemStackMatched(ItemStack is) {
        for (int i = 0; i < this.matchingItems.length; ++i) {
            ItemStack is1 = this.matchingItems[i];
            if (is1 == null || !this.doStacksMatch(is, is1)) continue;
            return true;
        }
        return false;
    }

    private boolean doStacksMatch(ItemStack is, ItemStack is1) {
        int oreID;
        if (this.checkMeta && is.func_77960_j() != is1.func_77960_j()) {
            return false;
        }
        if (this.checkNBT && !ItemStack.func_77970_a((ItemStack)is, (ItemStack)is1)) {
            return false;
        }
        if (ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)is1)) {
            return true;
        }
        if (this.useOreDict && (oreID = OreDictionary.getOreID((ItemStack)is)) > -1 && oreID == OreDictionary.getOreID((ItemStack)is1)) {
            return true;
        }
        return is.func_77973_b() == is1.func_77973_b();
    }

    @Override
    public int getTextureStateForSide(int s) {
        TileEntity source = this.getAdjacentTileEntity(this.getFacingDir().getOpposite());
        if (source instanceof TileEntityBlower) {
            TileEntityBlower te = (TileEntityBlower)source;
            return te.getFacingDir() != this.getFacingDir() ? 0 : 1;
        }
        return 0;
    }

    static {
        if (ModList.APPENG.isLoaded()) {
            try {
                Class c = Class.forName("appeng.helpers.DualityInterface");
                getPatterns = c.getDeclaredMethod("getPatterns", new Class[0]);
                getPatterns.setAccessible(true);
                c = InterfaceCache.MEINTERFACE.getClassType();
                dualityField = c.getDeclaredField("duality");
                dualityField.setAccessible(true);
            }
            catch (Exception e) {
                RotaryCraft.logger.logError((Object)"Could not add Item Pump AE pattern interfacing!");
                e.printStackTrace();
                ReflectiveFailureTracker.instance.logModReflectiveFailure((ModEntry)ModList.APPENG, e);
            }
        }
    }
}

