/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Storage;

import Reika.DragonAPI.Instantiable.HybridTank;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Interfaces.TileEntity.AdjacentUpdateWatcher;
import Reika.DragonAPI.Interfaces.TileEntity.BreakAction;
import Reika.DragonAPI.Interfaces.TileEntity.PlaceNotification;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaArrayHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaFluidHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.RotaryCraft.API.ReservoirAPI;
import Reika.RotaryCraft.Auxiliary.Interfaces.NBTMachine;
import Reika.RotaryCraft.Auxiliary.Interfaces.PipeConnector;
import Reika.RotaryCraft.Base.TileEntity.RotaryCraftTileEntity;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPiping;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.RotaryCraft;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityReservoir
extends RotaryCraftTileEntity
implements PipeConnector,
IFluidHandler,
NBTMachine,
BreakAction,
AdjacentUpdateWatcher,
PlaceNotification {
    public static final int CAPACITY = 64000;
    private static final ArrayList<Fluid> creativeFluids = new ArrayList();
    private static final Collection<ReservoirAPI.TankHandler> tankHandlers = new HashSet<ReservoirAPI.TankHandler>();
    private static final HashMap<String, FluidEffect> fluidEffects = new HashMap();
    private final StepTimer flowTimer = new StepTimer(TileEntityPiping.getTickDelay());
    private final StepTimer tempTimer = new StepTimer(20).stagger();
    public boolean isCovered = false;
    public boolean isCreative;
    private final HybridTank tank = new HybridTank("reservoir", 64000);
    private boolean[] adjacent = new boolean[10];

    public int getLiquidScaled(int par1) {
        return this.tank.getLevel() * par1 / 64000;
    }

    protected void onFirstTick(World world, int x, int y, int z) {
        this.updateSides(world, x, y, z);
    }

    private void updateSides(World world, int x, int y, int z) {
        this.adjacent[8] = MachineRegistry.getMachine((IBlockAccess)world, x, y, z - 1) == MachineRegistry.RESERVOIR;
        this.adjacent[4] = MachineRegistry.getMachine((IBlockAccess)world, x - 1, y, z) == MachineRegistry.RESERVOIR;
        this.adjacent[6] = MachineRegistry.getMachine((IBlockAccess)world, x + 1, y, z) == MachineRegistry.RESERVOIR;
        this.adjacent[2] = MachineRegistry.getMachine((IBlockAccess)world, x, y, z + 1) == MachineRegistry.RESERVOIR;
        this.adjacent[1] = MachineRegistry.getMachine((IBlockAccess)world, x - 1, y, z + 1) == MachineRegistry.RESERVOIR;
        this.adjacent[3] = MachineRegistry.getMachine((IBlockAccess)world, x + 1, y, z + 1) == MachineRegistry.RESERVOIR;
        this.adjacent[7] = MachineRegistry.getMachine((IBlockAccess)world, x - 1, y, z - 1) == MachineRegistry.RESERVOIR;
        this.adjacent[9] = MachineRegistry.getMachine((IBlockAccess)world, x + 1, y, z - 1) == MachineRegistry.RESERVOIR;
        this.syncAllData(false);
    }

    public void onAdjacentUpdate(World world, int x, int y, int z, Block b) {
        this.updateSides(world, x, y, z);
    }

    public void onPlaced() {
        this.updateNeighbors();
    }

    public void breakBlock() {
        this.updateNeighbors();
    }

    private void updateNeighbors() {
        for (int i = -1; i <= 1; ++i) {
            for (int k = -1; k <= 1; ++k) {
                int dz;
                int dx;
                if (i == 0 && k == 0 || MachineRegistry.getMachine((IBlockAccess)this.field_145850_b, dx = this.field_145851_c + i, this.field_145848_d, dz = this.field_145849_e + k) != this.getMachine()) continue;
                ((TileEntityReservoir)this.field_145850_b.func_147438_o(dx, this.field_145848_d, dz)).updateSides(this.field_145850_b, dx, this.field_145848_d, dz);
            }
        }
    }

    public boolean hasNearbyReservoir(int loc) {
        return this.adjacent[loc];
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        for (ReservoirAPI.TankHandler th : tankHandlers) {
            int amt = th.onTick((TileEntity)this, this.tank.getFluid());
            if (amt <= 0) continue;
            this.tank.removeLiquid(amt);
        }
        this.flowTimer.update();
        if (this.flowTimer.checkCap()) {
            this.transferBetween(world, x, y, z);
        }
        if (!this.isCovered) {
            if (!world.field_72995_K) {
                BiomeGenBase biome = world.func_72807_a(x, z);
                if (world.func_72896_J() && biome.func_76738_d() && world.func_72951_B(x, y + 1, z) && (this.isEmpty() || this.getFluid().equals(FluidRegistry.WATER) && this.getLevel() < 64000)) {
                    this.addLiquid(25, FluidRegistry.WATER);
                }
            }
            if (!this.tank.isEmpty() && this.tank.getActualFluid().getDensity(world, x, y, z) < 0 && this.tank.getActualFluid().isGaseous()) {
                this.tank.removeLiquid(100);
            }
        }
        if (this.tank.getActualFluid() == null || this.getLevel() <= 0) {
            this.tank.empty();
        } else if (this.isCreative) {
            this.tank.addLiquid(64000, this.tank.getActualFluid());
        }
        this.tempTimer.setCap(this.isCovered ? 30 : 20);
        this.tempTimer.update();
        if (!world.field_72995_K && !this.isEmpty() && this.tempTimer.checkCap() && !this.isSurrounded(false)) {
            Fluid f = this.tank.getActualFluid();
            int Tamb = ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z);
            int temp = f.getTemperature(world, x, y, z) - 273;
            int dT = temp - Tamb;
            int r = 2;
            for (int i = -r; i <= r; ++i) {
                for (int j = -r; j <= r; ++j) {
                    for (int k = -r; k <= r; ++k) {
                        double dd = ReikaMathLibrary.py3d((double)i, (double)j, (double)k) + 1.0;
                        int hiT = (int)((double)Tamb + (double)dT / dd / 2.0);
                        ReikaWorldHelper.temperatureEnvironment((World)world, (int)(x + i), (int)(y + j), (int)(z + k), (int)hiT);
                        if (temp <= 2500) continue;
                        ReikaSoundHelper.playSoundAtBlock((World)world, (int)(x + i), (int)(y + j), (int)(z + k), (String)"random.fizz", (float)0.2f, (float)1.0f);
                    }
                }
            }
            if (temp > 2500) {
                world.func_147449_b(x, y, z, (Block)Blocks.field_150356_k);
                world.func_147449_b(x + 1, y, z, (Block)Blocks.field_150356_k);
                world.func_147449_b(x - 1, y, z, (Block)Blocks.field_150356_k);
                world.func_147449_b(x, y, z + 1, (Block)Blocks.field_150356_k);
                world.func_147449_b(x, y, z - 1, (Block)Blocks.field_150356_k);
                ReikaSoundHelper.playSoundAtBlock((World)world, (int)x, (int)y, (int)z, (String)"random.fizz", (float)0.4f, (float)1.0f);
            }
            boolean hot = Tamb >= 300;
            hot = hot || ReikaWorldHelper.checkForAdjMaterial((World)world, (int)x, (int)y, (int)z, (Material)Material.field_151581_o) != null;
            boolean bl = hot = hot || ReikaWorldHelper.checkForAdjMaterial((World)world, (int)x, (int)y, (int)z, (Material)Material.field_151587_i) != null;
            if (hot && ReikaFluidHelper.isFlammable((Fluid)f)) {
                world.func_147468_f(x, y, z);
                world.func_72885_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 4.0f, true, true);
            }
        }
    }

    private boolean isSurrounded(boolean reservoirOnly) {
        return this.adjacent[2] && this.adjacent[4] && this.adjacent[6] && this.adjacent[8] || !reservoirOnly && ReikaWorldHelper.isBlockSurroundedBySolid((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (boolean)false);
    }

    private void transferBetween(World world, int x, int y, int z) {
        if (this.tank.getLevel() < 64000) {
            for (int i = 2; i < 6; ++i) {
                int diff;
                TileEntityReservoir tile;
                int dz;
                int dy;
                int dx;
                ForgeDirection dir = this.dirs[i];
                if (!this.adjacentOnSide(dir) || !this.matchMachine((IBlockAccess)world, dx = x + dir.offsetX, dy = y + dir.offsetY, dz = z + dir.offsetZ) || !this.canMixWith(tile = (TileEntityReservoir)world.func_147438_o(dx, dy, dz)) || (diff = tile.getLevel() - this.getLevel()) <= 1) continue;
                tile.tank.removeLiquid(diff / 2);
                this.tank.addLiquid(diff / 2, tile.getFluid());
            }
        }
    }

    public boolean adjacentOnSide(ForgeDirection dir) {
        switch (dir) {
            case EAST: {
                return this.adjacent[6];
            }
            case NORTH: {
                return this.adjacent[8];
            }
            case SOUTH: {
                return this.adjacent[2];
            }
            case WEST: {
                return this.adjacent[4];
            }
        }
        return false;
    }

    private boolean canMixWith(TileEntityReservoir tile) {
        if (tile.getFluid() == null) {
            return false;
        }
        return this.tank.isEmpty() || this.getFluid().equals(tile.getFluid());
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        this.tank.writeToNBT(NBT);
        NBT.func_74757_a("cover", this.isCovered);
        NBT.func_74757_a("creative", this.isCreative);
        NBT.func_74768_a("sides", ReikaArrayHelper.booleanToBitflags((boolean[])this.adjacent));
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.tank.readFromNBT(NBT);
        this.isCovered = NBT.func_74767_n("cover");
        this.isCreative = NBT.func_74767_n("creative");
        this.adjacent = ReikaArrayHelper.booleanFromBitflags((int)NBT.func_74762_e("sides"), (int)10);
    }

    @Override
    public boolean hasModelTransparency() {
        return true;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.RESERVOIR;
    }

    public int getRedstoneOverride() {
        return (int)(15.0f * this.tank.getFraction());
    }

    @Override
    public boolean canConnectToPipe(MachineRegistry m) {
        return m.isStandardPipe() || m == MachineRegistry.HOSE || m == MachineRegistry.FUELLINE || m == MachineRegistry.VALVE;
    }

    @Override
    public boolean canConnectToPipeOnSide(MachineRegistry p, ForgeDirection side) {
        return this.canConnectToPipe(p);
    }

    @Override
    public void onEMP() {
    }

    public Collection<AxisAlignedBB> getComplexHitbox() {
        ArrayList<AxisAlignedBB> li = new ArrayList<AxisAlignedBB>();
        li.add(AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.0625, (double)1.0));
        if (this.isCovered) {
            li.add(AxisAlignedBB.func_72330_a((double)0.0625, (double)0.875, (double)0.0625, (double)0.9375, (double)0.9375, (double)0.9375));
        }
        if (!this.isConnectedOnSide(ForgeDirection.EAST)) {
            li.add(AxisAlignedBB.func_72330_a((double)0.9375, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0));
        }
        if (!this.isConnectedOnSide(ForgeDirection.WEST)) {
            li.add(AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0625, (double)1.0, (double)1.0));
        }
        if (!this.isConnectedOnSide(ForgeDirection.SOUTH)) {
            li.add(AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.9375, (double)1.0, (double)1.0, (double)1.0));
        }
        if (!this.isConnectedOnSide(ForgeDirection.NORTH)) {
            li.add(AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.0625));
        }
        return li;
    }

    public AxisAlignedBB getHitbox() {
        if (this.isCovered || this.isEdgePiece(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            return ReikaAABBHelper.getBlockAABB((int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e);
        }
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)((double)this.field_145848_d + 0.0625), (double)(this.field_145849_e + 1));
    }

    private boolean isEdgePiece(World world, int x, int y, int z) {
        for (int i = 2; i < 6; ++i) {
            ForgeDirection dir = this.dirs[i];
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            MachineRegistry m = MachineRegistry.getMachine((IBlockAccess)world, dx, dy, dz);
            if (m == MachineRegistry.RESERVOIR) continue;
            return true;
        }
        return false;
    }

    @Override
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (from == ForgeDirection.UP) {
            return 0;
        }
        return this.tank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.canDrain(from, resource.getFluid()) ? this.tank.drain(resource.amount, doDrain) : null;
    }

    @Override
    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (from == ForgeDirection.UP) {
            return null;
        }
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return from != ForgeDirection.UP;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return from != ForgeDirection.UP && ReikaFluidHelper.isFluidDrainableFromTank((Fluid)fluid, (HybridTank)this.tank);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    public boolean canAcceptFluid(Fluid f) {
        return this.tank.isEmpty() || f.equals(this.tank.getActualFluid());
    }

    public int getLevel() {
        return this.tank.getLevel();
    }

    public Fluid getFluid() {
        return this.tank.getActualFluid();
    }

    public void setLevel(int amt, Fluid f) {
        this.tank.setContents(amt, f);
    }

    public void removeLiquid(int amt) {
        this.tank.removeLiquid(amt);
    }

    public void addLiquid(int amt, Fluid f) {
        this.tank.addLiquid(amt, f);
    }

    public boolean isEmpty() {
        return this.tank.isEmpty();
    }

    public FluidStack getContents() {
        return this.tank.getFluid();
    }

    public boolean isConnectedOnSide(ForgeDirection dir) {
        int dx = this.field_145851_c + dir.offsetX;
        int dy = this.field_145848_d + dir.offsetY;
        int dz = this.field_145849_e + dir.offsetZ;
        if (this.adjacentOnSide(dir)) {
            TileEntityReservoir te = (TileEntityReservoir)this.field_145850_b.func_147438_o(dx, dy, dz);
            if (te == null) {
                return false;
            }
            return te.isEmpty() || this.isEmpty() || te.getFluid().equals(this.getFluid());
        }
        return false;
    }

    public void setEmpty() {
        this.tank.empty();
    }

    @Override
    public TileEntityPiping.Flow getFlowForSide(ForgeDirection side) {
        return side == ForgeDirection.DOWN ? TileEntityPiping.Flow.OUTPUT : TileEntityPiping.Flow.INPUT;
    }

    @SideOnly(value=Side.CLIENT)
    public int getFluidRenderColor() {
        FluidStack fs = this.tank.getFluid();
        return fs != null && fs.tag != null && fs.tag.func_74764_b("renderColor") ? fs.tag.func_74762_e("renderColor") : 0xFFFFFF;
    }

    public void applyFluidEffectsToEntity(EntityLivingBase e) {
        if (!this.tank.isEmpty() && !this.isCovered) {
            Fluid f = this.tank.getActualFluid();
            FluidEffect eff = fluidEffects.get(f.getName());
            if (eff != null) {
                eff.applyEffect(e);
            }
            if (f.equals(FluidRegistry.LAVA) || f.getTemperature(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e) > 500) {
                e.func_70097_a(DamageSource.field_76371_c, 4.0f);
                e.func_70015_d(12);
            }
            if (e.func_70027_ad() && ReikaFluidHelper.isFlammable((Fluid)f)) {
                this.delete();
                this.field_145850_b.func_72885_a((Entity)e, e.field_70165_t, e.field_70163_u, e.field_70161_v, 4.0f, true, true);
            }
            if (f.canBePlacedInWorld()) {
                Block b = f.getBlock();
                b.func_149670_a(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, (Entity)e);
            }
        }
    }

    @Override
    public NBTTagCompound getTagsToWriteToStack() {
        NBTTagCompound NBT = new NBTTagCompound();
        NBT.func_74757_a("cover", this.isCovered);
        if (this.isEmpty()) {
            return NBT;
        }
        Fluid f = this.getFluid();
        int level = this.getLevel();
        ReikaNBTHelper.writeFluidToNBT((NBTTagCompound)NBT, (Fluid)f);
        NBT.func_74768_a("lvl", level);
        return NBT;
    }

    @Override
    public void setDataFromItemStackTag(NBTTagCompound NBT) {
        if (NBT == null) {
            this.tank.empty();
            this.isCovered = false;
            return;
        }
        Fluid f = ReikaNBTHelper.getFluidFromNBT((NBTTagCompound)NBT);
        int level = NBT.func_74762_e("lvl");
        this.tank.setContents(level, f);
        this.isCovered = NBT.func_74767_n("cover");
    }

    public void combineDataFromItemStackTag(NBTTagCompound NBT) {
        if (NBT == null) {
            return;
        }
        Fluid f = ReikaNBTHelper.getFluidFromNBT((NBTTagCompound)NBT);
        if (f != this.tank.getActualFluid()) {
            return;
        }
        int level = NBT.func_74762_e("lvl");
        this.tank.setContents(level + this.tank.getLevel(), f);
        this.isCovered = this.isCovered || NBT.func_74767_n("cover");
    }

    @Override
    public ArrayList<String> getDisplayTags(NBTTagCompound nbt) {
        ArrayList<String> li = new ArrayList<String>();
        Fluid f = ReikaNBTHelper.getFluidFromNBT((NBTTagCompound)nbt);
        if (f != null) {
            String fluid = f.getLocalizedName();
            int amt = nbt.func_74762_e("lvl");
            if (amt > 0) {
                String amount = String.format("%d", amt);
                String contents = "Contents: " + amount + " mB of " + fluid;
                li.add(contents);
            }
        }
        if (nbt.func_74767_n("cover")) {
            li.add("Covered");
        }
        return li;
    }

    @Override
    public ArrayList<NBTTagCompound> getCreativeModeVariants() {
        ArrayList<NBTTagCompound> li = new ArrayList<NBTTagCompound>();
        li.add(null);
        for (int i = 0; i < creativeFluids.size(); ++i) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("lvl", 64000);
            ReikaNBTHelper.writeFluidToNBT((NBTTagCompound)nbt, (Fluid)creativeFluids.get(i));
            li.add(nbt);
        }
        return li;
    }

    private static void addCreativeFluid(String name) {
        Fluid f = FluidRegistry.getFluid((String)name);
        if (f != null) {
            creativeFluids.add(f);
        }
    }

    public static void initCreativeFluids() {
        creativeFluids.clear();
        TileEntityReservoir.addCreativeFluid("water");
        TileEntityReservoir.addCreativeFluid("lava");
        TileEntityReservoir.addCreativeFluid("rc lubricant");
        TileEntityReservoir.addCreativeFluid("rc jet fuel");
        TileEntityReservoir.addCreativeFluid("rc ethanol");
        TileEntityReservoir.addCreativeFluid("rc liquid nitrogen");
        TileEntityReservoir.addCreativeFluid("rc ammonia");
        TileEntityReservoir.addCreativeFluid("rc sodium");
        TileEntityReservoir.addCreativeFluid("rc chlorine");
        TileEntityReservoir.addCreativeFluid("rc oxygen");
        TileEntityReservoir.addCreativeFluid("rc co2");
        TileEntityReservoir.addCreativeFluid("heavy water");
        TileEntityReservoir.addCreativeFluid("fuel");
        TileEntityReservoir.addCreativeFluid("oil");
        TileEntityReservoir.addCreativeFluid("ender");
        TileEntityReservoir.addCreativeFluid("redstone");
        TileEntityReservoir.addCreativeFluid("glowstone");
        TileEntityReservoir.addCreativeFluid("pyrotheum");
        TileEntityReservoir.addCreativeFluid("cryotheum");
        TileEntityReservoir.addCreativeFluid("coal");
        TileEntityReservoir.addCreativeFluid("bop.springwater");
        TileEntityReservoir.addCreativeFluid("poison");
        TileEntityReservoir.addCreativeFluid("sewage");
        TileEntityReservoir.addCreativeFluid("potion crystal");
        TileEntityReservoir.addCreativeFluid("chroma");
        fluidEffects.put("rc jet fuel", new PotionFluidEffect(Potion.field_76436_u, 0, 200));
        fluidEffects.put("rc ammonia", new PotionFluidEffect(Potion.field_76436_u, 0, 200));
        fluidEffects.put("ammonia", new PotionFluidEffect(Potion.field_76436_u, 0, 200));
        fluidEffects.put("rc ethanol", new EthanolEffect());
        fluidEffects.put("ethanol", new EthanolEffect());
    }

    public static void addFluidEffect(Fluid f, FluidEffect e) {
        TileEntityReservoir.addFluidEffect(f.getName(), e);
    }

    public static void addFluidEffect(String f, FluidEffect e) {
        FluidEffect g = fluidEffects.get(f);
        if (g != null) {
            RotaryCraft.logger.logError((Object)("Cannot add effect " + e + " for fluid " + f + "; fluid already mapped to " + g));
        } else {
            fluidEffects.put(f, e);
        }
    }

    public static final class WaterEffect
    implements FluidEffect {
        @Override
        public void applyEffect(EntityLivingBase e) {
            e.func_70066_B();
        }
    }

    public static class EthanolEffect
    implements FluidEffect {
        @Override
        public void applyEffect(EntityLivingBase e) {
            PotionEffect eff = e.func_70660_b(Potion.field_76431_k);
            int dura = 1;
            if (eff != null) {
                dura = eff.func_76459_b() + 1;
            }
            if (dura > 600) {
                dura = 600;
            }
            e.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, dura, 3));
        }
    }

    public static final class PotionFluidEffect
    implements FluidEffect {
        public final int duration;
        public final int level;
        public final Potion potion;

        public PotionFluidEffect(Potion p, int l, int d) {
            this.potion = p;
            this.level = l;
            this.duration = d;
        }

        @Override
        public void applyEffect(EntityLivingBase e) {
            e.func_70690_d(new PotionEffect(this.potion.field_76415_H, this.duration, this.level));
        }
    }

    public static interface FluidEffect {
        public void applyEffect(EntityLivingBase var1);
    }
}

