/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Production;

import Reika.DragonAPI.Interfaces.TileEntity.TriggerableAction;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.Libraries.ReikaRecipeHelper;
import Reika.RotaryCraft.API.Event.WorktableCraftEvent;
import Reika.RotaryCraft.API.Interfaces.ChargeableTool;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.WorktableRecipes;
import Reika.RotaryCraft.Base.ItemChargedArmor;
import Reika.RotaryCraft.Base.ItemChargedTool;
import Reika.RotaryCraft.Base.TileEntity.InventoriedRCTileEntity;
import Reika.RotaryCraft.Containers.Machine.ContainerWorktable;
import Reika.RotaryCraft.Items.Tools.Bedrock.ItemBedrockArmor;
import Reika.RotaryCraft.Items.Tools.ItemCraftPattern;
import Reika.RotaryCraft.Items.Tools.ItemJetPack;
import Reika.RotaryCraft.Registry.EngineType;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.RotaryAchievements;
import Reika.RotaryCraft.Registry.SoundRegistry;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public class TileEntityWorktable
extends InventoriedRCTileEntity
implements TriggerableAction {
    public boolean craftable = false;
    private ItemStack toCraft;

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (!world.field_72995_K && this.isReadyToCraft() && this.getTicksExisted() % 4 == 0) {
            this.chargeTools();
            this.makeJetplate();
            this.makeJetPropel();
            this.coolJetpacks();
            this.wingJetpacks();
            this.makeBedjump();
            this.makeHelmetUpgrades();
        }
    }

    protected void onPositiveRedstoneEdge() {
        if (!this.field_145850_b.field_72995_K) {
            if (!this.craft() && this.canUncraft()) {
                this.uncraft();
            }
            this.uncraftJetplate();
        }
    }

    private void makeHelmetUpgrades() {
        int armorslot = ReikaInventoryHelper.locateInInventory((Item)ItemRegistry.BEDHELM.getItemInstance(), (ItemStack[])this.inv);
        if (armorslot == -1) {
            armorslot = ReikaInventoryHelper.locateInInventory((Item)ItemRegistry.BEDREVEAL.getItemInstance(), (ItemStack[])this.inv);
        }
        if (armorslot != -1) {
            for (int i = 0; i < ItemBedrockArmor.HelmetUpgrades.list.length; ++i) {
                int k;
                ItemBedrockArmor.HelmetUpgrades g = ItemBedrockArmor.HelmetUpgrades.list[i];
                if (!g.isAvailable || g.existsOn(this.inv[armorslot])) continue;
                ItemStack[] rec = g.getUpgradeItems();
                boolean flag = false;
                int itemslot = -1;
                if (rec.length == 1) {
                    itemslot = ReikaInventoryHelper.locateInInventory((ItemStack)rec[0], (ItemStack[])this.inv, (boolean)false);
                    flag = itemslot != -1;
                } else if (armorslot == 4) {
                    boolean flag2 = true;
                    for (k = 0; k < rec.length; ++k) {
                        ItemStack is;
                        ItemStack in = this.inv[k >= 4 ? k + 1 : k];
                        if (ReikaItemHelper.matchStacks((ItemStack)in, (ItemStack)(is = rec[k]))) continue;
                        flag2 = false;
                        break;
                    }
                    flag = flag2;
                }
                if (!flag || !ReikaInventoryHelper.isEmptyFrom((IInventory)this, (int)9, (int)17)) continue;
                ItemStack is = this.inv[armorslot].func_77946_l();
                if (itemslot != -1) {
                    this.inv[itemslot] = null;
                    this.inv[armorslot] = null;
                } else {
                    for (k = 0; k < 9; ++k) {
                        ReikaInventoryHelper.decrStack((int)k, (ItemStack[])this.inv);
                    }
                    this.inv[armorslot] = null;
                }
                g.enable(is, true);
                this.inv[9] = is;
            }
        }
    }

    private void coolJetpacks() {
        Item item;
        ItemStack is = this.inv[4];
        if (is != null && (item = is.func_77973_b()) instanceof ItemJetPack) {
            ItemJetPack pack = (ItemJetPack)item;
            if (!ItemJetPack.PackUpgrades.COOLING.existsOn(is)) {
                boolean items = ReikaItemHelper.matchStacks((ItemStack)this.inv[3], (ItemStack)MachineRegistry.COOLINGFIN.getCraftedProduct());
                if (items &= ReikaItemHelper.matchStacks((ItemStack)this.inv[5], (ItemStack)MachineRegistry.COOLINGFIN.getCraftedProduct())) {
                    ReikaInventoryHelper.decrStack((int)3, (ItemStack[])this.inv);
                    ReikaInventoryHelper.decrStack((int)5, (ItemStack[])this.inv);
                    ItemJetPack.PackUpgrades.COOLING.enable(is, true);
                    this.inv[13] = is.func_77946_l();
                    this.inv[4] = null;
                }
            }
        }
    }

    private void makeJetPropel() {
        Item item;
        ItemStack is = this.inv[4];
        if (is != null && (item = is.func_77973_b()) instanceof ItemJetPack) {
            ItemJetPack pack = (ItemJetPack)item;
            if (!ItemJetPack.PackUpgrades.JET.existsOn(is) && ReikaItemHelper.matchStacks((ItemStack)this.inv[7], (ItemStack)EngineType.JET.getCraftedProduct())) {
                ReikaInventoryHelper.decrStack((int)7, (ItemStack[])this.inv);
                ItemJetPack.PackUpgrades.JET.enable(is, true);
                this.inv[13] = is.func_77946_l();
                this.inv[4] = null;
            }
        }
    }

    private void wingJetpacks() {
        Item item;
        ItemStack is = this.inv[4];
        if (is != null && (item = is.func_77973_b()) instanceof ItemJetPack) {
            ItemJetPack pack = (ItemJetPack)item;
            if (!ItemJetPack.PackUpgrades.WING.existsOn(is)) {
                int i;
                ItemStack ingot = pack.getMaterial();
                for (i = 0; i < 3; ++i) {
                    if (ReikaItemHelper.matchStacks((ItemStack)this.inv[i], (ItemStack)ingot)) continue;
                    return;
                }
                for (i = 0; i < 3; ++i) {
                    ReikaInventoryHelper.decrStack((int)i, (ItemStack[])this.inv);
                }
                ItemJetPack.PackUpgrades.WING.enable(is, true);
                this.inv[13] = is.func_77946_l();
                this.inv[4] = null;
            }
        }
    }

    private boolean craft() {
        EntityPlayer ep = this.getPlacer();
        ContainerWorktable cw = new ContainerWorktable(ep, this, this.field_145850_b);
        InventoryCrafting cm = new InventoryCrafting((Container)cw, 3, 3);
        for (int i = 0; i < 9; ++i) {
            cm.func_70299_a(i, this.func_70301_a(i));
        }
        WorktableRecipes.WorktableRecipe wr = WorktableRecipes.getInstance().findMatchingRecipe(cm, this.field_145850_b);
        if (wr != null) {
            this.handleCrafting(wr, ep);
            return true;
        }
        return false;
    }

    public boolean isReadyToCraft() {
        for (int i = 9; i < 18; ++i) {
            if (this.inv[i] == null) continue;
            return false;
        }
        return true;
    }

    public void handleCrafting(WorktableRecipes.WorktableRecipe wr, EntityPlayer ep) {
        if (wr.isRecycling()) {
            ArrayList<ItemStack> li = wr.getRecycling().getSplitOutput();
            int i = 9;
            for (ItemStack is : li) {
                ReikaInventoryHelper.addOrSetStack((ItemStack)is, (ItemStack[])this.inv, (int)i);
                ++i;
            }
            RotaryAchievements.RECYCLE.triggerAchievement(ep);
        } else {
            ItemStack is = wr.getOutput();
            is.func_77980_a(this.field_145850_b, ep, is.field_77994_a);
            ReikaInventoryHelper.addOrSetStack((ItemStack)is, (ItemStack[])this.inv, (int)13);
            MinecraftForge.EVENT_BUS.post((Event)new WorktableCraftEvent((TileEntity)this, ep, true, is));
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack item = this.func_70301_a(i);
            if (item == null) continue;
            ReikaInventoryHelper.decrStack((int)i, (ItemStack[])this.inv);
        }
        SoundRegistry.CRAFT.playSoundAtBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 0.3f, 1.5f);
    }

    private void makeBedjump() {
        int armorslot = ReikaInventoryHelper.locateInInventory((Item)ItemRegistry.BEDBOOTS.getItemInstance(), (ItemStack[])this.inv);
        int jumpslot = ReikaInventoryHelper.locateInInventory((Item)ItemRegistry.JUMP.getItemInstance(), (ItemStack[])this.inv);
        if (jumpslot != -1 && armorslot != -1 && ReikaInventoryHelper.hasNEmptyStacks((ItemStack[])this.inv, (int)17)) {
            ItemStack is;
            this.inv[jumpslot] = null;
            this.inv[armorslot] = null;
            this.inv[9] = is = ItemRegistry.BEDJUMP.getEnchantedStack();
        }
    }

    public boolean canUncraft() {
        boolean can = false;
        for (int i = 0; i < 9; ++i) {
            ItemStack is = this.inv[i];
            if (i == 4) {
                if (is == null || this.isNotUncraftable(is)) {
                    return false;
                }
                IRecipe ir = WorktableRecipes.getInstance().getInputRecipe(is);
                if (ir == null) {
                    return false;
                }
                List[] in = ReikaRecipeHelper.getRecipeArray((IRecipe)ir);
                boolean flag = true;
                for (int k = 0; k < 9; ++k) {
                    if (in[k] == null || in[k].isEmpty() || this.inv[k + 9] == null) continue;
                    if (!ReikaItemHelper.collectionContainsItemStack((Collection)in[k], (ItemStack)this.inv[k + 9])) {
                        flag = false;
                    }
                    if (this.inv[k + 9].field_77994_a < Math.min(this.func_70297_j_(), this.inv[k + 9].func_77976_d())) continue;
                    flag = false;
                }
                can = flag;
                continue;
            }
            if (is == null) continue;
            return false;
        }
        return can;
    }

    private boolean isNotUncraftable(ItemStack is) {
        ItemRegistry ir = ItemRegistry.getEntry(is);
        if (ir != null && (ir.isTool() || ir.isArmor())) {
            return is.func_77960_j() > 0;
        }
        if (is.field_77990_d == null) {
            return false;
        }
        if (is.field_77990_d.func_74762_e("dmg") > 0) {
            return true;
        }
        if (is.field_77990_d.func_74762_e("damage") > 0) {
            return true;
        }
        if (is.field_77990_d.func_74762_e("lube") > 0) {
            return true;
        }
        if (is.field_77990_d.func_74762_e("lvl") > 0) {
            return true;
        }
        if (is.field_77990_d.func_74764_b("ench")) {
            return true;
        }
        if (ir == ItemRegistry.MACHINE) {
            MachineRegistry r = (MachineRegistry)((Object)MachineRegistry.machineList.get(is.func_77960_j()));
            return !r.isUncraftable();
        }
        return false;
    }

    private void uncraft() {
        int i;
        ItemStack is = this.inv[4];
        IRecipe ir = WorktableRecipes.getInstance().getInputRecipe(is);
        List[] in = ReikaRecipeHelper.getRecipeArray((IRecipe)ir);
        for (i = 0; i < ir.func_77571_b().field_77994_a; ++i) {
            ReikaInventoryHelper.decrStack((int)4, (ItemStack[])this.inv);
        }
        for (i = 0; i < 9; ++i) {
            if (in[i] == null || in[i].isEmpty()) continue;
            if (this.inv[i + 9] == null) {
                this.inv[i + 9] = ((ItemStack)in[i].get(0)).func_77946_l();
                if (this.inv[i + 9].func_77960_j() != Short.MAX_VALUE) continue;
                this.inv[i + 9].func_77964_b(0);
                continue;
            }
            ++this.inv[i + 9].field_77994_a;
        }
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.WORKTABLE;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    private void chargeTools() {
        Item toolid;
        int toolslot;
        int coilslot = ReikaInventoryHelper.locateInInventory((Item)ItemRegistry.SPRING.getItemInstance(), (ItemStack[])this.inv);
        if (coilslot == -1) {
            coilslot = ReikaInventoryHelper.locateInInventory((Item)ItemRegistry.STRONGCOIL.getItemInstance(), (ItemStack[])this.inv);
        }
        if ((toolslot = ReikaInventoryHelper.locateInInventory((Item)(toolid = this.getTool()), (ItemStack[])this.inv)) != -1 && coilslot != -1 && ReikaInventoryHelper.hasNEmptyStacks((ItemStack[])this.inv, (int)17)) {
            Item coilid = this.inv[coilslot].func_77973_b();
            int coilmeta = this.inv[coilslot].func_77960_j();
            ItemStack tool = this.inv[toolslot];
            if (toolid instanceof ChargeableTool) {
                int newcoilcharge = ((ChargeableTool)toolid).setCharged(tool, coilmeta, coilid == ItemRegistry.STRONGCOIL.getItemInstance());
                ItemStack newcoil = new ItemStack(coilid, 1, newcoilcharge);
                this.inv[toolslot] = null;
                this.inv[coilslot] = null;
                this.inv[9] = tool.func_77946_l();
                this.inv[10] = newcoil;
            } else {
                NBTTagCompound tag;
                int toolmeta = tool.func_77960_j();
                ItemStack newtool = new ItemStack(toolid, 1, coilmeta);
                newtool.field_77990_d = tag = tool.field_77990_d != null ? (NBTTagCompound)tool.field_77990_d.func_74737_b() : null;
                ItemStack newcoil = new ItemStack(coilid, 1, toolmeta);
                this.inv[toolslot] = null;
                this.inv[coilslot] = null;
                this.inv[9] = newtool;
                this.inv[10] = newcoil;
            }
        }
    }

    private Item getTool() {
        for (int i = 0; i < 9; ++i) {
            ItemStack is = this.inv[i];
            if (is == null || !(is.func_77973_b() instanceof ItemChargedTool) && !(is.func_77973_b() instanceof ItemChargedArmor) && !(is.func_77973_b() instanceof ChargeableTool)) continue;
            return this.inv[i].func_77973_b();
        }
        return null;
    }

    private void makeJetplate() {
        boolean bed = false;
        int plateslot = ReikaInventoryHelper.locateInInventory((Item)ItemRegistry.BEDCHEST.getItemInstance(), (ItemStack[])this.inv);
        if (plateslot == -1) {
            plateslot = ReikaInventoryHelper.locateInInventory((Item)ItemRegistry.STEELCHEST.getItemInstance(), (ItemStack[])this.inv);
        } else {
            bed = true;
        }
        int jetslot = ReikaInventoryHelper.locateInInventory((Item)ItemRegistry.JETPACK.getItemInstance(), (ItemStack[])this.inv);
        if (jetslot != -1 && plateslot != -1 && plateslot < 9 && jetslot < 9 && ReikaInventoryHelper.hasNEmptyStacks((ItemStack[])this.inv, (int)17)) {
            ItemStack is;
            ItemStack jet = this.inv[jetslot];
            NBTTagCompound tag = jet.field_77990_d != null ? (NBTTagCompound)jet.field_77990_d.func_74737_b() : null;
            this.inv[jetslot] = null;
            this.inv[plateslot] = null;
            ItemStack itemStack = is = bed ? ItemRegistry.BEDPACK.getEnchantedStack() : ItemRegistry.STEELPACK.getStackOf();
            if (is.field_77990_d == null) {
                is.field_77990_d = new NBTTagCompound();
            }
            ReikaNBTHelper.combineNBT((NBTTagCompound)is.field_77990_d, (NBTTagCompound)tag);
            this.inv[9] = is;
        }
    }

    private void uncraftJetplate() {
        ItemStack combine = this.inv[4];
        boolean bed = ItemRegistry.BEDPACK.matchItem(combine);
        if (combine != null && (ItemRegistry.BEDPACK.matchItem(combine) || ItemRegistry.STEELPACK.matchItem(combine))) {
            ItemJetPack pack = (ItemJetPack)combine.func_77973_b();
            if (ReikaInventoryHelper.hasNEmptyStacks((ItemStack[])this.inv, (int)18)) {
                ItemStack plate;
                ItemStack jet = ItemRegistry.JETPACK.getStackOf();
                ((ItemJetPack)jet.func_77973_b()).addFluid(jet, pack.getCurrentFluid(combine), pack.getFuel(combine));
                this.inv[4] = null;
                this.inv[9] = plate = bed ? ItemRegistry.BEDCHEST.getEnchantedStack() : ItemRegistry.STEELCHEST.getStackOf();
                this.inv[10] = jet;
            }
        }
    }

    public int func_70302_i_() {
        return 19;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        if (i >= 9) {
            return false;
        }
        return ItemRegistry.CRAFTPATTERN.matchItem(this.inv[18]) ? this.patternMatches(i, itemstack, this.inv[18]) : true;
    }

    private boolean patternMatches(int slot, ItemStack is, ItemStack p) {
        return ItemCraftPattern.getMode(p) == ItemCraftPattern.RecipeMode.WORKTABLE && ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ItemCraftPattern.getItems(p)[slot]);
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return i >= 9 && i != 18;
    }

    public ItemStack getToCraft() {
        if (this.toCraft == null) {
            return null;
        }
        return this.toCraft.func_77946_l();
    }

    public void setToCraft(ItemStack is) {
        this.toCraft = is != null ? is.func_77946_l() : null;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
    }

    @Override
    public void onEMP() {
    }

    public boolean trigger() {
        return this.craft();
    }
}

