/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Production;

import Reika.DragonAPI.Interfaces.TileEntity.InertIInv;
import Reika.DragonAPI.Interfaces.TileEntity.PartialInventory;
import Reika.DragonAPI.Libraries.IO.ReikaRenderHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.FactorizationHandler;
import Reika.RotaryCraft.API.Event.BedrockDigEvent;
import Reika.RotaryCraft.API.Interfaces.SurrogateBedrock;
import Reika.RotaryCraft.Auxiliary.Interfaces.DiscreteFunction;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Base.TileEntity.InventoriedPowerReceiver;
import Reika.RotaryCraft.Registry.BlockRegistry;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.DifficultyEffects;
import Reika.RotaryCraft.Registry.DurationRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.RotaryAchievements;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityBedrockBreaker
extends InventoriedPowerReceiver
implements InertIInv,
DiscreteFunction {
    private ForgeDirection facing;
    private int step = 1;
    private double dropx;
    private double dropy;
    private double dropz;

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        ++this.tickcount;
        this.readPower(false);
        this.getIOSides(world, x, y, z, meta);
        if (this.power >= this.MINPOWER && this.torque >= this.MINTORQUE) {
            int hz;
            int hy;
            int hx;
            Block b;
            int time = this.getOperationTime();
            if (time <= 1) {
                RotaryAchievements.INSTANTBED.triggerAchievement(this.getPlacer());
            }
            if (this.tickcount >= time) {
                this.process(world, x, y, z, meta);
                this.tickcount = 0;
            }
            if ((b = world.func_147439_a(hx = x + this.step * this.facing.offsetX, hy = y + this.step * this.facing.offsetY, hz = z + this.step * this.facing.offsetZ)) != Blocks.field_150350_a) {
                ReikaParticleHelper.CRITICAL.spawnAroundBlock(world, hx, hy, hz, 4);
                ReikaSoundHelper.playStepSound((World)world, (int)hx, (int)hy, (int)hz, (Block)b, (float)(0.5f + rand.nextFloat()), (float)(0.5f * rand.nextFloat()));
            }
        }
    }

    public void process(World world, int x, int y, int z, int metadata) {
        int hz;
        int hy;
        int hx;
        if (this.hasInventorySpace() && this.canBreakAt(world, hx = x + this.step * this.facing.offsetX, hy = y + this.step * this.facing.offsetY, hz = z + this.step * this.facing.offsetZ)) {
            this.grind(world, x, y, z, hx, hy, hz, metadata);
        }
    }

    private boolean canBreakAt(World world, int x, int y, int z) {
        if (y < 0) {
            return false;
        }
        if (y > 255) {
            return false;
        }
        if (y == 0 && !ConfigRegistry.VOIDHOLE.getState()) {
            return false;
        }
        return world.field_72995_K || ReikaPlayerAPI.playerCanBreakAt((WorldServer)((WorldServer)world), (int)x, (int)y, (int)z, (EntityPlayerMP)this.getServerPlacer());
    }

    private boolean processBlock(World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        if (this.isBedrock(world, x, y, z)) {
            return true;
        }
        return b == BlockRegistry.BEDROCKSLICE.getBlockInstance();
    }

    private boolean hasInventorySpace() {
        if (this.inv[0] == null) {
            return true;
        }
        if (!ReikaItemHelper.matchStacks((ItemStack)this.inv[0], (ItemStack)ItemStacks.bedrockdust)) {
            return false;
        }
        return this.inv[0].field_77994_a + DifficultyEffects.BEDROCKDUST.getInt() <= this.inv[0].func_77976_d();
    }

    public void readPower(boolean doublesided) {
        if (!this.getReceptor(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145832_p())) {
            return;
        }
        super.getPower(doublesided);
        this.power = (long)this.omega * (long)this.torque;
    }

    public boolean getReceptor(World world, int x, int y, int z, int metadata) {
        if (y == 0 && !ConfigRegistry.VOIDHOLE.getState()) {
            return false;
        }
        switch (metadata) {
            case 0: {
                this.read = ForgeDirection.WEST;
                break;
            }
            case 1: {
                this.read = ForgeDirection.EAST;
                break;
            }
            case 2: {
                this.read = ForgeDirection.NORTH;
                break;
            }
            case 3: {
                this.read = ForgeDirection.SOUTH;
                break;
            }
            case 4: {
                this.read = ForgeDirection.DOWN;
                break;
            }
            case 5: {
                this.read = ForgeDirection.UP;
            }
        }
        return true;
    }

    public void getIOSides(World world, int x, int y, int z, int metadata) {
        switch (metadata) {
            case 0: {
                this.dropx = (double)x + 0.5;
                this.dropy = (double)y + 1.25;
                this.dropz = (double)z + 0.5;
                this.facing = ForgeDirection.EAST;
                break;
            }
            case 1: {
                this.dropx = (double)x + 0.5;
                this.dropy = (double)y + 1.25;
                this.dropz = (double)z + 0.5;
                this.facing = ForgeDirection.WEST;
                break;
            }
            case 2: {
                this.dropx = (double)x + 0.5;
                this.dropy = (double)y + 1.25;
                this.dropz = (double)z + 0.5;
                this.facing = ForgeDirection.SOUTH;
                break;
            }
            case 3: {
                this.dropx = (double)x + 0.5;
                this.dropy = (double)y + 1.25;
                this.dropz = (double)z + 0.5;
                this.facing = ForgeDirection.NORTH;
                break;
            }
            case 4: {
                this.dropx = (double)x + 0.5;
                this.dropy = (double)y + 1.25;
                this.dropz = (double)z + 0.5;
                this.facing = ForgeDirection.UP;
                break;
            }
            case 5: {
                this.dropx = (double)x + 0.5;
                this.dropy = (double)y - 0.25;
                this.dropz = (double)z + 0.5;
                this.facing = ForgeDirection.DOWN;
            }
        }
    }

    private boolean isBedrock(World world, int x, int y, int z) {
        Block id = world.func_147439_a(x, y, z);
        if (id == Blocks.field_150357_h) {
            return true;
        }
        if (id == FactorizationHandler.getInstance().bedrockID) {
            return true;
        }
        if (id instanceof SurrogateBedrock) {
            return ((SurrogateBedrock)id).isBedrock(world, x, y, z);
        }
        return false;
    }

    public void grind(World world, int mx, int my, int mz, int x, int y, int z, int meta) {
        if (this.processBlock(world, x, y, z)) {
            if (this.isBedrock(world, x, y, z)) {
                world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "dig.stone", 0.5f, rand.nextFloat() * 0.4f + 0.8f);
                world.func_147465_d(x, y, z, BlockRegistry.BEDROCKSLICE.getBlockInstance(), 0, 3);
            } else {
                int rockmetadata = world.func_72805_g(x, y, z);
                if (rockmetadata < 15) {
                    world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "dig.stone", 0.5f, rand.nextFloat() * 0.4f + 0.8f);
                    world.func_72921_c(x, y, z, rockmetadata + 1, 3);
                } else {
                    world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "mob.blaze.hit", 0.5f, rand.nextFloat() * 0.4f + 0.8f);
                    ItemStack is = this.getDrops(world, x, y, z);
                    world.func_147468_f(x, y, z);
                    if (!this.chestCheck(world, x, y, z, is)) {
                        if (this.isInventoryFull()) {
                            ReikaItemHelper.dropItem((World)world, (double)this.dropx, (double)this.dropy, (double)this.dropz, (ItemStack)is);
                        } else {
                            ReikaInventoryHelper.addOrSetStack((ItemStack)is, (ItemStack[])this.inv, (int)0);
                        }
                    }
                    RotaryAchievements.BEDROCKBREAKER.triggerAchievement(this.getPlacer());
                    MinecraftForge.EVENT_BUS.post((Event)new BedrockDigEvent((TileEntity)this, x, y, z));
                    if (!world.field_72995_K) {
                        this.incrementStep(world, mx, my, mz);
                    }
                }
            }
        } else {
            Block b = world.func_147439_a(x, y, z);
            if (b != Blocks.field_150350_a && b.func_149712_f(world, x, y, z) >= 0.0f) {
                ReikaSoundHelper.playBreakSound((World)world, (int)x, (int)y, (int)z, (Block)b);
                if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                    ReikaRenderHelper.spawnDropParticles((World)world, (int)x, (int)y, (int)z, (Block)b, (int)world.func_72805_g(x, y, z));
                }
                world.func_147468_f(x, y, z);
            }
            if (!world.field_72995_K) {
                this.incrementStep(world, mx, my, mz);
            }
        }
    }

    private boolean chestCheck(World world, int x, int y, int z, ItemStack is) {
        if (is == null) {
            return false;
        }
        if (world.field_72995_K) {
            return false;
        }
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = this.dirs[i];
            TileEntity te = this.getAdjacentTileEntity(dir);
            if (!(te instanceof IInventory)) continue;
            boolean flag = true;
            if (te instanceof PartialInventory && !((PartialInventory)te).hasInventory()) {
                flag = false;
            }
            if (!flag || !ReikaInventoryHelper.addToIInv((ItemStack)is, (IInventory)((IInventory)te))) continue;
            return true;
        }
        return false;
    }

    private void incrementStep(World world, int x, int y, int z) {
        int max = this.step + 1;
        for (int i = 1; i < max; ++i) {
            int dx = x + i * this.facing.offsetX;
            int dy = y + i * this.facing.offsetY;
            int dz = z + i * this.facing.offsetZ;
            if (ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)dx, (int)dy, (int)dz)) continue;
            this.step = i;
            return;
        }
        this.step = max;
    }

    public void dropInventory() {
        int meta = this.func_145832_p();
        if (this.inv[0] == null) {
            return;
        }
        EntityItem itementity = new EntityItem(this.field_145850_b, this.dropx, this.dropy, this.dropz, this.inv[0]);
        itementity.field_145804_b = 0;
        itementity.field_70159_w = -0.025 + 0.05 * (double)rand.nextFloat();
        itementity.field_70179_y = -0.025 + 0.05 * (double)rand.nextFloat();
        if (meta != 5) {
            itementity.field_70181_x = 0.1 + 0.2 * (double)rand.nextFloat() + 0.25 * (double)rand.nextFloat() * (double)rand.nextInt(2);
        }
        itementity.field_70133_I = true;
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_72838_d((Entity)itementity);
        }
        this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "random.pop", 0.2f, ((rand.nextFloat() - rand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        this.inv[0] = null;
    }

    private ItemStack getDrops(World world, int x, int y, int z) {
        ItemStack dust = ReikaItemHelper.getSizedItemStack((ItemStack)ItemStacks.bedrockdust, (int)this.getNumberDust(world, x, y, z));
        return dust;
    }

    private int getNumberDust(World world, int x, int y, int z) {
        return DifficultyEffects.BEDROCKDUST.getInt();
    }

    public int getContents() {
        return this.inv[0] != null && ReikaItemHelper.matchStacks((ItemStack)this.inv[0], (ItemStack)ItemStacks.bedrockdust) ? this.inv[0].field_77994_a : 0;
    }

    private void setContents(int num) {
        this.inv[0] = ReikaItemHelper.getSizedItemStack((ItemStack)ItemStacks.bedrockdust, (int)num);
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
        if (!this.isInWorld()) {
            this.phi = 0.0f;
            return;
        }
        if (this.power < this.MINPOWER || this.torque < this.MINTORQUE) {
            return;
        }
        this.phi = (float)((double)this.phi + ReikaMathLibrary.doubpow((double)ReikaMathLibrary.logbase((long)(this.omega + 1), (int)2), (double)1.05));
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.BEDROCKBREAKER;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    public int func_70302_i_() {
        return 1;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        return false;
    }

    public boolean isInventoryFull() {
        if (this.inv[0] == null) {
            return false;
        }
        if (!ReikaItemHelper.matchStacks((ItemStack)ItemStacks.bedrockdust, (ItemStack)this.inv[0])) {
            return true;
        }
        return this.inv[0].field_77994_a >= this.inv[0].func_77976_d();
    }

    @Override
    public void onEMP() {
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return false;
    }

    @Override
    public int getOperationTime() {
        return DurationRegistry.BEDROCK.getOperationTime(this.omega);
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("step", this.step);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.step = NBT.func_74762_e("step");
    }

    public int getStep() {
        return this.step;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }
}

