/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Processing;

import Reika.DragonAPI.Auxiliary.Trackers.ReflectiveFailureTracker;
import Reika.DragonAPI.Interfaces.Registry.ModEntry;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaEnchantmentHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.ModInteract.DeepInteract.ReikaMystcraftHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.IC2Handler;
import Reika.DragonAPI.ModInteract.ItemHandlers.MystCraftHandler;
import Reika.DragonAPI.ModList;
import Reika.RotaryCraft.Auxiliary.Interfaces.ConditionalOperation;
import Reika.RotaryCraft.Auxiliary.Interfaces.EnchantableMachine;
import Reika.RotaryCraft.Auxiliary.Interfaces.MultiOperational;
import Reika.RotaryCraft.Base.TileEntity.InventoriedPowerReceiver;
import Reika.RotaryCraft.Registry.DurationRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.RotaryCraft;
import ic2.api.recipe.Recipes;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class TileEntityDropProcessor
extends InventoriedPowerReceiver
implements ConditionalOperation,
MultiOperational,
EnchantableMachine {
    private static Class lootBagClass;
    private static Method generateBagLoot;
    private final ArrayList<ItemStack> overflow = new ArrayList();
    private HashMap<Enchantment, Integer> enchantments = new HashMap();
    public int dropProcessTime;

    public boolean func_102008_b(int slot, ItemStack is, int side) {
        return slot > 0;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        if (world.field_72995_K) {
            return;
        }
        this.getIOSidesDefault(world, x, y, z, meta);
        this.getPower(false);
        boolean flag1 = false;
        if (this.power >= this.MINPOWER && this.torque >= this.MINTORQUE) {
            int n = this.getNumberConsecutiveOperations();
            for (int i = 0; i < n; ++i) {
                flag1 |= this.doOperation(world, x, y, z, n > 1);
            }
        } else {
            this.dropProcessTime = 0;
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    private boolean doOperation(World world, int x, int y, int z, boolean multiple) {
        if (this.inv[1] == null) {
            if (this.overflow.isEmpty()) {
                if (this.inv[0] != null && this.isValid(this.inv[0])) {
                    ++this.dropProcessTime;
                    if (multiple || this.dropProcessTime >= this.getOperationTime()) {
                        this.dropProcessTime = 0;
                        this.processItem(world, x, y, z);
                    }
                    return true;
                }
                this.dropProcessTime = 0;
                return false;
            }
            this.dropProcessTime = 0;
            this.inv[1] = this.overflow.remove(0);
            return false;
        }
        this.dropProcessTime = 0;
        return false;
    }

    private boolean isValid(ItemStack is) {
        if (ReikaItemHelper.isBlock((ItemStack)is)) {
            return true;
        }
        if (ModList.IC2.isLoaded() && IC2Handler.IC2Stacks.SCRAPBOX.match(is)) {
            return true;
        }
        if (is.func_77973_b().getClass() == lootBagClass) {
            return true;
        }
        return ModList.MYSTCRAFT.isLoaded() && is.func_77973_b() == MystCraftHandler.getInstance().folderID;
    }

    private void processItem(World world, int x, int y, int z) {
        if (ReikaItemHelper.isBlock((ItemStack)this.inv[0])) {
            Block b = Block.func_149634_a((Item)this.inv[0].func_77973_b());
            ArrayList li = b.getDrops(world, x, y, z, this.inv[0].func_77960_j(), this.getEnchantment(Enchantment.field_77346_s));
            if (!(li = ReikaItemHelper.collateItemList((Collection)li)).isEmpty()) {
                this.inv[1] = (ItemStack)li.remove(0);
                this.overflow.addAll(li);
            }
        } else if (ModList.IC2.isLoaded() && IC2Handler.IC2Stacks.SCRAPBOX.match(this.inv[0])) {
            this.inv[1] = Recipes.scrapboxDrops.getDrop(this.inv[0], false);
        } else if (ModList.MYSTCRAFT.isLoaded() && this.inv[0].func_77973_b() == MystCraftHandler.getInstance().folderID) {
            List li = ReikaMystcraftHelper.getPagesInFolder((EntityPlayer)this.getPlacer(), (ItemStack)this.inv[0], (boolean)true);
            if (!li.isEmpty()) {
                this.inv[1] = (ItemStack)li.remove(0);
                this.overflow.addAll(li);
            }
        } else if (this.inv[0].func_77973_b().getClass() == lootBagClass) {
            ArrayList li = new ArrayList();
            int n = 8 + rand.nextInt(5);
            for (int i = 0; i < n; ++i) {
                try {
                    ItemStack is = (ItemStack)generateBagLoot.invoke(null, this.inv[0].func_77960_j(), rand);
                    if (is == null) continue;
                    li.add(is);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.writeError(e);
                }
            }
            if (!(li = ReikaItemHelper.collateItemList(li)).isEmpty()) {
                this.inv[1] = (ItemStack)li.remove(0);
                this.overflow.addAll(li);
            }
        }
        ReikaInventoryHelper.decrStack((int)0, (ItemStack[])this.inv);
    }

    public int func_70302_i_() {
        return 2;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        return this.isValid(is) && slot == 0;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.DROPS;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        for (int i = 0; i < Enchantment.field_77331_b.length; ++i) {
            int lvl;
            if (Enchantment.field_77331_b[i] == null || (lvl = this.getEnchantment(Enchantment.field_77331_b[i])) <= 0) continue;
            NBT.func_74768_a(Enchantment.field_77331_b[i].func_77320_a(), lvl);
        }
        NBTTagList li = new NBTTagList();
        NBT.func_74782_a("extra", (NBTBase)li);
        for (ItemStack is : this.overflow) {
            NBTTagCompound tag = new NBTTagCompound();
            is.func_77955_b(tag);
            li.func_74742_a((NBTBase)tag);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        this.enchantments = new HashMap();
        for (int i = 0; i < Enchantment.field_77331_b.length; ++i) {
            if (Enchantment.field_77331_b[i] == null) continue;
            int lvl = NBT.func_74762_e(Enchantment.field_77331_b[i].func_77320_a());
            this.enchantments.put(Enchantment.field_77331_b[i], lvl);
        }
        NBTTagList li = NBT.func_150295_c("extra", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
        this.overflow.clear();
        for (Object o : li.field_74747_a) {
            NBTTagCompound tag = (NBTTagCompound)o;
            ItemStack is = ItemStack.func_77949_a((NBTTagCompound)tag);
            if (is == null) continue;
            this.overflow.add(is);
        }
    }

    @Override
    public int getOperationTime() {
        return DurationRegistry.DROPS.getOperationTime(this.omega);
    }

    @Override
    public int getNumberConsecutiveOperations() {
        return DurationRegistry.DROPS.getNumberOperations(this.omega);
    }

    @Override
    public boolean areConditionsMet() {
        return this.inv[0] != null && ReikaItemHelper.isBlock((ItemStack)this.inv[0]) && this.inv[1] == null && this.overflow.isEmpty();
    }

    @Override
    public String getOperationalStatus() {
        return this.areConditionsMet() ? "Operational" : "Missing Items/Full Output";
    }

    @Override
    public boolean applyEnchants(ItemStack is) {
        boolean accepted = false;
        if (ReikaEnchantmentHelper.hasEnchantment((Enchantment)Enchantment.field_77346_s, (ItemStack)is)) {
            this.enchantments.put(Enchantment.field_77346_s, ReikaEnchantmentHelper.getEnchantmentLevel((Enchantment)Enchantment.field_77346_s, (ItemStack)is));
            accepted = true;
        }
        if (ReikaEnchantmentHelper.hasEnchantment((Enchantment)Enchantment.field_77342_w, (ItemStack)is)) {
            this.enchantments.put(Enchantment.field_77342_w, ReikaEnchantmentHelper.getEnchantmentLevel((Enchantment)Enchantment.field_77342_w, (ItemStack)is));
            accepted = true;
        }
        if (ReikaEnchantmentHelper.hasEnchantment((Enchantment)Enchantment.field_77349_p, (ItemStack)is)) {
            this.enchantments.put(Enchantment.field_77349_p, ReikaEnchantmentHelper.getEnchantmentLevel((Enchantment)Enchantment.field_77349_p, (ItemStack)is));
            accepted = true;
        }
        return accepted;
    }

    @Override
    public ArrayList<Enchantment> getValidEnchantments() {
        ArrayList<Enchantment> li = new ArrayList<Enchantment>();
        li.add(Enchantment.field_77346_s);
        return li;
    }

    @Override
    public HashMap<Enchantment, Integer> getEnchantments() {
        return this.enchantments;
    }

    @Override
    public boolean hasEnchantment(Enchantment e) {
        return this.getEnchantments().containsKey(e);
    }

    @Override
    public boolean hasEnchantments() {
        for (int i = 0; i < Enchantment.field_77331_b.length; ++i) {
            if (Enchantment.field_77331_b[i] == null || this.getEnchantment(Enchantment.field_77331_b[i]) <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getEnchantment(Enchantment e) {
        if (!this.hasEnchantment(e)) {
            return 0;
        }
        return this.getEnchantments().get(e);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.dropProcessTime = NBT.func_74765_d("CookTime");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74777_a("CookTime", (short)this.dropProcessTime);
    }

    public int getProgressScaled(int par1) {
        return this.dropProcessTime * par1 / 2 / this.getOperationTime();
    }

    public void dropCache() {
        ReikaItemHelper.dropItems((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), this.overflow);
        this.overflow.clear();
    }

    static {
        if (ModList.THAUMCRAFT.isLoaded()) {
            try {
                lootBagClass = Class.forName("thaumcraft.common.items.ItemLootBag");
                Class<?> c = Class.forName("thaumcraft.common.lib.utils.Utils");
                generateBagLoot = c.getMethod("generateLoot", Integer.TYPE, Random.class);
            }
            catch (Exception e) {
                RotaryCraft.logger.logError((Object)"Could not initialize TC loot bag processing:");
                e.printStackTrace();
                ReflectiveFailureTracker.instance.logModReflectiveFailure((ModEntry)ModList.THAUMCRAFT, e);
            }
        }
    }
}

