/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Processing;

import Reika.DragonAPI.Instantiable.Data.Collections.ChancedOutputList;
import Reika.DragonAPI.Instantiable.HybridTank;
import Reika.DragonAPI.Instantiable.TemporaryInventory;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.ReikaFluidHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.RotaryCraft.Auxiliary.Interfaces.ConditionalOperation;
import Reika.RotaryCraft.Auxiliary.Interfaces.MultiOperational;
import Reika.RotaryCraft.Auxiliary.Interfaces.PipeConnector;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipesCentrifuge;
import Reika.RotaryCraft.Base.TileEntity.InventoriedPowerReceiver;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPiping;
import Reika.RotaryCraft.Registry.DurationRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityCentrifuge
extends InventoriedPowerReceiver
implements MultiOperational,
ConditionalOperation,
IFluidHandler,
PipeConnector {
    private int progressTime;
    public static final int CAPACITY = 10000;
    private final HybridTank tank = new HybridTank("centrifuge", 10000);

    public int getProgressScaled(int l) {
        return l * this.progressTime / this.getOperationTime();
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
        this.phi += (float)this.omega;
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.CENTRIFUGE;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.getPowerBelow();
        if (this.power >= this.MINPOWER && this.omega >= this.MINSPEED) {
            int n = this.getNumberConsecutiveOperations();
            for (int i = 0; i < n; ++i) {
                this.doOperation(n > 1);
            }
        } else {
            this.progressTime = 0;
        }
    }

    private void doOperation(boolean multiple) {
        ItemStack in = this.inv[0];
        if (in != null && RecipesCentrifuge.getRecipes().isCentrifugable(in)) {
            ++this.progressTime;
            if (multiple || this.progressTime >= this.getOperationTime()) {
                FluidStack fs;
                ChancedOutputList out = RecipesCentrifuge.getRecipes().getRecipeResult(in);
                Collection items = out.keySet();
                if (this.canMakeAllOf(items) && ((fs = RecipesCentrifuge.getRecipes().getFluidResult(in)) == null || this.tank.canTakeIn(fs))) {
                    for (ItemStack is : items) {
                        double ch;
                        for (ch = (double)out.getNormalizedItemChance(is); ch >= 1.0; ch -= 1.0) {
                            ReikaInventoryHelper.addToIInv((ItemStack)is, (IInventory)this, (boolean)true, (int)1, (int)this.func_70302_i_());
                        }
                        if (!ReikaRandomHelper.doWithChance((double)ch)) continue;
                        ReikaInventoryHelper.addToIInv((ItemStack)is, (IInventory)this, (boolean)true, (int)1, (int)this.func_70302_i_());
                    }
                    if (fs != null) {
                        this.tank.addLiquid(fs.amount, fs.getFluid());
                    }
                    ReikaInventoryHelper.decrStack((int)0, (ItemStack[])this.inv);
                }
                this.progressTime = 0;
            }
        } else {
            this.progressTime = 0;
        }
    }

    private boolean canMakeAllOf(Collection<ItemStack> out) {
        if (out.size() > 9) {
            return ReikaInventoryHelper.isEmptyFrom((IInventory)this, (int)1, (int)9);
        }
        TemporaryInventory temp = new TemporaryInventory(9);
        for (int i = 0; i < 9; ++i) {
            ItemStack in = this.inv[i + 1];
            if (in == null) continue;
            temp.func_70299_a(i, in.func_77946_l());
        }
        for (ItemStack is : out) {
            if (ReikaInventoryHelper.addToIInv((ItemStack)is.func_77946_l(), (IInventory)temp)) continue;
            return false;
        }
        return true;
    }

    public int getLevel() {
        return this.tank.getLevel();
    }

    public Fluid getFluid() {
        return this.tank.getActualFluid();
    }

    public int getRedstoneOverride() {
        return 0;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return i != 0;
    }

    public int func_70302_i_() {
        return 10;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return i == 0 && RecipesCentrifuge.getRecipes().isCentrifugable(itemstack);
    }

    @Override
    public boolean areConditionsMet() {
        return this.inv[0] != null && RecipesCentrifuge.getRecipes().isCentrifugable(this.inv[0]);
    }

    @Override
    public String getOperationalStatus() {
        return this.areConditionsMet() ? "Operational" : "Missing Items";
    }

    @Override
    public int getOperationTime() {
        return DurationRegistry.CENTRIFUGE.getOperationTime(this.omega);
    }

    @Override
    public int getNumberConsecutiveOperations() {
        return DurationRegistry.CENTRIFUGE.getNumberOperations(this.omega);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.progressTime = NBT.func_74762_e("CookTime");
        this.tank.readFromNBT(NBT);
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("CookTime", this.progressTime);
        this.tank.writeToNBT(NBT);
    }

    @Override
    public boolean canConnectToPipe(MachineRegistry m) {
        return m.isStandardPipe() || m == MachineRegistry.HOSE;
    }

    @Override
    public boolean canConnectToPipeOnSide(MachineRegistry p, ForgeDirection side) {
        return this.canConnectToPipe(p) && side.offsetY == 0;
    }

    @Override
    public TileEntityPiping.Flow getFlowForSide(ForgeDirection side) {
        return side.offsetY == 0 ? TileEntityPiping.Flow.OUTPUT : TileEntityPiping.Flow.NONE;
    }

    @Override
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.canDrain(from, resource.getFluid()) ? this.tank.drain(resource.amount, doDrain) : null;
    }

    @Override
    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.canDrain(from, null) ? this.tank.drain(maxDrain, doDrain) : null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return from.offsetY == 0 && ReikaFluidHelper.isFluidDrainableFromTank((Fluid)fluid, (HybridTank)this.tank);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    public int getLiquidScaled(int a) {
        return a * this.tank.getLevel() / this.tank.getCapacity();
    }

    public int getProgress() {
        return this.progressTime;
    }

    @SideOnly(value=Side.CLIENT)
    public void syncProgress(int time) {
        this.progressTime = time;
    }
}

