/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Piping;

import Reika.RotaryCraft.Auxiliary.Interfaces.PumpablePipe;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPiping;
import Reika.RotaryCraft.Registry.MachineRegistry;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class TileEntityFuelLine
extends TileEntityPiping
implements PumpablePipe {
    private int fuel = 0;
    private Fluid fluid;

    private boolean isAcceptableFuel(Fluid f) {
        if (f.equals(FluidRegistry.getFluid((String)"rc jet fuel"))) {
            return true;
        }
        if (f.equals(FluidRegistry.getFluid((String)"rc ethanol"))) {
            return true;
        }
        if (f.equals(FluidRegistry.getFluid((String)"bioethanol"))) {
            return true;
        }
        if (f.equals(FluidRegistry.getFluid((String)"ethanol"))) {
            return true;
        }
        if (f.equals(FluidRegistry.getFluid((String)"fuel"))) {
            return true;
        }
        if (f.equals(FluidRegistry.getFluid((String)"rocket fuel"))) {
            return true;
        }
        return f.equals(FluidRegistry.getFluid((String)"rc lifbe fuel"));
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.FUELLINE;
    }

    @Override
    public boolean canConnectToPipe(MachineRegistry m) {
        return m == MachineRegistry.FUELLINE || m == MachineRegistry.VALVE || m == MachineRegistry.SEPARATION || m == MachineRegistry.BYPASS || m == MachineRegistry.SUCTION;
    }

    @Override
    public IIcon getBlockIcon() {
        return Blocks.field_150343_Z.func_149691_a(0, 0);
    }

    @Override
    public boolean hasLiquid() {
        return this.fuel > 0;
    }

    @Override
    public Fluid getFluidType() {
        return this.fluid;
    }

    @Override
    public int getFluidLevel() {
        return this.fuel;
    }

    @Override
    protected void setFluid(Fluid f) {
        this.fluid = f;
    }

    @Override
    protected void setLevel(int amt) {
        this.fuel = amt;
    }

    @Override
    protected boolean interactsWithMachines() {
        return true;
    }

    @Override
    protected void onIntake(TileEntity te) {
    }

    @Override
    public boolean isValidFluid(Fluid f) {
        return this.isAcceptableFuel(f);
    }

    @Override
    public boolean canReceiveFromPipeOn(ForgeDirection side) {
        return true;
    }

    @Override
    public boolean canEmitToPipeOn(ForgeDirection side) {
        return true;
    }

    @Override
    public Block getPipeBlockType() {
        return Blocks.field_150343_Z;
    }

    @Override
    public boolean canIntakeFromIFluidHandler(ForgeDirection side) {
        return side.offsetY != 0;
    }

    @Override
    public boolean canOutputToIFluidHandler(ForgeDirection side) {
        return side.offsetY == 0;
    }
}

