/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Farming;

import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Instantiable.Event.BlockTickEvent;
import Reika.DragonAPI.Libraries.Registry.ReikaCropHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.ModCropList;
import Reika.ReactorCraft.Entities.EntityRadiation;
import Reika.RotaryCraft.Base.TileEntity.SprinklerBlock;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.RotaryAchievements;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntitySprinkler
extends SprinklerBlock {
    @Override
    public void performEffects(World world, int x, int y, int z) {
        RotaryAchievements.SPRINKLER.triggerAchievement(this.getPlacer());
        this.spawnParticles(world, x, y, z);
        this.hydrate(world, x, y, z);
        if (ModList.REACTORCRAFT.isLoaded() && rand.nextInt(2400) == 0) {
            this.clearRadiation(world, x, y, z);
        }
    }

    @DependentMethodStripper.ModDependent(value=ModList.REACTORCRAFT)
    private void clearRadiation(World world, int x, int y, int z) {
        int r = this.getRange();
        AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((int)x, (int)y, (int)z).func_72317_d(0.0, -4.0, 0.0).func_72314_b((double)r, 4.0, (double)r);
        List li = world.func_72872_a(EntityRadiation.class, box);
        for (EntityRadiation e : li) {
            e.clean();
            if (!rand.nextBoolean()) continue;
            break;
        }
    }

    public void hydrate(World world, int x, int y, int z) {
        int ytop = y - 1;
        int range = this.getRange();
        for (int i = -range; i <= range; ++i) {
            for (int j = -range; j <= range; ++j) {
                int d;
                if (!world.field_72995_K) {
                    Block foundid;
                    int k;
                    boolean top;
                    if (rand.nextInt(20) == 0) {
                        top = false;
                        for (k = y - 1; k >= 0 && !top; --k) {
                            foundid = world.func_147439_a(x + i, k, z + j);
                            if (foundid == Blocks.field_150480_ab) {
                                world.func_72908_a((double)(x + i) + 0.5, (double)k + 0.5, (double)(z + j) + 0.5, "random.fizz", 0.6f + 0.4f * rand.nextFloat(), 0.5f + 0.5f * rand.nextFloat());
                                world.func_147468_f(x + i, k, z + j);
                            }
                            if (foundid == Blocks.field_150350_a || !foundid.func_149662_c()) continue;
                            top = true;
                            ytop = -1;
                        }
                    }
                    if (rand.nextInt(240) == 0) {
                        top = false;
                        for (k = y - 1; k >= 0 && !top; --k) {
                            foundid = world.func_147439_a(x + i, k, z + j);
                            int meta2 = world.func_72805_g(x + i, k, z + j);
                            if (rand.nextInt(15) == 0) {
                                ReikaCropHelper crop = ReikaCropHelper.getCrop((Block)foundid);
                                ModCropList modcrop = ModCropList.getModCrop((Block)foundid, (int)meta2);
                                if (crop != null && !crop.isRipe(meta2)) {
                                    world.func_72921_c(x + i, k, z + j, meta2 + 1, 3);
                                }
                                if (modcrop != null && !modcrop.isRipe(world, x + i, k, z + j)) {
                                    foundid.func_149674_a(world, x + i, k, z + j, rand);
                                    BlockTickEvent.fire((World)world, (int)(x + i), (int)k, (int)(j + j), (Block)foundid, (int)BlockTickEvent.UpdateFlags.FORCED.flag);
                                    world.func_147471_g(x + i, k, z + j);
                                }
                            }
                            if (foundid == Blocks.field_150458_ak) {
                                top = true;
                                ytop = k;
                            }
                            if (foundid == Blocks.field_150350_a || !foundid.func_149662_c()) continue;
                            top = true;
                            ytop = -1;
                        }
                        if (ytop == -1) {
                            return;
                        }
                        if (world.func_147439_a(x + i, ytop, z + j) == Blocks.field_150458_ak) {
                            ReikaWorldHelper.hydrateFarmland((World)world, (int)(x + i), (int)ytop, (int)(z + j), (boolean)false);
                        }
                    }
                }
                if (world.func_147439_a(x + i, ytop - 2, z + j) != Blocks.field_150458_ak || rand.nextInt(d = Math.max(1, 5 - ConfigRegistry.SPRINKLER.getValue())) != 0) continue;
                world.func_72869_a("splash", (double)(x + i) + 0.5, (double)ytop - 0.875, (double)(z + j) + 0.5, 0.0, 0.0, 0.0);
            }
        }
    }

    public void spawnParticles(World world, int x, int y, int z) {
        int i;
        int d = Math.max(0, ConfigRegistry.SPRINKLER.getValue());
        double ypos = (double)y + 0.125;
        double r = (double)this.getRange() / 10.0;
        double py = (double)y - 0.1875 + 0.5;
        for (i = 0; i < rand.nextInt(1 + d); ++i) {
            double px = (float)(x - 1) + 2.0f * rand.nextFloat();
            double pz = (float)(z - 1) + 2.0f * rand.nextFloat();
            world.func_72869_a("splash", px + 0.5, py, pz + 0.5, 0.0, 0.0, 0.0);
        }
        for (double vel = 0.0; vel < r; vel += 0.1) {
            py = (double)y - 0.1875 + 0.5;
            for (i = 0; i < rand.nextInt(1 + d * 4); ++i) {
                double vx = vel * (double)(-1.0f + rand.nextFloat() * 2.0f);
                double vz = vel * (double)(-1.0f + rand.nextFloat() * 2.0f);
                double px = (float)(x - 1) + 2.0f * rand.nextFloat();
                double pz = (float)(z - 1) + 2.0f * rand.nextFloat();
                world.func_72869_a("splash", px + 0.5, py, pz + 0.5, vx *= 1.05, 0.0, vz *= 1.05);
            }
        }
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.SPRINKLER;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    @Override
    public int getCapacity() {
        return 180;
    }

    @Override
    public int getWaterConsumption() {
        return 3;
    }

    @Override
    public ForgeDirection getPipeDirection() {
        return ForgeDirection.UP;
    }
}

