/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Engine;

import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.World.ReikaRedstoneHelper;
import Reika.RotaryCraft.Auxiliary.Interfaces.MagnetizationCore;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Base.TileEntity.TileEntityEngine;
import Reika.RotaryCraft.Registry.SoundRegistry;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class TileEntityACEngine
extends TileEntityEngine
implements MagnetizationCore {
    private boolean[] lastPower = new boolean[3];

    @Override
    protected void consumeFuel() {
    }

    @Override
    protected void internalizeFuel() {
    }

    @Override
    protected boolean getRequirements(World world, int x, int y, int z, int meta) {
        ItemStack is = this.inv[0];
        if (is == null) {
            return false;
        }
        if (!ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ItemStacks.shaftcore)) {
            return false;
        }
        if (is.field_77990_d == null) {
            return false;
        }
        if (!is.field_77990_d.func_74764_b("magnet")) {
            return false;
        }
        if (is.field_77990_d.func_74762_e("magnet") <= 0) {
            return false;
        }
        boolean ac = ReikaRedstoneHelper.isGettingACRedstone((World)world, (int)x, (int)y, (int)z, (boolean[])this.lastPower);
        if (!world.field_72995_K && ac && this.timer.checkCap("fuel")) {
            int m = is.field_77990_d.func_74762_e("magnet");
            this.magnetize(is, m - 1);
        }
        return ac;
    }

    private void magnetize(ItemStack is, int amt) {
        if (amt > 0) {
            is.field_77990_d.func_74768_a("magnet", amt);
        } else {
            is.field_77990_d.func_82580_o("magnet");
            if (is.field_77990_d.func_82582_d()) {
                is.field_77990_d = null;
            }
        }
    }

    @Override
    protected void playSounds(World world, int x, int y, int z, float pitchMultiplier, float volume) {
        ++this.soundtick;
        if (this.isMuffled(world, x, y, z)) {
            volume *= 0.3125f;
        }
        if (this.soundtick < this.getSoundLength(1.0f / pitchMultiplier) && this.soundtick < 2000) {
            return;
        }
        this.soundtick = 0;
        SoundRegistry.ELECTRIC.playSoundAtBlock(world, x, y, z, 0.125f * volume, 1.0f * pitchMultiplier);
    }

    public void magneticInterference(int mag, double dd) {
        this.torque = (int)(0.0625 * ReikaMathLibrary.logbase((long)mag, (int)2) * (double)this.getEngineType().getTorque() / dd);
        this.omega = (int)(0.0625 * ReikaMathLibrary.logbase((long)mag, (int)2) * (double)this.getEngineType().getSpeed() / dd / 4.0);
        this.power = (long)this.omega * (long)this.torque;
    }

    @Override
    public int getFuelLevel() {
        return 0;
    }

    @Override
    protected void affectSurroundings(World world, int x, int y, int z, int meta) {
    }

    @Override
    public int getCoreMagnetization() {
        return this.inv[0] != null && this.inv[0].field_77990_d != null ? this.inv[0].field_77990_d.func_74762_e("magnet") : 0;
    }
}

