/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Auxiliary;

import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.RotaryCraft.Auxiliary.Interfaces.PipeRenderConnector;
import Reika.RotaryCraft.Auxiliary.Interfaces.PumpablePipe;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPowerReceiver;
import Reika.RotaryCraft.Registry.MachineRegistry;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityPipePump
extends TileEntityPowerReceiver
implements PipeRenderConnector {
    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.PIPEPUMP;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.getSummativeSidedPower();
        this.getIOSidesDefault(world, x, y, z, meta);
        if (this.getTicksExisted() == 0) {
            ReikaWorldHelper.causeAdjacentUpdates((World)world, (int)x, (int)y, (int)z);
        }
        if (this.power >= this.MINPOWER && this.omega >= this.MINSPEED) {
            ForgeDirection dir = this.read.getOpposite();
            ForgeDirection dir2 = dir.getOpposite();
            TileEntity te = this.getAdjacentTileEntity(dir);
            TileEntity te2 = this.getAdjacentTileEntity(dir2);
            if (te instanceof PumpablePipe && te2 instanceof PumpablePipe) {
                PumpablePipe p1 = (PumpablePipe)te;
                PumpablePipe p2 = (PumpablePipe)te2;
                int lvl1 = p1.getFluidLevel();
                int lvl2 = p2.getFluidLevel();
                if (p2.canTransferTo(p1, dir)) {
                    p1.transferFrom(p2, this.getTransferrableAmount(lvl2));
                }
            }
        }
    }

    private int getTransferrableAmount(int amt) {
        return Math.min(amt, this.omega / 4);
    }

    public int getRedstoneOverride() {
        return 0;
    }

    @Override
    public boolean canConnectToPipeOnSide(ForgeDirection dir) {
        return dir == this.read || dir.getOpposite() == this.read;
    }
}

