/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Auxiliary;

import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.RotaryCraft.API.Interfaces.Fillable;
import Reika.RotaryCraft.Auxiliary.Interfaces.ConditionalOperation;
import Reika.RotaryCraft.Base.TileEntity.InventoriedPowerLiquidInOut;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPiping;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityFillingStation
extends InventoriedPowerLiquidInOut
implements ConditionalOperation {
    public static final int CAPACITY = 32000;
    public static final int FUEL_PER_CRYSTAL = 1000;
    public static final int INPUT_SLOT = 3;
    public static final int FUEL_SLOT = 1;
    public static final int OUTPUT_SLOT = 2;
    public static final int FILLING_SLOT = 0;

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.getIOSidesDefault(world, x, y, z, meta);
        this.getPower(false);
        if (this.power < this.MINPOWER) {
            return;
        }
        if (world.field_72995_K) {
            return;
        }
        if (this.canMakeFuel()) {
            this.makeFuel();
        }
        if (this.hasFillable()) {
            if (this.canFill()) {
                this.fill();
            }
        } else {
            ItemStack is = this.inv[3];
            if (is != null && is.func_77973_b() instanceof Fillable) {
                ReikaInventoryHelper.addOrSetStack((ItemStack)ReikaItemHelper.getSizedItemStack((ItemStack)is, (int)1), (ItemStack[])this.inv, (int)0);
                ReikaInventoryHelper.decrStack((int)3, (ItemStack[])this.inv);
            }
        }
    }

    private boolean hasContainer() {
        return this.inv[0] != null && FluidContainerRegistry.isContainer((ItemStack)this.inv[0]);
    }

    private void fillContainer() {
        FluidStack fs;
        int maxadd = this.getFluidToAdd() * 128;
        ItemStack filled = FluidContainerRegistry.fillFluidContainer((FluidStack)new FluidStack(this.tank.getActualFluid(), maxadd), (ItemStack)this.inv[0]);
        if (filled != null && (fs = FluidContainerRegistry.getFluidForFilledItem((ItemStack)filled)) != null && fs.amount > 0) {
            int added = fs.amount;
            this.tank.removeLiquid(added);
            this.inv[0] = filled;
        }
    }

    public boolean canMakeFuel() {
        if (this.inv[1] == null) {
            return false;
        }
        FluidStack fs = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.inv[1]);
        if (fs == null) {
            boolean item = this.inv[1].func_77973_b() == ItemRegistry.ETHANOL.getItemInstance();
            boolean space = this.tank.canTakeIn(1000) && (this.tank.isEmpty() || this.tank.getActualFluid().equals(FluidRegistry.getFluid((String)"rc ethanol")));
            return item && space;
        }
        if (this.tank.isEmpty()) {
            return true;
        }
        return this.tank.canTakeIn(fs.amount) && this.tank.getActualFluid().equals(fs.getFluid());
    }

    public void makeFuel() {
        if (this.inv[1].func_77973_b() == ItemRegistry.ETHANOL.getItemInstance()) {
            this.tank.addLiquid(1000, FluidRegistry.getFluid((String)"rc ethanol"));
            ReikaInventoryHelper.decrStack((int)1, (ItemStack[])this.inv);
            return;
        }
        FluidStack fs = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.inv[1]);
        this.tank.addLiquid(fs.amount, fs.getFluid());
        this.inv[1] = new ItemStack(Items.field_151133_ar);
    }

    private void fill() {
        ItemStack is = this.inv[0];
        Fillable i = (Fillable)is.func_77973_b();
        int added = i.addFluid(is, this.tank.getActualFluid(), this.getFluidToAdd());
        if (added > 0) {
            this.tank.removeLiquid(added);
        }
        if (this.canShuttleItem() && ReikaInventoryHelper.addOrSetStack((ItemStack)is, (ItemStack[])this.inv, (int)2)) {
            this.inv[0] = null;
        }
    }

    private boolean canShuttleItem() {
        ItemStack is = this.inv[0];
        Fillable f = (Fillable)is.func_77973_b();
        ItemStack is2 = this.inv[2];
        if (is2 == null) {
            return f.isFull(is);
        }
        if (!ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)is2)) {
            return false;
        }
        if (!f.isFull(is) || !f.isFull(is2)) {
            return false;
        }
        return is.field_77994_a + is2.field_77994_a <= is.func_77976_d();
    }

    private int getFluidToAdd() {
        int toadd = 4 * (int)ReikaMathLibrary.logbase((long)this.omega, (int)2);
        return Math.min(toadd, this.tank.getLevel());
    }

    private boolean hasFillable() {
        return this.inv[0] != null && this.inv[0].func_77973_b() instanceof Fillable;
    }

    private boolean canFill() {
        if (this.tank.isEmpty()) {
            return false;
        }
        ItemStack is = this.inv[0];
        if (is == null) {
            return false;
        }
        Fillable i = (Fillable)is.func_77973_b();
        int current = i.getCurrentFillLevel(is);
        int max = i.getCapacity(is);
        return i.isValidFluid(this.tank.getActualFluid(), is) && max > current;
    }

    private boolean canIntakeFluid(Fluid f) {
        return this.tank.isEmpty() || this.tank.getActualFluid().equals(f);
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return i == 2;
    }

    public int func_70302_i_() {
        return 4;
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemstack) {
        if (i == 3) {
            return itemstack.func_77973_b() instanceof Fillable;
        }
        if (i == 1) {
            boolean container = FluidContainerRegistry.isFilledContainer((ItemStack)itemstack);
            return container || itemstack.func_77973_b() == ItemRegistry.ETHANOL.getItemInstance();
        }
        return false;
    }

    @Override
    public boolean canConnectToPipe(MachineRegistry m) {
        return m == MachineRegistry.FUELLINE || m.isStandardPipe() || m == MachineRegistry.HOSE;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.FILLINGSTATION;
    }

    @Override
    public boolean hasModelTransparency() {
        return true;
    }

    public int getRedstoneOverride() {
        return this.canFill() ? 0 : 15;
    }

    public Fluid getFluid() {
        return this.tank.getActualFluid();
    }

    public int getLiquidScaled(int i) {
        return this.tank.getLevel() * i / this.tank.getCapacity();
    }

    @Override
    public Fluid getInputFluid() {
        return null;
    }

    @Override
    public boolean canReceiveFrom(ForgeDirection from) {
        return true;
    }

    @Override
    public int getCapacity() {
        return 32000;
    }

    @Override
    public boolean isValidFluid(Fluid f) {
        return true;
    }

    public ItemStack getItemForRender() {
        return this.inv[0] != null ? this.inv[0].func_77946_l() : null;
    }

    @Override
    public boolean areConditionsMet() {
        return !this.tank.isEmpty() && this.inv[0] != null && this.inv[0].func_77973_b() instanceof Fillable;
    }

    @Override
    public String getOperationalStatus() {
        return this.tank.isEmpty() ? "No Liquid" : (this.areConditionsMet() ? "Operational" : "No Fillable Items");
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return from == ForgeDirection.DOWN;
    }

    @Override
    public TileEntityPiping.Flow getFlowForSide(ForgeDirection side) {
        return side == ForgeDirection.DOWN ? TileEntityPiping.Flow.OUTPUT : TileEntityPiping.Flow.INPUT;
    }
}

