/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Auxiliary;

import Reika.DragonAPI.Instantiable.HybridTank;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.DragonAPI.Libraries.ReikaFluidHelper;
import Reika.RotaryCraft.Auxiliary.Interfaces.PipeConnector;
import Reika.RotaryCraft.Base.TileEntity.RotaryCraftTileEntity;
import Reika.RotaryCraft.Base.TileEntity.TileEntityEngine;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPiping;
import Reika.RotaryCraft.ModInterface.TileEntityFuelEngine;
import Reika.RotaryCraft.Registry.EngineType;
import Reika.RotaryCraft.Registry.MachineRegistry;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityEngineController
extends RotaryCraftTileEntity
implements PipeConnector,
IFluidHandler {
    public static final int FUELCAP = 3000;
    private final HybridTank tank = new HybridTank("ecu", 3000);
    public boolean redstoneMode;
    private int redstoneTick = 0;
    private int prevRedstone;
    private EngineSettings setting = EngineSettings.FULL;

    public boolean consumeFuel() {
        return this.setting.fuelFactor != 0;
    }

    public boolean canProducePower() {
        if (this.prevRedstone > 0 && !this.redstoneMode) {
            return false;
        }
        return this.setting.speedFactor != 0;
    }

    public boolean playSound() {
        return this.canProducePower();
    }

    public float getSpeedMultiplier() {
        if (this.canProducePower()) {
            return 1.0f / (float)this.setting.speedFactor;
        }
        return 0.0f;
    }

    public int getSpeedFactor() {
        if (this.canProducePower()) {
            return this.setting.speedFactor;
        }
        return 0;
    }

    public int getFuelMultiplier(EngineType.EngineClass e) {
        int base = this.setting.fuelFactor;
        if (e == EngineType.EngineClass.TURBINE) {
            base /= 8;
        }
        return Math.max(1, base);
    }

    public float getSoundStretch() {
        switch (this.setting) {
            case FULL: {
                return 1.0f;
            }
            case LOW: {
                return 0.6f;
            }
            case MEDIUM: {
                return 0.8f;
            }
            case SHUTDOWN: {
                return 0.0f;
            }
            case STANDBY: {
                return 0.4f;
            }
        }
        return 1.0f;
    }

    public void increment() {
        int l = EngineSettings.list.length;
        int o = this.setting.ordinal();
        if (++o >= l) {
            o = 0;
        }
        this.setting = EngineSettings.list[o];
    }

    public void setSetting(int ordinal) {
        int o = Math.max(0, Math.min(ordinal, EngineSettings.list.length - 1));
        this.setting = EngineSettings.list[o];
    }

    public int getSettingNumber() {
        return this.setting.ordinal();
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        int power;
        if (this.redstoneTick > 0) {
            --this.redstoneTick;
        }
        int n = power = this.redstoneTick == 0 ? world.func_94577_B(x, y, z) : this.prevRedstone;
        if (this.prevRedstone != power) {
            this.redstoneTick = 60;
        }
        this.prevRedstone = power;
        if (this.redstoneMode) {
            EngineSettings engineSettings = this.setting = power == 15 ? EngineSettings.SHUTDOWN : EngineSettings.list[4 - power / 3];
        }
        if (this.tank.isEmpty()) {
            return;
        }
        if (MachineRegistry.getMachine((IBlockAccess)world, x, y + 1, z) == MachineRegistry.ENGINE && this.transferToEngine((TileEntityEngine)world.func_147438_o(x, y + 1, z), false)) {
            return;
        }
        if (MachineRegistry.getMachine((IBlockAccess)world, x, y + 1, z) == MachineRegistry.FUELENGINE && this.transferToFuelEngine((TileEntityFuelEngine)world.func_147438_o(x, y + 1, z), false)) {
            return;
        }
        if (MachineRegistry.getMachine((IBlockAccess)world, x, y - 1, z) == MachineRegistry.ENGINE && this.transferToEngine((TileEntityEngine)world.func_147438_o(x, y - 1, z), true)) {
            return;
        }
        if (MachineRegistry.getMachine((IBlockAccess)world, x, y - 1, z) == MachineRegistry.FUELENGINE && this.transferToFuelEngine((TileEntityFuelEngine)world.func_147438_o(x, y - 1, z), true)) {
            return;
        }
    }

    private boolean transferToFuelEngine(TileEntityFuelEngine te, boolean flip) {
        if (te.isFlipped != flip) {
            return false;
        }
        FluidStack liq = this.tank.getFluid();
        int toadd = Math.min(liq.amount / 4 + 1, 24000 - te.getFuelLevel());
        if (toadd > 0) {
            te.addFuel(toadd);
            this.tank.removeLiquid(toadd);
            return true;
        }
        return false;
    }

    private boolean transferToEngine(TileEntityEngine te, boolean flip) {
        if (te.isFlipped != flip) {
            return false;
        }
        FluidStack liq = this.tank.getFluid();
        Fluid f = te.getEngineType().getFuelType();
        if (f == null || liq == null || !f.equals(liq.getFluid())) {
            return false;
        }
        if (te.getFuelLevel() + liq.amount > 240000) {
            return false;
        }
        te.addFuel(liq.amount / 4 + 1);
        this.tank.removeLiquid(liq.amount / 4 + 1);
        return true;
    }

    private boolean canIntakeFuel(Fluid f) {
        return this.tank.isEmpty() ? f != null : this.tank.getActualFluid().equals(f);
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        this.tank.writeToNBT(NBT);
        NBT.func_74768_a("lvl", this.setting.ordinal());
        NBT.func_74757_a("redstone", this.redstoneMode);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.tank.readFromNBT(NBT);
        this.setting = EngineSettings.list[NBT.func_74762_e("lvl")];
        this.redstoneMode = NBT.func_74767_n("redstone");
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.ECU;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    @Override
    public boolean canConnectToPipe(MachineRegistry m) {
        return m == MachineRegistry.FUELLINE;
    }

    @Override
    public boolean canConnectToPipeOnSide(MachineRegistry p, ForgeDirection side) {
        return true;
    }

    public static EngineSettings[] getSettingList() {
        EngineSettings[] arr = new EngineSettings[EngineSettings.list.length];
        System.arraycopy(EngineSettings.list, 0, arr, 0, arr.length);
        return arr;
    }

    public static String getSettingsAsString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < EngineSettings.list.length; ++i) {
            EngineSettings set = EngineSettings.list[i];
            sb.append(String.format("%s: %.2f%% Speed, %dx Fuel Efficiency", ReikaStringParser.capFirstChar((String)set.name()), set.getSpeedDecimal(), set.getEfficiencyFactor()));
            if (i >= EngineSettings.list.length - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (this.canFill(from, resource.getFluid())) {
            return this.tank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.canDrain(from, resource.getFluid()) ? this.tank.drain(resource.amount, doDrain) : null;
    }

    @Override
    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (fluid.equals(FluidRegistry.getFluid((String)"rc jet fuel"))) {
            return true;
        }
        if (fluid.equals(FluidRegistry.getFluid((String)"rc ethanol"))) {
            return true;
        }
        return fluid.equals(FluidRegistry.getFluid((String)"fuel"));
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return ReikaFluidHelper.isFluidDrainableFromTank((Fluid)fluid, (HybridTank)this.tank);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @Override
    public TileEntityPiping.Flow getFlowForSide(ForgeDirection side) {
        return TileEntityPiping.Flow.DUAL;
    }

    private static enum EngineSettings {
        SHUTDOWN(0, 0),
        STANDBY(16, 64),
        LOW(4, 8),
        MEDIUM(2, 2),
        FULL(1, 1);

        public final int speedFactor;
        public final int fuelFactor;
        public static final EngineSettings[] list;

        private EngineSettings(int speed, int fuel) {
            this.speedFactor = speed;
            this.fuelFactor = fuel;
        }

        public double getSpeedDecimal() {
            if (this == SHUTDOWN) {
                return 0.0;
            }
            return 100.0 / (double)this.speedFactor;
        }

        public int getEfficiencyFactor() {
            if (this == SHUTDOWN) {
                return 0;
            }
            return this.fuelFactor / this.speedFactor;
        }

        static {
            list = EngineSettings.values();
        }
    }
}

