/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Renders;

import Reika.DragonAPI.Interfaces.TileEntity.RenderFetcher;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.IO.ReikaLiquidRenderer;
import Reika.DragonAPI.Libraries.IO.ReikaRenderHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.ModList;
import Reika.RotaryCraft.Auxiliary.IORenderer;
import Reika.RotaryCraft.Base.RotaryTERenderer;
import Reika.RotaryCraft.Base.TileEntity.RotaryCraftTileEntity;
import Reika.RotaryCraft.Models.Animated.ModelGearbox;
import Reika.RotaryCraft.Models.Animated.ModelGearbox16;
import Reika.RotaryCraft.Models.Animated.ModelGearbox4;
import Reika.RotaryCraft.Models.Animated.ModelGearbox8;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityGearbox;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import org.lwjgl.opengl.GL11;

public class RenderGearbox
extends RotaryTERenderer {
    private ModelGearbox GearboxModel = new ModelGearbox();
    private ModelGearbox4 GearboxModel4 = new ModelGearbox4();
    private ModelGearbox8 GearboxModel8 = new ModelGearbox8();
    private ModelGearbox16 GearboxModel16 = new ModelGearbox16();
    private int itemMetadata = 0;
    private static Field manaIcon;

    private static IIcon getManaIcon() {
        IIcon ret = null;
        try {
            ret = (IIcon)manaIcon.get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (ret == null) {
            ret = Blocks.field_150355_j.func_149691_a(0, 0);
        }
        return ret;
    }

    public void renderTileEntityGearboxAt(TileEntityGearbox tile, double par2, double par4, double par6, float par8) {
        if (!tile.isInWorld()) {
            boolean var9 = false;
        } else {
            int var9 = tile.func_145832_p();
        }
        ModelGearbox var14 = this.GearboxModel;
        ModelGearbox4 var15 = this.GearboxModel4;
        ModelGearbox8 var16 = this.GearboxModel8;
        ModelGearbox16 var17 = this.GearboxModel16;
        this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/geartex.png");
        this.setupGL(tile, par2, par4, par6);
        int var11 = 0;
        if (tile.isInWorld()) {
            switch (tile.getGearboxType()) {
                case WOOD: {
                    if (tile.isLiving()) {
                        this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/geartexw_living.png");
                        break;
                    }
                    this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/geartexw.png");
                    break;
                }
                case STONE: {
                    if (tile.isLiving()) {
                        this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/geartexs_living.png");
                        break;
                    }
                    this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/geartexs.png");
                    break;
                }
                case STEEL: {
                    this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/geartex.png");
                    break;
                }
                case DIAMOND: {
                    this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/geartexd.png");
                    break;
                }
                case BEDROCK: {
                    this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/geartexb.png");
                }
            }
            switch (tile.func_145832_p() & 3) {
                case 0: {
                    var11 = 0;
                    break;
                }
                case 1: {
                    var11 = 180;
                    break;
                }
                case 2: {
                    var11 = 90;
                    break;
                }
                case 3: {
                    var11 = 270;
                }
            }
        } else {
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/geartex.png");
            switch (this.itemMetadata) {
                case 1: 
                case 6: 
                case 11: 
                case 16: 
                case 21: {
                    if (tile.isLiving()) {
                        this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/geartexw_living.png");
                        break;
                    }
                    this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/geartexw.png");
                    break;
                }
                case 2: 
                case 7: 
                case 12: 
                case 17: 
                case 22: {
                    if (tile.isLiving()) {
                        this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/geartexs_living.png");
                        break;
                    }
                    this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/geartexs.png");
                    break;
                }
                case 3: 
                case 8: 
                case 13: 
                case 18: 
                case 23: {
                    this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/geartex.png");
                    break;
                }
                case 4: 
                case 9: 
                case 14: 
                case 19: 
                case 24: {
                    this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/geartexd.png");
                    break;
                }
                case 5: 
                case 10: 
                case 15: 
                case 20: 
                case 25: {
                    this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/geartexb.png");
                }
            }
            switch (this.itemMetadata) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    var14.renderAll((TileEntity)tile, null, 0.0f, 0.0f);
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    var15.renderAll((TileEntity)tile, null, 0.0f, 0.0f);
                    break;
                }
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    var16.renderAll((TileEntity)tile, null, 0.0f, 0.0f);
                    break;
                }
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    var17.renderAll((TileEntity)tile, null, 0.0f, 0.0f);
                }
            }
            this.closeGL(tile);
            return;
        }
        GL11.glRotatef((float)var11, (float)0.0f, (float)1.0f, (float)0.0f);
        switch (tile.getRatio()) {
            case 2: {
                var14.renderAll((TileEntity)tile, null, -tile.phi, 0.0f);
                break;
            }
            case 4: {
                var15.renderAll((TileEntity)tile, null, -tile.phi, 0.0f);
                break;
            }
            case 8: {
                var16.renderAll((TileEntity)tile, null, -tile.phi, 0.0f);
                break;
            }
            case 16: {
                var17.renderAll((TileEntity)tile, null, -tile.phi, 0.0f);
            }
        }
        this.closeGL(tile);
    }

    public void func_147500_a(TileEntity tile, double par2, double par4, double par6, float par8) {
        if (par8 <= -999.0f) {
            this.itemMetadata = (int)(-par8) / 1000;
            par8 = 0.0f;
        }
        if (this.doRenderModel((RotaryCraftTileEntity)tile)) {
            this.renderTileEntityGearboxAt((TileEntityGearbox)tile, par2, par4, par6, par8);
        }
        if (((RotaryCraftTileEntity)tile).isInWorld() && MinecraftForgeClient.getRenderPass() == 1) {
            IORenderer.renderIO(tile, par2, par4, par6);
            this.renderLiquid(tile, par2, par4, par6);
        }
        if (!tile.func_145830_o()) {
            this.renderLiquid(tile, par2, par4, par6);
        }
    }

    private void renderMode(TileEntityGearbox tile, double par2, double par4, double par6) {
        ItemStack is = Minecraft.func_71410_x().field_71439_g.func_82169_q(3);
        boolean flag = ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ItemRegistry.IOGOGGLES.getStackOf());
        if (flag) {
            int var11 = 0;
            switch (tile.func_145832_p() & 3) {
                case 0: {
                    var11 = 0;
                    break;
                }
                case 1: {
                    var11 = 180;
                    break;
                }
                case 2: {
                    var11 = 90;
                    break;
                }
                case 3: {
                    var11 = 270;
                }
            }
            GL11.glTranslated((double)par2, (double)par4, (double)par6);
            double sc = 0.1;
            GL11.glScaled((double)sc, (double)sc, (double)sc);
            GL11.glRotatef((float)var11, (float)0.0f, (float)1.0f, (float)0.0f);
            String s = tile.reduction ? "Torque" : "Speed";
            Minecraft.func_71410_x().field_71466_p.func_78276_b(s, 0, 0, 0xFFFFFF);
            GL11.glScaled((double)(1.0 / sc), (double)(1.0 / sc), (double)(1.0 / sc));
            GL11.glTranslated((double)(-par2), (double)(-par4), (double)(-par6));
        }
    }

    private void renderLiquid(TileEntity tile, double par2, double par4, double par6) {
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)1048575);
        GL11.glTranslated((double)par2, (double)par4, (double)par6);
        TileEntityGearbox tr = (TileEntityGearbox)tile;
        if (tr.getLubricant() > 0) {
            Fluid f = FluidRegistry.getFluid((String)"rc lubricant");
            ReikaLiquidRenderer.bindFluidTexture((Fluid)f);
            GL11.glEnable((int)3042);
            IIcon ico = f.getIcon();
            int c = 0xFFFFFF;
            if (tr.isLiving()) {
                ico = this.getManaIcon();
                float t = (float)tr.getTicksExisted() + ReikaRenderHelper.getPartialTickTime();
                c = ReikaColorAPI.getModifiedHue((int)255, (int)(192 + (int)(32.0 * Math.sin((double)t / 16.0))));
            }
            float u = ico.func_94209_e();
            float v = ico.func_94206_g();
            float du = ico.func_94212_f();
            float dv = ico.func_94210_h();
            double h = 0.0625 + 0.25 * (double)tr.getLubricant() / (double)tr.getMaxLubricant() * 0.9;
            if (tr.isFlipped) {
                h = 1.0 - h;
                GL11.glDisable((int)2884);
            }
            Tessellator v5 = Tessellator.field_78398_a;
            v5.func_78382_b();
            v5.func_78378_d(c);
            v5.func_78375_b(0.0f, 1.0f, 0.0f);
            v5.func_78374_a(0.0625, h, 0.9375, (double)u, (double)dv);
            v5.func_78374_a(0.9375, h, 0.9375, (double)du, (double)dv);
            v5.func_78374_a(0.9375, h, 0.0625, (double)du, (double)v);
            v5.func_78374_a(0.0625, h, 0.0625, (double)u, (double)v);
            if (tr.isFlipped) {
                ico = Blocks.field_150359_w.func_149691_a(0, 0);
                u = ico.func_94209_e();
                v = ico.func_94206_g();
                du = ico.func_94212_f();
                dv = ico.func_94210_h();
                double o = 0.005;
                v5.func_78374_a(0.0625, h - o, 0.9375, (double)u, (double)dv);
                v5.func_78374_a(0.9375, h - o, 0.9375, (double)du, (double)dv);
                v5.func_78374_a(0.9375, h - o, 0.0625, (double)du, (double)v);
                v5.func_78374_a(0.0625, h - o, 0.0625, (double)u, (double)v);
            }
            v5.func_78381_a();
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    public String getImageFileName(RenderFetcher te) {
        String name;
        if (te == null) {
            return null;
        }
        TileEntityGearbox tile = (TileEntityGearbox)te;
        if (tile.isInWorld()) {
            switch (tile.getGearboxType()) {
                case WOOD: {
                    name = "geartexw.png";
                    break;
                }
                case STONE: {
                    name = "geartexs.png";
                    break;
                }
                case STEEL: {
                    name = "geartex.png";
                    break;
                }
                case DIAMOND: {
                    name = "geartexd.png";
                    break;
                }
                case BEDROCK: {
                    name = "geartexb.png";
                    break;
                }
                default: {
                    name = null;
                    break;
                }
            }
        } else {
            name = "geartex.png";
            switch (this.itemMetadata) {
                case 1: 
                case 6: 
                case 11: 
                case 16: 
                case 21: {
                    name = "geartexw.png";
                    break;
                }
                case 2: 
                case 7: 
                case 12: 
                case 17: 
                case 22: {
                    name = "geartexs.png";
                    break;
                }
                case 3: 
                case 8: 
                case 13: 
                case 18: 
                case 23: {
                    name = "geartex.png";
                    break;
                }
                case 4: 
                case 9: 
                case 14: 
                case 19: 
                case 24: {
                    name = "geartexd.png";
                    break;
                }
                case 5: 
                case 10: 
                case 15: 
                case 20: 
                case 25: {
                    name = "geartexb.png";
                    break;
                }
                default: {
                    name = null;
                }
            }
        }
        return name;
    }

    static {
        if (ModList.BOTANIA.isLoaded()) {
            try {
                Class<?> c = Class.forName("vazkii.botania.common.block.mana.BlockPool");
                manaIcon = c.getField("manaIcon");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

