/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Registry;

import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Exception.RegistrationException;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.RotaryCraft;

public enum PowerReceivers {
    AEROSOLIZER(16384L),
    AUTOBREEDER(16384L),
    BAITBOX(32768L),
    BEDROCKBREAKER(16384, 1, 0x400000),
    BORER,
    LIGHTBRIDGE(0x2000000L),
    CAVESCANNER(131072L),
    CHUNKLOADER(1, 0x200000, 1),
    COMPACTOR(4096, 1, 262144),
    EXTRACTOR(new int[]{512, 1, 1, 256}, new int[]{1, 2048, 8192, 1}, new long[]{65536L, 16384L, 32768L, 65536L}),
    FAN(1024L),
    FERMENTER(1, 32, 1024),
    FIREWORK(1, 4096, 65536),
    FLOODLIGHT(1024L),
    FORCEFIELD(524288L),
    FRACTIONATOR(1, 8192, 65536),
    FREEZEGUN(256, 1, 262144),
    GPR(32768L),
    GRINDER(128, 1, 4096),
    HEATER(16, 1, 8192),
    HEATRAY(0x200000L),
    IGNITER(1, 1024, 32768),
    REFRESHER(16384L),
    MOBHARVESTER(4096L),
    MOBRADAR(8192L),
    MUSICBOX,
    OBSIDIAN(1, 2048, 32768),
    PILEDRIVER(80000, 1, 16384),
    PLAYERDETECTOR,
    PROJECTOR(512L),
    PULSEJET(1, 131072, 1),
    PUMP(8, 1, 1024),
    RAILGUN(0x400000L),
    SCALECHEST(4096L),
    SONICWEAPON(262144L),
    SPAWNERCONTROLLER(131072L),
    TNTCANNON(65536L),
    VACUUM(16384L),
    WEATHERCONTROLLER(32768L),
    WINDER,
    WOODCUTTER(64, 1, 16384),
    MAGNETIZER(1, 2048, 16384),
    CONTAINMENT(131072L),
    SCREEN(4, 1, 1024),
    PURIFIER(64, 1, 16384),
    LASERGUN(0x800000L),
    ITEMCANNON(128, 1, 32768),
    FRICTION(32, 1, 8192),
    BLOCKCANNON(65536L),
    BUCKETFILLER(1, 512, 2048),
    SELFDESTRUCT,
    COMPRESSOR,
    EMP(0x10000000L),
    LINEBUILDER(1024, 1, 131072),
    TERRAFORMER(1024L),
    FUELENHANCER(1, 16384, 16384),
    ARROWGUN(1024L),
    BOILER,
    FERTILIZER(1024L),
    LAVAMAKER,
    GENERATOR,
    AGGREGATOR(1, 4096, 8192),
    AIRGUN(512, 1, 16384),
    SONICBORER(4096, 1, 65536),
    SORTING(1024L),
    FILLINGSTATION(1024L),
    BELT,
    VANDEGRAFF,
    DEFOLIATOR(16384L),
    BIGFURNACE(2048L),
    DISTILLER,
    HYDRAULIC,
    DYNAMO,
    CRYSTALLIZER(1, 1024, 2048),
    BUSCONTROLLER,
    GRINDSTONE(256, 1, 16384),
    BLOWER(1, 256, 1024),
    PORTALSHAFT,
    REFRIGERATOR(2048, 1, 32768),
    GASTANK(1024, 1, 16384),
    CRAFTER(1024L),
    ANTIAIR(1024, 1, 65536),
    PIPEPUMP(1, 4096, 4096),
    CHAIN,
    CENTRIFUGE(1, 4096, 16384),
    WETTER(1, 1024, 4096),
    DROPS(32, 1, 1024),
    ITEMFILTER(1024L),
    SPILLER(1024L),
    FILLER(1024L);

    private final int minT;
    private final int minS;
    private final long minP;
    private final long[] powers;
    private final int[] torques;
    private final int[] speeds;
    public static final PowerReceivers[] list;

    private PowerReceivers(int T, int S, int P) {
        this.minT = T;
        this.minS = S;
        this.minP = P;
        this.powers = null;
        this.torques = null;
        this.speeds = null;
    }

    private PowerReceivers() {
        this.minT = 1;
        this.minS = 1;
        this.minP = 1L;
        this.powers = null;
        this.torques = null;
        this.speeds = null;
    }

    private PowerReceivers(long P) {
        this.minT = 1;
        this.minS = 1;
        this.minP = P;
        this.powers = null;
        this.torques = null;
        this.speeds = null;
    }

    private PowerReceivers(int[] T, int[] S, long[] P) {
        this.torques = new int[T.length];
        this.speeds = new int[S.length];
        this.powers = new long[P.length];
        for (int i = 0; i < T.length; ++i) {
            this.torques[i] = T[i];
            this.speeds[i] = S[i];
            this.powers[i] = P[i];
        }
        this.minT = -1;
        this.minS = -1;
        this.minP = -1L;
    }

    public boolean hasMultiValuedPower() {
        return this.minT == -1 || this.minS == -1 || this.minP == -1L;
    }

    public int getMultiValuedPowerTypes() {
        return this.powers.length;
    }

    public int getNumberFaceDirections() {
        return 1;
    }

    public boolean isMetadataDifferentiated() {
        return false;
    }

    public boolean hasNoDirectMinPower() {
        return this.minP == 1L;
    }

    public boolean hasNoDirectMinSpeed() {
        return this.minS == 1;
    }

    public boolean hasNoDirectMinTorque() {
        return this.minT == 1;
    }

    public long getMinPower(int i) {
        if (!this.hasMultiValuedPower()) {
            throw new RuntimeException("Machine " + this.getName() + " cannot access mutlivalued power! Use direct power!");
        }
        return this.powers[i];
    }

    public int getMinTorque(int i) {
        if (!this.hasMultiValuedPower()) {
            throw new RuntimeException("Machine " + this.getName() + " cannot access mutlivalued power! Use direct power!");
        }
        return this.torques[i];
    }

    public int getMinSpeed(int i) {
        if (!this.hasMultiValuedPower()) {
            throw new RuntimeException("Machine " + this.getName() + " cannot access mutlivalued power! Use direct power!");
        }
        return this.speeds[i];
    }

    public int getMinTorque() {
        if (this.hasMultiValuedPower()) {
            throw new RuntimeException("Machine " + this.getName() + " cannot access Direct Power! Use multivalued power!");
        }
        return this.minT;
    }

    public int getMinSpeed() {
        if (this.hasMultiValuedPower()) {
            throw new RuntimeException("Machine " + this.getName() + " cannot access Direct Power! Use multivalued power!");
        }
        return this.minS;
    }

    public long getMinPower() {
        if (this.hasMultiValuedPower()) {
            throw new RuntimeException("Machine " + this.getName() + " cannot access Direct Power! Use multivalued power!");
        }
        return this.minP;
    }

    public double getMinPowerKW() {
        return (double)this.minP / 1000.0;
    }

    public double getMinPowerMW() {
        return (double)this.minP / 1000000.0;
    }

    public boolean isMinPowerOnly() {
        return this.minP != 1L && this.minS == 1 && this.minT == 1;
    }

    public boolean isMinSpeedOnly() {
        return this.minP == 1L && this.minS != 1 && this.minT == 1;
    }

    public boolean isMinTorqueOnly() {
        return this.minP == 1L && this.minS == 1 && this.minT != 1;
    }

    public static PowerReceivers getEnumFromMachineIndex(int index) {
        return ((MachineRegistry)((Object)MachineRegistry.machineList.get(index))).getPowerReceiverEntry();
    }

    public static PowerReceivers initialize(MachineRegistry m) {
        if (m.isPowerReceiver()) {
            String name = m.getName();
            String em = m.toString();
            if (name == null) {
                throw new RegistrationException((DragonAPIMod)RotaryCraft.instance, (Object)((Object)m) + " does not correspond to an existing machine Enum!");
            }
            for (PowerReceivers e : list) {
                String en = e.toString();
                if (!en.equals(em)) continue;
                return e;
            }
            throw new RegistrationException((DragonAPIMod)RotaryCraft.instance, "This should not happen! Machine " + name + " is a Power Receiver yet has no Power enum! Machine enum: " + em);
        }
        return null;
    }

    public MachineRegistry getMachine() {
        for (int i = 0; i < MachineRegistry.machineList.length; ++i) {
            MachineRegistry m = (MachineRegistry)((Object)MachineRegistry.machineList.get(i));
            if (m.getPowerReceiverEntry() != this) continue;
            return m;
        }
        RotaryCraft.logger.logError((Object)("This should not happen! Power Receiver " + (Object)((Object)this) + " has no machine!"));
        return null;
    }

    public String getName() {
        return this.toString();
    }

    public boolean isTemperatureSensitive() {
        if (this == COMPACTOR) {
            return true;
        }
        if (this == FERMENTER) {
            return true;
        }
        if (this == FREEZEGUN) {
            return true;
        }
        if (this == HEATER) {
            return true;
        }
        if (this == IGNITER) {
            return true;
        }
        if (this == OBSIDIAN) {
            return true;
        }
        if (this == PULSEJET) {
            return true;
        }
        return this == PURIFIER;
    }

    public boolean requiresHot() {
        if (!this.isTemperatureSensitive()) {
            return false;
        }
        if (this == COMPACTOR) {
            return true;
        }
        if (this == PULSEJET) {
            return true;
        }
        if (this == IGNITER) {
            return true;
        }
        return this == PURIFIER;
    }

    public boolean selfHeating() {
        if (!this.isTemperatureSensitive()) {
            return false;
        }
        if (this == PULSEJET) {
            return true;
        }
        return this == IGNITER;
    }

    public boolean waterPiped() {
        if (this == EXTRACTOR) {
            return true;
        }
        if (this == PUMP) {
            return true;
        }
        if (this == PULSEJET) {
            return true;
        }
        return this == OBSIDIAN;
    }

    public boolean isOmniSidedPower() {
        if (this == AEROSOLIZER) {
            return true;
        }
        if (this == BAITBOX) {
            return true;
        }
        if (this == CAVESCANNER) {
            return true;
        }
        if (this == FORCEFIELD) {
            return true;
        }
        if (this == GPR) {
            return true;
        }
        if (this == IGNITER) {
            return true;
        }
        if (this == REFRESHER) {
            return true;
        }
        if (this == MOBHARVESTER) {
            return true;
        }
        if (this == MUSICBOX) {
            return true;
        }
        if (this == SONICWEAPON) {
            return true;
        }
        if (this == TNTCANNON) {
            return true;
        }
        if (this == VACUUM) {
            return true;
        }
        return this == CONTAINMENT;
    }

    public boolean isBottomPower() {
        if (this == AUTOBREEDER) {
            return true;
        }
        if (this == FRACTIONATOR) {
            return true;
        }
        if (this == FREEZEGUN) {
            return true;
        }
        if (this == HEATER) {
            return true;
        }
        if (this == MOBRADAR) {
            return true;
        }
        if (this == OBSIDIAN) {
            return true;
        }
        if (this == PLAYERDETECTOR) {
            return true;
        }
        if (this == PULSEJET) {
            return true;
        }
        if (this == RAILGUN) {
            return true;
        }
        return this == WEATHERCONTROLLER;
    }

    public boolean isTwoSidedPower() {
        if (this == PUMP) {
            return true;
        }
        return this == PILEDRIVER;
    }

    public long getMinPowerForDisplay() {
        long min = -1L;
        if (this.hasNoDirectMinPower()) {
            min = 0L;
        } else if (this.hasMultiValuedPower()) {
            int n = this.getMultiValuedPowerTypes();
            for (int k = 0; k < n; ++k) {
                long t = this.getMinPower(k);
                if (t <= min) continue;
                min = t;
            }
        } else {
            min = this.getMinPower();
        }
        return min;
    }

    public int getMinTorqueForDisplay() {
        int min = -1;
        if (this.hasNoDirectMinTorque()) {
            min = 0;
        } else if (this.hasMultiValuedPower()) {
            int n = this.getMultiValuedPowerTypes();
            for (int k = 0; k < n; ++k) {
                int t = this.getMinTorque(k);
                if (t <= min) continue;
                min = t;
            }
        } else {
            min = this.getMinTorque();
        }
        return min;
    }

    public int getMinSpeedForDisplay() {
        int min = -1;
        if (this.hasNoDirectMinSpeed()) {
            min = 0;
        } else if (this.hasMultiValuedPower()) {
            int n = this.getMultiValuedPowerTypes();
            for (int k = 0; k < n; ++k) {
                int t = this.getMinSpeed(k);
                if (t <= min) continue;
                min = t;
            }
        } else {
            min = this.getMinSpeed();
        }
        return min;
    }

    static {
        list = PowerReceivers.values();
    }
}

