/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Registry;

import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.RotaryCraft.RotaryCraft;

public enum PacketRegistry {
    BORER(0, 3),
    BEVEL(4),
    SPLITTER(6, 7),
    SPAWNER(8),
    DETECTOR(9),
    HEATER(10),
    CVT(12, 14),
    CANNON(15, 18),
    SONIC(19, 20),
    FORCE(21),
    CHEST(22),
    COIL(23, 24),
    MUSIC(25, 32),
    VACUUM(33),
    WINDER(34),
    PROJECTOR(35),
    CONTAINMENT(36),
    ITEMCANNON(37, 39),
    MIRROR(40),
    SAFEPLAYER(41),
    ENGINEBACKFIRE(42),
    MUSICPARTICLE(43),
    REDGEAR(48),
    TERRAFORMER(49),
    PNEUMATIC(50, 52),
    JETPACK(53, 55),
    FERTILIZER(56),
    GRAVELGUN(57),
    SLIDE(58),
    POWERBUS(59, 62),
    PARTICLES(63),
    BLOWER(64, 67),
    DEFOLIATOR(68),
    GPR(69),
    CRAFTER(70, 72),
    POWERSYNC(73),
    AFTERBURN(74),
    CRAFTPATTERNMODE(75),
    FILTERSETTING(76);

    private int min;
    private int max;

    private PacketRegistry(int l, int h) {
        this.min = l;
        this.max = h;
    }

    private PacketRegistry(int id) {
        this.min = id;
        this.max = id;
    }

    public int getMinValue() {
        return this.min;
    }

    public int getMaxValue() {
        return this.max;
    }

    public boolean isLongPacket() {
        return this == SONIC;
    }

    public int getNumberDataInts() {
        if (this == MUSIC) {
            return 4;
        }
        if (this == CANNON) {
            return 2;
        }
        if (this == REDGEAR) {
            return 2;
        }
        if (this == DEFOLIATOR) {
            return 3;
        }
        if (this == POWERSYNC) {
            return 4;
        }
        if (this == CRAFTER) {
            return 2;
        }
        if (this == ENGINEBACKFIRE) {
            return 0;
        }
        if (this == ITEMCANNON) {
            return 4;
        }
        return 1;
    }

    public boolean hasOneID() {
        return this.max == this.min;
    }

    public static PacketRegistry getEnum(int index) {
        for (PacketRegistry e : PacketRegistry.values()) {
            if (!ReikaMathLibrary.isValueInsideBoundsIncl((int)e.getMinValue(), (int)e.getMaxValue(), (int)index)) continue;
            return e;
        }
        RotaryCraft.logger.logError((Object)("Index " + index + " does not correspond to an existing packet classification!"));
        return null;
    }
}

