/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Registry;

import Reika.ChromatiCraft.Auxiliary.Interfaces.NBTTile;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.DragonOptions;
import Reika.DragonAPI.Exception.RegistrationException;
import Reika.DragonAPI.Instantiable.Data.Immutable.ImmutableArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Data.Maps.BlockMap;
import Reika.DragonAPI.Interfaces.Registry.TileEnum;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.PowerTypes;
import Reika.RotaryCraft.Auxiliary.Interfaces.CachedConnection;
import Reika.RotaryCraft.Auxiliary.Interfaces.DamagingContact;
import Reika.RotaryCraft.Auxiliary.Interfaces.EnchantableMachine;
import Reika.RotaryCraft.Auxiliary.Interfaces.FrictionHeatable;
import Reika.RotaryCraft.Auxiliary.Interfaces.MultiOperational;
import Reika.RotaryCraft.Auxiliary.Interfaces.NBTMachine;
import Reika.RotaryCraft.Auxiliary.Interfaces.TemperatureTE;
import Reika.RotaryCraft.Auxiliary.Interfaces.TransmissionReceiver;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipeHandler;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.WorktableRecipes;
import Reika.RotaryCraft.Base.BlockModelledMultiTE;
import Reika.RotaryCraft.Base.TileEntity.EnergyToPowerBase;
import Reika.RotaryCraft.Base.TileEntity.RotaryCraftTileEntity;
import Reika.RotaryCraft.Base.TileEntity.TileEntityAimedCannon;
import Reika.RotaryCraft.Base.TileEntity.TileEntityEngine;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPiping;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPowerReceiver;
import Reika.RotaryCraft.Base.TileEntity.TileEntityTransmissionMachine;
import Reika.RotaryCraft.Blocks.BlockAdvGear;
import Reika.RotaryCraft.Blocks.BlockDMIMachine;
import Reika.RotaryCraft.Blocks.BlockDMMachine;
import Reika.RotaryCraft.Blocks.BlockDMachine;
import Reika.RotaryCraft.Blocks.BlockEngine;
import Reika.RotaryCraft.Blocks.BlockFlywheel;
import Reika.RotaryCraft.Blocks.BlockGPR;
import Reika.RotaryCraft.Blocks.BlockGearbox;
import Reika.RotaryCraft.Blocks.BlockIMachine;
import Reika.RotaryCraft.Blocks.BlockMIMachine;
import Reika.RotaryCraft.Blocks.BlockMMachine;
import Reika.RotaryCraft.Blocks.BlockMachine;
import Reika.RotaryCraft.Blocks.BlockModEngine;
import Reika.RotaryCraft.Blocks.BlockPiping;
import Reika.RotaryCraft.Blocks.BlockShaft;
import Reika.RotaryCraft.Blocks.BlockSolar;
import Reika.RotaryCraft.Blocks.BlockTrans;
import Reika.RotaryCraft.ModInterface.TileEntityAirCompressor;
import Reika.RotaryCraft.ModInterface.TileEntityBoiler;
import Reika.RotaryCraft.ModInterface.TileEntityDynamo;
import Reika.RotaryCraft.ModInterface.TileEntityElectricMotor;
import Reika.RotaryCraft.ModInterface.TileEntityFuelEngine;
import Reika.RotaryCraft.ModInterface.TileEntityGenerator;
import Reika.RotaryCraft.ModInterface.TileEntityMagnetic;
import Reika.RotaryCraft.ModInterface.TileEntityPneumaticEngine;
import Reika.RotaryCraft.ModInterface.TileEntitySteam;
import Reika.RotaryCraft.Registry.BlockRegistry;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.EngineType;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.MaterialRegistry;
import Reika.RotaryCraft.Registry.PowerReceivers;
import Reika.RotaryCraft.RotaryCraft;
import Reika.RotaryCraft.RotaryNames;
import Reika.RotaryCraft.TileEntities.Auxiliary.TileEntityCoolingFin;
import Reika.RotaryCraft.TileEntities.Auxiliary.TileEntityEngineController;
import Reika.RotaryCraft.TileEntities.Auxiliary.TileEntityFillingStation;
import Reika.RotaryCraft.TileEntities.Auxiliary.TileEntityFurnaceHeater;
import Reika.RotaryCraft.TileEntities.Auxiliary.TileEntityHeater;
import Reika.RotaryCraft.TileEntities.Auxiliary.TileEntityMirror;
import Reika.RotaryCraft.TileEntities.Auxiliary.TileEntityPipePump;
import Reika.RotaryCraft.TileEntities.Auxiliary.TileEntityScreen;
import Reika.RotaryCraft.TileEntities.Decorative.TileEntityDisplay;
import Reika.RotaryCraft.TileEntities.Decorative.TileEntityFireworkMachine;
import Reika.RotaryCraft.TileEntities.Decorative.TileEntityMusicBox;
import Reika.RotaryCraft.TileEntities.Decorative.TileEntityParticleEmitter;
import Reika.RotaryCraft.TileEntities.Decorative.TileEntityProjector;
import Reika.RotaryCraft.TileEntities.Farming.TileEntityAutoBreeder;
import Reika.RotaryCraft.TileEntities.Farming.TileEntityBaitBox;
import Reika.RotaryCraft.TileEntities.Farming.TileEntityComposter;
import Reika.RotaryCraft.TileEntities.Farming.TileEntityFan;
import Reika.RotaryCraft.TileEntities.Farming.TileEntityFertilizer;
import Reika.RotaryCraft.TileEntities.Farming.TileEntityGroundHydrator;
import Reika.RotaryCraft.TileEntities.Farming.TileEntityLawnSprinkler;
import Reika.RotaryCraft.TileEntities.Farming.TileEntityMobHarvester;
import Reika.RotaryCraft.TileEntities.Farming.TileEntitySpawnerController;
import Reika.RotaryCraft.TileEntities.Farming.TileEntitySprinkler;
import Reika.RotaryCraft.TileEntities.Farming.TileEntityWoodcutter;
import Reika.RotaryCraft.TileEntities.Piping.TileEntityBedrockPipe;
import Reika.RotaryCraft.TileEntities.Piping.TileEntityBypass;
import Reika.RotaryCraft.TileEntities.Piping.TileEntityFuelLine;
import Reika.RotaryCraft.TileEntities.Piping.TileEntityHose;
import Reika.RotaryCraft.TileEntities.Piping.TileEntityPipe;
import Reika.RotaryCraft.TileEntities.Piping.TileEntitySeparatorPipe;
import Reika.RotaryCraft.TileEntities.Piping.TileEntitySuctionPipe;
import Reika.RotaryCraft.TileEntities.Piping.TileEntityValve;
import Reika.RotaryCraft.TileEntities.Processing.TileEntityAutoCrafter;
import Reika.RotaryCraft.TileEntities.Processing.TileEntityBigFurnace;
import Reika.RotaryCraft.TileEntities.Processing.TileEntityCentrifuge;
import Reika.RotaryCraft.TileEntities.Processing.TileEntityCompactor;
import Reika.RotaryCraft.TileEntities.Processing.TileEntityCrystallizer;
import Reika.RotaryCraft.TileEntities.Processing.TileEntityDistillery;
import Reika.RotaryCraft.TileEntities.Processing.TileEntityDropProcessor;
import Reika.RotaryCraft.TileEntities.Processing.TileEntityDryingBed;
import Reika.RotaryCraft.TileEntities.Processing.TileEntityExtractor;
import Reika.RotaryCraft.TileEntities.Processing.TileEntityFuelConverter;
import Reika.RotaryCraft.TileEntities.Processing.TileEntityGrinder;
import Reika.RotaryCraft.TileEntities.Processing.TileEntityMagnetizer;
import Reika.RotaryCraft.TileEntities.Processing.TileEntityPulseFurnace;
import Reika.RotaryCraft.TileEntities.Processing.TileEntityPurifier;
import Reika.RotaryCraft.TileEntities.Processing.TileEntityWetter;
import Reika.RotaryCraft.TileEntities.Production.TileEntityAggregator;
import Reika.RotaryCraft.TileEntities.Production.TileEntityBedrockBreaker;
import Reika.RotaryCraft.TileEntities.Production.TileEntityBlastFurnace;
import Reika.RotaryCraft.TileEntities.Production.TileEntityBorer;
import Reika.RotaryCraft.TileEntities.Production.TileEntityFermenter;
import Reika.RotaryCraft.TileEntities.Production.TileEntityFractionator;
import Reika.RotaryCraft.TileEntities.Production.TileEntityLavaMaker;
import Reika.RotaryCraft.TileEntities.Production.TileEntityObsidianMaker;
import Reika.RotaryCraft.TileEntities.Production.TileEntityPump;
import Reika.RotaryCraft.TileEntities.Production.TileEntityRefrigerator;
import Reika.RotaryCraft.TileEntities.Production.TileEntitySolar;
import Reika.RotaryCraft.TileEntities.Production.TileEntityWorktable;
import Reika.RotaryCraft.TileEntities.Storage.TileEntityFluidCompressor;
import Reika.RotaryCraft.TileEntities.Storage.TileEntityReservoir;
import Reika.RotaryCraft.TileEntities.Storage.TileEntityScaleableChest;
import Reika.RotaryCraft.TileEntities.Surveying.TileEntityCCTV;
import Reika.RotaryCraft.TileEntities.Surveying.TileEntityCaveFinder;
import Reika.RotaryCraft.TileEntities.Surveying.TileEntityGPR;
import Reika.RotaryCraft.TileEntities.Surveying.TileEntityMobRadar;
import Reika.RotaryCraft.TileEntities.Surveying.TileEntitySpyCam;
import Reika.RotaryCraft.TileEntities.TileEntityBlower;
import Reika.RotaryCraft.TileEntities.TileEntityBucketFiller;
import Reika.RotaryCraft.TileEntities.TileEntityChunkLoader;
import Reika.RotaryCraft.TileEntities.TileEntityGrindstone;
import Reika.RotaryCraft.TileEntities.TileEntityItemCannon;
import Reika.RotaryCraft.TileEntities.TileEntityItemFilter;
import Reika.RotaryCraft.TileEntities.TileEntityItemRefresher;
import Reika.RotaryCraft.TileEntities.TileEntityPlayerDetector;
import Reika.RotaryCraft.TileEntities.TileEntitySmokeDetector;
import Reika.RotaryCraft.TileEntities.TileEntitySorting;
import Reika.RotaryCraft.TileEntities.TileEntityVacuum;
import Reika.RotaryCraft.TileEntities.TileEntityWinder;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityAdvancedGear;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityBeltHub;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityBevelGear;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityBusController;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityChainDrive;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityClutch;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityFlywheel;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityGearbox;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityMonitor;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityMultiClutch;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityPortalShaft;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityPowerBus;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityShaft;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntitySplitter;
import Reika.RotaryCraft.TileEntities.Weaponry.TileEntityAAGun;
import Reika.RotaryCraft.TileEntities.Weaponry.TileEntityAirGun;
import Reika.RotaryCraft.TileEntities.Weaponry.TileEntityBlockCannon;
import Reika.RotaryCraft.TileEntities.Weaponry.TileEntityContainment;
import Reika.RotaryCraft.TileEntities.Weaponry.TileEntityEMP;
import Reika.RotaryCraft.TileEntities.Weaponry.TileEntityForceField;
import Reika.RotaryCraft.TileEntities.Weaponry.TileEntityFreezeGun;
import Reika.RotaryCraft.TileEntities.Weaponry.TileEntityHeatRay;
import Reika.RotaryCraft.TileEntities.Weaponry.TileEntityLandmine;
import Reika.RotaryCraft.TileEntities.Weaponry.TileEntityLaserGun;
import Reika.RotaryCraft.TileEntities.Weaponry.TileEntityMachineGun;
import Reika.RotaryCraft.TileEntities.Weaponry.TileEntityRailGun;
import Reika.RotaryCraft.TileEntities.Weaponry.TileEntitySelfDestruct;
import Reika.RotaryCraft.TileEntities.Weaponry.TileEntitySonicWeapon;
import Reika.RotaryCraft.TileEntities.Weaponry.TileEntityTNTCannon;
import Reika.RotaryCraft.TileEntities.Weaponry.TileEntityVanDeGraff;
import Reika.RotaryCraft.TileEntities.World.TileEntityAerosolizer;
import Reika.RotaryCraft.TileEntities.World.TileEntityBeamMirror;
import Reika.RotaryCraft.TileEntities.World.TileEntityBlockFiller;
import Reika.RotaryCraft.TileEntities.World.TileEntityDefoliator;
import Reika.RotaryCraft.TileEntities.World.TileEntityFlooder;
import Reika.RotaryCraft.TileEntities.World.TileEntityFloodlight;
import Reika.RotaryCraft.TileEntities.World.TileEntityIgniter;
import Reika.RotaryCraft.TileEntities.World.TileEntityLamp;
import Reika.RotaryCraft.TileEntities.World.TileEntityLightBridge;
import Reika.RotaryCraft.TileEntities.World.TileEntityLineBuilder;
import Reika.RotaryCraft.TileEntities.World.TileEntityPileDriver;
import Reika.RotaryCraft.TileEntities.World.TileEntitySonicBorer;
import Reika.RotaryCraft.TileEntities.World.TileEntityTerraformer;
import Reika.RotaryCraft.TileEntities.World.TileEntityWeatherController;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.oredict.ShapedOreRecipe;

public enum MachineRegistry implements TileEnum
{
    BEDROCKBREAKER("machine.bedrock", BlockDMMachine.class, TileEntityBedrockBreaker.class, 0, "RenderBedrockBreaker"),
    ENGINE("machine.engine", BlockEngine.class, TileEntityEngine.class, 0, "RenderSEngine"),
    FLYWHEEL("machine.flywheel", BlockFlywheel.class, TileEntityFlywheel.class, 0, "RenderFlywheel"),
    SHAFT("machine.shaft", BlockShaft.class, TileEntityShaft.class, 0, "RenderShaft"),
    BEVELGEARS("machine.bevel", BlockTrans.class, TileEntityBevelGear.class, 0, "RenderBevel"),
    GEARBOX("machine.gearbox", BlockGearbox.class, TileEntityGearbox.class, 0, "RenderGearbox"),
    SPLITTER("machine.splitter", BlockTrans.class, TileEntitySplitter.class, 1, "RenderSplitter"),
    FERMENTER("machine.fermenter", BlockIMachine.class, TileEntityFermenter.class, 0),
    FLOODLIGHT("machine.floodlight", BlockDMMachine.class, TileEntityFloodlight.class, 1, "RenderLamp"),
    CLUTCH("machine.clutch", BlockTrans.class, TileEntityClutch.class, 2, "RenderClutch"),
    DYNAMOMETER("machine.dyna", BlockTrans.class, TileEntityMonitor.class, 3, "RenderMonitor"),
    GRINDER("machine.grinder", BlockDMIMachine.class, TileEntityGrinder.class, 0, "RenderGrinder"),
    HEATRAY("machine.heatray", BlockDMMachine.class, TileEntityHeatRay.class, 2, "RenderHRay"),
    HOSE("machine.hose", BlockPiping.class, TileEntityHose.class, 0, "PipeRenderer"),
    BORER("machine.borer", BlockDMachine.class, TileEntityBorer.class, 0),
    LIGHTBRIDGE("machine.lightbridge", BlockDMMachine.class, TileEntityLightBridge.class, 3, "RenderBridge"),
    PUMP("machine.pump", BlockDMMachine.class, TileEntityPump.class, 4, "RenderPump"),
    PIPE("machine.pipe", BlockPiping.class, TileEntityPipe.class, 1, "PipeRenderer"),
    RESERVOIR("machine.reservoir", BlockMMachine.class, TileEntityReservoir.class, 0, "RenderReservoir"),
    AEROSOLIZER("machine.aerosolizer", BlockMIMachine.class, TileEntityAerosolizer.class, 0, "RenderAerosolizer"),
    EXTRACTOR("machine.extractor", BlockMIMachine.class, TileEntityExtractor.class, 1, "RenderExtractor"),
    PULSEJET("machine.pulsejet", BlockMIMachine.class, TileEntityPulseFurnace.class, 2, "RenderPulseFurnace"),
    COMPACTOR("machine.compactor", BlockDMIMachine.class, TileEntityCompactor.class, 1, "RenderCompactor"),
    FAN("machine.fan", BlockDMMachine.class, TileEntityFan.class, 5, "RenderFan"),
    FUELLINE("machine.fuelline", BlockPiping.class, TileEntityFuelLine.class, 2, "PipeRenderer"),
    FRACTIONATOR("machine.fractionator", BlockMIMachine.class, TileEntityFractionator.class, 3, "RenderFraction"),
    GPR("machine.gpr", BlockGPR.class, TileEntityGPR.class, 0),
    OBSIDIAN("machine.obsidian", BlockMIMachine.class, TileEntityObsidianMaker.class, 4, "RenderObsidian"),
    PILEDRIVER("machine.piledriver", BlockDMMachine.class, TileEntityPileDriver.class, 6, "RenderPileDriver"),
    VACUUM("machine.vacuum", BlockMIMachine.class, TileEntityVacuum.class, 5, "RenderVacuum"),
    FIREWORK("machine.firework", BlockIMachine.class, TileEntityFireworkMachine.class, 1),
    SPRINKLER("machine.sprinkler", BlockMMachine.class, TileEntitySprinkler.class, 1, "RenderSprinkler"),
    WOODCUTTER("machine.woodcutter", BlockDMMachine.class, TileEntityWoodcutter.class, 7, "RenderWoodcutter"),
    SPAWNERCONTROLLER("machine.spawnercontroller", BlockMMachine.class, TileEntitySpawnerController.class, 2, "RenderSpawner"),
    PLAYERDETECTOR("machine.playerdetector", BlockMMachine.class, TileEntityPlayerDetector.class, 3, "RenderDetector"),
    HEATER("machine.heater", BlockMIMachine.class, TileEntityHeater.class, 6, "RenderHeater"),
    BAITBOX("machine.baitbox", BlockMIMachine.class, TileEntityBaitBox.class, 7, "RenderBaitBox"),
    AUTOBREEDER("machine.breeder", BlockMIMachine.class, TileEntityAutoBreeder.class, 8, "RenderBreeder"),
    ECU("machine.ecu", BlockMachine.class, TileEntityEngineController.class, 0),
    SMOKEDETECTOR("machine.smokedetector", BlockMIMachine.class, TileEntitySmokeDetector.class, 9, "RenderSmokeDetector"),
    MOBRADAR("machine.mobradar", BlockMMachine.class, TileEntityMobRadar.class, 4, "RenderMobRadar"),
    WINDER("machine.winder", BlockDMIMachine.class, TileEntityWinder.class, 2, "RenderWinder"),
    ADVANCEDGEARS("machine.advgear", BlockAdvGear.class, TileEntityAdvancedGear.class, 0, "RenderAdvGear"),
    TNTCANNON("machine.tntcannon", BlockMIMachine.class, TileEntityTNTCannon.class, 10, "RenderCannon"),
    SONICWEAPON("machine.sonicweapon", BlockMMachine.class, TileEntitySonicWeapon.class, 5, "RenderSonic"),
    BLASTFURNACE("machine.blastfurnace", BlockIMachine.class, TileEntityBlastFurnace.class, 2),
    FORCEFIELD("machine.forcefield", BlockMMachine.class, TileEntityForceField.class, 6, "RenderForceField"),
    MUSICBOX("machine.musicbox", BlockMachine.class, TileEntityMusicBox.class, 1),
    SPILLER("machine.spiller", BlockMachine.class, TileEntityFlooder.class, 8),
    CHUNKLOADER("machine.chunkloader", BlockMMachine.class, TileEntityChunkLoader.class, 7, "RenderChunkLoader"),
    MOBHARVESTER("machine.mobharvester", BlockMMachine.class, TileEntityMobHarvester.class, 8, "RenderHarvester"),
    CCTV("machine.cctv", BlockMIMachine.class, TileEntityCCTV.class, 11, "RenderCCTV"),
    PROJECTOR("machine.projector", BlockDMIMachine.class, TileEntityProjector.class, 3, "RenderProjector"),
    RAILGUN("machine.railgun", BlockMIMachine.class, TileEntityRailGun.class, 12, "RenderRailGun"),
    WEATHERCONTROLLER("machine.weather", BlockMIMachine.class, TileEntityWeatherController.class, 13, "RenderIodide"),
    REFRESHER("machine.refresher", BlockMachine.class, TileEntityItemRefresher.class, 2),
    FREEZEGUN("machine.freezegun", BlockMIMachine.class, TileEntityFreezeGun.class, 14, "RenderFreezeGun"),
    CAVESCANNER("machine.cavescanner", BlockMMachine.class, TileEntityCaveFinder.class, 9, "RenderCaveFinder"),
    SCALECHEST("machine.chest", BlockDMIMachine.class, TileEntityScaleableChest.class, 4, "RenderScaleChest"),
    IGNITER("machine.firestarter", BlockIMachine.class, TileEntityIgniter.class, 3),
    MAGNETIZER("machine.magnetizer", BlockDMIMachine.class, TileEntityMagnetizer.class, 5, "RenderMagnetizer"),
    CONTAINMENT("machine.containment", BlockMMachine.class, TileEntityContainment.class, 10, "RenderProtectionDome"),
    SCREEN("machine.screen", BlockDMIMachine.class, TileEntityScreen.class, 6, "RenderCCTVScreen"),
    PURIFIER("machine.purifier", BlockIMachine.class, TileEntityPurifier.class, 4),
    LASERGUN("machine.lasergun", BlockMMachine.class, TileEntityLaserGun.class, 11, "RenderLaserGun"),
    ITEMCANNON("machine.itemcannon", BlockMIMachine.class, TileEntityItemCannon.class, 15, "RenderItemCannon"),
    LANDMINE("machine.landmine", BlockMIMachine.class, TileEntityLandmine.class, 16, "RenderLandmine"),
    FRICTION("machine.friction", BlockDMMachine.class, TileEntityFurnaceHeater.class, 8, "RenderFriction"),
    BLOCKCANNON("machine.blockcannon", BlockMIMachine.class, TileEntityBlockCannon.class, 17, "RenderCannon"),
    BUCKETFILLER("machine.bucketfiller", BlockIMachine.class, TileEntityBucketFiller.class, 5),
    MIRROR("machine.mirror", BlockSolar.class, TileEntityMirror.class, 0, "RenderMirror"),
    SOLARTOWER("machine.solartower", BlockSolar.class, TileEntitySolar.class, 1, "RenderSolar"),
    SPYCAM("machine.spycam", BlockMIMachine.class, TileEntitySpyCam.class, 18, "RenderSpyCam"),
    SELFDESTRUCT("machine.selfdestruct", BlockMachine.class, TileEntitySelfDestruct.class, 3),
    COOLINGFIN("machine.coolingfin", BlockDMMachine.class, TileEntityCoolingFin.class, 9, "RenderFin"),
    WORKTABLE("machine.worktable", BlockIMachine.class, TileEntityWorktable.class, 6),
    COMPRESSOR("machine.compressor", BlockModEngine.class, TileEntityAirCompressor.class, 0, "RenderCompressor", PowerTypes.PNEUMATIC),
    PNEUENGINE("machine.pneuengine", BlockModEngine.class, TileEntityPneumaticEngine.class, 1, "RenderPneumatic", PowerTypes.PNEUMATIC),
    DISPLAY("machine.display", BlockMMachine.class, TileEntityDisplay.class, 12, "RenderDisplay"),
    LAMP("machine.lamp", BlockMachine.class, TileEntityLamp.class, 4),
    EMP("machine.emp", BlockMMachine.class, TileEntityEMP.class, 14, "RenderEMP"),
    LINEBUILDER("machine.linebuilder", BlockDMIMachine.class, TileEntityLineBuilder.class, 7, "RenderLineBuilder"),
    BEAMMIRROR("machine.beammirror", BlockDMMachine.class, TileEntityBeamMirror.class, 11, "RenderBeamMirror"),
    MULTICLUTCH("machine.multiclutch", BlockTrans.class, TileEntityMultiClutch.class, 4, "RenderMultiClutch"),
    TERRAFORMER("machine.terraformer", BlockMachine.class, TileEntityTerraformer.class, 6),
    SORTING("machine.sorting", BlockDMachine.class, TileEntitySorting.class, 2),
    FUELENHANCER("machine.fuelenhancer", BlockMMachine.class, TileEntityFuelConverter.class, 13, "RenderFuelConverter"),
    ARROWGUN("machine.arrowgun", BlockDMachine.class, TileEntityMachineGun.class, 1),
    BOILER("machine.frictionboiler", BlockMMachine.class, TileEntityBoiler.class, 15, "RenderBoiler", PowerTypes.STEAM),
    STEAMTURBINE("machine.steamturbine", BlockDMMachine.class, TileEntitySteam.class, 10, "RenderSteam", PowerTypes.STEAM),
    FERTILIZER("machine.fertilizer", BlockMIMachine.class, TileEntityFertilizer.class, 19, "RenderFertilizer"),
    LAVAMAKER("machine.lavamaker", BlockMIMachine.class, TileEntityLavaMaker.class, 20, "RenderRockMelter"),
    GENERATOR("machine.generator", BlockModEngine.class, TileEntityGenerator.class, 2, "RenderGenerator", PowerTypes.EU),
    ELECTRICMOTOR("machine.electricmotor", BlockModEngine.class, TileEntityElectricMotor.class, 3, "RenderElecMotor", PowerTypes.EU),
    VALVE("machine.valve", BlockPiping.class, TileEntityValve.class, 4, "PipeRenderer"),
    BYPASS("machine.bypass", BlockPiping.class, TileEntityBypass.class, 5, "PipeRenderer"),
    SEPARATION("machine.separation", BlockPiping.class, TileEntitySeparatorPipe.class, 6, "PipeRenderer"),
    AGGREGATOR("machine.aggregator", BlockMMachine.class, TileEntityAggregator.class, 16, "RenderAggregator"),
    AIRGUN("machine.airgun", BlockDMMachine.class, TileEntityAirGun.class, 12, "RenderAirGun"),
    SONICBORER("machine.sonicborer", BlockDMMachine.class, TileEntitySonicBorer.class, 13, "RenderSonicBorer"),
    FUELENGINE("machine.fuelengine", BlockModEngine.class, TileEntityFuelEngine.class, 4, "RenderFuelEngine", ModList.BCENERGY),
    FILLINGSTATION("machine.fillingstation", BlockDMIMachine.class, TileEntityFillingStation.class, 8, "RenderFillingStation"),
    BELT("machine.belt", BlockDMMachine.class, TileEntityBeltHub.class, 14, "RenderBelt"),
    VANDEGRAFF("machine.vandegraff", BlockMMachine.class, TileEntityVanDeGraff.class, 17, "RenderVanDeGraff"),
    DEFOLIATOR("machine.defoliator", BlockMIMachine.class, TileEntityDefoliator.class, 21, "RenderDefoliator"),
    BIGFURNACE("machine.bigfurnace", BlockMIMachine.class, TileEntityBigFurnace.class, 22, "RenderBigFurnace"),
    DISTILLER("machine.distiller", BlockMMachine.class, TileEntityDistillery.class, 18, "RenderDistillery"),
    SUCTION("machine.suction", BlockPiping.class, TileEntitySuctionPipe.class, 7, "PipeRenderer"),
    DYNAMO("machine.dynamo", BlockModEngine.class, TileEntityDynamo.class, 5, "RenderDynamo", PowerTypes.RF),
    MAGNETIC("machine.magnetic", BlockModEngine.class, TileEntityMagnetic.class, 6, "RenderMagnetic", PowerTypes.RF),
    CRYSTALLIZER("machine.crystal", BlockDMIMachine.class, TileEntityCrystallizer.class, 9, "RenderCrystal"),
    BUSCONTROLLER("machine.buscontroller", BlockDMachine.class, TileEntityBusController.class, 3),
    POWERBUS("machine.bus", BlockMachine.class, TileEntityPowerBus.class, 5),
    PARTICLE("machine.particle", BlockMachine.class, TileEntityParticleEmitter.class, 7),
    LAWNSPRINKLER("machine.lawnsprinkler", BlockMMachine.class, TileEntityLawnSprinkler.class, 19, "RenderLawnSprinkler"),
    GRINDSTONE("machine.grindstone", BlockDMIMachine.class, TileEntityGrindstone.class, 10, "RenderGrindstone"),
    BLOWER("machine.blower", BlockDMachine.class, TileEntityBlower.class, 4),
    PORTALSHAFT("machine.portalshaft", BlockDMMachine.class, TileEntityPortalShaft.class, 15, "RenderPortalShaft"),
    REFRIGERATOR("machine.refrigerator", BlockDMIMachine.class, TileEntityRefrigerator.class, 11, "RenderFridge"),
    GASTANK("machine.gastank", BlockMMachine.class, TileEntityFluidCompressor.class, 20, "RenderGasCompressor"),
    CRAFTER("machine.crafter", BlockIMachine.class, TileEntityAutoCrafter.class, 7),
    COMPOSTER("machine.composter", BlockMIMachine.class, TileEntityComposter.class, 23, "RenderComposter"),
    ANTIAIR("machine.antiair", BlockMIMachine.class, TileEntityAAGun.class, 24, "RenderAAGun"),
    PIPEPUMP("machine.pipepump", BlockDMMachine.class, TileEntityPipePump.class, 16, "RenderPipePump"),
    CHAIN("machine.chain", BlockDMMachine.class, TileEntityChainDrive.class, 17, "RenderBelt"),
    CENTRIFUGE("machine.centrifuge", BlockMIMachine.class, TileEntityCentrifuge.class, 25, "RenderCentrifuge"),
    BEDPIPE("machine.bedpipe", BlockPiping.class, TileEntityBedrockPipe.class, 8, "PipeRenderer"),
    DRYING("machine.drying", BlockMIMachine.class, TileEntityDryingBed.class, 26, "RenderDryingBed"),
    WETTER("machine.wetter", BlockMIMachine.class, TileEntityWetter.class, 27, "RenderWetter"),
    DROPS("machine.drops", BlockIMachine.class, TileEntityDropProcessor.class, 8),
    ITEMFILTER("machine.itemfilter", BlockIMachine.class, TileEntityItemFilter.class, 9),
    HYDRATOR("machine.hydrator", BlockMMachine.class, TileEntityGroundHydrator.class, 21, "RenderHydrator"),
    FILLER("machine.filler", BlockMachine.class, TileEntityBlockFiller.class, 9);

    private final String name;
    private final Class te;
    private final BlockRegistry block;
    private final Class blockClass;
    private final int meta;
    private boolean hasRender = false;
    private String renderClass;
    private ModList requirement;
    private PowerTypes powertype;
    private PowerReceivers receiver;
    private TileEntity renderInstance;
    public static final ImmutableArray<MachineRegistry> machineList;
    private static final BlockMap<MachineRegistry> machineMappings;

    private MachineRegistry(String n2, Class<? extends Block> b, Class<? extends RotaryCraftTileEntity> tile, int m) {
        this.name = n2;
        this.blockClass = b;
        this.block = BlockRegistry.getBlockFromClassAndOffset(b, m / 16);
        if (this.block == null) {
            throw new RegistrationException((DragonAPIMod)RotaryCraft.instance, "Machine " + this.name() + " registered with a null block!");
        }
        this.te = tile;
        this.meta = m % 16;
        this.receiver = PowerReceivers.initialize(this);
    }

    private MachineRegistry(String n2, Class<? extends Block> b, Class<? extends RotaryCraftTileEntity> tile, int m, ModList a) {
        this(n2, b, tile, m);
        this.requirement = a;
        this.receiver = PowerReceivers.initialize(this);
    }

    private MachineRegistry(String n2, Class<? extends Block> b, Class<? extends RotaryCraftTileEntity> tile, int m, String r) {
        this(n2, b, tile, m);
        this.hasRender = true;
        this.renderClass = r;
        this.receiver = PowerReceivers.initialize(this);
    }

    private MachineRegistry(String n2, Class<? extends Block> b, Class<? extends RotaryCraftTileEntity> tile, int m, String r, PowerTypes p) {
        this(n2, b, tile, m, r);
        this.powertype = p;
        this.receiver = PowerReceivers.initialize(this);
    }

    private MachineRegistry(String n2, Class<? extends Block> b, Class<? extends RotaryCraftTileEntity> tile, int m, String r, ModList a) {
        this(n2, b, tile, m, r);
        this.requirement = a;
        this.receiver = PowerReceivers.initialize(this);
    }

    public static TileEntity createTEFromIDAndMetadata(Block id, int metad) {
        int index = MachineRegistry.getMachineIndexFromIDandMetadata(id, metad);
        if (index == -1) {
            RotaryCraft.logger.logError((Object)("ID " + id + " and metadata " + metad + " are not a valid machine identification pair!"));
            return null;
        }
        Class TEClass = ((MachineRegistry)((Object)MachineRegistry.machineList.get((int)index))).te;
        try {
            return (TileEntity)TEClass.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw new RegistrationException((DragonAPIMod)RotaryCraft.instance, "ID " + id + " and metadata " + metad + " failed to instantiate their TileEntity of " + TEClass);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new RegistrationException((DragonAPIMod)RotaryCraft.instance, "ID " + id + " and metadata " + metad + " failed illegally accessed their TileEntity of " + TEClass);
        }
    }

    public boolean hasRender() {
        return this.hasRender;
    }

    public String getRenderer() {
        if (!this.hasRender) {
            throw new RuntimeException("Machine " + this.getName() + " has no render to call!");
        }
        return this.getRenderPackage() + "." + this.renderClass;
    }

    public String getRenderPackage() {
        if (this.hasPrerequisite() || BlockModEngine.class.isAssignableFrom(this.blockClass)) {
            return "Reika.RotaryCraft.ModInterface";
        }
        if (this.blockClass == BlockTrans.class) {
            return "Reika.RotaryCraft.Renders";
        }
        if (this.blockClass == BlockEngine.class) {
            return "Reika.RotaryCraft.Renders";
        }
        if (this.blockClass == BlockSolar.class) {
            return "Reika.RotaryCraft.Renders";
        }
        if (this.blockClass == BlockFlywheel.class) {
            return "Reika.RotaryCraft.Renders";
        }
        if (this.blockClass == BlockGearbox.class) {
            return "Reika.RotaryCraft.Renders";
        }
        if (this.blockClass == BlockShaft.class) {
            return "Reika.RotaryCraft.Renders";
        }
        if (this.blockClass == BlockAdvGear.class) {
            return "Reika.RotaryCraft.Renders";
        }
        if (this.blockClass == BlockPiping.class) {
            return "Reika.RotaryCraft.Renders";
        }
        String base = "Reika.RotaryCraft.Renders";
        String app = ".";
        app = app + this.getBlockType();
        return base + app;
    }

    public String getBlockType() {
        return this.blockClass.getSimpleName().replaceAll("Block", "").replaceAll("Machine", "");
    }

    public Block getBlock() {
        return this.getBlockRegistryEntry().getBlockInstance();
    }

    public int getNumberDirections() {
        if (this.is2Sided()) {
            return 2;
        }
        if (this.is4Sided()) {
            return 4;
        }
        if (this.is6Sided()) {
            return 6;
        }
        return 1;
    }

    public PowerReceivers getPowerReceiverEntry() {
        return this.receiver;
    }

    public static int getMachineIndexFromIDandMetadata(Block id, int metad) {
        MachineRegistry m = MachineRegistry.getMachineMapping(id, metad);
        return m != null ? m.ordinal() : -1;
    }

    public static MachineRegistry getMachine(WorldLocation loc) {
        return MachineRegistry.getMachine((IBlockAccess)loc.getWorld(), loc.xCoord, loc.yCoord, loc.zCoord);
    }

    public static MachineRegistry getMachine(IBlockAccess world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (b == Blocks.field_150350_a) {
            return null;
        }
        return MachineRegistry.getMachineMapping(b, meta);
    }

    public static MachineRegistry getMachine(IBlockAccess world, double x, double y, double z) {
        return MachineRegistry.getMachine(world, (int)Math.floor(x), (int)Math.floor(y), (int)Math.floor(z));
    }

    public static MachineRegistry getMachineFromIDandMetadata(Block id, int metad) {
        return MachineRegistry.getMachineMapping(id, metad);
    }

    private static MachineRegistry getMachineMapping(Block id, int meta) {
        if (id == BlockRegistry.GPR.getBlockInstance()) {
            return GPR;
        }
        if (id == BlockRegistry.SHAFT.getBlockInstance()) {
            return SHAFT;
        }
        if (id == BlockRegistry.ENGINE.getBlockInstance()) {
            return ENGINE;
        }
        if (id == BlockRegistry.GEARBOX.getBlockInstance()) {
            return GEARBOX;
        }
        if (id == BlockRegistry.FLYWHEEL.getBlockInstance()) {
            return FLYWHEEL;
        }
        return (MachineRegistry)((Object)machineMappings.get(id, meta));
    }

    public int getBlockMetadata() {
        return this.meta;
    }

    public String getName() {
        return StatCollector.func_74838_a((String)this.name);
    }

    public String getDefaultName() {
        return this.getName();
    }

    public float getMinX(RotaryCraftTileEntity tile) {
        if (this == SPRINKLER) {
            return 0.3125f;
        }
        if (this == WOODCUTTER && tile.func_145832_p() == 0) {
            return 0.0625f;
        }
        if (this == SMOKEDETECTOR) {
            return 0.25f;
        }
        if (this == CCTV) {
            return 0.25f;
        }
        if (this == SCALECHEST) {
            return 0.0625f;
        }
        return 0.0f;
    }

    public float getMinY(RotaryCraftTileEntity tile) {
        if (this == SPRINKLER) {
            return 0.4375f;
        }
        if (this == SMOKEDETECTOR) {
            return 0.875f;
        }
        if (this == SPYCAM) {
            return 0.375f;
        }
        if (this == CCTV && tile.func_145832_p() == 1) {
            return 0.5f - 0.5f * (float)Math.sin(Math.toRadians(((TileEntityCCTV)tile).theta));
        }
        return 0.0f;
    }

    public float getMinZ(RotaryCraftTileEntity tile) {
        if (this == SPRINKLER) {
            return 0.3125f;
        }
        if (this == WOODCUTTER && tile.func_145832_p() == 2) {
            return 0.0625f;
        }
        if (this == SMOKEDETECTOR) {
            return 0.25f;
        }
        if (this == CCTV) {
            return 0.25f;
        }
        if (this == SCALECHEST) {
            return 0.0625f;
        }
        return 0.0f;
    }

    public float getMaxX(RotaryCraftTileEntity tile) {
        if (this == SPRINKLER) {
            return 0.6875f;
        }
        if (this == SMOKEDETECTOR) {
            return 0.75f;
        }
        if (this == CCTV) {
            return 0.75f;
        }
        if (this == WOODCUTTER && tile.func_145832_p() == 1) {
            return 0.9375f;
        }
        if (this == SCALECHEST) {
            return 0.9375f;
        }
        return 1.0f;
    }

    public float getMaxY(RotaryCraftTileEntity tile) {
        if (this == FLOODLIGHT) {
            if (((TileEntityFloodlight)tile).beammode) {
                return 1.0f;
            }
            return 0.875f;
        }
        if (this == CCTV && tile.func_145832_p() == 0) {
            return 0.5f - 0.5f * (float)Math.sin(Math.toRadians(((TileEntityCCTV)tile).theta));
        }
        if (this == GRINDER) {
            return 0.8125f;
        }
        if (this == HEATRAY) {
            return 0.6875f;
        }
        if (this == LIGHTBRIDGE) {
            return 0.6875f;
        }
        if (this == PUMP) {
            return 0.75f;
        }
        if (this == AEROSOLIZER) {
            return 0.875f;
        }
        if (this == PULSEJET) {
            return 0.5625f;
        }
        if (this == HEATER) {
            return 0.5f;
        }
        if (this == AUTOBREEDER) {
            return 0.5f;
        }
        if (this == OBSIDIAN) {
            return 0.75f;
        }
        if (this == WOODCUTTER) {
            return 0.875f;
        }
        if (this == SPAWNERCONTROLLER) {
            return 0.375f;
        }
        if (this == PLAYERDETECTOR) {
            return 0.6875f;
        }
        if (this == MOBRADAR) {
            return 0.75f;
        }
        if (this == WINDER) {
            return 0.8125f;
        }
        if (this == TNTCANNON) {
            return 0.9375f;
        }
        if (this == MOBHARVESTER) {
            return 0.999f;
        }
        if (this == PROJECTOR) {
            return 0.8125f;
        }
        if (this == WEATHERCONTROLLER) {
            return 0.675f;
        }
        if (this == MAGNETIZER) {
            return 0.9375f;
        }
        if (this == SCALECHEST) {
            return 0.875f;
        }
        if (this == LANDMINE) {
            return 0.4375f;
        }
        if (this == BLOCKCANNON) {
            return 0.9375f;
        }
        if (this == EMP) {
            return 0.5f;
        }
        if (this == PNEUENGINE) {
            return 0.8125f;
        }
        if (this == FERTILIZER) {
            return 0.875f;
        }
        if (this == DEFOLIATOR) {
            return 0.625f;
        }
        if (this == LAWNSPRINKLER) {
            return 0.75f;
        }
        if (this == GRINDSTONE) {
            return 0.9375f;
        }
        if (this == COMPOSTER) {
            return 0.75f;
        }
        if (this == CENTRIFUGE) {
            return 0.375f;
        }
        if (this == FRICTION) {
            return 0.9375f;
        }
        return 1.0f;
    }

    public float getMaxZ(RotaryCraftTileEntity tile) {
        if (this == SPRINKLER) {
            return 0.6875f;
        }
        if (this == SMOKEDETECTOR) {
            return 0.75f;
        }
        if (this == CCTV) {
            return 0.75f;
        }
        if (this == WOODCUTTER && tile.func_145832_p() == 3) {
            return 0.9375f;
        }
        if (this == SCALECHEST) {
            return 0.9375f;
        }
        return 1.0f;
    }

    public boolean hasSneakActions() {
        switch (this) {
            case CAVESCANNER: 
            case SCREEN: 
            case GPR: 
            case RESERVOIR: {
                return true;
            }
        }
        return false;
    }

    public boolean isXFlipped() {
        return this == BEDROCKBREAKER;
    }

    public boolean isZFlipped() {
        switch (this) {
            case BEDROCKBREAKER: 
            case FLOODLIGHT: 
            case LIGHTBRIDGE: 
            case HEATRAY: 
            case FAN: 
            case PROJECTOR: 
            case SCALECHEST: {
                return true;
            }
        }
        return false;
    }

    public BlockRegistry getBlockRegistryEntry() {
        return this.block;
    }

    public boolean isPipe() {
        return TileEntityPiping.class.isAssignableFrom(this.te);
    }

    public boolean isStandardPipe() {
        return this == PIPE || this == BEDPIPE;
    }

    public boolean hasInv() {
        if (BlockIMachine.class.isAssignableFrom(this.blockClass)) {
            return true;
        }
        if (BlockDMIMachine.class.isAssignableFrom(this.blockClass)) {
            return true;
        }
        return BlockMIMachine.class.isAssignableFrom(this.blockClass);
    }

    public Class getTEClass() {
        return this.te;
    }

    public String getMultiName(RotaryCraftTileEntity tile) {
        if (!this.isMultiNamed()) {
            throw new RuntimeException("Machine " + this.getName() + " has no multi name and yet was called for it!");
        }
        if (this == GEARBOX) {
            TileEntityGearbox gbx = (TileEntityGearbox)tile;
            return gbx.getGearboxType() != null ? RotaryNames.getGearboxName(gbx.func_145832_p() / 4 * 5 + gbx.getGearboxType().ordinal()) : this.getName();
        }
        if (this == ENGINE) {
            TileEntityEngine eng = (TileEntityEngine)tile;
            return eng.getEngineType() != null ? RotaryNames.getEngineName(eng.getEngineType().ordinal()) : this.getName();
        }
        if (this == SHAFT) {
            TileEntityShaft sha = (TileEntityShaft)tile;
            return sha.getShaftType() != null ? RotaryNames.getShaftName(sha.getShaftType().ordinal()) : this.getName();
        }
        if (this == FLYWHEEL) {
            TileEntityFlywheel fly = (TileEntityFlywheel)tile;
            return RotaryNames.getFlywheelName(fly.func_145832_p() / 4);
        }
        if (this == ADVANCEDGEARS) {
            TileEntityAdvancedGear adv = (TileEntityAdvancedGear)tile;
            return RotaryNames.getAdvGearName(adv.func_145832_p() / 4);
        }
        throw new RegistrationException((DragonAPIMod)RotaryCraft.instance, "Machine " + this.getName() + " has an unspecified multi name!");
    }

    public boolean isMultiNamed() {
        switch (this) {
            case ENGINE: 
            case GEARBOX: 
            case SHAFT: 
            case ADVANCEDGEARS: 
            case FLYWHEEL: {
                return true;
            }
        }
        return false;
    }

    public boolean isPowerReceiver() {
        return TileEntityPowerReceiver.class.isAssignableFrom(this.te);
    }

    public boolean dealsContactDamage() {
        return DamagingContact.class.isAssignableFrom(this.te);
    }

    public boolean dealsHeatDamage(Entity e) {
        if (e instanceof EntityItem || e instanceof EntityXPOrb) {
            return false;
        }
        switch (this) {
            case COMPACTOR: 
            case HEATER: 
            case IGNITER: 
            case OBSIDIAN: 
            case PULSEJET: 
            case FRICTION: {
                return true;
            }
        }
        return false;
    }

    public boolean is4Sided() {
        switch (this) {
            case SCREEN: 
            case LIGHTBRIDGE: 
            case HEATRAY: 
            case PROJECTOR: 
            case SCALECHEST: 
            case ENGINE: 
            case GEARBOX: 
            case ADVANCEDGEARS: 
            case FLYWHEEL: 
            case COMPACTOR: 
            case FRICTION: 
            case BORER: 
            case SPLITTER: 
            case FERMENTER: 
            case DYNAMOMETER: 
            case GRINDER: 
            case WOODCUTTER: 
            case WINDER: 
            case BLASTFURNACE: 
            case MAGNETIZER: 
            case PNEUENGINE: 
            case DISPLAY: 
            case MULTICLUTCH: 
            case ARROWGUN: 
            case STEAMTURBINE: 
            case BEAMMIRROR: 
            case GENERATOR: 
            case ELECTRICMOTOR: 
            case AIRGUN: 
            case FUELENGINE: 
            case SORTING: 
            case FILLINGSTATION: 
            case DISTILLER: 
            case MAGNETIC: 
            case CRYSTALLIZER: 
            case BUSCONTROLLER: 
            case REFRIGERATOR: 
            case DROPS: {
                return true;
            }
        }
        return false;
    }

    public boolean is6Sided() {
        switch (this) {
            case BEDROCKBREAKER: 
            case FLOODLIGHT: 
            case FAN: 
            case SHAFT: 
            case COOLINGFIN: 
            case COMPRESSOR: 
            case LINEBUILDER: 
            case SONICBORER: 
            case BELT: 
            case DYNAMO: 
            case BLOWER: 
            case PIPEPUMP: 
            case CHAIN: 
            case CLUTCH: {
                return true;
            }
        }
        return false;
    }

    public boolean is2Sided() {
        if (this.isCannon()) {
            return true;
        }
        switch (this) {
            case GPR: 
            case PILEDRIVER: 
            case PUMP: 
            case GRINDSTONE: {
                return true;
            }
        }
        return false;
    }

    public boolean isCannon() {
        return TileEntityAimedCannon.class.isAssignableFrom(this.te);
    }

    public boolean hasModel() {
        if (this.isPipe()) {
            return true;
        }
        switch (this) {
            case ENGINE: 
            case GEARBOX: 
            case SHAFT: 
            case ADVANCEDGEARS: 
            case FLYWHEEL: {
                return true;
            }
        }
        return BlockModelledMultiTE.class.isAssignableFrom(this.blockClass);
    }

    public boolean hasCustomPlacerItem() {
        switch (this) {
            case ENGINE: 
            case GEARBOX: 
            case SHAFT: 
            case ADVANCEDGEARS: 
            case FLYWHEEL: {
                return true;
            }
        }
        return false;
    }

    public ItemStack getCraftedProduct() {
        if (this == ADVANCEDGEARS) {
            return ItemRegistry.ADVGEAR.getStackOf();
        }
        if (this == FLYWHEEL) {
            return ItemRegistry.FLYWHEEL.getStackOf();
        }
        if (this == ENGINE) {
            return ItemRegistry.ENGINE.getStackOf();
        }
        if (this == SHAFT) {
            return ItemRegistry.SHAFT.getStackOf();
        }
        if (this == GEARBOX) {
            return ItemRegistry.GEARBOX.getStackOf();
        }
        return ItemRegistry.MACHINE.getStackOfMetadata(this.ordinal());
    }

    public ItemStack getCraftedMetadataProduct(int metadata) {
        if (this == ADVANCEDGEARS) {
            return ItemRegistry.ADVGEAR.getStackOfMetadata(metadata);
        }
        if (this == FLYWHEEL) {
            return ItemRegistry.FLYWHEEL.getStackOfMetadata(metadata);
        }
        if (this == ENGINE) {
            return ItemRegistry.ENGINE.getStackOfMetadata(metadata);
        }
        if (this == SHAFT) {
            return ItemRegistry.SHAFT.getStackOfMetadata(metadata);
        }
        if (this == GEARBOX) {
            return ItemRegistry.GEARBOX.getStackOfMetadata(metadata);
        }
        return this.getCraftedProduct();
    }

    public ItemStack getCraftedProduct(TileEntity te) {
        ItemStack is = this.getCraftedMetadataProduct(((RotaryCraftTileEntity)te).getItemMetadata());
        if (te instanceof NBTTile) {
            if (is.field_77990_d == null) {
                is.field_77990_d = new NBTTagCompound();
            }
            ((NBTTile)te).getTagsToWriteToStack(is.field_77990_d);
        }
        return is;
    }

    public boolean isEnchantable() {
        return EnchantableMachine.class.isAssignableFrom(this.te);
    }

    public boolean cachesConnections() {
        return CachedConnection.class.isAssignableFrom(this.te);
    }

    public boolean isModConversionEngine() {
        switch (this) {
            case GENERATOR: 
            case COMPRESSOR: 
            case DYNAMO: 
            case BOILER: {
                return true;
            }
        }
        return false;
    }

    public boolean isEnergyToPower() {
        return EnergyToPowerBase.class.isAssignableFrom(this.te);
    }

    public boolean isPoweredTransmissionMachine() {
        return TransmissionReceiver.class.isAssignableFrom(this.te);
    }

    public boolean hasSubdivisions() {
        switch (this) {
            case ENGINE: 
            case GEARBOX: 
            case SHAFT: 
            case ADVANCEDGEARS: 
            case FLYWHEEL: {
                return true;
            }
        }
        return false;
    }

    public int getNumberSubtypes() {
        switch (this) {
            case ENGINE: {
                return EngineType.engineList.length;
            }
            case GEARBOX: 
            case SHAFT: {
                return MaterialRegistry.matList.length + 1;
            }
            case ADVANCEDGEARS: {
                return TileEntityAdvancedGear.GearType.list.length;
            }
            case FLYWHEEL: {
                return 4;
            }
        }
        return 1;
    }

    public boolean canBeBroken() {
        switch (this) {
            case ENGINE: 
            case SHAFT: 
            case FLYWHEEL: 
            case MIRROR: {
                return true;
            }
        }
        return false;
    }

    public boolean isBroken(RotaryCraftTileEntity tile) {
        if (!this.canBeBroken()) {
            return false;
        }
        if (this == SHAFT) {
            return ((TileEntityShaft)tile).failed();
        }
        if (this == FLYWHEEL) {
            return ((TileEntityFlywheel)tile).failed;
        }
        if (this == ENGINE) {
            return ((TileEntityEngine)tile).isBroken();
        }
        if (this == MIRROR) {
            return ((TileEntityMirror)tile).broken;
        }
        return false;
    }

    public List<ItemStack> getBrokenProducts() {
        if (this == MIRROR) {
            Object[] is = new ItemStack[]{ReikaItemHelper.getSizedItemStack((ItemStack)ItemStacks.basepanel, (int)2), ReikaItemHelper.getSizedItemStack((ItemStack)ItemStacks.pcb, (int)1), ReikaItemHelper.getSizedItemStack((ItemStack)ItemStacks.steelgear, (int)1)};
            return ReikaJavaLibrary.makeListFromArray((Object[])is);
        }
        return null;
    }

    public boolean isAvailableInCreativeInventory() {
        if (this.isDummiedOut()) {
            return false;
        }
        if (this.isIncomplete() && !DragonAPICore.isReikasComputer() && !DragonOptions.DEBUGMODE.getState()) {
            return false;
        }
        if (this.isConfigDisabled()) {
            return false;
        }
        return this != PORTALSHAFT;
    }

    public boolean isDummiedOut() {
        if (RotaryCraft.instance.isLocked()) {
            return true;
        }
        if (DragonAPICore.isReikasComputer()) {
            return false;
        }
        if (this == CCTV) {
            return true;
        }
        if (this.requirement != null && !this.requirement.isLoaded()) {
            return true;
        }
        return this.powertype != null && !this.powertype.isLoaded();
    }

    public boolean hasPrerequisite() {
        return this.requirement != null || this.powertype != null;
    }

    public ModList getModDependency() {
        return this.requirement;
    }

    public PowerTypes getPowerDependency() {
        return this.powertype;
    }

    public String getPrerequisite() {
        if (this.requirement != null) {
            return this.requirement.getDisplayName();
        }
        if (this.powertype != null) {
            return this.powertype.name();
        }
        return "None";
    }

    public boolean renderInPass1() {
        if (this == COOLINGFIN) {
            return true;
        }
        if (this == DISPLAY) {
            return true;
        }
        if (this.isPipe()) {
            return true;
        }
        return this == PUMP;
    }

    public boolean isSidePlaced() {
        if (this == COOLINGFIN) {
            return true;
        }
        if (this == COMPRESSOR) {
            return true;
        }
        return this == DYNAMO;
    }

    public boolean allowsAcceleration() {
        switch (this) {
            case BLASTFURNACE: 
            case DRYING: 
            case COMPOSTER: 
            case HYDRATOR: {
                return true;
            }
        }
        return false;
    }

    public boolean matches(MachineRegistry m) {
        return this == m;
    }

    public void addRecipe(IRecipe ir) {
        if (this.isCraftable()) {
            WorktableRecipes.getInstance().addRecipe(ir, this.isCrucial() ? RecipeHandler.RecipeLevel.CORE : RecipeHandler.RecipeLevel.PROTECTED);
            if (ConfigRegistry.TABLEMACHINES.getState()) {
                GameRegistry.addRecipe((IRecipe)ir);
            }
        }
    }

    public void addOreRecipe(Object ... obj) {
        if (this.isCraftable()) {
            ShapedOreRecipe ir = new ShapedOreRecipe(this.getCraftedProduct(), obj);
            WorktableRecipes.getInstance().addRecipe((IRecipe)ir, this.isCrucial() ? RecipeHandler.RecipeLevel.CORE : RecipeHandler.RecipeLevel.PROTECTED);
            if (ConfigRegistry.TABLEMACHINES.getState()) {
                GameRegistry.addRecipe((IRecipe)ir);
            }
        }
    }

    public void addSizedOreRecipe(int size, Object ... obj) {
        if (this.isCraftable()) {
            ShapedOreRecipe ir = new ShapedOreRecipe(ReikaItemHelper.getSizedItemStack((ItemStack)this.getCraftedProduct(), (int)size), obj);
            WorktableRecipes.getInstance().addRecipe((IRecipe)ir, this.isCrucial() ? RecipeHandler.RecipeLevel.CORE : RecipeHandler.RecipeLevel.PROTECTED);
            if (ConfigRegistry.TABLEMACHINES.getState()) {
                GameRegistry.addRecipe((IRecipe)ir);
            }
        }
    }

    public void addMetaOreRecipe(int meta, Object ... obj) {
        if (this.isCraftable()) {
            ShapedOreRecipe ir = new ShapedOreRecipe(this.getCraftedMetadataProduct(meta), obj);
            WorktableRecipes.getInstance().addRecipe((IRecipe)ir, this.isCrucial() ? RecipeHandler.RecipeLevel.CORE : RecipeHandler.RecipeLevel.PROTECTED);
            if (ConfigRegistry.TABLEMACHINES.getState()) {
                GameRegistry.addRecipe((IRecipe)ir);
            }
        }
    }

    public void addSizedMetaOreRecipe(int size, int meta, Object ... obj) {
        if (this.isCraftable()) {
            ShapedOreRecipe ir = new ShapedOreRecipe(ReikaItemHelper.getSizedItemStack((ItemStack)this.getCraftedMetadataProduct(meta), (int)size), obj);
            WorktableRecipes.getInstance().addRecipe((IRecipe)ir, this.isCrucial() ? RecipeHandler.RecipeLevel.CORE : RecipeHandler.RecipeLevel.PROTECTED);
            if (ConfigRegistry.TABLEMACHINES.getState()) {
                GameRegistry.addRecipe((IRecipe)ir);
            }
        }
    }

    public void addRecipe(ItemStack is, Object ... obj) {
        if (this.isCraftable()) {
            WorktableRecipes.getInstance().addRecipe(is, this.isCrucial() ? RecipeHandler.RecipeLevel.CORE : RecipeHandler.RecipeLevel.PROTECTED, obj);
            if (ConfigRegistry.TABLEMACHINES.getState()) {
                GameRegistry.addRecipe((ItemStack)is, (Object[])obj);
            }
        }
    }

    public void addCrafting(Object ... obj) {
        if (this.isCraftable()) {
            WorktableRecipes.getInstance().addRecipe(this.getCraftedProduct(), this.isCrucial() ? RecipeHandler.RecipeLevel.CORE : RecipeHandler.RecipeLevel.PROTECTED, obj);
            if (ConfigRegistry.TABLEMACHINES.getState()) {
                GameRegistry.addRecipe((ItemStack)this.getCraftedProduct(), (Object[])obj);
            }
        }
    }

    public void addNBTCrafting(NBTTagCompound NBT, Object ... obj) {
        if (this.isCraftable()) {
            ItemStack is = this.getCraftedProduct();
            is.field_77990_d = (NBTTagCompound)NBT.func_74737_b();
            WorktableRecipes.getInstance().addRecipe(is, this.isCrucial() ? RecipeHandler.RecipeLevel.CORE : RecipeHandler.RecipeLevel.PROTECTED, obj);
            if (ConfigRegistry.TABLEMACHINES.getState()) {
                GameRegistry.addRecipe((ItemStack)is, (Object[])obj);
            }
        }
    }

    public void addSizedNBTCrafting(NBTTagCompound NBT, int num, Object ... obj) {
        if (this.isCraftable()) {
            ItemStack is = ReikaItemHelper.getSizedItemStack((ItemStack)this.getCraftedProduct(), (int)num);
            is.field_77990_d = (NBTTagCompound)NBT.func_74737_b();
            WorktableRecipes.getInstance().addRecipe(is, this.isCrucial() ? RecipeHandler.RecipeLevel.CORE : RecipeHandler.RecipeLevel.PROTECTED, obj);
            if (ConfigRegistry.TABLEMACHINES.getState()) {
                GameRegistry.addRecipe((ItemStack)is, (Object[])obj);
            }
        }
    }

    public void addSizedCrafting(int num, Object ... obj) {
        if (this.isCraftable()) {
            WorktableRecipes.getInstance().addRecipe(ReikaItemHelper.getSizedItemStack((ItemStack)this.getCraftedProduct(), (int)num), this.isCrucial() ? RecipeHandler.RecipeLevel.CORE : RecipeHandler.RecipeLevel.PROTECTED, obj);
            if (ConfigRegistry.TABLEMACHINES.getState()) {
                GameRegistry.addRecipe((ItemStack)ReikaItemHelper.getSizedItemStack((ItemStack)this.getCraftedProduct(), (int)num), (Object[])obj);
            }
        }
    }

    public void addMetaCrafting(int metadata, Object ... obj) {
        if (this.isCraftable()) {
            WorktableRecipes.getInstance().addRecipe(this.getCraftedMetadataProduct(metadata), this.isCrucial() ? RecipeHandler.RecipeLevel.CORE : RecipeHandler.RecipeLevel.PROTECTED, obj);
            if (ConfigRegistry.TABLEMACHINES.getState()) {
                GameRegistry.addRecipe((ItemStack)this.getCraftedMetadataProduct(metadata), (Object[])obj);
            }
        }
    }

    public void addNBTMetaCrafting(NBTTagCompound NBT, int metadata, Object ... obj) {
        ItemStack is = this.getCraftedMetadataProduct(metadata);
        is.field_77990_d = (NBTTagCompound)NBT.func_74737_b();
        if (this.isCraftable()) {
            WorktableRecipes.getInstance().addRecipe(is, this.isCrucial() ? RecipeHandler.RecipeLevel.CORE : RecipeHandler.RecipeLevel.PROTECTED, obj);
            if (ConfigRegistry.TABLEMACHINES.getState()) {
                GameRegistry.addRecipe((ItemStack)is, (Object[])obj);
            }
        }
    }

    public void addSizedMetaCrafting(int num, int metadata, Object ... obj) {
        if (this.isCraftable()) {
            WorktableRecipes.getInstance().addRecipe(ReikaItemHelper.getSizedItemStack((ItemStack)this.getCraftedMetadataProduct(metadata), (int)num), this.isCrucial() ? RecipeHandler.RecipeLevel.CORE : RecipeHandler.RecipeLevel.PROTECTED, obj);
            if (ConfigRegistry.TABLEMACHINES.getState()) {
                GameRegistry.addRecipe((ItemStack)ReikaItemHelper.getSizedItemStack((ItemStack)this.getCraftedMetadataProduct(metadata), (int)num), (Object[])obj);
            }
        }
    }

    public boolean isCraftable() {
        if (this.requirement != null && !this.requirement.isLoaded()) {
            return false;
        }
        if (this.powertype != null && !this.powertype.isLoaded()) {
            return false;
        }
        return !this.isDummiedOut() && !this.isTechnical() && !this.isConfigDisabled();
    }

    public boolean isConfigDisabled() {
        if (this == BORER || this == SONICBORER) {
            return ConfigRegistry.NOMINERS.getState();
        }
        if (this == TNTCANNON) {
            return !ConfigRegistry.ALLOWTNTCANNON.getState();
        }
        if (this == ITEMCANNON) {
            return !ConfigRegistry.ALLOWITEMCANNON.getState();
        }
        if (this == EMP) {
            return !ConfigRegistry.ALLOWEMP.getState();
        }
        if (this == LIGHTBRIDGE) {
            return !ConfigRegistry.ALLOWLIGHTBRIDGE.getState();
        }
        if (this == CHUNKLOADER) {
            return !ConfigRegistry.ALLOWCHUNKLOADER.getState();
        }
        if (this == SPILLER) {
            return ConfigRegistry.SPILLERRANGE.getValue() == 0;
        }
        if (this.isModConversionEngine()) {
            return !ConfigRegistry.enableConverters();
        }
        return false;
    }

    public boolean isTechnical() {
        return this == PORTALSHAFT;
    }

    public TileEntity createTEInstanceForRender(int offset) {
        if (this == ENGINE) {
            return EngineType.engineList[offset].getTEInstanceForRender();
        }
        if (this.renderInstance != null) {
            return this.renderInstance;
        }
        try {
            this.renderInstance = (TileEntity)this.te.newInstance();
            return this.renderInstance;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw new RegistrationException((DragonAPIMod)RotaryCraft.instance, (Object)((Object)this) + " failed to instantiate its TileEntity of " + this.te);
        }
        catch (IllegalAccessException e) {
            throw new RegistrationException((DragonAPIMod)RotaryCraft.instance, (Object)((Object)this) + " failed to instantiate its TileEntity of " + this.te);
        }
        catch (LinkageError e) {
            e.printStackTrace();
            throw new RegistrationException((DragonAPIMod)RotaryCraft.instance, (Object)((Object)this) + " failed to instantiate its TileEntity of " + this.te);
        }
    }

    public static ArrayList<MachineRegistry> getEnchantableMachineList() {
        ArrayList<MachineRegistry> li = new ArrayList<MachineRegistry>();
        for (int i = 0; i < MachineRegistry.machineList.length; ++i) {
            MachineRegistry m = (MachineRegistry)((Object)machineList.get(i));
            if (!m.isEnchantable()) continue;
            li.add(m);
        }
        return li;
    }

    public static ArrayList<Object[]> getDeepEnchantableMachineList() {
        ArrayList<Object[]> li = new ArrayList<Object[]>();
        for (int i = 0; i < MachineRegistry.machineList.length; ++i) {
            MachineRegistry m = (MachineRegistry)((Object)machineList.get(i));
            if (!m.isEnchantable()) continue;
            Object[] o = new Object[]{m, ((EnchantableMachine)m.createTEInstanceForRender(0)).getValidEnchantments()};
            li.add(o);
        }
        return li;
    }

    public boolean isIncomplete() {
        return !this.hasRender && this.hasModel();
    }

    public boolean canBeFrictionHeated() {
        return FrictionHeatable.class.isAssignableFrom(this.te);
    }

    public boolean hasNBTVariants() {
        return NBTMachine.class.isAssignableFrom(this.te);
    }

    public boolean hasTemperature() {
        return TemperatureTE.class.isAssignableFrom(this.te);
    }

    public boolean isTransmissionMachine() {
        return TileEntityTransmissionMachine.class.isAssignableFrom(this.te);
    }

    public boolean isAdvancedTransmission() {
        switch (this) {
            case GEARBOX: 
            case ADVANCEDGEARS: 
            case SPLITTER: 
            case DYNAMOMETER: {
                return true;
            }
        }
        return false;
    }

    public boolean canFlip() {
        switch (this) {
            case PULSEJET: 
            case SPLITTER: 
            case PUMP: 
            case SMOKEDETECTOR: 
            case SPRINKLER: {
                return false;
            }
        }
        return true;
    }

    public boolean isCrucial() {
        if (this.isPipe()) {
            return true;
        }
        if (this.isCritical()) {
            return true;
        }
        switch (this) {
            case BEDROCKBREAKER: 
            case HEATRAY: 
            case FAN: 
            case ENGINE: 
            case GEARBOX: 
            case SHAFT: 
            case ADVANCEDGEARS: 
            case COMPACTOR: 
            case HEATER: 
            case FRICTION: 
            case BORER: 
            case SPLITTER: 
            case FERMENTER: 
            case DYNAMOMETER: 
            case GRINDER: 
            case WOODCUTTER: 
            case WINDER: 
            case BLASTFURNACE: 
            case MAGNETIZER: 
            case MULTICLUTCH: 
            case SORTING: 
            case FILLINGSTATION: 
            case MAGNETIC: 
            case CRYSTALLIZER: 
            case BUSCONTROLLER: 
            case REFRIGERATOR: 
            case COOLINGFIN: 
            case COMPRESSOR: 
            case BELT: 
            case DYNAMO: 
            case BLOWER: 
            case PIPEPUMP: 
            case PUMP: 
            case MIRROR: 
            case DRYING: 
            case COMPOSTER: 
            case BEVELGEARS: 
            case EXTRACTOR: 
            case FRACTIONATOR: 
            case SPAWNERCONTROLLER: 
            case ECU: 
            case MOBHARVESTER: 
            case SOLARTOWER: 
            case WORKTABLE: 
            case FERTILIZER: 
            case LAVAMAKER: 
            case AGGREGATOR: 
            case VANDEGRAFF: 
            case POWERBUS: 
            case BIGFURNACE: 
            case CRAFTER: 
            case CENTRIFUGE: 
            case WETTER: {
                return true;
            }
        }
        return false;
    }

    public boolean isCritical() {
        if (this.isPipe()) {
            return true;
        }
        switch (this) {
            case BEDROCKBREAKER: 
            case HEATRAY: 
            case FAN: 
            case ENGINE: 
            case GEARBOX: 
            case SHAFT: 
            case ADVANCEDGEARS: 
            case COMPACTOR: 
            case HEATER: 
            case FRICTION: 
            case SPLITTER: 
            case FERMENTER: 
            case GRINDER: 
            case WINDER: 
            case BLASTFURNACE: 
            case MAGNETIZER: 
            case MULTICLUTCH: 
            case SORTING: 
            case FILLINGSTATION: 
            case BUSCONTROLLER: 
            case REFRIGERATOR: 
            case COOLINGFIN: 
            case BELT: 
            case BLOWER: 
            case PIPEPUMP: 
            case PUMP: 
            case DRYING: 
            case BEVELGEARS: 
            case EXTRACTOR: 
            case FRACTIONATOR: 
            case WORKTABLE: 
            case FERTILIZER: 
            case AGGREGATOR: 
            case VANDEGRAFF: 
            case POWERBUS: 
            case CRAFTER: 
            case CENTRIFUGE: 
            case WETTER: {
                return true;
            }
        }
        return false;
    }

    public boolean canBeDisabledInOverworld() {
        switch (this) {
            case BORER: 
            case SONICBORER: 
            case EMP: 
            case RAILGUN: 
            case LASERGUN: {
                return true;
            }
        }
        return false;
    }

    public boolean isUncraftable() {
        switch (this) {
            case COOLINGFIN: {
                return false;
            }
        }
        return true;
    }

    public static MachineRegistry getMachineByPlacerItem(ItemStack item) {
        if (ItemRegistry.GEARBOX.matchItem(item)) {
            return GEARBOX;
        }
        if (ItemRegistry.ENGINE.matchItem(item)) {
            return ENGINE;
        }
        if (ItemRegistry.ADVGEAR.matchItem(item)) {
            return ADVANCEDGEARS;
        }
        if (ItemRegistry.SHAFT.matchItem(item)) {
            return SHAFT;
        }
        if (ItemRegistry.FLYWHEEL.matchItem(item)) {
            return FLYWHEEL;
        }
        if (ItemRegistry.MACHINE.matchItem(item)) {
            return (MachineRegistry)((Object)machineList.get(item.func_77960_j()));
        }
        return null;
    }

    public boolean canDoMultiPerTick() {
        return this == EXTRACTOR || MultiOperational.class.isAssignableFrom(this.getTEClass());
    }

    public boolean isSolidBottom() {
        switch (this) {
            case RESERVOIR: 
            case HEATRAY: 
            case PROJECTOR: 
            case ENGINE: 
            case GEARBOX: 
            case SHAFT: 
            case ADVANCEDGEARS: 
            case FLYWHEEL: 
            case FRICTION: 
            case DYNAMOMETER: 
            case GRINDER: 
            case WINDER: 
            case MAGNETIZER: 
            case DISPLAY: 
            case STEAMTURBINE: 
            case GENERATOR: 
            case ELECTRICMOTOR: 
            case AIRGUN: 
            case MAGNETIC: 
            case CRYSTALLIZER: 
            case REFRIGERATOR: 
            case SONICBORER: 
            case CLUTCH: 
            case GRINDSTONE: 
            case COMPOSTER: 
            case BLOCKCANNON: 
            case TNTCANNON: 
            case ITEMCANNON: {
                return true;
            }
        }
        return false;
    }

    static {
        machineList = new ImmutableArray((Object[])MachineRegistry.values());
        machineMappings = new BlockMap();
        for (int i = 0; i < MachineRegistry.machineList.length; ++i) {
            int meta;
            MachineRegistry m = (MachineRegistry)((Object)machineList.get(i));
            Block id = m.getBlock();
            if (machineMappings.containsKey(id, meta = m.meta)) {
                throw new RegistrationException((DragonAPIMod)RotaryCraft.instance, "ID/Meta conflict @ " + id + "/" + meta + ": " + (Object)((Object)m) + " & " + machineMappings.get(id, meta));
            }
            machineMappings.put(id, meta, (Object)m);
        }
    }
}

