/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Registry;

import Reika.DragonAPI.Instantiable.Data.Collections.OneWayCollections;
import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Interfaces.Registry.OreType;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.ModOreList;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.ExtractorModOres;
import Reika.RotaryCraft.RotaryCraft;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public enum ExtractorBonus {
    GOLD(ItemStacks.goldsolution, ItemStacks.silverflakes, 0.125f),
    IRON(ItemStacks.ironsolution, ItemStacks.tungstenflakes, 0.025f),
    COAL(ItemStacks.coalsolution, new ItemStack(Items.field_151016_H), 0.0625f, ModList.REACTORCRAFT, ExtractorModOres.getFlakeProduct(ModOreList.PITCHBLENDE), ModList.IC2, ExtractorModOres.getFlakeProduct(ModOreList.URANIUM)),
    COPPER(ExtractorModOres.getSolutionProduct(ModOreList.COPPER), ItemStacks.goldoreflakes, 0.25f),
    LEAD(ExtractorModOres.getSolutionProduct(ModOreList.LEAD), ExtractorModOres.getFlakeProduct(ModOreList.NICKEL), 0.25f),
    NETHERGOLD(ExtractorModOres.getSolutionProduct(ModOreList.NETHERGOLD), ItemStacks.silverflakes, 0.125f),
    NETHERIRON(ExtractorModOres.getSolutionProduct(ModOreList.NETHERIRON), ItemStacks.tungstenflakes, 0.05f),
    SILVER(ExtractorModOres.getSolutionProduct(ModOreList.SILVER), ExtractorModOres.getFlakeProduct(ModOreList.IRIDIUM), 0.01f, ModList.IC2),
    PLATINUM(ExtractorModOres.getSolutionProduct(ModOreList.PLATINUM), ExtractorModOres.getFlakeProduct(ModOreList.IRIDIUM), 0.0625f, ModList.IC2),
    NETHERPLATINUM(ExtractorModOres.getSolutionProduct(ModOreList.NETHERPLATINUM), ExtractorModOres.getFlakeProduct(ModOreList.IRIDIUM), 0.125f, ModList.IC2),
    FERROUS(ExtractorModOres.getSolutionProduct(ModOreList.NICKEL), ExtractorModOres.getFlakeProduct(ModOreList.PLATINUM), 0.5f),
    NETHERNICKEL(ExtractorModOres.getSolutionProduct(ModOreList.NETHERNICKEL), ExtractorModOres.getFlakeProduct(ModOreList.PLATINUM), 0.5f),
    SODALITE(ExtractorModOres.getSolutionProduct(ModOreList.SODALITE), ExtractorModOres.getFlakeProduct(ModOreList.ALUMINUM), 1.0f),
    PYRITE(ExtractorModOres.getSolutionProduct(ModOreList.PYRITE), ExtractorModOres.getFlakeProduct(ModOreList.SULFUR), 0.4f),
    BAUXITE(ExtractorModOres.getSolutionProduct(ModOreList.BAUXITE), ExtractorModOres.getFlakeProduct(ModOreList.ALUMINUM), 0.25f),
    IRIDIUM(ExtractorModOres.getSolutionProduct(ModOreList.IRIDIUM), ExtractorModOres.getFlakeProduct(ModOreList.PLATINUM), 0.5f),
    TUNGSTEN(ExtractorModOres.getSolutionProduct(ModOreList.TUNGSTEN), ItemStacks.ironoreflakes, 0.75f),
    OSMIUM(ExtractorModOres.getSolutionProduct(ModOreList.OSMIUM), ItemStacks.ironoreflakes, 0.125f),
    LAPIS(ItemStacks.lapissolution, ItemStacks.aluminumpowder, 0.125f),
    RUBY(ExtractorModOres.getSolutionProduct(ModOreList.RUBY), ExtractorModOres.getFlakeProduct(ModOreList.ALUMINUM), 0.0625f),
    SAPPHIRE(ExtractorModOres.getSolutionProduct(ModOreList.SAPPHIRE), ExtractorModOres.getFlakeProduct(ModOreList.ALUMINUM), 0.0625f),
    QUARTZ(ItemStacks.quartzsolution, ExtractorModOres.getFlakeProduct(ModOreList.CERTUSQUARTZ), 0.0625f),
    CERTUS(ExtractorModOres.getSolutionProduct(ModOreList.CERTUSQUARTZ), ItemStacks.quartzflakes, 0.5f),
    COBALT(ExtractorModOres.getSolutionProduct(ModOreList.COBALT), ExtractorModOres.getFlakeProduct(ModOreList.NICKEL), 0.125f),
    REDSTONE(ItemStacks.redsolution, ItemStacks.aluminumpowder, 0.25f),
    MAGNETITE(ExtractorModOres.getSolutionProduct(ModOreList.MAGNETITE), ItemStacks.ironoreflakes, 0.2f),
    MONAZIT(ExtractorModOres.getSolutionProduct(ModOreList.MONAZIT), ExtractorModOres.getFlakeProduct(ModOreList.THORIUM), 0.15f, ModList.REACTORCRAFT),
    EMERALD(ItemStacks.emeraldsolution, ExtractorModOres.getFlakeProduct(ModOreList.RUBY), 0.1f);

    private ItemStack bonusItem;
    private ItemStack sourceItem;
    private float probability;
    private boolean isVariable = false;
    private List<ItemStack> modBonus;
    private List<ModList> bonusMods;
    private boolean hasReq = false;
    private ModList requirementMod;
    private static final ExtractorBonus[] bonusList;
    private static final ItemHashMap<ItemStack> itemmap;
    private static final ItemHashMap<ExtractorBonus> bonusmap;
    private static final OneWayCollections.OneWayMap<OreType, OreType> oremap;
    private static final MultiMap<OreType, OreType> backwards;
    private static final Random rand;

    private ExtractorBonus(ItemStack in, ItemStack is, float chance, ModList req) {
        this.bonusItem = is.func_77946_l();
        this.sourceItem = in.func_77946_l();
        this.probability = chance;
        this.hasReq = true;
        this.requirementMod = req;
        if (req.isLoaded()) {
            RotaryCraft.logger.log((Object)(req.getDisplayName() + " is loaded. Adding extractor bonus " + this.toString()));
        } else {
            RotaryCraft.logger.log((Object)(req.getDisplayName() + " is not loaded. Skipping extractor bonus " + this.toString()));
        }
    }

    private ExtractorBonus(ItemStack in, ItemStack is, float chance) {
        this.bonusItem = is.func_77946_l();
        this.sourceItem = in.func_77946_l();
        this.probability = chance;
        RotaryCraft.logger.log((Object)("Adding extractor bonus " + this.toString()));
    }

    private ExtractorBonus(ItemStack in, ItemStack is, float chance, Object ... mods) {
        this.bonusItem = is.func_77946_l();
        this.sourceItem = in.func_77946_l();
        this.probability = chance;
        this.isVariable = true;
        if (mods.length % 2 != 0) {
            throw new IllegalArgumentException("Every mod must have a specified bonus!");
        }
        this.modBonus = new ArrayList<ItemStack>();
        this.bonusMods = new ArrayList<ModList>();
        for (int i = 0; i < mods.length; i += 2) {
            ModList mod = (ModList)mods[i];
            ItemStack extra = (ItemStack)mods[i + 1];
            this.modBonus.add(extra.func_77946_l());
            this.bonusMods.add(mod);
        }
        RotaryCraft.logger.log((Object)("Adding extractor bonus " + this.toString()));
    }

    public static ExtractorBonus getBonusForIngredient(ItemStack is) {
        return (ExtractorBonus)((Object)bonusmap.get(is));
    }

    public static ItemStack getBonusItemForIngredient(ItemStack is) {
        return (ItemStack)itemmap.get(is);
    }

    private ItemStack getBonus() {
        if (this.hasReq && !this.requirementMod.isLoaded()) {
            return null;
        }
        if (this.isVariable) {
            for (int i = 0; i < this.bonusMods.size(); ++i) {
                if (!this.bonusMods.get(i).isLoaded()) continue;
                return this.modBonus.get(i).func_77946_l();
            }
        }
        return this.bonusItem.func_77946_l();
    }

    public boolean doBonus() {
        int chance = (int)(1.0f / this.probability);
        return rand.nextInt(chance) == 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isVariable) {
            sb.append("Bonuses from ");
            sb.append(StatCollector.func_74838_a((String)this.sourceItem.func_82833_r()));
            sb.append(":\n");
            for (int i = 0; i < this.bonusMods.size(); ++i) {
                ModList mod = this.bonusMods.get(i);
                ItemStack item = this.modBonus.get(i);
                sb.append("\t\t\t");
                sb.append(mod.getDisplayName());
                sb.append(": ");
                sb.append(StatCollector.func_74838_a((String)item.func_82833_r()));
                sb.append(" (");
                sb.append(this.getBonusPercent());
                sb.append("% chance)");
                if (i >= this.bonusMods.size() - 1) continue;
                sb.append("\n");
            }
        } else if (this.hasReq) {
            sb.append("Bonus of ");
            sb.append(StatCollector.func_74838_a((String)this.bonusItem.func_82833_r()));
            sb.append(" from ");
            sb.append(StatCollector.func_74838_a((String)this.sourceItem.func_82833_r()));
            sb.append(" (");
            sb.append(this.getBonusPercent());
            sb.append("% chance); ");
            sb.append("Requires ");
            sb.append(this.requirementMod.getDisplayName());
        } else {
            sb.append("Bonus of ");
            sb.append(StatCollector.func_74838_a((String)this.bonusItem.func_82833_r()));
            sb.append(" from ");
            sb.append(StatCollector.func_74838_a((String)this.sourceItem.func_82833_r()));
            sb.append(" (");
            sb.append(this.getBonusPercent());
            sb.append("% chance)");
        }
        return sb.toString();
    }

    public float getBonusPercent() {
        return this.probability * 100.0f;
    }

    public static boolean hasBonus(ModOreList ore) {
        return oremap.containsKey((Object)ore);
    }

    public static boolean isGivenAsBonus(ModOreList ore) {
        return backwards.containsKey((Object)ore);
    }

    static {
        bonusList = ExtractorBonus.values();
        itemmap = new ItemHashMap().setOneWay();
        bonusmap = new ItemHashMap().setOneWay();
        oremap = new OneWayCollections.OneWayMap();
        backwards = new MultiMap((MultiMap.CollectionFactory)new MultiMap.HashSetFactory()).setNullEmpty();
        rand = new Random();
        for (int i = 0; i < bonusList.length; ++i) {
            ExtractorBonus b = bonusList[i];
            ItemStack is = b.sourceItem;
            ItemStack bon = b.getBonus();
            if (bon == null) continue;
            OreType in = ExtractorModOres.getOreFromExtract(is);
            OreType out = ExtractorModOres.getOreFromExtract(bon);
            oremap.put((Object)in, (Object)out);
            backwards.addValue((Object)out, (Object)in);
            itemmap.put(is, (Object)bon);
            bonusmap.put(is, (Object)b);
        }
        backwards.lock();
    }
}

