/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.ModInterface;

import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.ModInteract.Power.ReikaEUHelper;
import Reika.DragonAPI.ModList;
import Reika.RotaryCraft.Auxiliary.Interfaces.NBTMachine;
import Reika.RotaryCraft.Auxiliary.Interfaces.RCToModConverter;
import Reika.RotaryCraft.Auxiliary.Interfaces.UpgradeableMachine;
import Reika.RotaryCraft.Base.TileEntity.PoweredLiquidReceiver;
import Reika.RotaryCraft.Items.Tools.ItemEngineUpgrade;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

@APIStripper.Strippable(value={"ic2.api.energy.tile.IEnergySource"})
public class TileEntityGenerator
extends PoweredLiquidReceiver
implements IEnergySource,
RCToModConverter,
UpgradeableMachine,
NBTMachine {
    private ForgeDirection facingDir;
    public static final boolean hardModeEU = ConfigRegistry.HARDEU.getState();
    private boolean upgraded;

    public ForgeDirection getFacing() {
        return this.facingDir != null ? this.facingDir : ForgeDirection.EAST;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.GENERATOR;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.getIOSides(world, x, y, z, meta);
        if (hardModeEU) {
            if (this.tank.isEmpty()) {
                this.torque = 0;
                this.omega = 0;
                this.power = 0L;
                return;
            }
            if (this.power > 0L) {
                int t;
                this.tank.removeLiquid(1);
                int n = t = this.upgraded ? 4096 : 1024;
                if (this.torque > t && ReikaRandomHelper.doWithChance((double)((double)(this.torque - t) / 20000.0))) {
                    if (rand.nextInt(this.upgraded ? 16 : 4) == 0) {
                        this.delete();
                        world.func_72885_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 3.0f, true, true);
                    } else {
                        ReikaSoundHelper.playSoundAtBlock((World)world, (int)x, (int)y, (int)z, (String)"random.fizz");
                    }
                }
            }
        }
        this.getPower(false);
    }

    private void getIOSides(World world, int x, int y, int z, int meta) {
        switch (meta) {
            case 0: {
                this.facingDir = ForgeDirection.NORTH;
                break;
            }
            case 1: {
                this.facingDir = ForgeDirection.WEST;
                break;
            }
            case 2: {
                this.facingDir = ForgeDirection.SOUTH;
                break;
            }
            case 3: {
                this.facingDir = ForgeDirection.EAST;
            }
        }
        this.read = this.facingDir;
        this.write = this.read.getOpposite();
    }

    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        return direction == this.getFacing().getOpposite();
    }

    public double getOfferedEnergy() {
        return ((double)this.power - this.getPowerLoss()) / ReikaEUHelper.getWattsPerEU() * ConfigRegistry.getConverterEfficiency();
    }

    private double getPowerLoss() {
        int t;
        int n = t = this.upgraded ? 512 : 128;
        return this.torque > t ? (double)ReikaMathLibrary.intpow2((int)(this.torque - t), (int)2) * (this.upgraded ? 0.0625 : 0.125) : 0.0;
    }

    public void drawEnergy(double amount) {
    }

    public void onFirstTick(World world, int x, int y, int z) {
        if (!world.field_72995_K && ModList.IC2.isLoaded()) {
            this.addTileToNet();
        }
    }

    @DependentMethodStripper.ModDependent(value=ModList.IC2)
    private void addTileToNet() {
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
    }

    protected void onInvalidateOrUnload(World world, int x, int y, int z, boolean invalidate) {
        if (!world.field_72995_K && ModList.IC2.isLoaded()) {
            this.removeTileFromNet();
        }
    }

    @DependentMethodStripper.ModDependent(value=ModList.IC2)
    private void removeTileFromNet() {
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
    }

    public int getSourceTier() {
        return ReikaEUHelper.getIC2TierFromPower((double)this.getOfferedEnergy());
    }

    @Override
    public boolean canConnectToPipe(MachineRegistry m) {
        return m.isStandardPipe();
    }

    @Override
    public boolean isValidFluid(Fluid f) {
        return f != null && (f.equals(FluidRegistry.getFluid((String)"ic2coolant")) || f.equals(FluidRegistry.getFluid((String)"rc liquid nitrogen")));
    }

    @Override
    public Fluid getInputFluid() {
        return null;
    }

    @Override
    public boolean canReceiveFrom(ForgeDirection from) {
        return from == ForgeDirection.DOWN;
    }

    @Override
    public int getCapacity() {
        return 6000;
    }

    @Override
    public void upgrade(ItemStack is) {
        this.upgraded = true;
    }

    public boolean isUpgraded() {
        return this.upgraded;
    }

    @Override
    public boolean canUpgradeWith(ItemStack item) {
        return !this.upgraded && ItemRegistry.UPGRADE.matchItem(item) && item.func_77960_j() == ItemEngineUpgrade.Upgrades.FLUX.ordinal();
    }

    @Override
    public final void setDataFromItemStackTag(NBTTagCompound nbt) {
        if (nbt != null) {
            this.upgraded = nbt.func_74767_n("upgrade");
        }
    }

    @Override
    public final NBTTagCompound getTagsToWriteToStack() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("upgrade", this.upgraded);
        return nbt;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74757_a("upgrade", this.upgraded);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.upgraded = NBT.func_74767_n("upgrade");
    }

    @Override
    public ArrayList<NBTTagCompound> getCreativeModeVariants() {
        return new ArrayList<NBTTagCompound>();
    }

    @Override
    public ArrayList<String> getDisplayTags(NBTTagCompound NBT) {
        return new ArrayList<String>();
    }
}

