/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.ModInterface;

import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.Instantiable.HybridTank;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModRegistry.InterfaceCache;
import Reika.RotaryCraft.API.Power.PowerGenerator;
import Reika.RotaryCraft.API.Power.ShaftMerger;
import Reika.RotaryCraft.Auxiliary.Interfaces.PowerSourceTracker;
import Reika.RotaryCraft.Auxiliary.Interfaces.SimpleProvider;
import Reika.RotaryCraft.Auxiliary.Interfaces.TemperatureTE;
import Reika.RotaryCraft.Auxiliary.PowerSourceList;
import Reika.RotaryCraft.Auxiliary.RotaryAux;
import Reika.RotaryCraft.Base.TileEntity.TileEntityIOMachine;
import Reika.RotaryCraft.Registry.EngineType;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.SoundRegistry;
import Reika.RotaryCraft.TileEntities.Auxiliary.TileEntityEngineController;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import micdoodle8.mods.galacticraft.api.world.IAtmosphericGas;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

@APIStripper.Strippable(value={"buildcraft.api.transport.IPipeConnection"})
public class TileEntityFuelEngine
extends TileEntityIOMachine
implements IFluidHandler,
SimpleProvider,
PowerGenerator,
IPipeConnection,
TemperatureTE {
    public static final int GEN_OMEGA = 256;
    public static final int GEN_TORQUE = 2048;
    private int temperature;
    public static final int CAPACITY = 24000;
    public static final int MAXTEMP = 750;
    private final HybridTank tank = new HybridTank("fuelengine", 24000);
    private final HybridTank watertank = new HybridTank("waterfuelengine", 24000);
    private final HybridTank lubetank = new HybridTank("lubefuelengine", 24000);
    private StepTimer fuelTimer = new StepTimer(36);
    private StepTimer soundTick = new StepTimer(40);
    private StepTimer tempTimer = new StepTimer(20);

    private boolean canEmitPower(World world, int x, int y, int z) {
        IGalacticraftWorldProvider ig;
        if (this.tank.isEmpty()) {
            return false;
        }
        if (!(!InterfaceCache.IGALACTICWORLD.instanceOf((Object)world.field_73011_w) || (ig = (IGalacticraftWorldProvider)world.field_73011_w).hasBreathableAtmosphere() && ig.isGasPresent(IAtmosphericGas.OXYGEN))) {
            return false;
        }
        if (this.lubetank.isEmpty()) {
            return false;
        }
        if (this.hasECU()) {
            TileEntityEngineController te = this.getECU();
            return te.canProducePower();
        }
        return true;
    }

    private boolean hasECU() {
        return this.getMachine(this.isFlipped ? ForgeDirection.UP : ForgeDirection.DOWN) == MachineRegistry.ECU;
    }

    private TileEntityEngineController getECU() {
        return (TileEntityEngineController)this.getAdjacentTileEntity(this.isFlipped ? ForgeDirection.UP : ForgeDirection.DOWN);
    }

    private void updateSpeed(int maxspeed, boolean revup) {
        if (revup) {
            if (this.omega < maxspeed) {
                this.omega += 4 * (int)ReikaMathLibrary.logbase((long)maxspeed, (int)2);
                this.tank.removeLiquid(1);
                if (this.omega > maxspeed) {
                    this.omega = maxspeed;
                }
            }
        } else if (this.omega > 0) {
            this.omega -= this.omega / 256 + 1;
        }
    }

    private int getFuelDuration(World world, int x, int y, int z) {
        if (this.hasECU()) {
            TileEntityEngineController te = this.getECU();
            return 36 * te.getFuelMultiplier(EngineType.EngineClass.PISTON);
        }
        return 36;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.getIOSides(world, x, y, z, meta);
        this.fuelTimer.setCap(this.getFuelDuration(world, x, y, z));
        int genomega = this.getGenOmega();
        this.tempTimer.update();
        if (this.tempTimer.checkCap()) {
            this.updateTemperature(world, x, y, z, meta);
        }
        if (this.canEmitPower(world, x, y, z)) {
            this.fuelTimer.update();
            if (this.fuelTimer.checkCap()) {
                this.tank.removeLiquid(this.getConsumedFuel());
            }
            this.torque = 2048;
            if (this.hasECU()) {
                TileEntityEngineController te = this.getECU();
                genomega = (int)((float)genomega * te.getSpeedMultiplier());
            }
        } else {
            genomega = 0;
            if (this.omega == 0) {
                this.torque = 0;
            }
        }
        this.updateSpeed(genomega, genomega >= this.omega);
        this.power = this.omega * this.torque;
        this.soundTick.update();
        if (this.power > 0L) {
            this.makeSmoke(world, x, y, z, meta);
            if (this.soundTick.checkCap()) {
                SoundRegistry.DIESEL.playSoundAtBlock(world, x, y, z, RotaryAux.isMuffled((TileEntity)this) ? 0.3f : 1.0f, 0.4f);
            }
            if (world.func_82737_E() % 32L == 0L) {
                this.lubetank.removeLiquid(1);
            }
        }
    }

    private int getConsumedFuel() {
        return 2;
    }

    private int getGenOmega() {
        return this.temperature <= 450 ? 256 : Math.max(16, 706 - this.temperature);
    }

    private void makeSmoke(World world, int x, int y, int z, int meta) {
        if (this.isFlipped) {
            y = (int)((double)y - 0.5);
        }
        switch (meta) {
            case 0: {
                ReikaParticleHelper.SMOKE.spawnAt(world, (double)x + 0.6875, (double)y + 0.9375, (double)z + 0.0625);
                ReikaParticleHelper.SMOKE.spawnAt(world, (double)x + 0.6875, (double)y + 0.9375, (double)z + 0.9375);
                break;
            }
            case 1: {
                ReikaParticleHelper.SMOKE.spawnAt(world, (double)x + 0.3175, (double)y + 0.9375, (double)z + 0.0625);
                ReikaParticleHelper.SMOKE.spawnAt(world, (double)x + 0.3175, (double)y + 0.9375, (double)z + 0.9375);
                break;
            }
            case 2: {
                ReikaParticleHelper.SMOKE.spawnAt(world, (double)x + 0.0625, (double)y + 0.9375, (double)z + 0.6875);
                ReikaParticleHelper.SMOKE.spawnAt(world, (double)x + 0.9375, (double)y + 0.9375, (double)z + 0.6875);
                break;
            }
            case 3: {
                ReikaParticleHelper.SMOKE.spawnAt(world, (double)x + 0.0625, (double)y + 0.9375, (double)z + 0.3175);
                ReikaParticleHelper.SMOKE.spawnAt(world, (double)x + 0.9375, (double)y + 0.9375, (double)z + 0.3175);
            }
        }
    }

    private void getIOSides(World world, int x, int y, int z, int meta) {
        switch (meta) {
            case 0: {
                this.write = ForgeDirection.WEST;
                break;
            }
            case 1: {
                this.write = ForgeDirection.EAST;
                break;
            }
            case 2: {
                this.write = ForgeDirection.NORTH;
                break;
            }
            case 3: {
                this.write = ForgeDirection.SOUTH;
            }
        }
    }

    @Override
    public boolean canProvidePower() {
        return !this.tank.isEmpty();
    }

    @Override
    public PowerSourceList getPowerSources(PowerSourceTracker io, ShaftMerger caller) {
        return new PowerSourceList().addSource(this);
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
        if (!this.isInWorld()) {
            this.phi = 0.0f;
            return;
        }
        this.phi = (float)((double)this.phi + ReikaMathLibrary.doubpow((double)ReikaMathLibrary.logbase((long)(this.omega + 1), (int)2), (double)1.05));
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.FUELENGINE;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int getRedstoneOverride() {
        return 15 * this.tank.getLevel() / this.tank.getCapacity();
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        Fluid f = resource.getFluid();
        if (this.canFill(from, f)) {
            if (f.equals(FluidRegistry.getFluid((String)"rc lubricant"))) {
                return this.lubetank.fill(resource, doFill);
            }
            if (f.equals(FluidRegistry.getFluid((String)"fuel"))) {
                return this.tank.fill(resource, doFill);
            }
            if (f.equals(FluidRegistry.WATER)) {
                return this.watertank.fill(resource, doFill);
            }
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid f) {
        switch (from) {
            case UP: {
                return this.isFlipped && f.equals(FluidRegistry.getFluid((String)"fuel"));
            }
            case DOWN: {
                return !this.isFlipped && f.equals(FluidRegistry.getFluid((String)"fuel"));
            }
            case EAST: 
            case NORTH: 
            case SOUTH: 
            case WEST: {
                return f.equals(FluidRegistry.getFluid((String)"rc lubricant")) || f.equals(FluidRegistry.WATER);
            }
        }
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo(), this.watertank.getInfo(), this.lubetank.getInfo()};
    }

    @Override
    public long getMaxPower() {
        return this.power;
    }

    @Override
    public long getCurrentPower() {
        return this.power;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        this.tank.writeToNBT(NBT);
        this.watertank.writeToNBT(NBT);
        this.lubetank.writeToNBT(NBT);
        NBT.func_74768_a("temp", this.temperature);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.tank.readFromNBT(NBT);
        this.watertank.readFromNBT(NBT);
        this.lubetank.readFromNBT(NBT);
        this.temperature = NBT.func_74762_e("temp");
    }

    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection with) {
        return type == IPipeTile.PipeType.FLUID && with != ForgeDirection.DOWN ? IPipeConnection.ConnectOverride.CONNECT : IPipeConnection.ConnectOverride.DEFAULT;
    }

    public int getFuelLevel() {
        return this.tank.getLevel();
    }

    public int getWaterLevel() {
        return this.watertank.getLevel();
    }

    public int getLubeLevel() {
        return this.lubetank.getLevel();
    }

    public void addFuel(int amt) {
        this.tank.addLiquid(amt, FluidRegistry.getFluid((String)"fuel"));
    }

    public void removeFuel(int amt) {
        this.tank.removeLiquid(amt);
    }

    public void addWater(int amt) {
        this.watertank.addLiquid(amt, FluidRegistry.WATER);
    }

    public void addLube(int amt) {
        this.lubetank.addLiquid(amt, FluidRegistry.getFluid((String)"rc lubricant"));
    }

    @Override
    public int getEmittingX() {
        return this.field_145851_c + this.write.offsetX;
    }

    @Override
    public int getEmittingY() {
        return this.field_145848_d + this.write.offsetY;
    }

    @Override
    public int getEmittingZ() {
        return this.field_145849_e + this.write.offsetZ;
    }

    @Override
    public void updateTemperature(World world, int x, int y, int z, int meta) {
        int Tamb = ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z);
        int dT = this.temperature - Tamb;
        if (dT > 0) {
            --this.temperature;
            int c = (this.temperature - Tamb) / 100;
            if (!this.watertank.isEmpty()) {
                this.temperature -= c;
                this.watertank.removeLiquid(20);
            }
        }
        if (this.power > 0L) {
            this.temperature += 5;
        }
        if (this.temperature > 750) {
            this.overheat(world, x, y, z);
        }
    }

    @Override
    public void addTemperature(int temp) {
        this.temperature += temp;
    }

    @Override
    public int getTemperature() {
        return this.temperature;
    }

    @Override
    public int getThermalDamage() {
        return 0;
    }

    @Override
    public void overheat(World world, int x, int y, int z) {
        world.func_147468_f(x, y, z);
        if (!world.field_72995_K) {
            world.func_72885_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 4.0f, true, true);
            world.func_72885_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 8.0f, true, true);
        }
    }

    @Override
    public boolean canBeCooledWithFins() {
        return false;
    }

    @Override
    public boolean allowExternalHeating() {
        return false;
    }

    public void setTemperature(int temp) {
        this.temperature = temp;
    }

    @Override
    public void getAllOutputs(Collection<TileEntity> c, ForgeDirection dir) {
        c.add(this.getAdjacentTileEntity(this.write));
    }

    @SideOnly(value=Side.CLIENT)
    public int getFuelScaled(int a) {
        return this.tank.getLevel() * a / this.tank.getCapacity();
    }

    @SideOnly(value=Side.CLIENT)
    public int getWaterScaled(int a) {
        return this.watertank.getLevel() * a / this.watertank.getCapacity();
    }

    @SideOnly(value=Side.CLIENT)
    public int getLubricantScaled(int a) {
        return this.lubetank.getLevel() * a / this.lubetank.getCapacity();
    }

    @SideOnly(value=Side.CLIENT)
    public int getTemperatureScaled(int a) {
        return this.temperature * a / 750;
    }

    public int getFuelDuration() {
        return this.tank.getLevel() * this.fuelTimer.getCap() / this.getConsumedFuel() / 20;
    }

    @Override
    public int getMaxTemperature() {
        return 750;
    }
}

