/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.ModInterface;

import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import Reika.DragonAPI.ModInteract.Power.ReikaEUHelper;
import Reika.DragonAPI.ModList;
import Reika.RotaryCraft.API.Power.PowerGenerator;
import Reika.RotaryCraft.Auxiliary.Interfaces.SimpleProvider;
import Reika.RotaryCraft.Base.TileEntity.EnergyToPowerBase;
import Reika.RotaryCraft.ModInterface.TileEntityGenerator;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.SoundRegistry;
import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.tile.IEnergyStorage;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

@APIStripper.Strippable(value={"ic2.api.energy.tile.IEnergySink"})
public class TileEntityElectricMotor
extends EnergyToPowerBase
implements PowerGenerator,
SimpleProvider,
IEnergySink {
    public static int CAPACITY = 90000;

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
        if (!this.isInWorld()) {
            this.phi = 0.0f;
            return;
        }
        this.phi = (float)((double)this.phi + ReikaMathLibrary.doubpow((double)ReikaMathLibrary.logbase((long)(this.omega + 1), (int)2), (double)1.05));
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.ELECTRICMOTOR;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        ++this.tickcount;
        this.getIOSides(world, x, y, z, meta);
        this.read = this.getFacing();
        this.write = this.read.getOpposite();
        this.updateSpeed();
        if (!world.field_72995_K) {
            ++this.tickcount;
            if (this.power > 0L && this.tickcount >= 294) {
                this.tickcount = 0;
                SoundRegistry.ELECTRIC.playSoundAtBlock(world, x, y, z, this.isMuffled() ? 0.08f : 0.2f, 0.51f);
            }
        }
        this.basicPowerReceiver();
    }

    @Override
    public int getEmittingX() {
        return this.field_145851_c + this.write.offsetX;
    }

    @Override
    public int getEmittingY() {
        return this.field_145848_d + this.write.offsetY;
    }

    @Override
    public int getEmittingZ() {
        return this.field_145849_e + this.write.offsetZ;
    }

    @Override
    public int getMaxStorage() {
        return CAPACITY;
    }

    @Override
    protected int getIdealConsumedUnitsPerTick() {
        return MathHelper.func_76143_f((double)((double)this.power / ReikaEUHelper.getWattsPerEU()));
    }

    @Override
    public String getUnitDisplay() {
        return "EU";
    }

    @Override
    public int getPowerColor() {
        return ReikaColorAPI.RGBtoHex((int)255, (int)220, (int)0);
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection dir) {
        return (dir == this.getFacing() || dir == ForgeDirection.DOWN) && this.isValidSupplier(emitter);
    }

    public double getDemandedEnergy() {
        return this.getMaxStorage() - this.getStoredPower();
    }

    public int getSinkTier() {
        return 5;
    }

    private int getScaledTier() {
        return ReikaEUHelper.getIC2TierFromPower((double)this.getTierPower());
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        int tier = ReikaEUHelper.getIC2TierFromEUVoltage((double)voltage);
        int tier1 = this.getScaledTier();
        double add = Math.min(amount, (double)(this.getMaxStorage() - this.storedEnergy));
        this.storedEnergy = (int)((double)this.storedEnergy + add);
        return amount - add;
    }

    private void onWrongVoltage(int tier, int correct) {
        int over = tier - correct;
        if (over > 2 && TileEntityGenerator.hardModeEU) {
            this.field_145850_b.func_72885_a(null, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 9.0f, true, true);
        } else if (over > 1) {
            ReikaParticleHelper.SMOKE.spawnAroundBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 12);
            ReikaSoundHelper.playSoundAtBlock((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (String)"random.fizz");
        } else if (over == 1) {
            if (rand.nextInt(5) == 0) {
                ReikaParticleHelper.SMOKE.spawnAroundBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 12);
                ReikaSoundHelper.playSoundAtBlock((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (String)"random.fizz");
            }
            if (rand.nextInt(15) == 0) {
                SoundRegistry.ELECTRIC.playSoundAtBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 0.2f, 2.0f);
            }
        }
    }

    @Override
    @DependentMethodStripper.ModDependent(value=ModList.IC2)
    public boolean isValidSupplier(TileEntity te) {
        return te instanceof IEnergySource || te instanceof IEnergyConductor || te instanceof IEnergyStorage;
    }

    public void onFirstTick(World world, int x, int y, int z) {
        this.getIOSides(world, x, y, z, this.func_145832_p());
        if (!world.field_72995_K && ModList.IC2.isLoaded()) {
            this.addTileToNet();
        }
    }

    @DependentMethodStripper.ModDependent(value=ModList.IC2)
    private void addTileToNet() {
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
    }

    protected void onInvalidateOrUnload(World world, int x, int y, int z, boolean invalidate) {
        if (!world.field_72995_K && ModList.IC2.isLoaded()) {
            this.removeTileFromNet();
        }
    }

    @DependentMethodStripper.ModDependent(value=ModList.IC2)
    private void removeTileFromNet() {
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
    }
}

