/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.ModInterface;

import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.Power.ReikaRFHelper;
import Reika.RotaryCraft.Auxiliary.Interfaces.NBTMachine;
import Reika.RotaryCraft.Auxiliary.Interfaces.RCToModConverter;
import Reika.RotaryCraft.Auxiliary.Interfaces.UpgradeableMachine;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPowerReceiver;
import Reika.RotaryCraft.Items.Tools.ItemEngineUpgrade;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyReceiver;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@APIStripper.Strippable(value={"cofh.api.energy.IEnergyHandler"})
public class TileEntityDynamo
extends TileEntityPowerReceiver
implements IEnergyHandler,
RCToModConverter,
UpgradeableMachine,
NBTMachine {
    private ForgeDirection facingDir;
    private boolean upgraded;
    public static final int MAXTORQUE = 1024;
    public static final int MAXTORQUE_UPGRADE = 2048;
    public static final int MAXOMEGA = 8192;

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
        if (!this.isInWorld()) {
            this.phi = 0.0f;
            return;
        }
        this.phi = (float)((double)this.phi + ReikaMathLibrary.doubpow((double)ReikaMathLibrary.logbase((long)(this.omega + 1), (int)2), (double)1.05));
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.DYNAMO;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        int metadata;
        Block b;
        super.updateTileEntity();
        this.getIOSides(world, x, y, z, meta);
        this.getPower(false);
        if ((world.func_72820_D() & 0x1FL) == 0L) {
            ReikaWorldHelper.causeAdjacentUpdates((World)world, (int)x, (int)y, (int)z);
        }
        int writex = x + this.write.offsetX;
        int writey = y + this.write.offsetY;
        int writez = z + this.write.offsetZ;
        if (this.power > 0L && (b = world.func_147439_a(writex, writey, writez)) != Blocks.field_150350_a && b.hasTileEntity(metadata = world.func_72805_g(writex, writey, writez))) {
            IEnergyReceiver rc;
            TileEntity tile = world.func_147438_o(writex, writey, writez);
            if (tile instanceof IEnergyHandler) {
                IEnergyHandler rc2 = (IEnergyHandler)tile;
                if (rc2.canConnectEnergy(this.facingDir.getOpposite())) {
                    int rf = this.getGenRF();
                    float used = rc2.receiveEnergy(this.facingDir.getOpposite(), rf, false);
                }
            } else if (tile instanceof IEnergyReceiver && (rc = (IEnergyReceiver)tile).canConnectEnergy(this.facingDir.getOpposite())) {
                int rf = this.getGenRF();
                float used = rc.receiveEnergy(this.facingDir.getOpposite(), rf, false);
            }
        }
    }

    public int getGenRF() {
        int tq = Math.min(this.torque, this.upgraded ? 2048 : 1024);
        int om = Math.min(this.omega, 8192);
        long pwr = (long)tq * (long)om;
        return (int)((double)(pwr / (long)ReikaRFHelper.getWattsPerRF()) * ConfigRegistry.getConverterEfficiency());
    }

    private void getIOSides(World world, int x, int y, int z, int meta) {
        switch (meta) {
            case 2: {
                this.facingDir = ForgeDirection.SOUTH;
                break;
            }
            case 3: {
                this.facingDir = ForgeDirection.EAST;
                break;
            }
            case 4: {
                this.facingDir = ForgeDirection.NORTH;
                break;
            }
            case 5: {
                this.facingDir = ForgeDirection.WEST;
                break;
            }
            case 1: {
                this.facingDir = ForgeDirection.DOWN;
                break;
            }
            case 0: {
                this.facingDir = ForgeDirection.UP;
            }
        }
        this.write = this.facingDir;
        this.read = this.write.getOpposite();
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return 0;
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        if (this.canConnectEnergy(from)) {
            int rf = (int)(this.power / (long)ReikaRFHelper.getWattsPerRF());
        }
        return 0;
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return from == this.facingDir;
    }

    private ForgeDirection getFacing() {
        return this.facingDir != null ? this.facingDir : ForgeDirection.EAST;
    }

    public int getEnergyStored(ForgeDirection from) {
        return 0;
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return 0;
    }

    @Override
    public void upgrade(ItemStack is) {
        this.upgraded = true;
    }

    public boolean isUpgraded() {
        return this.upgraded;
    }

    @Override
    public boolean canUpgradeWith(ItemStack item) {
        return !this.upgraded && ItemRegistry.UPGRADE.matchItem(item) && item.func_77960_j() == ItemEngineUpgrade.Upgrades.FLUX.ordinal();
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74757_a("upgrade", this.upgraded);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.upgraded = NBT.func_74767_n("upgrade");
    }

    @Override
    public final void setDataFromItemStackTag(NBTTagCompound nbt) {
        if (nbt != null) {
            this.upgraded = nbt.func_74767_n("upgrade");
        }
    }

    @Override
    public final NBTTagCompound getTagsToWriteToStack() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("upgrade", this.upgraded);
        return nbt;
    }

    @Override
    public ArrayList<NBTTagCompound> getCreativeModeVariants() {
        return new ArrayList<NBTTagCompound>();
    }

    @Override
    public ArrayList<String> getDisplayTags(NBTTagCompound NBT) {
        return new ArrayList<String>();
    }
}

