/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.ModInterface.NEI;

import Reika.DragonAPI.Libraries.IO.ReikaGuiAPI;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipesBlastFurnace;
import Reika.RotaryCraft.GUIs.Machine.Inventory.GuiBlastFurnace;
import Reika.RotaryCraft.RotaryCraft;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class BlastFurnaceHandler
extends TemplateRecipeHandler {
    public String getRecipeName() {
        return "Blast Furnace";
    }

    public String getGuiTexture() {
        return "/Reika/RotaryCraft/Textures/GUI/blastfurngui.png";
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ReikaTextureHelper.bindTexture(RotaryCraft.class, (String)this.getGuiTexture());
        GL11.glDisable((int)2929);
        ReikaGuiAPI.instance.drawTexturedModalRectWithDepth(0, 0, 5, 11, 166, 70, ReikaGuiAPI.NEI_DEPTH);
    }

    public void drawForeground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        ReikaTextureHelper.bindTexture(RotaryCraft.class, (String)this.getGuiTexture());
        this.drawExtras(recipe);
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(115, 23, 23, 18), "rcblastf", new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId != null && outputId.equals("rcblastf")) {
            Collection<RecipesBlastFurnace.BlastFurnacePattern> li = RecipesBlastFurnace.getRecipes().getAllRecipes();
            for (RecipesBlastFurnace.BlastFurnacePattern p : li) {
                if (p instanceof RecipesBlastFurnace.BlastRecipe) {
                    this.arecipes.add(new BlastFurnRecipe((RecipesBlastFurnace.BlastRecipe)p));
                    continue;
                }
                if (p instanceof RecipesBlastFurnace.BlastCrafting) {
                    this.arecipes.add(new BlastFurnCrafting((RecipesBlastFurnace.BlastCrafting)p));
                    continue;
                }
                RotaryCraft.logger.logError((Object)("Unrenderable recipe, makes " + p.outputItem() + "!"));
            }
        }
        super.loadCraftingRecipes(outputId, results);
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId != null && inputId.equals("rcblastf")) {
            this.loadCraftingRecipes(inputId, ingredients);
        }
        super.loadUsageRecipes(inputId, ingredients);
    }

    public void loadCraftingRecipes(ItemStack result) {
        ArrayList<RecipesBlastFurnace.BlastRecipe> li = RecipesBlastFurnace.getRecipes().getAllRecipesMaking(result);
        for (int i = 0; i < li.size(); ++i) {
            this.arecipes.add(new BlastFurnRecipe(li.get(i)));
        }
        ArrayList<RecipesBlastFurnace.BlastCrafting> li2 = RecipesBlastFurnace.getRecipes().getAllCraftingMaking(result);
        for (int i = 0; i < li2.size(); ++i) {
            this.arecipes.add(new BlastFurnCrafting(li2.get(i)));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        ArrayList<RecipesBlastFurnace.BlastRecipe> li = RecipesBlastFurnace.getRecipes().getAllRecipesUsing(ingredient);
        for (int i = 0; i < li.size(); ++i) {
            this.arecipes.add(new BlastFurnRecipe(li.get(i)));
        }
        ArrayList<RecipesBlastFurnace.BlastCrafting> li2 = RecipesBlastFurnace.getRecipes().getAllCraftingUsing(ingredient);
        for (int i = 0; i < li2.size(); ++i) {
            this.arecipes.add(new BlastFurnCrafting(li2.get(i)));
        }
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiBlastFurnace.class;
    }

    public int recipiesPerPage() {
        return 1;
    }

    public void drawExtras(int recipe) {
        ReikaGuiAPI.instance.func_73729_b(6, 17, 176, 44, 11, 43);
        BlastTempRecipe r = (BlastTempRecipe)this.arecipes.get(recipe);
        String s = String.format("%dC", r.getRecipeTemperature());
        FontRenderer f = Minecraft.func_71410_x().field_71466_p;
        ReikaGuiAPI.instance.drawCenteredStringNoShadow(f, s, f.func_78256_a(s) / 2 - 2 * (s.length() / 5), 61, 0);
        int dy = 0;
        if (r instanceof BlastFurnRecipe) {
            RecipesBlastFurnace.BlastInput in3;
            RecipesBlastFurnace.BlastInput in2;
            RecipesBlastFurnace.BlastRecipe br = ((BlastFurnRecipe)r).recipe;
            RecipesBlastFurnace.BlastInput in1 = br.primary;
            if (in1.exists()) {
                String sg = String.format("%s: x%d (%.1f%%)", in1.getItemForDisplay().func_82833_r(), in1.numberToUse, Float.valueOf(100.0f * in1.chanceToUse));
                f.func_78276_b(sg, 21, 72, 0);
                dy += f.field_78288_b + 2;
            }
            if ((in2 = br.secondary).exists()) {
                String sg = String.format("%s: x%d (%.1f%%)", in2.getItemForDisplay().func_82833_r(), in2.numberToUse, Float.valueOf(100.0f * in2.chanceToUse));
                f.func_78276_b(sg, 21, 72 + dy, 0);
                dy += f.field_78288_b + 2;
            }
            if ((in3 = br.tertiary).exists()) {
                String sg = String.format("%s: x%d (%.1f%%)", in3.getItemForDisplay().func_82833_r(), in3.numberToUse, Float.valueOf(100.0f * in3.chanceToUse));
                f.func_78276_b(sg, 21, 72 + dy, 0);
                dy += f.field_78288_b + 2;
            }
            f.func_78276_b("Bonus output: " + (br.hasBonus ? "Yes" : "No"), 21, 72 + dy, 0);
        } else if (r instanceof BlastFurnCrafting) {
            RecipesBlastFurnace.BlastCrafting br = ((BlastFurnCrafting)r).recipe;
            String sg = String.format("Time Factor: %dx", br.speed);
            ReikaGuiAPI.instance.drawCenteredStringNoShadow(f, sg, 83, 64 + dy, 0);
        }
    }

    public static interface BlastTempRecipe {
        public int getRecipeTemperature();
    }

    public class BlastFurnCrafting
    extends TemplateRecipeHandler.CachedRecipe
    implements BlastTempRecipe {
        public final RecipesBlastFurnace.BlastCrafting recipe;

        private BlastFurnCrafting(RecipesBlastFurnace.BlastCrafting c) {
            super((TemplateRecipeHandler)BlastFurnaceHandler.this);
            this.recipe = c;
        }

        public ArrayList<PositionedStack> getIngredients() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            ItemStack[] items = this.recipe.getArrayForDisplay();
            int dx = 57;
            int dy = 6;
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    ItemStack is = items[i + j * 3];
                    if (is == null) continue;
                    stacks.add(new PositionedStack((Object)is, dx + 18 * i, dy + 18 * j));
                }
            }
            return stacks;
        }

        public PositionedStack getResult() {
            return new PositionedStack((Object)this.recipe.outputItem(), 143, 24);
        }

        @Override
        public int getRecipeTemperature() {
            return this.recipe.temperature;
        }
    }

    public class BlastFurnRecipe
    extends TemplateRecipeHandler.CachedRecipe
    implements BlastTempRecipe {
        public final RecipesBlastFurnace.BlastRecipe recipe;
        private final ArrayList<Integer> inputs;

        private BlastFurnRecipe(RecipesBlastFurnace.BlastRecipe r) {
            super((TemplateRecipeHandler)BlastFurnaceHandler.this);
            this.recipe = r;
            this.inputs = r.getValidInputNumbers();
        }

        private int getInput() {
            long time = System.currentTimeMillis();
            int index = (int)(time / 500L % (long)this.inputs.size());
            return this.inputs.get(index);
        }

        public PositionedStack getResult() {
            int in = this.getInput();
            int num = this.recipe.getNumberProduced(in);
            return new PositionedStack((Object)ReikaItemHelper.getSizedItemStack((ItemStack)this.recipe.outputItem(), (int)num), 143, 24);
        }

        public ArrayList<PositionedStack> getIngredients() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            int dx = 57;
            int dy = 6;
            int num = this.getInput();
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    if (i * 3 + j >= num) continue;
                    stacks.add(new PositionedStack((Object)this.recipe.mainItemForDisplay(), dx + 18 * i, dy + 18 * j));
                }
            }
            if (this.recipe.tertiary.exists()) {
                stacks.add(new PositionedStack((Object)this.recipe.tertiary.getItemForDisplay(), 21, 5));
            }
            if (this.recipe.primary.exists()) {
                stacks.add(new PositionedStack((Object)this.recipe.primary.getItemForDisplay(), 21, 24));
            }
            if (this.recipe.secondary.exists()) {
                stacks.add(new PositionedStack((Object)this.recipe.secondary.getItemForDisplay(), 21, 43));
            }
            return stacks;
        }

        @Override
        public int getRecipeTemperature() {
            return this.recipe.temperature;
        }
    }
}

