/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.ModInterface;

import Reika.DragonAPI.Auxiliary.ModularLogger;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Instantiable.Event.BlockTickEvent;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.Bees.AlleleRegistry;
import Reika.DragonAPI.ModInteract.Bees.BasicFlowerProvider;
import Reika.DragonAPI.ModInteract.Bees.BasicGene;
import Reika.DragonAPI.ModInteract.Bees.BeeSpecies;
import Reika.DragonAPI.ModInteract.ItemHandlers.AgriCraftHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.ForestryHandler;
import Reika.DragonAPI.ModList;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.ModInterface.AgriCanola;
import Reika.RotaryCraft.Registry.BlockRegistry;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.RotaryCraft;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleFlowers;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IFlowerAcceptableRule;
import forestry.api.genetics.IFlowerGrowthHelper;
import forestry.api.genetics.IFlowerProvider;
import net.minecraft.block.Block;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class CanolaBee
extends BeeSpecies {
    private static final String LOGGER_ID = "CanolaBee";
    private final AlleleCanola canola = new AlleleCanola();

    public CanolaBee() {
        super("Slippery", "bee.canola", "Mechanica Lubrica", "Reika", (IClassification)new BeeSpecies.BeeBranch("branch.rotary", "Mechanica", "Mechanica", "These bees seem to be made to aid mechanical devices."));
        this.addSpecialty(ItemStacks.slipperyComb, 15.0f);
        this.addSpecialty(ItemStacks.canolaSeeds, 25.0f);
        this.addProduct(ForestryHandler.Combs.HONEY.getItem(), 40.0f);
        this.addProduct(ForestryHandler.Combs.DRIPPING.getItem(), 10.0f);
        this.addProduct(ForestryHandler.Combs.STRINGY.getItem(), 2.5f);
        if (ConfigRegistry.enableBeeYeast()) {
            this.addSpecialty(ItemRegistry.YEAST.getStackOf(), 10.0f);
        }
    }

    public String getDescription() {
        return "These bees produce a greasy comb that can be processed into a fluid that seems to aid mechanical motion.";
    }

    public EnumTemperature getTemperature() {
        return EnumTemperature.NORMAL;
    }

    public EnumHumidity getHumidity() {
        return EnumHumidity.NORMAL;
    }

    public boolean hasEffect() {
        return false;
    }

    public boolean isSecret() {
        return false;
    }

    public boolean isCounted() {
        return true;
    }

    public int getOutlineColor() {
        return 16766208;
    }

    public boolean isDominant() {
        return true;
    }

    public boolean isNocturnal() {
        return false;
    }

    public boolean isJubilant(IBeeGenome ibg, IBeeHousing ibh) {
        World world = ibh.getWorld();
        ChunkCoordinates c = ibh.getCoordinates();
        int Tamb = ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)c.field_71574_a, (int)c.field_71572_b, (int)c.field_71573_c);
        return Tamb > 15 && Tamb < 35;
    }

    public IAllele getFlowerAllele() {
        return this.canola;
    }

    public AlleleRegistry.Speeds getProductionSpeed() {
        return AlleleRegistry.Speeds.FAST;
    }

    public AlleleRegistry.Fertility getFertility() {
        return AlleleRegistry.Fertility.NORMAL;
    }

    public AlleleRegistry.Flowering getFloweringRate() {
        return AlleleRegistry.Flowering.FASTER;
    }

    public AlleleRegistry.Life getLifespan() {
        return AlleleRegistry.Life.SHORT;
    }

    public AlleleRegistry.Territory getTerritorySize() {
        return AlleleRegistry.Territory.DEFAULT;
    }

    public boolean isCaveDwelling() {
        return false;
    }

    public int getTemperatureTolerance() {
        return 1;
    }

    public int getHumidityTolerance() {
        return 1;
    }

    public AlleleRegistry.Tolerance getHumidityToleranceDir() {
        return AlleleRegistry.Tolerance.BOTH;
    }

    public AlleleRegistry.Tolerance getTemperatureToleranceDir() {
        return AlleleRegistry.Tolerance.BOTH;
    }

    public IAllele getEffectAllele() {
        return AlleleRegistry.Effect.NONE.getAllele();
    }

    public boolean isTolerantFlyer() {
        return false;
    }

    static {
        ModularLogger.instance.addLogger((DragonAPIMod)RotaryCraft.instance, LOGGER_ID);
    }

    private final class FlowerProviderCanola
    extends BasicFlowerProvider
    implements IFlowerAcceptableRule {
        private FlowerProviderCanola() {
            super(BlockRegistry.CANOLA.getBlockInstance(), "canola");
        }

        public boolean growFlower(IFlowerGrowthHelper helper, String flowerType, World world, int x, int y, int z) {
            if (ModularLogger.instance.isEnabled(CanolaBee.LOGGER_ID)) {
                ModularLogger.instance.log(CanolaBee.LOGGER_ID, "Canola bee @ " + x + ", " + y + ", " + z + " running growFlower");
            }
            int r = 24;
            int n = 4;
            boolean flag = false;
            for (int i = 0; i < n; ++i) {
                int dx = ReikaRandomHelper.getRandomPlusMinus((int)x, (int)r);
                int dy = ReikaRandomHelper.getRandomPlusMinus((int)y, (int)r);
                int dz = ReikaRandomHelper.getRandomPlusMinus((int)z, (int)r);
                if (dy <= 0) continue;
                Block b = world.func_147439_a(dx, dy, dz);
                int meta = world.func_72805_g(dx, dy, dz);
                if (b != BlockRegistry.CANOLA.getBlockInstance() || meta >= 9) continue;
                b.func_149674_a(world, dx, dy, dz, CanolaBee.this.rand);
                BlockTickEvent.fire((World)world, (int)dx, (int)dy, (int)dz, (Block)b, (int)BlockTickEvent.UpdateFlags.FORCED.flag);
                flag = true;
            }
            return true;
        }

        public String getDescription() {
            return "Canola Plants";
        }

        public boolean isAcceptableFlower(String flowerType, World world, int x, int y, int z) {
            if (super.isAcceptedFlower(world, x, y, z)) {
                return true;
            }
            if (!ModList.AGRICRAFT.isLoaded()) {
                return false;
            }
            Block b = world.func_147439_a(x, y, z);
            int meta = world.func_72805_g(x, y, z);
            return AgriCraftHandler.getInstance().isCrop(b, meta) && AgriCraftHandler.getInstance().getCropObject(world, x, y, z) == AgriCanola.instance;
        }
    }

    private final class AlleleCanola
    extends BasicGene
    implements IAlleleFlowers {
        public AlleleCanola() {
            super("flower.canola", "Canola", EnumBeeChromosome.FLOWER_PROVIDER);
        }

        public IFlowerProvider getProvider() {
            return new FlowerProviderCanola();
        }
    }
}

