/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.GUIs.Machine.Inventory;

import Reika.DragonAPI.Instantiable.GUI.ImagedGuiButton;
import Reika.DragonAPI.Libraries.IO.ReikaLiquidRenderer;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.RotaryCraft.Base.GuiPowerOnlyMachine;
import Reika.RotaryCraft.Containers.Machine.Inventory.ContainerTerraformer;
import Reika.RotaryCraft.Registry.PacketRegistry;
import Reika.RotaryCraft.RotaryCraft;
import Reika.RotaryCraft.TileEntities.World.TileEntityTerraformer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class GuiTerraformer
extends GuiPowerOnlyMachine {
    TileEntityTerraformer terra;
    private List<BiomeGenBase> targets;
    private int offset = 0;

    public GuiTerraformer(EntityPlayer pl, TileEntityTerraformer te) {
        super((Container)new ContainerTerraformer(pl, te), te);
        this.ep = pl;
        this.terra = te;
        this.field_146999_f = 240;
        this.field_147000_g = 222;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int j = (this.field_146294_l - this.field_146999_f) / 2;
        int k = (this.field_146295_m - this.field_147000_g) / 2;
        String tex = "/Reika/RotaryCraft/Textures/GUI/biomes.png";
        this.targets = new ArrayList<BiomeGenBase>(this.terra.getValidTargetBiomes(this.terra.getCentralBiome()));
        for (int i = 0; i < this.getNumberBiomesOnPage(); ++i) {
            BiomeGenBase b = this.targets.get(i + this.offset);
            this.field_146292_n.add(new ImagedGuiButton(i, j + 8, k + 17 + 39 * i, 32, 32, 32 * (b.field_76756_M % 8), 32 * (b.field_76756_M / 8), tex, b.field_76791_y, 0xFFFFFF, false, RotaryCraft.class));
        }
        tex = "/Reika/RotaryCraft/Textures/GUI/buttons.png";
        this.field_146292_n.add(new ImagedGuiButton(100, j + 11, k + 6, 24, 12, 18, 110, tex, RotaryCraft.class));
        this.field_146292_n.add(new ImagedGuiButton(101, j + 11, k + this.field_147000_g - 14, 24, 12, 42, 110, tex, RotaryCraft.class));
    }

    private int getNumberBiomesOnPage() {
        return Math.min(this.targets.size(), 5);
    }

    @Override
    protected void func_146284_a(GuiButton b) {
        super.func_146284_a(b);
        if (b.field_146127_k == 100 && this.offset > 0) {
            --this.offset;
        } else if (b.field_146127_k == 101 && this.offset < this.targets.size() - 5) {
            ++this.offset;
        } else if (b.field_146127_k < this.targets.size()) {
            BiomeGenBase biome = this.targets.get(b.field_146127_k);
            ReikaPacketHelper.sendDataPacket((String)"RotaryCraftData", (int)PacketRegistry.TERRAFORMER.getMinValue(), (TileEntity)this.terra, (int)biome.field_76756_M);
        }
        this.func_73866_w_();
    }

    @Override
    protected void func_146979_b(int par2, int par3) {
        super.func_146979_b(par2, par3);
        int j = (this.field_146294_l - this.field_146999_f) / 2;
        int k = (this.field_146295_m - this.field_147000_g) / 2;
        BiomeGenBase from = this.terra.getCentralBiome();
        for (int i = 0; i < this.getNumberBiomesOnPage(); ++i) {
            BiomeGenBase to = this.targets.get(i + this.offset);
            FluidStack liq = this.terra.getReqLiquidForTransform(from, to);
            if (liq != null) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                ReikaLiquidRenderer.bindFluidTexture((Fluid)liq.getFluid());
                IIcon ico = liq.getFluid().getIcon();
                this.func_94065_a(48, 17 + i * 39, ico, 16, 16);
                api.drawCenteredStringNoShadow(this.field_146289_q, String.format("%d", liq.amount), 56, 21 + i * 39, 0);
            } else {
                api.drawLine(48, 17 + i * 39, 64, 33 + i * 39, 0);
                api.drawLine(64, 17 + i * 39, 48, 33 + i * 39, 0);
            }
            ArrayList<ItemStack> items = this.terra.getItemsForTransform(from, to);
            if (items != null && !items.isEmpty()) {
                int step = (int)(System.nanoTime() / 500000000L % (long)items.size());
                ItemStack is = items.get(step);
                api.drawItemStack(field_146296_j, this.field_146289_q, is, 48, 35 + i * 39);
                continue;
            }
            api.drawLine(48, 35 + i * 39, 64, 51 + i * 39, 0);
            api.drawLine(64, 35 + i * 39, 48, 51 + i * 39, 0);
        }
        String tex = "/Reika/RotaryCraft/Textures/GUI/" + this.getGuiTexture() + ".png";
        ReikaTextureHelper.bindTexture(RotaryCraft.class, (String)tex);
    }

    @Override
    protected void func_146976_a(float par1, int par2, int par3) {
        super.func_146976_a(par1, par2, par3);
        int j = (this.field_146294_l - this.field_146999_f) / 2;
        int k = (this.field_146295_m - this.field_147000_g) / 2;
    }

    @Override
    protected String getGuiTexture() {
        return "terraformergui";
    }
}

