/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft;

import Reika.DragonAPI.Auxiliary.Trackers.DonatorController;
import Reika.DragonAPI.Auxiliary.Trackers.PatreonController;
import Reika.DragonAPI.Auxiliary.Trackers.PlayerSpecificRenderer;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.DragonOptions;
import Reika.DragonAPI.Instantiable.IO.SoundLoader;
import Reika.DragonAPI.Instantiable.Rendering.BlockSheetTexRenderer;
import Reika.DragonAPI.Instantiable.Rendering.ForcedTextureArmorModel;
import Reika.DragonAPI.Instantiable.Rendering.ItemSpriteSheetRenderer;
import Reika.DragonAPI.Instantiable.Rendering.MultiSheetItemRenderer;
import Reika.DragonAPI.Instantiable.Rendering.SpawnerRenderer;
import Reika.DragonAPI.Interfaces.PlayerRenderObj;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.RotaryCraft.Auxiliary.DonatorGearRender;
import Reika.RotaryCraft.Auxiliary.RotaryRenderList;
import Reika.RotaryCraft.Base.RotaryTERenderer;
import Reika.RotaryCraft.CommonProxy;
import Reika.RotaryCraft.ConnectedGlassRenderer;
import Reika.RotaryCraft.CubicalMachineRenderer;
import Reika.RotaryCraft.DecoTankItemRenderer;
import Reika.RotaryCraft.Entities.EntityCustomTNT;
import Reika.RotaryCraft.Entities.EntityDischarge;
import Reika.RotaryCraft.Entities.EntityExplosiveShell;
import Reika.RotaryCraft.Entities.EntityFlakShot;
import Reika.RotaryCraft.Entities.EntityFreezeGunShot;
import Reika.RotaryCraft.Entities.EntityIceBlock;
import Reika.RotaryCraft.Entities.EntityLiquidBlock;
import Reika.RotaryCraft.Entities.EntityRailGunShot;
import Reika.RotaryCraft.Entities.EntitySonicShot;
import Reika.RotaryCraft.Entities.RenderDischarge;
import Reika.RotaryCraft.Entities.RenderFlakShot;
import Reika.RotaryCraft.Entities.RenderFreezeGunShot;
import Reika.RotaryCraft.Entities.RenderIceBlock;
import Reika.RotaryCraft.Entities.RenderLiquidBlock;
import Reika.RotaryCraft.Entities.RenderRailGunShot;
import Reika.RotaryCraft.Entities.RenderSonicShot;
import Reika.RotaryCraft.ItemMachineRenderer;
import Reika.RotaryCraft.PipeBodyRenderer;
import Reika.RotaryCraft.Registry.BlockRegistry;
import Reika.RotaryCraft.Registry.HandbookRegistry;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.SoundRegistry;
import Reika.RotaryCraft.RotaryCraft;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderTNTPrimed;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    private static final ItemSpriteSheetRenderer[] items = new ItemSpriteSheetRenderer[]{new ItemSpriteSheetRenderer((DragonAPIMod)RotaryCraft.instance, RotaryCraft.class, "Textures/Items/items.png"), new ItemSpriteSheetRenderer((DragonAPIMod)RotaryCraft.instance, RotaryCraft.class, "Textures/Items/items2.png"), new ItemSpriteSheetRenderer((DragonAPIMod)RotaryCraft.instance, RotaryCraft.class, "Textures/Items/items3.png")};
    private static final MultiSheetItemRenderer[] multisheets = new MultiSheetItemRenderer[]{new MultiSheetItemRenderer((DragonAPIMod)RotaryCraft.instance, RotaryCraft.class)};
    public static final BlockSheetTexRenderer block = new BlockSheetTexRenderer(RotaryCraft.class, "Textures/Terrain/textures.png");
    public static final ItemMachineRenderer machineItems = new ItemMachineRenderer();
    public static final DecoTankItemRenderer decotank = new DecoTankItemRenderer();
    public static final SpawnerRenderer spawner = new SpawnerRenderer();
    public static PipeBodyRenderer pipe;
    public static CubicalMachineRenderer cube;
    public static ConnectedGlassRenderer connected;
    private static final HashMap<ItemRegistry, ForcedTextureArmorModel> armorTextures;
    private static final HashMap<ItemRegistry, String> armorAssets;

    @Override
    public void registerSounds() {
        new SoundLoader((SoundEnum[])SoundRegistry.soundList).register();
    }

    public static ItemSpriteSheetRenderer getSpritesheetRenderer(int index) {
        return items[index];
    }

    @Override
    public void registerRenderers() {
        pipeRender = RenderingRegistry.getNextAvailableRenderId();
        pipe = new PipeBodyRenderer(pipeRender);
        RenderingRegistry.registerBlockHandler((int)pipeRender, (ISimpleBlockRenderingHandler)pipe);
        cubeRender = RenderingRegistry.getNextAvailableRenderId();
        cube = new CubicalMachineRenderer(cubeRender);
        RenderingRegistry.registerBlockHandler((int)cubeRender, (ISimpleBlockRenderingHandler)cube);
        connectedRender = RenderingRegistry.getNextAvailableRenderId();
        connected = new ConnectedGlassRenderer(connectedRender);
        RenderingRegistry.registerBlockHandler((int)connectedRender, (ISimpleBlockRenderingHandler)connected);
        if (DragonOptions.NORENDERS.getState()) {
            RotaryCraft.logger.log((Object)"Disabling all machine renders for FPS and lag profiling.");
        } else {
            this.loadModels();
        }
        RenderingRegistry.registerEntityRenderingHandler(EntityRailGunShot.class, (Render)new RenderRailGunShot());
        RenderingRegistry.registerEntityRenderingHandler(EntityExplosiveShell.class, (Render)new RenderRailGunShot());
        RenderingRegistry.registerEntityRenderingHandler(EntityFreezeGunShot.class, (Render)new RenderFreezeGunShot());
        RenderingRegistry.registerEntityRenderingHandler(EntityFlakShot.class, (Render)new RenderFlakShot());
        RenderingRegistry.registerEntityRenderingHandler(EntityIceBlock.class, (Render)new RenderIceBlock());
        RenderingRegistry.registerEntityRenderingHandler(EntitySonicShot.class, (Render)new RenderSonicShot());
        RenderingRegistry.registerEntityRenderingHandler(EntityLiquidBlock.class, (Render)new RenderLiquidBlock());
        RenderingRegistry.registerEntityRenderingHandler(EntityDischarge.class, (Render)new RenderDischarge());
        RenderingRegistry.registerEntityRenderingHandler(EntityCustomTNT.class, (Render)new RenderTNTPrimed());
        this.registerSpriteSheets();
        this.registerBlockSheets();
        MinecraftForgeClient.registerItemRenderer((Item)ItemRegistry.SPAWNER.getItemInstance(), (IItemRenderer)spawner);
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)BlockRegistry.DECOTANK.getBlockInstance()), (IItemRenderer)decotank);
    }

    @Override
    public void addArmorRenders() {
        NVHelmet = RenderingRegistry.addNewArmourRendererPrefix((String)"NVHelmet");
        NVGoggles = RenderingRegistry.addNewArmourRendererPrefix((String)"NVGoggles");
        IOGoggles = RenderingRegistry.addNewArmourRendererPrefix((String)"IOGoggles");
        armor = RenderingRegistry.addNewArmourRendererPrefix((String)"Bedrock");
        SteelArmor = RenderingRegistry.addNewArmourRendererPrefix((String)"HSLA");
        ClientProxy.addArmorTexture(ItemRegistry.JETPACK, "/Reika/RotaryCraft/Textures/Misc/jet.png");
        ClientProxy.addArmorTexture(ItemRegistry.BEDPACK, "/Reika/RotaryCraft/Textures/Misc/bedrock_jet.png");
        ClientProxy.addArmorTexture(ItemRegistry.STEELPACK, "/Reika/RotaryCraft/Textures/Misc/hsla_jet.png");
        ClientProxy.addArmorTexture(ItemRegistry.JUMP, "/Reika/RotaryCraft/Textures/Misc/jump.png");
        ClientProxy.addArmorTexture(ItemRegistry.BEDJUMP, "/Reika/RotaryCraft/Textures/Misc/bedrock_jump.png");
        ClientProxy.addArmorTexture(ItemRegistry.NVG, "/Reika/RotaryCraft/Textures/Misc/NVGoggles.png");
        ClientProxy.addArmorTexture(ItemRegistry.IOGOGGLES, "/Reika/RotaryCraft/Textures/Misc/IOGoggles.png");
        ClientProxy.addArmorTexture(ItemRegistry.BEDHELM, "/Reika/RotaryCraft/Textures/Misc/bedrock_1.png");
        ClientProxy.addArmorTexture(ItemRegistry.BEDREVEAL, "/Reika/RotaryCraft/Textures/Misc/bedreveal.png");
        ClientProxy.addArmorTexture(ItemRegistry.BEDCHEST, "/Reika/RotaryCraft/Textures/Misc/bedrock_1.png");
        ClientProxy.addArmorTexture(ItemRegistry.BEDBOOTS, "/Reika/RotaryCraft/Textures/Misc/bedrock_1.png");
        ClientProxy.addArmorTexture(ItemRegistry.BEDLEGS, "/Reika/RotaryCraft/Textures/Misc/bedrock_2.png");
        ClientProxy.addArmorTexture(ItemRegistry.STEELBOOTS, "/Reika/RotaryCraft/Textures/Misc/steel_1.png");
        ClientProxy.addArmorTexture(ItemRegistry.STEELHELMET, "/Reika/RotaryCraft/Textures/Misc/steel_1.png");
        ClientProxy.addArmorTexture(ItemRegistry.STEELCHEST, "/Reika/RotaryCraft/Textures/Misc/steel_1.png");
        ClientProxy.addArmorTexture(ItemRegistry.STEELLEGS, "/Reika/RotaryCraft/Textures/Misc/steel_2.png");
    }

    private static void addArmorTexture(ItemRegistry item, String tex) {
        RotaryCraft.logger.log((Object)("Adding armor texture for " + (Object)((Object)item) + ": " + tex));
        armorTextures.put(item, new ForcedTextureArmorModel(RotaryCraft.class, tex, item.getArmorType()));
        String[] s = tex.split("/");
        String file = s[s.length - 1];
        String defaultTex = "rotarycraft:textures/models/armor/" + file;
        armorAssets.put(item, defaultTex);
    }

    public static ForcedTextureArmorModel getArmorRenderer(ItemRegistry item) {
        return armorTextures.get((Object)item);
    }

    public static String getArmorTextureAsset(ItemRegistry item) {
        return armorAssets.get((Object)item);
    }

    public void loadModels() {
        int i;
        for (i = 0; i < MachineRegistry.machineList.length; ++i) {
            MachineRegistry m = (MachineRegistry)((Object)MachineRegistry.machineList.get(i));
            if (!m.hasRender() || m.isPipe()) continue;
            RotaryTERenderer render = RotaryRenderList.instantiateRenderer(m);
            ClientRegistry.bindTileEntitySpecialRenderer((Class)m.getTEClass(), (TileEntitySpecialRenderer)render);
        }
        for (i = 0; i < ItemRegistry.itemList.length; ++i) {
            ItemRegistry ir = ItemRegistry.itemList[i];
            if (!ir.isPlacer()) continue;
            MinecraftForgeClient.registerItemRenderer((Item)ir.getItemInstance(), (IItemRenderer)machineItems);
        }
    }

    private void registerBlockSheets() {
    }

    private void registerSpriteSheets() {
        for (int i = 0; i < ItemRegistry.itemList.length; ++i) {
            ItemRegistry ir = ItemRegistry.itemList[i];
            if (ir.isPlacer()) continue;
            if (ir.isMultiSheet()) {
                MinecraftForgeClient.registerItemRenderer((Item)ir.getItemInstance(), (IItemRenderer)multisheets[-ir.getTextureSheet()]);
                continue;
            }
            MinecraftForgeClient.registerItemRenderer((Item)ir.getItemInstance(), (IItemRenderer)items[ir.getTextureSheet()]);
        }
    }

    @Override
    public void initClasses() {
        super.initClasses();
        ReikaJavaLibrary.initClass(HandbookRegistry.class);
        ReikaJavaLibrary.initClass(SoundRegistry.class);
    }

    @Override
    public World getClientWorld() {
        return FMLClientHandler.instance().getClient().field_71441_e;
    }

    @Override
    public void loadDonatorRender() {
        ArrayList donators = new ArrayList();
        donators.addAll(DonatorController.instance.getReikasDonators());
        donators.addAll(PatreonController.instance.getModPatrons("Reika"));
        for (DonatorController.Donator s : donators) {
            if (s.ingameName != null) {
                PlayerSpecificRenderer.instance.registerRenderer(s.ingameName, (PlayerRenderObj)DonatorGearRender.instance);
                continue;
            }
            RotaryCraft.logger.logError((Object)("Donator " + s.displayName + " UUID could not be found! Cannot give special render!"));
        }
    }

    static {
        armorTextures = new HashMap();
        armorAssets = new HashMap();
    }
}

