/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Base.TileEntity;

import Reika.ChromatiCraft.API.Interfaces.WorldRift;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.Java.ReikaArrayHelper;
import Reika.RotaryCraft.API.Power.ShaftMerger;
import Reika.RotaryCraft.Auxiliary.Interfaces.PowerSourceTracker;
import Reika.RotaryCraft.Auxiliary.Interfaces.SimpleProvider;
import Reika.RotaryCraft.Auxiliary.Interfaces.TransmissionReceiver;
import Reika.RotaryCraft.Auxiliary.PowerSourceList;
import Reika.RotaryCraft.Auxiliary.RotaryAux;
import Reika.RotaryCraft.Auxiliary.ShaftPowerEmitter;
import Reika.RotaryCraft.Base.TileEntity.TileEntityIOMachine;
import Reika.RotaryCraft.Base.TileEntity.TileEntityTransmissionMachine;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.PowerReceivers;
import Reika.RotaryCraft.RotaryCraft;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityPowerBus;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityShaft;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntitySplitter;
import java.util.Collection;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityPowerReceiver
extends TileEntityIOMachine {
    public final long MINPOWER;
    public final int MINTORQUE;
    public final int MINSPEED;
    private long prevpower;
    public PowerReceivers machine;
    private long[][] powerin = new long[6][3];

    public TileEntityPowerReceiver() {
        this.machine = PowerReceivers.getEnumFromMachineIndex(this.getMachineIndex());
        if (this.machine == null) {
            this.MINPOWER = 0L;
            this.MINSPEED = 0;
            this.MINTORQUE = 0;
            return;
        }
        if (!this.machine.hasMultiValuedPower()) {
            this.MINPOWER = this.machine.getMinPower();
            this.MINSPEED = this.machine.getMinSpeed();
            this.MINTORQUE = this.machine.getMinTorque();
        } else {
            this.MINPOWER = 0L;
            this.MINSPEED = 0;
            this.MINTORQUE = 0;
        }
    }

    public final long getScaledOmega(int a) {
        return this.MINSPEED > 0 ? (long)Math.min(a, a * this.omega / this.MINSPEED) : (long)(this.omega > 0 ? a : 0);
    }

    public final long getScaledTorque(int a) {
        return this.MINTORQUE > 0 ? (long)Math.min(a, a * this.torque / this.MINTORQUE) : (long)(this.torque > 0 ? a : 0);
    }

    public final long getScaledPower(int a) {
        return this.MINPOWER > 0L ? Math.min((long)a, (long)a * this.power / this.MINPOWER) : (long)(this.power > 0L ? a : 0);
    }

    @Override
    public void updateTileEntity() {
        super.updateTileEntity();
        if (this.MINPOWER == -1L) {
            RotaryCraft.logger.logError((Object)(this.getName() + " has not registered its power!"));
            ReikaChatHelper.write((Object)(this.getName() + " has not registered its power!"));
        }
    }

    private void clear() {
        for (int i = 0; i < this.powerin.length; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.powerin[i][j] = 0L;
            }
        }
    }

    public long[] returnHighest() {
        long[] val = new long[3];
        for (int i = 0; i < this.powerin.length; ++i) {
            if (this.powerin[i][0] <= val[0]) continue;
            for (int j = 0; j < 3; ++j) {
                val[j] = this.powerin[i][j];
            }
        }
        return val;
    }

    public void getIOSidesDefault(World world, int x, int y, int z, int metadata) {
        switch (metadata) {
            case 0: {
                this.read = ForgeDirection.EAST;
                break;
            }
            case 1: {
                this.read = ForgeDirection.WEST;
                break;
            }
            case 2: {
                this.read = ForgeDirection.SOUTH;
                break;
            }
            case 3: {
                this.read = ForgeDirection.NORTH;
                break;
            }
            case 4: {
                this.read = ForgeDirection.DOWN;
                break;
            }
            case 5: {
                this.read = ForgeDirection.UP;
            }
        }
    }

    private void readFromCross(TileEntityShaft cross, int slot) {
        if (cross.isWritingTo(this)) {
            this.powerin[slot][2] = cross.readomega[0];
            this.powerin[slot][1] = cross.readtorque[0];
            this.powerin[slot][0] = this.powerin[slot][1] * this.powerin[slot][2];
        } else if (cross.isWritingTo2(this)) {
            this.powerin[slot][2] = cross.readomega[1];
            this.powerin[slot][1] = cross.readtorque[1];
            this.powerin[slot][0] = this.powerin[slot][1] * this.powerin[slot][2];
        } else {
            return;
        }
    }

    protected void readFromSplitter(World world, int x, int y, int z, TileEntitySplitter spl, int slot) {
        int ratio = spl.getRatioFromMode();
        if (ratio == 0) {
            return;
        }
        boolean favorbent = false;
        if (ratio < 0) {
            favorbent = true;
            ratio = -ratio;
        }
        if (x == spl.getWriteX() && z == spl.getWriteZ()) {
            this.powerin[slot][2] = spl.omega;
            if (ratio == 1) {
                this.powerin[slot][1] = spl.torque / 2;
                this.powerin[slot][0] = spl.omega * spl.torque / 2;
                return;
            }
            this.powerin[slot][1] = favorbent ? (long)(spl.torque / ratio) : (long)((int)((double)spl.torque * (((double)ratio - 1.0) / (double)ratio)));
            this.powerin[slot][0] = this.powerin[slot][1] * this.powerin[slot][2];
        } else if (x == spl.getWriteX2() && z == spl.getWriteZ2()) {
            this.powerin[slot][2] = spl.omega;
            if (ratio == 1) {
                this.powerin[slot][1] = spl.torque / 2;
                this.powerin[slot][0] = spl.omega * spl.torque / 2;
                return;
            }
            this.powerin[slot][1] = favorbent ? (long)((int)((double)spl.torque * (((double)ratio - 1.0) / (double)ratio))) : (long)(spl.torque / ratio);
            this.powerin[slot][0] = this.powerin[slot][1] * this.powerin[slot][2];
        } else {
            this.powerin[slot][0] = 0L;
            this.powerin[slot][1] = 0L;
            this.powerin[slot][2] = 0L;
            return;
        }
    }

    protected final void getPower(boolean doubleSided) {
        this.getPower(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, doubleSided);
    }

    private void getPower(World world, int x, int y, int z, boolean doubleSided) {
        WorldLocation loc;
        WorldRift sr;
        ShaftPowerEmitter sp;
        ForgeDirection dir;
        TileEntityPowerBus pwr;
        TileEntityTransmissionMachine devicein;
        TileEntity te;
        if (this.field_145850_b.field_72995_K && !RotaryAux.getPowerOnClient) {
            return;
        }
        this.clear();
        boolean isCentered = x == this.field_145851_c && y == this.field_145848_d && z == this.field_145849_e;
        int dx = x + this.read.offsetX;
        int dy = y + this.read.offsetY;
        int dz = z + this.read.offsetZ;
        MachineRegistry m = isCentered ? this.getMachine(this.read) : MachineRegistry.getMachine((IBlockAccess)world, dx, dy, dz);
        TileEntity tileEntity = te = isCentered ? this.getAdjacentTileEntity(this.read) : world.func_147438_o(dx, dy, dz);
        if (this.isProvider(te)) {
            if (m == MachineRegistry.SHAFT) {
                devicein = (TileEntityShaft)te;
                if (((TileEntityShaft)devicein).isCross()) {
                    this.readFromCross((TileEntityShaft)devicein, 0);
                    this.torquein = (int)this.powerin[0][1];
                    this.omegain = (int)this.powerin[0][2];
                } else if (devicein.isWritingTo(this)) {
                    this.torquein = ((TileEntityShaft)devicein).torque;
                    this.omegain = ((TileEntityShaft)devicein).omega;
                }
            }
            if (m == MachineRegistry.POWERBUS) {
                pwr = (TileEntityPowerBus)te;
                dir = this.read.getOpposite();
                this.omegain = pwr.getSpeedToSide(dir);
                this.torquein = pwr.getTorqueToSide(dir);
            }
            if (te instanceof SimpleProvider) {
                this.copyStandardPower(te);
            }
            if (te instanceof ShaftPowerEmitter && (sp = (ShaftPowerEmitter)te).isEmitting() && sp.canWriteTo(this.read.getOpposite())) {
                this.torquein = sp.getTorque();
                this.omegain = sp.getOmega();
            }
            if (m == MachineRegistry.SPLITTER) {
                devicein = (TileEntitySplitter)te;
                if (((TileEntitySplitter)devicein).isSplitting()) {
                    this.readFromSplitter(world, x, y, z, (TileEntitySplitter)devicein, 0);
                    this.torquein = (int)this.powerin[0][1];
                    this.omegain = (int)this.powerin[0][2];
                } else if (devicein.isWritingTo(this)) {
                    this.torquein = ((TileEntitySplitter)devicein).torque;
                    this.omegain = ((TileEntitySplitter)devicein).omega;
                } else {
                    this.omegain = 0;
                    this.torquein = 0;
                }
            }
            this.powerin[0][0] = (long)this.torquein * (long)this.omegain;
            this.powerin[0][1] = this.torquein;
            this.powerin[0][2] = this.omegain;
        } else if (te instanceof WorldRift) {
            sr = (WorldRift)te;
            loc = sr.getLinkTarget();
            if (loc != null) {
                this.getPower(loc.getWorld(), loc.xCoord, loc.yCoord, loc.zCoord, doubleSided);
            } else {
                this.omegain = 0;
                this.torquein = 0;
            }
        } else {
            this.torquein = 0;
            this.omegain = 0;
        }
        if (!doubleSided) {
            this.torque = this.torquein;
            this.omega = this.omegain;
            this.power = (long)this.omega * (long)this.torque;
            if (this.power != this.prevpower) {
                this.prevpower = this.power;
            }
            return;
        }
        this.torquein = 0;
        this.omegain = 0;
        dx = x + this.read2.offsetX;
        dy = y + this.read2.offsetY;
        dz = z + this.read2.offsetZ;
        m = isCentered ? this.getMachine(this.read2) : MachineRegistry.getMachine((IBlockAccess)world, dx, dy, dz);
        TileEntity tileEntity2 = te = isCentered ? this.getAdjacentTileEntity(this.read2) : world.func_147438_o(dx, dy, dz);
        if (this.isProvider(te)) {
            if (m == MachineRegistry.SHAFT) {
                devicein = (TileEntityShaft)te;
                if (((TileEntityShaft)devicein).isCross()) {
                    this.readFromCross((TileEntityShaft)devicein, 1);
                    this.torquein = (int)this.powerin[1][1];
                    this.omegain = (int)this.powerin[1][2];
                }
                if (devicein.isWritingTo(this)) {
                    this.torquein = ((TileEntityShaft)devicein).torque;
                    this.omegain = ((TileEntityShaft)devicein).omega;
                }
            }
            if (m == MachineRegistry.POWERBUS) {
                pwr = (TileEntityPowerBus)te;
                dir = this.read2.getOpposite();
                this.omegain = pwr.getSpeedToSide(dir);
                this.torquein = pwr.getTorqueToSide(dir);
            }
            if (te instanceof SimpleProvider) {
                this.copyStandardPower(te);
            }
            if (te instanceof ShaftPowerEmitter && (sp = (ShaftPowerEmitter)te).isEmitting() && sp.canWriteTo(this.read2.getOpposite())) {
                this.torquein = sp.getTorque();
                this.omegain = sp.getOmega();
            }
            if (m == MachineRegistry.SPLITTER) {
                devicein = (TileEntitySplitter)te;
                if (((TileEntitySplitter)devicein).isSplitting()) {
                    this.readFromSplitter(world, x, y, z, (TileEntitySplitter)devicein, 1);
                    this.torquein = (int)this.powerin[1][1];
                    this.omegain = (int)this.powerin[1][2];
                } else if (devicein.isWritingTo(this)) {
                    this.torquein = ((TileEntitySplitter)devicein).torque;
                    this.omegain = ((TileEntitySplitter)devicein).omega;
                } else {
                    this.omegain = 0;
                    this.torquein = 0;
                }
            }
            this.powerin[1][0] = (long)this.torquein * (long)this.omegain;
            this.powerin[1][1] = this.torquein;
            this.powerin[1][2] = this.omegain;
        } else if (te instanceof WorldRift) {
            sr = (WorldRift)te;
            loc = sr.getLinkTarget();
            if (loc != null) {
                this.getPower(loc.getWorld(), loc.xCoord, loc.yCoord, loc.zCoord, doubleSided);
            } else {
                this.omegain = 0;
                this.torquein = 0;
            }
        } else {
            this.torquein = 0;
            this.omegain = 0;
        }
        long[] powers = this.returnHighest();
        this.torque = (int)powers[1];
        this.omega = (int)powers[2];
        this.power = (long)this.torque * (long)this.omega;
        if (this.power != this.prevpower) {
            this.prevpower = this.power;
        }
    }

    protected final void getOffsetPower4Sided(int stepx, int stepy, int stepz, boolean vertical) {
        this.getOffsetPower4Sided(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, stepx, stepy, stepz, vertical);
    }

    private void getOffsetPower4Sided(World world, int x, int y, int z, int stepx, int stepy, int stepz, boolean vertical) {
        int i;
        if (this.field_145850_b.field_72995_K && !RotaryAux.getPowerOnClient) {
            return;
        }
        this.setPointingOffset(stepx, stepy, stepz);
        boolean isCentered = x == this.field_145851_c && y == this.field_145848_d && z == this.field_145849_e;
        this.isOmniSided = vertical;
        if (!this.isOmniSided) {
            this.read = ForgeDirection.EAST;
            this.read2 = ForgeDirection.WEST;
            this.read3 = ForgeDirection.SOUTH;
            this.read4 = ForgeDirection.NORTH;
        }
        int n = i = vertical ? 0 : 2;
        while (i < 6) {
            ForgeDirection in = this.dirs[i];
            int x1 = x + stepx + in.offsetX;
            int y1 = y + stepy + in.offsetY;
            int z1 = z + stepz + in.offsetZ;
            MachineRegistry id1 = MachineRegistry.getMachine((IBlockAccess)world, x1, y1, z1);
            TileEntity te1 = this.getTileEntity(x1, y1, z1);
            if (this.isProvider(te1)) {
                ShaftPowerEmitter sp;
                TileEntityTransmissionMachine devicein;
                if (id1 == MachineRegistry.SHAFT) {
                    devicein = (TileEntityShaft)te1;
                    if (((TileEntityShaft)devicein).isCross()) {
                        this.readFromCross((TileEntityShaft)devicein, 0);
                        this.torquein = (int)this.powerin[0][1];
                        this.omegain = (int)this.powerin[0][2];
                    } else if (devicein.isWritingTo(this)) {
                        this.torquein = ((TileEntityShaft)devicein).torque;
                        this.omegain = ((TileEntityShaft)devicein).omega;
                    }
                }
                if (id1 == MachineRegistry.POWERBUS) {
                    TileEntityPowerBus pwr = (TileEntityPowerBus)te1;
                    ForgeDirection dir = in.getOpposite();
                    this.omegain = pwr.getSpeedToSide(dir);
                    this.torquein = pwr.getTorqueToSide(dir);
                }
                if (te1 instanceof SimpleProvider) {
                    this.copyStandardPower(te1);
                }
                if (te1 instanceof ShaftPowerEmitter && (sp = (ShaftPowerEmitter)te1).isEmitting() && sp.canWriteTo(in.getOpposite())) {
                    this.torquein = sp.getTorque();
                    this.omegain = sp.getOmega();
                }
                if (id1 == MachineRegistry.SPLITTER) {
                    devicein = (TileEntitySplitter)te1;
                    if (((TileEntitySplitter)devicein).isSplitting()) {
                        this.readFromSplitter(world, x, y, z, (TileEntitySplitter)devicein, 0);
                        this.torquein = (int)this.powerin[0][1];
                        this.omegain = (int)this.powerin[0][2];
                    } else if (devicein.isWritingTo(this)) {
                        this.torquein = ((TileEntitySplitter)devicein).torque;
                        this.omegain = ((TileEntitySplitter)devicein).omega;
                    } else {
                        this.omegain = 0;
                        this.torquein = 0;
                    }
                }
            } else if (te1 instanceof WorldRift) {
                WorldRift sr = (WorldRift)te1;
                WorldLocation loc = sr.getLinkTarget();
                if (loc != null) {
                    this.getPower(loc.getWorld(), loc.xCoord, loc.yCoord, loc.zCoord, false);
                } else {
                    this.omega = 0;
                    this.torque = 0;
                }
                this.torquein = this.torque;
                this.omegain = this.omega;
                this.torque = 0;
                this.omega = 0;
                this.power = 0L;
            }
            this.powerin[i][0] = this.torquein * this.omegain;
            this.powerin[i][1] = this.torquein;
            this.powerin[i][2] = this.omegain;
            this.torquein = 0;
            this.omegain = 0;
            ++i;
        }
        long[] powers = this.returnHighest();
        this.torque = (int)powers[1];
        this.omega = (int)powers[2];
        this.power = (long)this.torque * (long)this.omega;
        if (this.power != this.prevpower) {
            this.prevpower = this.power;
        }
    }

    protected final void getPowerBelow() {
        this.read = ForgeDirection.DOWN;
        this.getPower(false);
    }

    protected final void getPowerAbove() {
        this.read = ForgeDirection.UP;
        this.getPower(false);
    }

    protected final void getSummativeSidedPower() {
        int i;
        this.isOmniSided = true;
        if (this.field_145850_b.field_72995_K && !RotaryAux.getPowerOnClient) {
            return;
        }
        int x = this.field_145851_c;
        int y = this.field_145848_d;
        int z = this.field_145849_e;
        long[][] powers = new long[2][6];
        if (this.getMachine().getMinY(this) == 0.0f) {
            this.getPowerBelow();
            powers[0][0] = this.omega;
            powers[1][0] = this.torque;
        }
        if (this.getMachine().getMaxY(this) == 1.0f) {
            this.getPowerAbove();
            powers[0][1] = this.omega;
            powers[1][1] = this.torque;
        }
        this.read = ForgeDirection.EAST;
        if (this.getMachine().getMaxX(this) == 1.0f) {
            this.getPower(false);
            powers[0][2] = this.omega;
            powers[1][2] = this.torque;
        }
        this.read = ForgeDirection.WEST;
        if (this.getMachine().getMinX(this) == 0.0f) {
            this.getPower(false);
            powers[0][3] = this.omega;
            powers[1][3] = this.torque;
        }
        this.read = ForgeDirection.SOUTH;
        if (this.getMachine().getMaxZ(this) == 1.0f) {
            this.getPower(false);
            powers[0][4] = this.omega;
            powers[1][4] = this.torque;
        }
        this.read = ForgeDirection.NORTH;
        if (this.getMachine().getMinZ(this) == 0.0f) {
            this.getPower(false);
            powers[0][5] = this.omega;
            powers[1][5] = this.torque;
        }
        this.read = null;
        this.torque = 0;
        this.omega = 0;
        this.power = 0L;
        boolean unequal = false;
        boolean bl = unequal = !ReikaArrayHelper.allNonZerosEqual((long[])powers[0]);
        if (unequal) {
            this.field_145850_b.func_72869_a("crit", (double)((float)x + rand.nextFloat()), (double)((float)y + rand.nextFloat()), (double)((float)z + rand.nextFloat()), (double)(rand.nextFloat() / 2.0f), (double)rand.nextFloat(), (double)(rand.nextFloat() / 2.0f));
            if (rand.nextInt(5) == 0) {
                this.field_145850_b.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "mob.blaze.hit", 1.0f, 1.0f);
            }
            if (this.power != this.prevpower) {
                this.prevpower = this.power;
            }
            return;
        }
        for (i = 0; powers[0][i] == 0L && i < 5; ++i) {
        }
        this.omega = (int)powers[0][i];
        this.torque = (int)ReikaArrayHelper.sumArray((long[])powers[1]);
        this.power = (long)this.omega * (long)this.torque;
        if (this.power != this.prevpower) {
            this.prevpower = this.power;
        }
    }

    @Override
    public boolean canProvidePower() {
        return false;
    }

    @Override
    public PowerSourceList getPowerSources(PowerSourceTracker io, ShaftMerger caller) {
        PowerSourceList pwr = new PowerSourceList();
        if (this.isOmniSided) {
            for (int i = 0; i < 6; ++i) {
                ForgeDirection dir = this.dirs[i];
                pwr.addAll(PowerSourceList.getAllFrom(this.field_145850_b, dir, this.field_145851_c + dir.offsetX + this.getPointingOffsetX(), this.field_145848_d + dir.offsetY + this.getPointingOffsetY(), this.field_145849_e + dir.offsetZ + this.getPointingOffsetZ(), this, caller));
            }
        } else {
            if (this.read != null) {
                pwr.addAll(PowerSourceList.getAllFrom(this.field_145850_b, this.read, this.field_145851_c + this.read.offsetX + this.getPointingOffsetX(), this.field_145848_d + this.read.offsetY + this.getPointingOffsetY(), this.field_145849_e + this.read.offsetZ + this.getPointingOffsetZ(), this, caller));
            }
            if (this.read2 != null) {
                pwr.addAll(PowerSourceList.getAllFrom(this.field_145850_b, this.read2, this.field_145851_c + this.read2.offsetX + this.getPointingOffsetX(), this.field_145848_d + this.read2.offsetY + this.getPointingOffsetY(), this.field_145849_e + this.read2.offsetZ + this.getPointingOffsetZ(), this, caller));
            }
            if (this.read3 != null) {
                pwr.addAll(PowerSourceList.getAllFrom(this.field_145850_b, this.read3, this.field_145851_c + this.read3.offsetX + this.getPointingOffsetX(), this.field_145848_d + this.read3.offsetY + this.getPointingOffsetY(), this.field_145849_e + this.read3.offsetZ + this.getPointingOffsetZ(), this, caller));
            }
            if (this.read4 != null) {
                pwr.addAll(PowerSourceList.getAllFrom(this.field_145850_b, this.read4, this.field_145851_c + this.read4.offsetX + this.getPointingOffsetX(), this.field_145848_d + this.read4.offsetY + this.getPointingOffsetY(), this.field_145849_e + this.read4.offsetZ + this.getPointingOffsetZ(), this, caller));
            }
        }
        return pwr;
    }

    @Override
    public final void getAllOutputs(Collection<TileEntity> c, ForgeDirection dir) {
        if (this instanceof TransmissionReceiver) {
            ((TransmissionReceiver)((Object)this)).getOutputs(c, dir);
        }
    }
}

