/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Auxiliary;

import Reika.DragonAPI.Instantiable.Data.Collections.OneWayCollections;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.MekToolHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.RedstoneArsenalHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.TinkerToolHandler;
import Reika.RotaryCraft.API.Interfaces.EnvironmentalHeatSource;
import Reika.RotaryCraft.Base.TileEntity.RotaryCraftTileEntity;
import Reika.RotaryCraft.Base.TileEntity.TileEntityEngine;
import Reika.RotaryCraft.GuiHandler;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.GuiRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.RotaryCraft;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntitySplitter;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.awt.Color;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class RotaryAux {
    public static int blockModel;
    public static final Color[] sideColors;
    public static final String[] sideColorNames;
    public static final boolean getPowerOnClient;
    private static Set<Class<? extends TileEntity>> shaftPowerBlacklist;

    public static boolean isBlacklistedIOMachine(TileEntity te) {
        return shaftPowerBlacklist.contains(te.getClass());
    }

    private static void addShaftBlacklist(String name) {
        try {
            Class<?> cl = Class.forName(name);
            shaftPowerBlacklist.add(cl);
            RotaryCraft.logger.log((Object)("Disabling " + name + " for shaft power. Destructive compatibility."));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static final boolean hasGui(World world, int x, int y, int z, EntityPlayer ep) {
        Object GUI;
        MachineRegistry m = MachineRegistry.getMachine((IBlockAccess)world, x, y, z);
        if (m == MachineRegistry.ENGINE) {
            TileEntityEngine te = (TileEntityEngine)world.func_147438_o(x, y, z);
            if (te == null) {
                return false;
            }
            if (te.getEngineType() == null) {
                return false;
            }
            return te.getEngineType().hasGui();
        }
        if (m == MachineRegistry.SPLITTER) {
            TileEntitySplitter te = (TileEntitySplitter)world.func_147438_o(x, y, z);
            return te.func_145832_p() >= 8;
        }
        if (m == MachineRegistry.SCREEN) {
            return !ep.func_70093_af();
        }
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && (GUI = GuiHandler.instance.getClientGuiElement(GuiRegistry.MACHINE.ordinal(), ep, world, x, y, z)) != null) {
            return true;
        }
        return FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER && (GUI = GuiHandler.instance.getServerGuiElement(GuiRegistry.MACHINE.ordinal(), ep, world, x, y, z)) != null;
    }

    public static int get4SidedMetadataFromPlayerLook(EntityLivingBase ep) {
        int i;
        for (i = MathHelper.func_76128_c((double)((double)(ep.field_70177_z * 4.0f / 360.0f) + 0.5)); i > 3; i -= 4) {
        }
        while (i < 0) {
            i += 4;
        }
        switch (i) {
            case 0: {
                return 2;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 0;
            }
        }
        return -1;
    }

    public static int get6SidedMetadataFromPlayerLook(EntityLivingBase ep) {
        if (MathHelper.func_76135_e((float)ep.field_70125_A) < 60.0f) {
            int i;
            for (i = MathHelper.func_76128_c((double)((double)(ep.field_70177_z * 4.0f / 360.0f) + 0.5)); i > 3; i -= 4) {
            }
            while (i < 0) {
                i += 4;
            }
            switch (i) {
                case 0: {
                    return 2;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 3;
                }
                case 3: {
                    return 0;
                }
            }
        } else {
            if (ep.field_70125_A > 0.0f) {
                return 4;
            }
            return 5;
        }
        return -1;
    }

    public static int get2SidedMetadataFromPlayerLook(EntityLivingBase ep) {
        int i;
        for (i = MathHelper.func_76128_c((double)((double)(ep.field_70177_z * 4.0f / 360.0f) + 0.5)); i > 3; i -= 4) {
        }
        while (i < 0) {
            i += 4;
        }
        switch (i) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 1;
            }
        }
        return -1;
    }

    public static void flipXMetadatas(TileEntity t) {
        if (!(t instanceof RotaryCraftTileEntity)) {
            return;
        }
        RotaryCraftTileEntity te = (RotaryCraftTileEntity)t;
        int m = te.func_145832_p();
        switch (m) {
            case 0: {
                te.setBlockMetadata(1);
                break;
            }
            case 1: {
                te.setBlockMetadata(0);
            }
        }
    }

    public static void flipZMetadatas(TileEntity t) {
        if (!(t instanceof RotaryCraftTileEntity)) {
            return;
        }
        RotaryCraftTileEntity te = (RotaryCraftTileEntity)t;
        int m = te.func_145832_p();
        switch (m) {
            case 2: {
                te.setBlockMetadata(3);
                break;
            }
            case 3: {
                te.setBlockMetadata(2);
            }
        }
    }

    public static boolean canHarvestSteelMachine(EntityPlayer ep) {
        if (ep.field_71075_bZ.field_75098_d) {
            return false;
        }
        ItemStack eitem = ep.field_71071_by.func_70448_g();
        if (eitem == null) {
            return false;
        }
        if (TinkerToolHandler.getInstance().isHammer(eitem)) {
            return false;
        }
        if (TinkerToolHandler.getInstance().isPick(eitem) && TinkerToolHandler.getInstance().isStoneOrBetter(eitem)) {
            return true;
        }
        if (MekToolHandler.getInstance().isPickTypeTool(eitem) && !MekToolHandler.getInstance().isWood(eitem)) {
            return true;
        }
        if (eitem.func_77973_b() == RedstoneArsenalHandler.getInstance().pickID) {
            return RedstoneArsenalHandler.getInstance().pickLevel > 0;
        }
        return eitem.func_77973_b().canHarvestBlock(Blocks.field_150366_p, eitem);
    }

    public static boolean shouldSetFlipped(World world, int x, int y, int z) {
        boolean softBelow = ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)x, (int)(y - 1), (int)z);
        boolean softAbove = ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)x, (int)(y + 1), (int)z);
        return !softAbove && softBelow;
    }

    public static String getMessage(String tag) {
        return StatCollector.func_74838_a((String)("message." + tag));
    }

    public static void writeMessage(String tag) {
        ReikaChatHelper.writeString((String)RotaryAux.getMessage(tag));
    }

    public static boolean isMuffled(TileEntity te) {
        World world = te.field_145850_b;
        int x = te.field_145851_c;
        int y = te.field_145848_d;
        int z = te.field_145849_e;
        return ReikaWorldHelper.getMaterial((World)world, (int)x, (int)(y + 1), (int)z) == Material.field_151580_n && ReikaWorldHelper.getMaterial((World)world, (int)x, (int)(y - 1), (int)z) == Material.field_151580_n;
    }

    public static boolean isNextToIce(World world, int x, int y, int z) {
        if (ReikaWorldHelper.checkForAdjMaterial((World)world, (int)x, (int)y, (int)z, (Material)Material.field_151588_w) != null) {
            return true;
        }
        Block b = world.func_147439_a(x, y - 1, z);
        if (b instanceof EnvironmentalHeatSource) {
            EnvironmentalHeatSource ehs = (EnvironmentalHeatSource)b;
            return ehs.isActive((IBlockAccess)world, x, y, z) && ehs.getSourceType((IBlockAccess)world, x, y, z).isCold();
        }
        return false;
    }

    public static boolean isNextToWater(World world, int x, int y, int z) {
        if (ReikaWorldHelper.checkForAdjMaterial((World)world, (int)x, (int)y, (int)z, (Material)Material.field_151586_h) != null) {
            return true;
        }
        for (int i = 1; i <= 2; ++i) {
            Block b = world.func_147439_a(x, y - i, z);
            if (!(b instanceof EnvironmentalHeatSource)) continue;
            EnvironmentalHeatSource ehs = (EnvironmentalHeatSource)b;
            return ehs.isActive((IBlockAccess)world, x, y - i, z) && ehs.getSourceType((IBlockAccess)world, x, y - i, z) == EnvironmentalHeatSource.SourceType.WATER;
        }
        return false;
    }

    public static boolean isNextToFire(World world, int x, int y, int z) {
        if (ReikaWorldHelper.checkForAdjBlock((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150480_ab) != null) {
            return true;
        }
        for (int i = 1; i <= 2; ++i) {
            Block b = world.func_147439_a(x, y - i, z);
            if (!(b instanceof EnvironmentalHeatSource)) continue;
            EnvironmentalHeatSource ehs = (EnvironmentalHeatSource)b;
            return ehs.isActive((IBlockAccess)world, x, y - i, z) && ehs.getSourceType((IBlockAccess)world, x, y - i, z) == EnvironmentalHeatSource.SourceType.FIRE;
        }
        return false;
    }

    public static boolean isNextToLava(World world, int x, int y, int z) {
        if (ReikaWorldHelper.checkForAdjMaterial((World)world, (int)x, (int)y, (int)z, (Material)Material.field_151587_i) != null) {
            return true;
        }
        for (int i = 1; i <= 2; ++i) {
            Block b = world.func_147439_a(x, y - i, z);
            if (!(b instanceof EnvironmentalHeatSource)) continue;
            EnvironmentalHeatSource ehs = (EnvironmentalHeatSource)b;
            return ehs.isActive((IBlockAccess)world, x, y - i, z) && ehs.getSourceType((IBlockAccess)world, x, y - i, z) == EnvironmentalHeatSource.SourceType.LAVA;
        }
        return false;
    }

    public static boolean isAboveFire(World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y - 1, z);
        if (b == Blocks.field_150480_ab) {
            return true;
        }
        for (int i = 1; i <= 2; ++i) {
            b = world.func_147439_a(x, y - i, z);
            if (!(b instanceof EnvironmentalHeatSource)) continue;
            EnvironmentalHeatSource ehs = (EnvironmentalHeatSource)b;
            return ehs.isActive((IBlockAccess)world, x, y - i, z) && ehs.getSourceType((IBlockAccess)world, x, y - i, z) == EnvironmentalHeatSource.SourceType.FIRE;
        }
        return false;
    }

    public static boolean isAboveLava(World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y - 1, z);
        if (b.func_149688_o() == Material.field_151587_i) {
            return true;
        }
        for (int i = 1; i <= 2; ++i) {
            b = world.func_147439_a(x, y - i, z);
            if (!(b instanceof EnvironmentalHeatSource)) continue;
            EnvironmentalHeatSource ehs = (EnvironmentalHeatSource)b;
            return ehs.isActive((IBlockAccess)world, x, y - i, z) && ehs.getSourceType((IBlockAccess)world, x, y - i, z) == EnvironmentalHeatSource.SourceType.LAVA;
        }
        return false;
    }

    static {
        sideColors = new Color[]{Color.CYAN, Color.BLUE, Color.YELLOW, Color.BLACK, new Color(255, 120, 0), Color.MAGENTA};
        sideColorNames = new String[]{"CYAN", "BLUE", "YELLOW", "BLACK", "ORANGE", "MAGENTA"};
        getPowerOnClient = ConfigRegistry.POWERCLIENT.getState();
        shaftPowerBlacklist = new OneWayCollections.OneWaySet();
    }
}

