/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Auxiliary.RecipeManagers;

import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Magic.ItemElementCalculator;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaRecipeHelper;
import Reika.DragonAPI.ModList;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipeHandler;
import Reika.RotaryCraft.Auxiliary.RecyclingRecipe;
import Reika.RotaryCraft.Base.ItemBlockPlacer;
import Reika.RotaryCraft.Registry.MachineRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.world.World;

public class WorktableRecipes
extends RecipeHandler {
    private static final WorktableRecipes instance = new WorktableRecipes();
    private ArrayList<WorktableRecipe> recipes = new ArrayList();
    private ArrayList<IRecipe> display = new ArrayList();
    private final RecipeSorter sorter = new RecipeSorter();

    public static final WorktableRecipes getInstance() {
        return instance;
    }

    public void addAPIRecipe(IRecipe recipe) {
        this.addRecipe(recipe, RecipeHandler.RecipeLevel.API);
    }

    public void addRecyclingRecipe(RecyclingRecipe recipe) {
        this.addRecipe(recipe, RecipeHandler.RecipeLevel.PERIPHERAL);
    }

    public void addRecipe(IRecipe recipe, RecipeHandler.RecipeLevel rl) {
        WorktableRecipe wr = new WorktableRecipe(recipe);
        this.recipes.add(wr);
        this.display.add(recipe);
        super.onAddRecipe(wr, rl);
    }

    private WorktableRecipes() {
        super(MachineRegistry.WORKTABLE);
    }

    public ShapedRecipes addAPIRecipe(ItemStack output, Object ... items) {
        return this.addRecipe(output, RecipeHandler.RecipeLevel.API, items);
    }

    public ShapedRecipes addRecipe(ItemStack output, RecipeHandler.RecipeLevel rl, Object ... items) {
        String s = "";
        int i = 0;
        int j = 0;
        int k = 0;
        if (items[i] == null || items[i] instanceof ItemStack && ((ItemStack)items[i]).func_77973_b() == null) {
            throw new IllegalArgumentException("Null item in recipe! Possible mod conflict?");
        }
        if (items[i] instanceof String[]) {
            String[] astring = (String[])items[i++];
            for (int l = 0; l < astring.length; ++l) {
                String s1 = astring[l];
                ++k;
                j = s1.length();
                s = s + s1;
            }
        } else {
            while (items[i] instanceof String) {
                String s2 = (String)items[i++];
                ++k;
                j = s2.length();
                s = s + s2;
            }
        }
        HashMap<Character, ItemStack> hashmap = new HashMap<Character, ItemStack>();
        while (i < items.length) {
            Character character = (Character)items[i];
            ItemStack itemstack1 = null;
            if (items[i + 1] instanceof Item) {
                itemstack1 = new ItemStack((Item)items[i + 1]);
            } else if (items[i + 1] instanceof Block) {
                itemstack1 = new ItemStack((Block)items[i + 1], 1, Short.MAX_VALUE);
            } else if (items[i + 1] instanceof ItemStack) {
                itemstack1 = (ItemStack)items[i + 1];
            } else if (items[i + 1] == null || items[i + 1] instanceof ItemStack && ((ItemStack)items[i + 1]).func_77973_b() == null) {
                throw new IllegalArgumentException("Null item in recipe! Possible mod conflict?");
            }
            hashmap.put(character, itemstack1);
            i += 2;
        }
        ItemStack[] aitemstack = new ItemStack[j * k];
        for (int i1 = 0; i1 < j * k; ++i1) {
            char c0 = s.charAt(i1);
            aitemstack[i1] = hashmap.containsKey(Character.valueOf(c0)) ? ((ItemStack)hashmap.get(Character.valueOf(c0))).func_77946_l() : null;
        }
        ShapedRecipes shapedrecipes = new ShapedRecipes(j, k, aitemstack, output);
        this.addRecipe((IRecipe)shapedrecipes, rl);
        return shapedrecipes;
    }

    public void addShapelessAPIRecipe(ItemStack output, Object ... items) {
        this.addShapelessRecipe(output, RecipeHandler.RecipeLevel.API, items);
    }

    public void addShapelessRecipe(ItemStack output, RecipeHandler.RecipeLevel rl, Object ... items) {
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        Object[] aobject = items;
        int i = items.length;
        for (int j = 0; j < i; ++j) {
            Object object1 = aobject[j];
            if (object1 == null) {
                throw new IllegalArgumentException("Null item in recipe! Possible mod conflict?");
            }
            if (object1 instanceof ItemStack) {
                if (((ItemStack)object1).func_77973_b() == null) {
                    throw new IllegalArgumentException("Null item in recipe! Possible mod conflict?");
                }
                li.add(((ItemStack)object1).func_77946_l());
                continue;
            }
            if (object1 instanceof Item) {
                li.add(new ItemStack((Item)object1));
                continue;
            }
            if (!(object1 instanceof Block)) {
                throw new RuntimeException("Invalid shapeless recipe!");
            }
            li.add(new ItemStack((Block)object1));
        }
        this.addRecipe((IRecipe)new ShapelessRecipes(output, li), rl);
    }

    public WorktableRecipe findMatchingRecipe(InventoryCrafting ic, World world) {
        int i = 0;
        ItemStack is = null;
        ItemStack is1 = null;
        for (int j = 0; j < ic.func_70302_i_(); ++j) {
            ItemStack is2 = ic.func_70301_a(j);
            if (is2 == null) continue;
            if (i == 0) {
                is = is2;
            }
            if (i == 1) {
                is1 = is2;
            }
            ++i;
        }
        for (WorktableRecipe wr : this.recipes) {
            IRecipe ir = wr.recipe;
            if (!ir.func_77569_a(ic, world)) continue;
            return wr;
        }
        return null;
    }

    public List<WorktableRecipe> getRecipeListCopy() {
        return Collections.unmodifiableList(this.recipes);
    }

    @SideOnly(value=Side.CLIENT)
    public List<IRecipe> getDisplayList() {
        return Collections.unmodifiableList(this.display);
    }

    public IRecipe getInputRecipe(ItemStack is) {
        for (WorktableRecipe wr : this.recipes) {
            IRecipe ir = wr.recipe;
            ItemStack is2 = ir.func_77571_b();
            if (!ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)is2) || is.field_77994_a < is2.field_77994_a) continue;
            return ir;
        }
        return null;
    }

    @Override
    public void addPostLoadRecipes() {
    }

    @Override
    protected boolean removeRecipe(RecipeHandler.MachineRecipe recipe) {
        return this.recipes.remove(recipe) && this.display.remove(((WorktableRecipe)recipe).recipe);
    }

    private static class RecipeSorter
    implements Comparator<WorktableRecipe> {
        private RecipeSorter() {
        }

        @Override
        public int compare(WorktableRecipe ir, WorktableRecipe ir2) {
            return ir.recipe instanceof ShapelessRecipes && ir2.recipe instanceof ShapedRecipes ? 1 : (ir2.recipe instanceof ShapelessRecipes && ir.recipe instanceof ShapedRecipes ? -1 : (ir2.recipe.func_77570_a() < ir.recipe.func_77570_a() ? -1 : (ir2.recipe.func_77570_a() > ir.recipe.func_77570_a() ? 1 : 0)));
        }
    }

    public static final class WorktableRecipe
    implements RecipeHandler.MachineRecipe {
        private final IRecipe recipe;
        private final ItemStack output;

        private WorktableRecipe(IRecipe ir) {
            if (ir == null) {
                throw new IllegalArgumentException("Invalid worktable recipe: Null!");
            }
            if (ir.func_77571_b() == null) {
                throw new IllegalArgumentException("Invalid worktable recipe: No output!");
            }
            this.recipe = ir;
            this.output = ir.func_77571_b();
        }

        public ItemStack getOutput() {
            return this.output.func_77946_l();
        }

        public boolean containsItem(ItemStack is) {
            return ReikaRecipeHelper.recipeContains((IRecipe)this.recipe, (ItemStack)is);
        }

        @SideOnly(value=Side.CLIENT)
        public ItemStack[] getDisplayArray() {
            return ReikaRecipeHelper.getPermutedRecipeArray((IRecipe)this.recipe);
        }

        @DependentMethodStripper.ModDependent(value=ModList.CHROMATICRAFT)
        public ElementTagCompound getElements() {
            return ItemElementCalculator.instance.getIRecipeTotal(this.recipe);
        }

        @Override
        public String getUniqueID() {
            return "WORKTABLE/" + this.recipe.getClass().getName() + "^" + ReikaRecipeHelper.toString((IRecipe)this.recipe) + ">" + RecipeHandler.fullID(this.output) + "?" + (this.output.func_77973_b() instanceof ItemBlockPlacer);
        }

        @Override
        public String getAllInfo() {
            return "Crafting " + RecipeHandler.fullID(this.output) + " from " + ReikaRecipeHelper.toString((IRecipe)this.recipe);
        }

        @Override
        public Collection<ItemStack> getAllUsedItems() {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>(ReikaRecipeHelper.getAllItemsInRecipe((IRecipe)this.recipe));
            li.add(this.output);
            return li;
        }

        public boolean isRecycling() {
            return this.recipe instanceof RecyclingRecipe;
        }

        public RecyclingRecipe getRecycling() {
            return this.isRecycling() ? (RecyclingRecipe)this.recipe : null;
        }
    }
}

