/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Auxiliary.RecipeManagers;

import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.IC2Handler;
import Reika.DragonAPI.ModInteract.ItemHandlers.MekToolHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.RedstoneArsenalHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.ThaumItemHelper;
import Reika.DragonAPI.ModList;
import Reika.RotaryCraft.API.RecipeInterface;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipeHandler;
import Reika.RotaryCraft.Registry.BlockRegistry;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.RotaryCraft;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class RecipesPulseFurnace
extends RecipeHandler
implements RecipeInterface.PulseFurnaceManager {
    private static final RecipesPulseFurnace PulseFurnaceBase = new RecipesPulseFurnace();
    private ItemHashMap<PulseJetRecipe> recipes = new ItemHashMap();

    public static final RecipesPulseFurnace getRecipes() {
        return PulseFurnaceBase;
    }

    private RecipesPulseFurnace() {
        super(MachineRegistry.PULSEJET);
        RecipeInterface.pulsefurn = this;
        this.addSmelting(Blocks.field_150343_Z, BlockRegistry.BLASTGLASS.getCraftedProduct(1), RecipeHandler.RecipeLevel.CORE);
        this.addSmelting(Items.field_151042_j, ItemStacks.steelingot, RecipeHandler.RecipeLevel.CORE);
        this.addRecycling();
        this.addSmelting(ItemStacks.redgolddust, ItemStacks.redgoldingot, RecipeHandler.RecipeLevel.CORE);
        this.addSmelting(Blocks.field_150319_E, new ItemStack(Items.field_151042_j, 1, 0), RecipeHandler.RecipeLevel.PERIPHERAL);
        this.addSmelting(Blocks.field_150318_D, new ItemStack(Items.field_151043_k, 1, 0), RecipeHandler.RecipeLevel.PERIPHERAL);
    }

    private void addRecycling() {
        this.addSmelting((Item)Items.field_151020_U, new ItemStack(Items.field_151042_j, 3, 0), RecipeHandler.RecipeLevel.PROTECTED);
        this.addSmelting((Item)Items.field_151029_X, new ItemStack(Items.field_151042_j, 2, 0), RecipeHandler.RecipeLevel.PROTECTED);
        this.addSmelting((Item)Items.field_151022_W, new ItemStack(Items.field_151042_j, 4, 0), RecipeHandler.RecipeLevel.PROTECTED);
        this.addSmelting((Item)Items.field_151023_V, new ItemStack(Items.field_151042_j, 5, 0), RecipeHandler.RecipeLevel.PROTECTED);
        this.addSmelting((Item)Items.field_151028_Y, new ItemStack(Items.field_151042_j, 5, 0), RecipeHandler.RecipeLevel.PROTECTED);
        this.addSmelting((Item)Items.field_151030_Z, new ItemStack(Items.field_151042_j, 8, 0), RecipeHandler.RecipeLevel.PROTECTED);
        this.addSmelting((Item)Items.field_151165_aa, new ItemStack(Items.field_151042_j, 7, 0), RecipeHandler.RecipeLevel.PROTECTED);
        this.addSmelting((Item)Items.field_151167_ab, new ItemStack(Items.field_151042_j, 4, 0), RecipeHandler.RecipeLevel.PROTECTED);
        this.addSmelting(Items.field_151019_K, new ItemStack(Items.field_151042_j, 2, 0), RecipeHandler.RecipeLevel.PROTECTED);
        this.addSmelting(Items.field_151037_a, new ItemStack(Items.field_151042_j, 1, 0), RecipeHandler.RecipeLevel.PROTECTED);
        this.addSmelting(Items.field_151036_c, new ItemStack(Items.field_151042_j, 3, 0), RecipeHandler.RecipeLevel.PROTECTED);
        this.addSmelting(Items.field_151035_b, new ItemStack(Items.field_151042_j, 3, 0), RecipeHandler.RecipeLevel.PROTECTED);
        this.addSmelting(Items.field_151040_l, new ItemStack(Items.field_151042_j, 2, 0), RecipeHandler.RecipeLevel.PROTECTED);
        this.addSmelting((Item)Items.field_151169_ag, new ItemStack(Items.field_151043_k, 5, 0), RecipeHandler.RecipeLevel.PROTECTED);
        this.addSmelting((Item)Items.field_151171_ah, new ItemStack(Items.field_151043_k, 8, 0), RecipeHandler.RecipeLevel.PROTECTED);
        this.addSmelting((Item)Items.field_151149_ai, new ItemStack(Items.field_151043_k, 7, 0), RecipeHandler.RecipeLevel.PROTECTED);
        this.addSmelting((Item)Items.field_151151_aj, new ItemStack(Items.field_151043_k, 4, 0), RecipeHandler.RecipeLevel.PROTECTED);
        this.addSmelting(Items.field_151006_E, new ItemStack(Items.field_151043_k, 3, 0), RecipeHandler.RecipeLevel.PROTECTED);
        this.addSmelting(Items.field_151010_B, new ItemStack(Items.field_151043_k, 2, 0), RecipeHandler.RecipeLevel.PROTECTED);
        this.addSmelting(Items.field_151011_C, new ItemStack(Items.field_151043_k, 1, 0), RecipeHandler.RecipeLevel.PROTECTED);
        this.addSmelting(Items.field_151005_D, new ItemStack(Items.field_151043_k, 3, 0), RecipeHandler.RecipeLevel.PROTECTED);
        this.addSmelting(Items.field_151013_M, new ItemStack(Items.field_151043_k, 2, 0), RecipeHandler.RecipeLevel.PROTECTED);
        this.addSmelting((Item)Items.field_151161_ac, new ItemStack(Items.field_151045_i, 5, 0), RecipeHandler.RecipeLevel.PROTECTED);
        this.addSmelting((Item)Items.field_151163_ad, new ItemStack(Items.field_151045_i, 8, 0), RecipeHandler.RecipeLevel.PROTECTED);
        this.addSmelting((Item)Items.field_151173_ae, new ItemStack(Items.field_151045_i, 7, 0), RecipeHandler.RecipeLevel.PROTECTED);
        this.addSmelting((Item)Items.field_151175_af, new ItemStack(Items.field_151045_i, 4, 0), RecipeHandler.RecipeLevel.PROTECTED);
        this.addSmelting(Items.field_151056_x, new ItemStack(Items.field_151045_i, 3, 0), RecipeHandler.RecipeLevel.PROTECTED);
        this.addSmelting(Items.field_151048_u, new ItemStack(Items.field_151045_i, 2, 0), RecipeHandler.RecipeLevel.PROTECTED);
        this.addSmelting(Items.field_151047_v, new ItemStack(Items.field_151045_i, 1, 0), RecipeHandler.RecipeLevel.PROTECTED);
        this.addSmelting(Items.field_151046_w, new ItemStack(Items.field_151045_i, 3, 0), RecipeHandler.RecipeLevel.PROTECTED);
        this.addSmelting(Items.field_151012_L, new ItemStack(Items.field_151045_i, 2, 0), RecipeHandler.RecipeLevel.PROTECTED);
        this.addSmelting(Items.field_151138_bX, new ItemStack(Items.field_151042_j, 7), RecipeHandler.RecipeLevel.PROTECTED);
        this.addSmelting(Items.field_151125_bZ, new ItemStack(Items.field_151045_i, 7), RecipeHandler.RecipeLevel.PROTECTED);
        this.addSmelting(Items.field_151136_bY, new ItemStack(Items.field_151043_k, 7), RecipeHandler.RecipeLevel.PROTECTED);
        this.addSmelting(Items.field_151033_d, new ItemStack(Items.field_151042_j, 1, 0), RecipeHandler.RecipeLevel.PROTECTED);
        this.addSmelting(Items.field_151133_ar, new ItemStack(Items.field_151042_j, 3, 0), RecipeHandler.RecipeLevel.PROTECTED);
        this.addSmelting(Items.field_151131_as, new ItemStack(Items.field_151042_j, 3, 0), RecipeHandler.RecipeLevel.PROTECTED);
        this.addSmelting(Items.field_151129_at, new ItemStack(Items.field_151042_j, 3, 0), RecipeHandler.RecipeLevel.PROTECTED);
        this.addSmelting(Items.field_151117_aB, new ItemStack(Items.field_151042_j, 3, 0), RecipeHandler.RecipeLevel.PROTECTED);
        this.addSmelting(Items.field_151143_au, new ItemStack(Items.field_151042_j, 5, 0), RecipeHandler.RecipeLevel.PROTECTED);
        this.addSmelting(Items.field_151139_aw, new ItemStack(Items.field_151042_j, 6, 0), RecipeHandler.RecipeLevel.PROTECTED);
        this.addSmelting(Items.field_151066_bu, new ItemStack(Items.field_151042_j, 7, 0), RecipeHandler.RecipeLevel.PROTECTED);
        this.addSmelting(ItemRegistry.STEELHELMET.getItemInstance(), this.getSizedSteel(5), RecipeHandler.RecipeLevel.PROTECTED);
        this.addSmelting(ItemRegistry.STEELBOOTS.getItemInstance(), this.getSizedSteel(4), RecipeHandler.RecipeLevel.PROTECTED);
        this.addSmelting(ItemRegistry.STEELCHEST.getItemInstance(), this.getSizedSteel(8), RecipeHandler.RecipeLevel.PROTECTED);
        this.addSmelting(ItemRegistry.STEELLEGS.getItemInstance(), this.getSizedSteel(7), RecipeHandler.RecipeLevel.PROTECTED);
        this.addSmelting(ItemRegistry.STEELAXE.getItemInstance(), this.getSizedSteel(3), RecipeHandler.RecipeLevel.PROTECTED);
        this.addSmelting(ItemRegistry.STEELPICK.getItemInstance(), this.getSizedSteel(3), RecipeHandler.RecipeLevel.PROTECTED);
        this.addSmelting(ItemRegistry.STEELSHOVEL.getItemInstance(), this.getSizedSteel(1), RecipeHandler.RecipeLevel.PROTECTED);
        this.addSmelting(ItemRegistry.STEELHOE.getItemInstance(), this.getSizedSteel(2), RecipeHandler.RecipeLevel.PROTECTED);
        this.addSmelting(ItemRegistry.STEELSHEARS.getItemInstance(), this.getSizedSteel(2), RecipeHandler.RecipeLevel.PROTECTED);
        this.addSmelting(ItemRegistry.STEELSICKLE.getItemInstance(), this.getSizedSteel(3), RecipeHandler.RecipeLevel.PROTECTED);
    }

    private ItemStack getSizedSteel(int size) {
        return ReikaItemHelper.getSizedItemStack((ItemStack)ItemStacks.steelingot, (int)size);
    }

    @Override
    public void addAPISmelting(ItemStack in, ItemStack itemstack) {
        this.addSmelting(in, itemstack, RecipeHandler.RecipeLevel.API);
    }

    public void addSmelting(ItemStack in, ItemStack itemstack) {
        this.addSmelting(in, itemstack, RecipeHandler.RecipeLevel.CORE);
    }

    private void addSmelting(ItemStack in, ItemStack itemstack, RecipeHandler.RecipeLevel rl) {
        PulseJetRecipe rec = new PulseJetRecipe(in, itemstack);
        this.recipes.put(in, (Object)rec);
        this.onAddRecipe(rec, rl);
    }

    private void addSmelting(Block b, ItemStack itemstack, RecipeHandler.RecipeLevel rl) {
        this.addSmelting(new ItemStack(b, 1, Short.MAX_VALUE), itemstack, rl);
    }

    private void addSmelting(Item i, ItemStack itemstack, RecipeHandler.RecipeLevel rl) {
        this.addSmelting(new ItemStack(i, 1, Short.MAX_VALUE), itemstack, rl);
    }

    public void addCustomRecipe(ItemStack in, ItemStack output) {
        this.addSmelting(in, output, RecipeHandler.RecipeLevel.CUSTOM);
    }

    public ItemStack getSmeltingResult(ItemStack item) {
        PulseJetRecipe ret = item != null ? (PulseJetRecipe)this.recipes.get(item) : null;
        return ret != null ? ret.output.func_77946_l() : null;
    }

    public List<ItemStack> getSources(ItemStack result) {
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        for (ItemStack in : this.recipes.keySet()) {
            ItemStack out = this.getSmeltingResult(in);
            if (!ReikaItemHelper.matchStacks((ItemStack)result, (ItemStack)out)) continue;
            li.add(in.func_77946_l());
        }
        return li;
    }

    public boolean isProduct(ItemStack item) {
        for (PulseJetRecipe pjr : this.recipes.values()) {
            if (!pjr.makesItem(item)) continue;
            return true;
        }
        return false;
    }

    public boolean isSmeltable(ItemStack ingredient) {
        return this.getSmeltingResult(ingredient) != null;
    }

    public Collection<ItemStack> getAllSmeltables() {
        return Collections.unmodifiableCollection(this.recipes.keySet());
    }

    @Override
    public void addPostLoadRecipes() {
        int i;
        ItemStack out;
        int[] n;
        Object[] items;
        if (ModList.THERMALFOUNDATION.isLoaded()) {
            ItemStack enderdust = GameRegistry.findItemStack((String)ModList.THERMALFOUNDATION.modLabel, (String)"dustEnderium", (int)1);
            ItemStack enderingot = GameRegistry.findItemStack((String)ModList.THERMALFOUNDATION.modLabel, (String)"ingotEnderium", (int)1);
            if (enderdust == null || enderingot == null) {
                RotaryCraft.logger.logError((Object)"No item found for TE3 enderium crafting!");
            } else {
                this.addSmelting(enderdust, enderingot, RecipeHandler.RecipeLevel.MODINTERACT);
            }
        }
        if (ModList.ARSENAL.isLoaded()) {
            ItemStack fluxdust = RedstoneArsenalHandler.getInstance().getFluxDust();
            ItemStack fluxingot = RedstoneArsenalHandler.getInstance().getFluxIngot();
            if (fluxdust == null || fluxingot == null) {
                RotaryCraft.logger.logError((Object)"No item found for Redstone Arsenal fluxed ingot crafting!");
            } else {
                this.addSmelting(fluxdust, fluxingot, RecipeHandler.RecipeLevel.MODINTERACT);
            }
        }
        if (ModList.IC2.isLoaded()) {
            items = new ItemStack[]{IC2Handler.IC2Stacks.BRONZEAXE.getItem(), IC2Handler.IC2Stacks.BRONZEPICK.getItem(), IC2Handler.IC2Stacks.BRONZEHOE.getItem(), IC2Handler.IC2Stacks.BRONZESWORD.getItem(), IC2Handler.IC2Stacks.BRONZESHOVEL.getItem(), IC2Handler.IC2Stacks.BRONZEHELMET.getItem(), IC2Handler.IC2Stacks.BRONZECHESTPLATE.getItem(), IC2Handler.IC2Stacks.BRONZELEGGINGS.getItem(), IC2Handler.IC2Stacks.BRONZEBOOTS.getItem()};
            n = new int[]{3, 3, 2, 2, 1, 5, 8, 7, 4};
            out = (ItemStack)OreDictionary.getOres((String)"ingotBronze").get(0);
            for (i = 0; i < items.length; ++i) {
                if (items[i] == null) continue;
                this.addSmelting(items[i].func_77973_b(), ReikaItemHelper.getSizedItemStack((ItemStack)out, (int)n[i]), RecipeHandler.RecipeLevel.MODINTERACT);
            }
        }
        if (ModList.RAILCRAFT.isLoaded()) {
            items = new Object[]{"tool.steel.pickaxe", "tool.steel.axe", "tool.steel.sword", "tool.steel.hoe", "tool.steel.shovel", "armor.steel.helmet", "armor.steel.plate", "armor.steel.legs", "armor.steel.boots", "tool.steel.shears"};
            n = new int[]{3, 3, 2, 2, 1, 5, 8, 7, 4, 2};
            for (int i2 = 0; i2 < items.length; ++i2) {
                items[i2] = ReikaItemHelper.lookupItem((ModList)ModList.RAILCRAFT, (String)((String)items[i2]), (int)0);
            }
            out = ReikaItemHelper.lookupItem((ModList)ModList.RAILCRAFT, (String)"ingot", (int)0);
            for (i = 0; i < items.length; ++i) {
                if (items[i] == null) continue;
                this.addSmelting(((ItemStack)items[i]).func_77973_b(), ReikaItemHelper.getSizedItemStack((ItemStack)out, (int)n[i]), RecipeHandler.RecipeLevel.MODINTERACT);
            }
        }
        if (ModList.ENDERIO.isLoaded()) {
            items = new Object[]{"item.darkSteel_pickaxe", "item.darkSteel_axe", "item.darkSteel_sword", "item.darkSteel_helmet", "item.darkSteel_chestplate", "item.darkSteel_leggings", "item.darkSteel_boots", "item.darkSteel_shears"};
            n = new int[]{3, 3, 2, 5, 8, 7, 4, 2};
            for (int i3 = 0; i3 < items.length; ++i3) {
                items[i3] = ReikaItemHelper.lookupItem((ModList)ModList.ENDERIO, (String)((String)items[i3]), (int)0);
            }
            out = ReikaItemHelper.lookupItem((ModList)ModList.ENDERIO, (String)"itemAlloy", (int)6);
            for (i = 0; i < items.length; ++i) {
                if (items[i] == null) continue;
                this.addSmelting(((ItemStack)items[i]).func_77973_b(), ReikaItemHelper.getSizedItemStack((ItemStack)out, (int)n[i]), RecipeHandler.RecipeLevel.MODINTERACT);
            }
        }
        if (ModList.THAUMCRAFT.isLoaded()) {
            items = new Object[]{"ItemPickThaumium", "ItemAxeThaumium", "ItemSwordThaumium", "ItemHoeThaumium", "ItemShovelThaumium", "ItemHelmetThaumium", "ItemChestplateThaumium", "ItemLeggingsThaumium"};
            n = new int[]{3, 3, 2, 2, 1, 5, 8, 7};
            for (int i4 = 0; i4 < items.length; ++i4) {
                items[i4] = ReikaItemHelper.lookupItem((ModList)ModList.THAUMCRAFT, (String)((String)items[i4]), (int)0);
            }
            out = ThaumItemHelper.ItemEntry.THAUMIUM.getItem();
            for (i = 0; i < items.length; ++i) {
                if (items[i] == null) continue;
                this.addSmelting(((ItemStack)items[i]).func_77973_b(), ReikaItemHelper.getSizedItemStack((ItemStack)out, (int)n[i]), RecipeHandler.RecipeLevel.MODINTERACT);
            }
        }
        if (ModList.MEKTOOLS.isLoaded()) {
            for (MekToolHandler.Materials m : MekToolHandler.Materials.values()) {
                ItemStack out2 = m.getRawMaterial();
                for (MekToolHandler.Tools t : MekToolHandler.Tools.values()) {
                    Item i5 = m.getItem(t);
                    if (i5 == null) continue;
                    this.addSmelting(i5, ReikaItemHelper.getSizedItemStack((ItemStack)out2, (int)t.getNumberIngots(m)), RecipeHandler.RecipeLevel.MODINTERACT);
                }
            }
        }
    }

    @Override
    protected boolean removeRecipe(RecipeHandler.MachineRecipe recipe) {
        return this.recipes.removeValue((Object)((PulseJetRecipe)recipe));
    }

    private static class PulseJetRecipe
    implements RecipeHandler.MachineRecipe {
        private final ItemStack input;
        private final ItemStack output;

        private PulseJetRecipe(ItemStack in, ItemStack out) {
            this.input = in;
            this.output = out;
        }

        public ItemStack getOutput() {
            return this.output.func_77946_l();
        }

        public boolean makesItem(ItemStack is) {
            return ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)this.output);
        }

        @Override
        public String getUniqueID() {
            return RecipeHandler.fullID(this.input) + ">" + RecipeHandler.fullID(this.output);
        }

        @Override
        public String getAllInfo() {
            return "Smelting " + RecipeHandler.fullID(this.input) + " into " + RecipeHandler.fullID(this.output);
        }

        @Override
        public Collection<ItemStack> getAllUsedItems() {
            return ReikaJavaLibrary.makeListFrom((Object[])new Object[]{this.input, this.output});
        }
    }
}

