/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Auxiliary.RecipeManagers;

import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.RotaryCraft.API.RecipeInterface;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipeHandler;
import Reika.RotaryCraft.Items.Tools.ItemEngineUpgrade;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.PowerReceivers;
import java.util.Collection;
import net.minecraft.item.ItemStack;

public class RecipesMagnetizer
extends RecipeHandler
implements RecipeInterface.MagnetizerManager {
    private final ItemHashMap<MagnetizerRecipe> recipes = new ItemHashMap();
    private static final RecipesMagnetizer instance = new RecipesMagnetizer();

    public static final RecipesMagnetizer getRecipes() {
        return instance;
    }

    private RecipesMagnetizer() {
        super(MachineRegistry.MAGNETIZER);
        RecipeInterface.magnetizer = this;
        this.addRecipe(ItemStacks.shaftcore, 0, 2, 1, RecipeHandler.RecipeLevel.CORE);
        this.addRecipe(ItemRegistry.UPGRADE.getStackOfMetadata(ItemEngineUpgrade.Upgrades.MAGNETOSTATIC2.ordinal()), 32768, 1, 4, RecipeHandler.RecipeLevel.CORE);
    }

    private void addRecipe(ItemStack in, int minSpeed, int reqSpeedPerMicroTesla, int timeFactor, RecipeHandler.RecipeLevel rl) {
        this.addRecipe(in, minSpeed, reqSpeedPerMicroTesla, timeFactor, null, rl);
    }

    private void addRecipe(ItemStack in, int minSpeed, int reqSpeedPerMicroTesla, int timeFactor, RecipeInterface.MagnetizerManager.MagnetizationAction a, RecipeHandler.RecipeLevel rl) {
        MagnetizerRecipe rec = new MagnetizerRecipe(in, timeFactor, minSpeed, reqSpeedPerMicroTesla, a);
        this.recipes.put(in, (Object)rec);
        this.onAddRecipe(rec, rl);
    }

    @Override
    public void addAPIRecipe(ItemStack in, int minSpeed, int reqSpeedPerMicroTesla, int timeFactor, RecipeInterface.MagnetizerManager.MagnetizationAction a) {
        this.addRecipe(in, minSpeed, reqSpeedPerMicroTesla, timeFactor, a, RecipeHandler.RecipeLevel.API);
    }

    @Override
    public void addPostLoadRecipes() {
    }

    @Override
    protected boolean removeRecipe(RecipeHandler.MachineRecipe recipe) {
        return this.recipes.removeValue((Object)((MagnetizerRecipe)recipe));
    }

    public MagnetizerRecipe getRecipe(ItemStack is) {
        return (MagnetizerRecipe)this.recipes.get(is);
    }

    public Collection<MagnetizerRecipe> getAllRecipes() {
        return this.recipes.values();
    }

    public String getRecipesAsString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Required Speeds:\n\n");
        for (MagnetizerRecipe mr : this.recipes.values()) {
            sb.append(mr.item.func_82833_r() + " @ " + Math.max(PowerReceivers.MAGNETIZER.getMinSpeed(), mr.minSpeed) + " rad/s\n");
        }
        return sb.toString();
    }

    public static class MagnetizerRecipe
    implements RecipeHandler.MachineRecipe {
        private final ItemStack item;
        public final int timeFactor;
        public final int minSpeed;
        public final int speedPeruT;
        public final RecipeInterface.MagnetizerManager.MagnetizationAction action;

        private MagnetizerRecipe(ItemStack is, int time, int omega, int sput, RecipeInterface.MagnetizerManager.MagnetizationAction a) {
            this.item = is;
            this.timeFactor = time;
            this.minSpeed = omega;
            this.speedPeruT = sput;
            this.action = a;
        }

        public ItemStack getItem() {
            return this.item.func_77946_l();
        }

        @Override
        public String getUniqueID() {
            return RecipeHandler.fullID(this.item) + "/" + this.timeFactor + "/" + this.minSpeed + "/" + this.speedPeruT;
        }

        @Override
        public Collection<ItemStack> getAllUsedItems() {
            return ReikaJavaLibrary.makeListFrom((Object)this.getItem());
        }

        @Override
        public String getAllInfo() {
            return "Magnetizing " + RecipeHandler.fullID(this.item) + " @ speed " + this.minSpeed + " to " + this.speedPeruT + "/rads @ " + this.timeFactor + "x time factor";
        }
    }
}

